/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.ui;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.rpc.ServiceException;

import com.leagueplanet.GameDetail;
import com.leagueplanet.Update;
import com.leagueplanet.UpdateService;
import com.leagueplanet.UpdateServiceLocator;

/**
 * Servlet implementation class for Servlet: UpdateScoreServlet
 * 
 */
public class UpdateScoreServlet extends javax.servlet.http.HttpServlet
		implements javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		long gameId = getLongParam(request, "gameId", 0);
		forwardGameDetail(request, response, gameId, "/score-form.jsp");
	}

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		long gameId = getLongParam(request, "gameId", 0);
		int visitorScore = (int) getLongParam(request, "visitorScore", -1);
		int homeScore = (int) getLongParam(request, "homeScore", -1);

		try {
			// wywoanie usugi WWW w celu aktualizacji wyniku
			UpdateService service = new UpdateServiceLocator();
			Update port = service.getUpdate();
			port.updateScore(gameId, visitorScore, homeScore);

			forwardGameDetail(request, response, gameId,
					"/score-confirmation.jsp");
		} catch (ServiceException e) {
			e.printStackTrace();
		}
	}

	private void forwardGameDetail(HttpServletRequest request,
			HttpServletResponse response, long gameId, String url)
			throws ServletException, IOException {
		try {
			// wywoanie usugi WWW w celu pozyskania danych o meczu
			UpdateService service = new UpdateServiceLocator();
			Update port = service.getUpdate();
			GameDetail gameDetail = port.getGameDetail(gameId);

			// dodanie obiektu informacji o meczu do danych sesji
			HttpSession session = request.getSession(true);
			session.setAttribute("gameDetail", gameDetail);

			// przekazanie dania do strony JSP
			ServletContext context = getServletContext();
			RequestDispatcher dispatcher = context.getRequestDispatcher(url);
			dispatcher.forward(request, response);

		} catch (ServiceException e) {
			e.printStackTrace();
		}
	}

	private long getLongParam(HttpServletRequest request, String name,
			long value) {

		String param = request.getParameter(name);
		if (param != null) {
			try {
				value = Long.parseLong(param);
			} catch (NumberFormatException e) {
			}
		}

		return value;
	}
}