/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.ui;

import java.io.IOException;
import java.rmi.RemoteException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.leagueplanet.message.query.GetScheduleRequest;
import com.leagueplanet.resource.schedule.ScheduleContent;
import com.leagueplanet.resource.schedule.ScheduleType;
import com.leagueplanet.ws.query.QueryInterfaceProxy;

/**
 * Servlet implementation class for Servlet: ScheduleServlet
 * 
 */
public class ScheduleServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	public ScheduleServlet() {
		super();
	}

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		ScheduleType schedule = null;

		// pozyskanie id terminarza z parametrw wejciowych dania
		long scheduleId = 0;
		String param = request.getParameter("scheduleId");
		if (param != null) {
			try {
				scheduleId = Long.parseLong(param);
			} catch (NumberFormatException e) {
			}

		}

		// jeli identyfikator terminarza jest poprawny, wywoujemy usug WWW
		if (scheduleId > 0) {
			try {
				QueryInterfaceProxy proxy = new QueryInterfaceProxy();

				GetScheduleRequest scheduleRequest = new GetScheduleRequest(
						scheduleId);
				ScheduleContent scheduleContent = proxy
						.getSchedule(scheduleRequest);
				schedule = scheduleContent.getSchedule();

			} catch (RemoteException e) {
				e.printStackTrace();
			}
		}
		
		if (schedule == null) {
			schedule = new ScheduleType();
		}
		
		// dodanie danych terminarza do sesji
		HttpSession session = request.getSession(true);
		session.setAttribute("schedule", schedule);

		// przekierowanie dania do strony JSP wywietlajcej terminarz
		ServletContext context = getServletContext();
		RequestDispatcher dispatcher = context
				.getRequestDispatcher("/schedule.jsp");
		dispatcher.forward(request, response);

	}
}