/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.ui;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import com.leagueplanet.GameDetail;
import com.leagueplanet.resource.schedule.GameType;
import com.leagueplanet.resource.schedule.LocationResourceType;
import com.leagueplanet.resource.schedule.ScoreType;

public class GameFormat {
	
	private String dateString;
	private String timeString;
	private String locationName;
	private String visitorName;
	private String homeName;
	private String scoreString;
	
	private final String DATE_PATTERN = "dd.MM.yyyy";
	private final String TIME_PATTERN = "hh:mm";
	
	public GameFormat(GameType game) {
		
		LocationResourceType arena = game.getArena();
		String timeZoneId = "GMT+1:00";//arena.getTimeZone();
		TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
		dateString = formatDate(game.getDateTime(), timeZone, DATE_PATTERN);
		timeString = formatDate(game.getDateTime(), timeZone, TIME_PATTERN);

		locationName = game.getArena().getName();
		visitorName = game.getVisitor().getName();
		homeName = game.getHome().getName();
		
		ScoreType score = game.getScore();
		scoreString = score.getVisitor() + "-" + score.getHome();
	}
	
	public GameFormat (GameDetail game) {
		
		TimeZone timeZone = TimeZone.getTimeZone("GMT+1:00");//game.getLocationTimeZoneId());
		dateString = formatDate(game.getDateTime(), timeZone, DATE_PATTERN);
		timeString = formatDate(game.getDateTime(), timeZone, TIME_PATTERN);
		
		locationName = game.getLocationName();
		visitorName = game.getVisitorName();
		homeName = game.getHomeName();
		
		scoreString = game.getVisitorScore() + "-" + game.getHomeScore();
		
	}
	
	private String formatDate(Calendar dateTime, TimeZone timeZone, String pattern) {
		
		SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
		dateFormat.setTimeZone(timeZone);
		
		Date date = dateTime.getTime();

		return dateFormat.format(date);
	}

	public String getDateString() {
		
		return dateString;
	}
	
	public String getTimeString() {
		
		return timeString;
	}
	
	public String getVisitorName() {
		
		return visitorName;
	}
	
	public String getHomeName() {
		
		return homeName;
	}
	
	public String getLocationName() {
		
		return locationName;
	}
	
	public String getScoreString() {
		
		return scoreString;
	}	
}
