﻿/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
	// walidacja wartości typu całkowitego
	
	function validateInteger(validatorId, valueId, minValue, maxValue) {
	
		var validatorElement = document.getElementById(validatorId);	
		
		var valueElement = document.getElementById(valueId);
		var value = Number(valueElement.value);

		// walidacja wartości
		if (isNaN(value) || (value != Math.round(value)) || 
			(minValue > value) || (value > maxValue)) {
			
			validatorElement.innerHTML = 
				"Proszę wprowadzić liczbę całkowitą z zakresu od " + minValue + 
				" do " + maxValue + "!" ;
			return false;
		}
		
		// wartość jest poprawna
		validatorElement.innerHTML = "";
		return true;
	}
	
	function validateGoals(validatorId, goalsId) {
	
		// liczba bramek musi być liczbą z zakresu od 0 do 99
		return validateInteger(validatorId, goalsId, 0, 99);
	}
	
	function validateVisitor() {
	
		return validateGoals("visitorValidator", "visitorId");
	}
	
	function validateHome() {
	
		return validateGoals("homeValidator", "homeId");
	}

	// walidacja wszystkich pól wejściowych
	
	function validateFields() {
	
		var visitorValid = validateVisitor();
		var homeValid = validateHome();
		
		return visitorValid && homeValid;
	}
	
	// przesłanie wyniku do serwera
	
	function submitScore() {
	
		var valid = validateFields();
		if (!valid) {
		
			window.alert(
				"Wprowadzono niepoprawny wynik.\n" + 
				"Proszę poprawić dane i ponownie zatwierdzić formularz.");
		}
		
		return valid;
	}
	
	// zerowanie komunikatów walidatora
	
	function resetValidators() {
	
		document.getElementById("visitorValidator").innerHTML = "";
		document.getElementById("homeValidator").innerHTML = "";
	}
	
