<!--
/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
-->
<%@ page language="java" contentType="text/html; charset=ISO-8859-2"
	pageEncoding="ISO-8859-2" session="true"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page import="com.leagueplanet.resource.schedule.GameType"%>
<%@page import="com.leagueplanet.resource.schedule.LeagueResourceType"%>
<%@page import="com.leagueplanet.ui.GameFormat"%>
<jsp:useBean class="com.leagueplanet.resource.schedule.ScheduleType" id="schedule" scope="session"></jsp:useBean>
<%
String name = schedule.getName();
LeagueResourceType league = schedule.getLeague();
GameType[] games = schedule.getGames();

String leagueName = league == null ? "nieznana liga" : league.getName();
String scheduleName = name == null ? "nieznany terminarz" : name;
String title = leagueName + " " + scheduleName;

int gameCount = games == null ? 0 : games.length;
%>
<html>
<head>
<meta http-equiv="Content-Type"
	content="text/html; charset=ISO-8859-2">
<title><%= title %></title>
<link rel="stylesheet" href="schedule.css" type="text/css">

</head>
<body>
<h1><%= leagueName %></h1>
<h2><%= scheduleName %></h2>

<% if (gameCount == 0) { %>
<p>W terminarzu nie ma adnych rozgrywek.</p>
<% } else { %>
<table>
	<thead>
		<tr>
			<th>Data</th>
			<th>Godzina</th>
			<th>Arena</th>
			<th>Gocie</th>
			<th>Gospodarze</th>
			<th>Wynik</th>
		</tr>
	</thead>
	<tbody>
	
<% for (int i = 0; i < gameCount; i++) { 
	int row = i + 1;
	String rowClass = (row % 2) == 0 ? "even-row" : "odd-row";
	
	GameType game = games[i];
	GameFormat gameFormat = new GameFormat(game);
	long gameId = game.getGameId();
	String scoreUrl = "updateScore?gameId=" + gameId;
%>	
		<tr class="<%= rowClass %>">
			<td><%= gameFormat.getDateString() %></td>
			<td><%= gameFormat.getTimeString() %></td>
			<td><%= gameFormat.getLocationName() %></td>
			<td><%= gameFormat.getVisitorName() %></td>
			<td><%= gameFormat.getHomeName() %></td>
			<td><a href="<%= scoreUrl %>"><%= gameFormat.getScoreString() %></a></td>
		</tr>
<% } %>
	</tbody>
</table>
<% } %>
</body>
</html>
