/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.servlet;

import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.leagueplanet.cmp.GameUtil;


/**
 * Servlet implementation class for Servlet: GameServlet
 * 
 * @web.servlet name="GameServlet" display-name="GameServlet"
 * 
 * @web.servlet-mapping url-pattern="/GameServlet"
 * 
 */
public class GameServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public GameServlet() {
		super();
	}


	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		try {
			SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm aaa");
			Date date = new Date(dateFormat.parse(request.getParameter("date"))
					.getTime());
			Time time = new Time(timeFormat.parse(request.getParameter("time"))
					.getTime());
			String arena = request.getParameter("arena");
			String home = request.getParameter("home");
			String visitor = request.getParameter("visitor");
			String homeScore = request.getParameter("homeScore");
			String visitorScore = request.getParameter("visitorScore");

			GameUtil.getLocalHome().create(1,date, time, arena, home, visitor,
					homeScore, visitorScore);
			this.getServletContext().getRequestDispatcher("/schedule.jsp")
					.forward(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}