/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.cmp;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.ParseException;
import java.util.*;

import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Player;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Score;
import com.leagueplanet.model.Team;

public class IceHockeyCMPDAOImpl implements LeagueDAO {

	// singleton DAO
	private static IceHockeyCMPDAOImpl leagueDAO = null;

	public static LeagueDAO getLeagueDAO() {
		if (leagueDAO == null) {
			leagueDAO = new IceHockeyCMPDAOImpl();
		}
		return leagueDAO;
	}

	public League findLeague(long id) {
		// TODO: Add mappings for leagues and schedules
		League league=new League(id, "Modzieowa dziewczca liga hokejowa");
		league.getSchedules().add(findSchedule(1));
		return league;
	}

	public Schedule findSchedule(long id) {
		// TODO: Add mappings schedules
		Schedule schedule = new Schedule(id, "Sezon 2006/7");

		try {
			Collection games = GameUtil.getHome().findScheduleGames(
					(int) id);
			Iterator iterator = games.iterator();
			while (iterator.hasNext()) {
				com.leagueplanet.cmp.Game cmp = 
					(com.leagueplanet.cmp.Game) iterator.next();
				schedule.getEvents().add(createGameFromCMP(cmp));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return schedule;
	}

	private Game createGameFromCMP(com.leagueplanet.cmp.Game cmp)
			throws SQLException, ParseException, RemoteException {
		Game game = new Game();
		game.setId(cmp.getId().intValue());
		Calendar dateTime = Calendar.getInstance();
		dateTime.setTime(cmp.getDate());
		dateTime.set(Calendar.HOUR_OF_DAY,
				cmp.getTime().getHours());
		dateTime.set(Calendar.MINUTE, cmp.getTime().getMinutes());
		game.setDateAndTime(dateTime);
		game.setLocation(new Location(0, cmp.getArena()));
		Team homeTeam = new Team();
		homeTeam.setName(cmp.getHome());
		game.setHome(homeTeam);
		Team visitorTeam = new Team();
		visitorTeam.setName(cmp.getVisitor());
		game.setVisitor(visitorTeam);
		Score gameScore = new Score(Integer
				.parseInt(cmp.getHomescore()), Integer.parseInt(cmp
				.getVisitorscore()));
		game.setScore(gameScore);
		return game;
	}

	// TODO: Add mappings later
	public Set getSchedulesForLeague(String league) {
		return null;
	}

	public Set findLeaguesWithName(String name) {
		return null;
	}

	public void save(League newLeague) {
	}

	public Game findGame(long id) {
		return null;
	}

	public Location findLocation(long id) {
		return null;
	}

	public Team findTeam(long id) {
		return null;
	}

	public Player findPlayer(long id) {
		return null;
	}
}
