/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.cmp;

import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.Time;
import java.util.Random;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
 
/**
 * @ejb.bean name="Game" 
 *	jndi-name="Game"
 *	type="CMP" 
 *  primkey-field="id" 
 *  schema="GameSCHEMA" 
 *  cmp-version="2.x"
 *
 *  @ejb.persistence 
 *   table-name="APP.GAME" 
 * 
 * @ejb.finder 
 *  query="SELECT OBJECT(a) FROM GameSCHEMA as a"  
 *  signature="java.util.Collection findAll()"  
 *
 * @ejb.finder 
 *  query="SELECT OBJECT(a) FROM GameSCHEMA as a WHERE a.scheduleid = ?1"  
 *  signature="java.util.Collection findScheduleGames(int scheduleid)"
 *  
 * @ejb.pk class="java.lang.Integer"
 *
 * @jboss.persistence 
 *  datasource="java:/LeagueDS" 
 *  datasource-mapping="Derby" 
 *  table-name="APP.GAME" 
 *  create-table="true" 
 *  remove-table="false" 
 *  alter-table="true"
 **/
public abstract class GameBean implements javax.ejb.EntityBean {

	/**
	 * @ejb.create-method 
	 */
	public java.lang.Integer ejbCreate(int scheduleId,Date date, 
			Time time, String arena, String home, String visitor, 
			String hScore, String vScore)
			throws javax.ejb.CreateException {
			setDate(date);
		setTime(time);
		setArena(arena);
		setHome(home);
		setVisitor(visitor);
		setHomescore(hScore);
		setVisitorscore(vScore);
		Random random = new Random(System.currentTimeMillis());
		setId(new Integer(random.nextInt()));
		setScheduleid(new Integer(scheduleId));
		//EJB 2.0 spec says return null for CMP ejbCreate methods.
		return null;
	}

	/**
	 * @ejb.create-method 
	 */
	public java.lang.Integer ejbCreate(int scheduleId,
			          com.leagueplanet.model.Game game)
			throws javax.ejb.CreateException {
		setDate(new Date(game.getDateAndTime().getTimeInMillis()));
		setTime(new Time(game.getDateAndTime().getTimeInMillis()));
		setArena(game.getLocation().getName());
		setHome(game.getHome().getName());
		setVisitor(game.getVisitor().getName());
		setHomescore(""+game.getScore().getHome());
		setVisitorscore(""+game.getScore().getVisitor());
		Random random = new Random(System.currentTimeMillis());
		setId(new Integer(random.nextInt()));
		setScheduleid(new Integer(scheduleId));		
		//EJB 2.0 spec says return null for CMP ejbCreate methods.
		return null;
	}

	public void ejbPostCreate() throws javax.ejb.CreateException {
	}

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="ID"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 */
	public abstract java.lang.Integer getId();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setId(java.lang.Integer id);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="SCHEDULEID"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.lang.Integer getScheduleid();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setScheduleid(java.lang.Integer scheduleid);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="DATE"
	 *     jdbc-type="DATE"
	 *     sql-type="DATE"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.sql.Date getDate();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setDate(java.sql.Date date);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="TIME"
	 *     jdbc-type="TIME"
	 *     sql-type="TIME"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.sql.Time getTime();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setTime(java.sql.Time time);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="ARENA"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(40)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.lang.String getArena();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setArena(java.lang.String arena);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="HOME"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(40)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.lang.String getHome();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setHome(java.lang.String home);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="VISITOR"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(40)"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 */
	public abstract java.lang.String getVisitor();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setVisitor(java.lang.String visitor);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="HOMESCORE"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(40)"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 */
	public abstract java.lang.String getHomescore();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setHomescore(java.lang.String homescore);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="VISITORSCORE"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(40)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 */
	public abstract java.lang.String getVisitorscore();

	/**
	 * @ejb.interface-method
	 */
	public abstract void setVisitorscore(java.lang.String visitorscore);

	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbRemove() throws RemoveException, EJBException,
			RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void setEntityContext(EntityContext arg0)
			throws EJBException, RemoteException {
	}

	public void unsetEntityContext() throws EJBException,
			RemoteException {
		// TODO Auto-generated method stub
	}

}
