/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.ejb;

import java.util.Set;

import com.leagueplanet.model.*;
import com.leagueplanet.services.IceHockeyFacade;
import com.leagueplanet.services.LeagueFacade;

/**
 * @ejb.bean 
 *     name="LeagueFacade" 
 *     description="Komponent EJB o nazwie LeagueFacade"
 *     display-name="LeagueFacade" 
 *     jndi-name="LeagueFacade"
 *     type="Stateless" 
 *     transaction-type="Container"
 */

public abstract class LeagueFacadeBean implements
		LeagueFacade, javax.ejb.SessionBean {

	private LeagueFacade leagueFacade;

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public boolean createLeague(League newLeague) {
		return leagueFacade.createLeague(newLeague);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public boolean doesLeagueExist(String name) {
		return leagueFacade.doesLeagueExist(name);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public Game findGame(long id) {
		return leagueFacade.findGame(id);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public League findLeague(long id) {
		return leagueFacade.findLeague(id);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public Location findLocation(long id) {
		return leagueFacade.findLocation(id);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public Player findPlayer(long id) {
		return leagueFacade.findPlayer(id);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public Schedule findSchedule(long id) {
		return leagueFacade.findSchedule(id);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public Team findTeam(long id) {
		return leagueFacade.findTeam(id);
	}

	/**
	 * @ejb.interface-method view-type="both"
	 */
	public Set getSchedulesForLeague(String league) {
		return leagueFacade.getSchedulesForLeague(league);
	}

	/**
	 * @ejb.create-method view-type="remote"
	 */
	public void ejbCreate() {
		leagueFacade = IceHockeyFacade.getLeagueFacade();
	}
}
