/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.services;

import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.dao.example.IceHockeyDAOImpl;
import com.leagueplanet.services.LeagueFacade;
import com.leagueplanet.services.impl.LeagueFacadeImpl;

public class IceHockeyFacade {

	private static LeagueFacade facade = null;

	public static LeagueFacade getLeagueFacade() {
		if (facade == null) {
			init();
		}
		return facade;
	}

	private static void init() {
		// utworzenie nowej implementacji fasady
		LeagueFacadeImpl facadeImpl = new LeagueFacadeImpl();
		// wskazanie fasady w dao dla ligi hokejowej
		LeagueDAO dao = IceHockeyDAOImpl.getLeagueDAO();
		facadeImpl.setLeagueDAO(dao);
		facade = facadeImpl;
	}

}
