<?xml version="1.0" encoding="UTF-8"?>
<!--
/*******************************************************************************
* Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* This sample developed for the book
*     Eclipse Web Tools Platform: Developing Java Web Applications
* See http://eclipsewtp.org
*******************************************************************************/
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

	<xsl:output method="html" />

	<xsl:template match="/schedule">
		<html>
			<head>
				<title>
					<xsl:value-of
						select="concat(league,' ', 'Terminarz ', name)" />
				</title>
				<link rel="stylesheet" href="schedule.css"
					type="text/css" />

			</head>
			<body>
				<h1>
					<xsl:value-of select="league" />
				</h1>
				<h2>
					<xsl:value-of select="concat('Terminarz ', name)" />
				</h2>
				<xsl:apply-templates select="games" />
				<xsl:call-template name="email" />
			</body>
		</html>
	</xsl:template>

	<xsl:template match="games">
		<table>
			<thead>
				<tr>
					<th>Data</th>
					<th>Godzina</th>
					<th>Arena</th>
					<th>Goście</th>
					<th>Gospodarze</th>
					<th>Wynik</th>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="game">
					<tr>
						<xsl:attribute name="class">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:text>odd-row</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>even-row</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<td>
							<xsl:value-of select="date" />
						</td>
						<td>
							<xsl:value-of select="time" />
						</td>
						<td>
							<xsl:value-of select="arena" />
						</td>
						<td>
							<xsl:value-of select="visitor" />
						</td>
						<td>
							<xsl:value-of select="home" />
						</td>
						<td>
							<xsl:value-of select="score" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>

	<xsl:template name="email">
		<br />
		<hr />
		<script language="JavaScript">
			<![CDATA[
var protocol = "mailto"; 
var user = "webmaster"; 
var server = "leagueplanet.com"; 
function contact() {
	window.open(protocol + ":" + user + "@" + server, "_self");
}
]]>
		</script>

		<p>
			W przypadku pytań odnośnie tej strony WWW, prosimy o konkakt z
			opiekunem serwisu pod adresem
   			<a href="javascript:contact()">webmaster at leagueplanet dot com</a>
   		</p>
	</xsl:template>

</xsl:stylesheet>
