/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.example.ch03;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Database {

	/**
	 * Pobiera z bazy danych pen nazw uytkownika.
	 * 
	 * @param userid
	 *            cig identyfikatora uytkownika
	 * @return cig penej nazwy
	 * @throws SQLException
	 *             w przypadku problemu z baz danych
	 */
	public String lookupFullname(String userid) throws SQLException {

		Connection connection = null;
		PreparedStatement statement = null;
		ResultSet resultset = null;
		String fullname = "";
		String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
		String URL = "jdbc:derby:C:\\web1db";
		String QUERY = "SELECT FULLNAME FROM WEB1.LOGIN WHERE USERID = ?";

		try {
			Class.forName(DRIVER);
			connection = DriverManager.getConnection(URL);
			statement = connection.prepareStatement(QUERY);
			statement.setString(1, userid);
			resultset = statement.executeQuery();

			if (resultset.next())
				fullname = resultset.getString("FULLNAME").trim();

		} catch (Exception e) {
			e.printStackTrace();
		} finally {

			if (resultset != null)
				resultset.close();

			if (statement != null)
				statement.close();

			if (connection != null)
				connection.close();
		}

		return fullname;
	}
}
