package com.packtpub.e4.clock.ui.internal;

import java.util.Date;
import java.util.TimeZone;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TimeZonePropertySource implements IPropertySource {

	private TimeZone timeZone;

	public TimeZonePropertySource(TimeZone timeZone) {
		this.timeZone = timeZone;
	}

	private static final Object ID = new Object();
	private static final Object DAYLIGHT = new Object();
	private static final Object NAME = new Object();

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[] {
				new PropertyDescriptor(ID, "Strefa czasowa"),
				new PropertyDescriptor(DAYLIGHT, "Czas letni"),
				new PropertyDescriptor(NAME, "Nazwa") };
	}

	public Object getPropertyValue(Object id) {
		if (ID.equals(id)) {
			return timeZone.getID();
		} else if (DAYLIGHT.equals(id)) {
			return timeZone.inDaylightTime(new Date());
		} else if (NAME.equals(id)) {
			return timeZone.getDisplayName();
		} else {
			return null;
		}
	}

	@Override
	public Object getEditableValue() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isPropertySet(Object id) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void resetPropertyValue(Object id) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setPropertyValue(Object id, Object value) {
		// TODO Auto-generated method stub

	}

}
