VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CFormResizer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'
' Opis:  Umozliwia zmiane rozmierow formularza i obsluguje zmienianie rozmiarow i pozycji
'               dla wszystkich formantow, uzywajac infoamrcji o zmienie rozmiarow okreslocych w
'               wlasciwosci Tag kazdego formantu
'
' Authors:      Stephen Bullen, www.oaltd.co.uk
'

Option Explicit

''''''''''''''''''''''''''''''''''''''''''''''''''
' Deklaracje poziomu modulu
''''''''''''''''''''''''''''''''''''''''''''''''''

Dim moForm As Object    'Formularz, ktory obslugujemy
Dim mdWidth As Double   'Poprzednia szerokosc formularza
Dim mdHeight As Double  'Poprzednia wysokosc formularza

Dim mdMinHeight As Double   'Minimalna wyskokosc jaka formaular zmoze miec przed pokazaniem paskow przewijania
Dim mdMinWidth As Double    'Minimalna szerokosc jaka formualrz moze miec przed pokazaniem paskow przewijania

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Podajemy, dla ktorego formularza obslugujemy zmiany rozmiarow
'           ustawiajac w zdarzeniu UserForm_Initialize. Umozliwiamy zmiany rozmiarow
'           formularza i okreslamy jego rozmiar i polozenie
'
' Arguments:    oForm       Formularz do obslugi
'
' Data          Deweloper       Dzialanie
' --------------------------------------------------------------
' 05 Cze 04     Stephen Bullen  Utworzyl
'
Public Property Set Form(oNew As Object)

    Dim oCtl As MSForms.Control
    Dim sTag As String
    Dim dMaxHeightChange As Double
    Dim dMaxWidthChange As Double

    'Zapamietanie formularza na pozniej
    Set moForm = oNew

    If Not oNew Is Nothing Then
        'Zapamietanie biezacego rozmiaru do uzycia w metodzie zmiany rozmiarow
        mdWidth = moForm.InsideWidth
        mdHeight = moForm.InsideHeight
        dMaxHeightChange = mdHeight
        dMaxWidthChange = mdWidth
    
        'Wyliczenie minimalnych wymiarow formularza
        For Each oCtl In moForm.Controls
    
            'Odczytanie wlasciwosci Tag fprmatu, ktora zawiera informacje o zmianie rozmiarow
            sTag = UCase(oCtl.Tag)
    
            'Jessli zmieniamy wymiary, sprawdzamy, aby nie bylu ujemne.
            'Maksymalne dozwolona zmiana jest definiowane przez formant, ktory moze sie najmniej przesunac/zmienic rozmiar.
            If InStr(1, sTag, "T", vbBinaryCompare) Then dMaxHeightChange = fnMin(dMaxHeightChange, oCtl.Top / ResizeFactor(sTag, "T"))
            If InStr(1, sTag, "H", vbBinaryCompare) Then dMaxHeightChange = fnMin(dMaxHeightChange, oCtl.Height / ResizeFactor(sTag, "H"))
            If InStr(1, sTag, "L", vbBinaryCompare) Then dMaxWidthChange = fnMin(dMaxWidthChange, oCtl.Left / ResizeFactor(sTag, "L"))
            If InStr(1, sTag, "W", vbBinaryCompare) Then dMaxWidthChange = fnMin(dMaxWidthChange, oCtl.Width / ResizeFactor(sTag, "W"))
        Next
    
        'Obliczanie minimalnych dozwolonych wymiarow, po ktorych widzimy paki przewijania
        mdMinHeight = mdHeight - dMaxHeightChange
        mdMinWidth = mdWidth - dMaxWidthChange
    End If
    
End Property


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komantarza: Wywolywane z zdarzenia User_Form resize. Wyzwalane takze
'           gdy zmienia sie rozmiar samodzielnie
'
' Data          Deweloper       Dzialanie
' --------------------------------------------------------------
' 05 Cze 04     Stephen Bullen  Utworzyl
'
Public Sub FormResize(ByVal dNewWidth As Double, ByVal dNewHeight As Double)

    Dim dHeightAdj As Double
    Dim dWidthAdj As Double
    Dim sTag As String
    Dim oCtl As MSForms.Control
    Dim i As Integer

    On Error Resume Next

    'Sprawdzamy limity dwukrotnie, na wypadek, gdyby pokazac/ukryc paski przewijanie podczas pierwszego sprawdzenia
    For i = 1 To 2
        If dNewHeight - (moForm.Height - moForm.InsideHeight) < mdMinHeight Then
            moForm.ScrollBars = moForm.ScrollBars Or 2
            moForm.ScrollHeight = mdMinHeight
            dHeightAdj = -fnMax(mdHeight - mdMinHeight, 0)
        Else
            'Obliczanie zmieny wysokosci i szerokosci
            dHeightAdj = dNewHeight - (moForm.Height - moForm.InsideHeight) - fnMax(mdHeight, mdMinHeight)
            moForm.ScrollBars = moForm.ScrollBars And Not 2
            moForm.ScrollHeight = 0
        End If

        If dNewWidth - (moForm.Width - moForm.InsideWidth) < mdMinWidth Then
            moForm.ScrollBars = moForm.ScrollBars Or 1
            moForm.ScrollWidth = mdMinWidth
            dWidthAdj = -fnMax(mdWidth - mdMinWidth, 0)
        Else
            dWidthAdj = dNewWidth - (moForm.Width - moForm.InsideWidth) - fnMax(mdWidth, mdMinWidth)
            moForm.ScrollBars = moForm.ScrollBars And Not 1
            moForm.ScrollWidth = 0
        End If
    Next i

    'Petla przez wszystkie formanty na formularzu,
    'regulujac ich polozenie i rozmiar
    For Each oCtl In moForm.Controls
        With oCtl
            sTag = UCase(.Tag)

            'Zmiana gory (Top)
            If InStr(1, sTag, "T", vbBinaryCompare) Then
                .Top = .Top + dHeightAdj * ResizeFactor(sTag, "T")
            End If

            'Zmiana lewa (Left)
            If InStr(1, sTag, "L", vbBinaryCompare) Then
                .Left = .Left + dWidthAdj * ResizeFactor(sTag, "L")
            End If

            'Zmiana wysokosci (Height)
            If InStr(1, sTag, "H", vbBinaryCompare) Then
                .Height = .Height + dHeightAdj * ResizeFactor(sTag, "H")
            End If

            'Zmiana szerokosciu (Width)
            If InStr(1, sTag, "W", vbBinaryCompare) Then
                .Width = .Width + dWidthAdj * ResizeFactor(sTag, "W")
            End If
        End With
    Next        'Formant

    'Zapamietajmy nowe wymiary formularza na nastepny raz
    mdWidth = dNewWidth - (moForm.Width - moForm.InsideWidth)
    mdHeight = dNewHeight - (moForm.Height - moForm.InsideHeight)

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Funkcja do lokalizacji litery wlasciwosci (T, L, H lub W)
'           w lancuchu Tag i zwrocenie wspolczynnika zmiany rozmiarow dla niej
'
' Argumenty:    sTag        Pelen tekst lancucha Tag formantu
'               sChange     Szukana litera wspolczynnika (T, L, H lub W)
'
' Zwaraca:      Wspolczynnik zmiany w procentach
'
' Data          Deweloper       Dzialanie
' --------------------------------------------------------------
' 05 Cze 04     Stephen Bullen  Utworzyl
'
Private Function ResizeFactor(sTag As String, sChange As String)

    Dim iPos As Integer, dfactor As Double

    'Lokalizacja litery wlasciwoscui w lancuchu tag
    iPos = InStr(1, sTag, sChange, vbBinaryCompare)

    'Jesli znalezlismy...
    If iPos > 0 Then

        '... czytamy liczbe
        dfactor = Val(Mid$(sTag, iPos + 1))

        'Jesli nie ma liczby, uzywamy czynnika 100%
        If dfactor = 0 Then dfactor = 1
    End If

    'Zwrocenie czynnika
    ResizeFactor = dfactor

End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Pobranie minimum z dwoch liczb
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Private Function fnMin(ByVal d1 As Double, ByVal d2 As Double) As Double
    If d1 < d2 Then
        fnMin = d1
    Else
        fnMin = d2
    End If
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Komentarze: Pobiera maksimum z dwoch liczb
'
' Data          Deweloper           Dzialanie
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 20 Paz 2005   Stephen Bullen      Utworzyl
'
Private Function fnMax(ByVal d1 As Double, ByVal d2 As Double) As Double
    If d1 > d2 Then
        fnMax = d1
    Else
        fnMax = d2
    End If
End Function


