//
//  TouchesViewController.m
//  Touches
//
//  Created by Todd Moore on 4/21/11.
//  http://toddmoore.com/
//  Demonstracja wielu dotknięć i miejsce ich przesunięcia w kierunku paska stanu.
//

#import "TouchesViewController.h"

@implementation TouchesViewController

- (void)dealloc
{
    [super dealloc];
}

- (void)didReceiveMemoryWarning
{
    // Usunięcie widoków, które nie posiadają widoku nadrzędnego.
    [super didReceiveMemoryWarning];
    
    // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku.

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Zwrot wartości YES dla obsługiwanych układów.
    return (YES);
}


// W tej metodzie zostaną utworzone nowe widoki w celu dopasowania punktów dotknięć.
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
	// Iteracja przez elementy dotknięć.
	for (UITouch *touch in touches)
	{
		// Pobranie punktu dotknięcia widoku.
		CGPoint touchPoint = [touch locationInView: self.view];
        
        // Dodanie nowego podwidoku w miejscu dotknięcia i jego oznaczenie tagiem.
        UIImageView *touchView = [[UIImageView alloc] initWithImage: [UIImage imageNamed: @"touch.png"]];
        touchView.center = touchPoint;
        touchView.tag = (int) touch;
        [self.view addSubview: touchView];
        [touchView release];
	}	
}

// W tej metodzie nastąpi uaktualnienie położenia widoków.
- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event
{
	// Iteracja przez elementy dotknięć i uaktualnienie podwidoków.
	for (UITouch *touch in touches)
	{
        // Pobranie punktu dotknięcia widoku.
		CGPoint touchPoint = [touch locationInView: self.view];
        
        for (UIView *touchView in self.view.subviews)
        {
            if (touchView.tag == (int) touch) 
            {
                touchView.center = touchPoint;
                break;
            }
        }
	}	
}

// W tej metodzie wszystkie dodane widoki zostaną usunięte.
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event
{
	for (UITouch *touch in touches)
	{
        for (UIView *touchView in self.view.subviews)
        {
            if (touchView.tag == (int) touch)
            {
                [touchView removeFromSuperview];
                break;
            }
        }
	}
}

// Ta metoda działa tak samo jak touchesEnded:withEvent:.
- (void)touchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event
{
	[self touchesEnded: touches withEvent:event];
}

@end
