//
//  Puck.h
//  AirHockey
//
//  Created by Górczyński Robert on 20/01/2012.
//

#import <Foundation/Foundation.h>
#import "Paddle.h"

@interface Puck : NSObject
{
    UIView *view;   // Widok krążka kontroluje ten obiekt.
    CGRect rect[3]; // Zawiera prostokąty ograniczające oraz obydwu bramek.
    int box;        // Prostokąt, w którym mieści się krążek.
    float maxSpeed; // Maksymalna prędkość krążka.
    float speed;    // Aktualna prędkość krążka.
    float dx, dy;   // Aktualny kierunek krążka.
    int winner;     // Definicja zwycięzcy
                    // (0= nikt, 1=gracz 2 zdobył punkt, 2=gracz 2 zdobył punkt).
}

// Właściwości tylko do odczytu dotyczące krążka.
@property (readonly) float maxSpeed;
@property (readonly) float speed;
@property (readonly) float dx;
@property (readonly) float dy;
@property (readonly) int winner;

// Inicjalizacja obiektu.
- (id)initWithPuck:(UIView *)puck 
          Boundary:(CGRect)boundary 
             Goal1:(CGRect)goal1 
             Goal2:(CGRect)goal2 
          MaxSpeed:(float)max;

// Wyzerowanie położenia i umieszczenie krążka w środku prostokąta ograniczającego.
- (void)reset;

// Zwrot aktualnego położenia centrum krążka.
- (CGPoint)center;

// Animacja krążka i zwrot wartości true w przypadku uderzenia w ścianę.
- (bool)animate;

// Sprawdzenie, czy wystąpiła kolizja z paletką i na tej podstawie zmiana ścieżki ruchu krążka.
- (bool)handleCollision:(Paddle *)paddle;

@end
