//
//  Paddle.m
//  AirHockey
//
//  Created by Górczyński Robert on 19/01/2012.
//

#import "Paddle.h"

@implementation Paddle

@synthesize touch;
@synthesize speed;
@synthesize maxSpeed;


- (id)initWithView:(UIView *)paddle Boundary:(CGRect)rect MaxSpeed:(float)max
{
    self = [super init];
    
    if (self)
    {
        // Własna inicjalizacja.
        view = paddle;
        boundary = rect;
        maxSpeed = max;
    }
    return self;
}

// Wyzerowanie położenia do środka prostokąta ograniczającego ruch.
- (void)reset
{
    pos.x = boundary.origin.x + boundary.size.width / 2;
    pos.y = boundary.origin.y + boundary.size.height / 2;
    view.center = pos;
}

// Miejsce, do którego powinna zostać przesunięta paletka.
- (void)move:(CGPoint)pt
{
    // Dostosowanie pozycji X, aby paletka pozostała w zdefiniowanym prostokącie.
    if (pt.x < boundary.origin.x) 
    {
        pt.x = boundary.origin.x;
    }
    else if (pt.x > boundary.origin.x + boundary.size.width)
    {
        pt.x = boundary.origin.x + boundary.size.width;
    }
    
    // Dostosowanie pozycji Y, aby paletka pozostała w zdefiniowanym prostokącie.
    if (pt.y < boundary.origin.y) 
    {
        pt.y = boundary.origin.y;
    }
    else if (pt.y > boundary.origin.y + boundary.size.height)
    {
        pt.y = boundary.origin.y + boundary.size.height;
    }
    
    // Uaktualnienie położenia.
    pos = pt;
}

// Punkt centralny paletki.
- (CGPoint)center
{
    return view.center;
}

// Sprawdzenie, czy paletka przecina się z prostokątem.
- (bool)intersects:(CGRect)rect
{
    return CGRectIntersectsRect(view.frame, rect);
}

// Ustalenie odległości dzielącej bieżące położenie paletki i punktu.
- (float)distance:(CGPoint)pt
{
    float diffx = (view.center.x) - (pt.x);
    float diffy = (view.center.y) - (pt.y);
    return sqrt(diffx*diffx + diffy*diffy);
}

// Animacja widoku krążka do kolejnego położenia bez przekraczania prędkości maksymalnej.
- (void)animate
{
    // Sprawdzenie, czy konieczne jest przesunięcie krążka.
    if (CGPointEqualToPoint(view.center,pos) == false)
    {
        // Obliczenie odległości, o jaką trzeba przesunąć krążek.
        float d = [self distance:pos];
        
        // Sprawdzenie maksymalnej odległości jaką może pokonać paletka.
        if (d > maxSpeed)
        {
            // Zmodyfikowanie położenia na maksymalną dozwoloną.
            float r = atan2(pos.y - view.center.y, pos.x - view.center.x);
            float x = view.center.x + cos(r) * (maxSpeed);
            float y = view.center.y + sin(r) * (maxSpeed);
            view.center = CGPointMake(x,y);
            speed = maxSpeed;
        }
        else
        {
            // Ustawienie położenia paletki ponieważ nie przekracza prędkości maksymalnej.
            view.center = pos;
            speed = d;
        }
    }
    else
    {
        // Brak ruchu.
        speed = 0;
    }
}

- (void)dealloc
{
    [super dealloc];
}


@end
