/*!
 * jQuery JavaScript Library v3.3.1
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2018-01-20T17:24Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var document = window.document;

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var concat = arr.concat;

var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

      // Support: Chrome <=57, Firefox <=52
      // In some browsers, typeof returns "function" for HTML <object> elements
      // (i.e., `typeof document.createElement( "object" ) === "function"`).
      // We don't want to classify *any* DOM node as a function.
      return typeof obj === "function" && typeof obj.nodeType !== "number";
  };


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};




	var preservedScriptAttributes = {
		type: true,
		src: true,
		noModule: true
	};

	function DOMEval( code, doc, node ) {
		doc = doc || document;

		var i,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {
				if ( node[ i ] ) {
					script[ i ] = node[ i ];
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.3.1",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	},

	// Support: Android <=4.0 only
	// Make sure we trim BOM and NBSP
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {

					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && Array.isArray( src ) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject( src ) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {

		/* eslint-disable no-unused-vars */
		// See https://github.com/eslint/eslint/issues/6125
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a global context
	globalEval: function( code ) {
		DOMEval( code );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// Support: Android <=4.0 only
	trim: function( text ) {
		return text == null ?
			"" :
			( text + "" ).replace( rtrim, "" );
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.3
 * https://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2016-08-08
 */
(function( window ) {

var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ({}).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	push_native = arr.push,
	push = arr.push,
	slice = arr.slice,
	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = "(?:\\\\.|[\\w-]|[^\0-\\xa0])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +
		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +
		// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace +
		"*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +
		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +
		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),

	rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),
		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
			whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),
	funescape = function( _, escaped, escapedWhitespace ) {
		var high = "0x" + escaped - 0x10000;
		// NaN means non-codepoint
		// Support: Firefox<24
		// Workaround erroneous numeric interpretation of +"0x"
		return high !== high || escapedWhitespace ?
			escaped :
			high < 0 ?
				// BMP codepoint
				String.fromCharCode( high + 0x10000 ) :
				// Supplemental Plane codepoint (surrogate pair)
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	disabledAncestor = addCombinator(
		function( elem ) {
			return elem.disabled === true && ("form" in elem || "label" in elem);
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		(arr = slice.call( preferredDoc.childNodes )),
		preferredDoc.childNodes
	);
	// Support: Android<4.0
	// Detect silently failing push.apply
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			push_native.apply( target, slice.call(els) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;
			// Can't trust NodeList.length
			while ( (target[j++] = els[i++]) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {

		if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {
			setDocument( context );
		}
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {

				// ID selector
				if ( (m = match[1]) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( (elem = context.getElementById( m )) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && (elem = newContext.getElementById( m )) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[2] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( (m = match[3]) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!compilerCache[ selector + " " ] &&
				(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {

				if ( nodeType !== 1 ) {
					newContext = context;
					newSelector = selector;

				// qSA looks outside Element context, which is not what we want
				// Thanks to Andrew Dupont for this workaround technique
				// Support: IE <=8
				// Exclude object elements
				} else if ( context.nodeName.toLowerCase() !== "object" ) {

					// Capture the context ID, setting it first if necessary
					if ( (nid = context.getAttribute( "id" )) ) {
						nid = nid.replace( rcssescape, fcssescape );
					} else {
						context.setAttribute( "id", (nid = expando) );
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[i] = "#" + nid + " " + toSelector( groups[i] );
					}
					newSelector = groups.join( "," );

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;
				}

				if ( newSelector ) {
					try {
						push.apply( results,
							newContext.querySelectorAll( newSelector )
						);
						return results;
					} catch ( qsaError ) {
					} finally {
						if ( nid === expando ) {
							context.removeAttribute( "id" );
						}
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {
		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {
			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return (cache[ key + " " ] = value);
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement("fieldset");

	try {
		return !!fn( el );
	} catch (e) {
		return false;
	} finally {
		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}
		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split("|"),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[i] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( (cur = cur.nextSibling) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
						disabledAncestor( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9-11, Edge
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	if ( preferredDoc !== document &&
		(subWindow = document.defaultView) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert(function( el ) {
		el.className = "i";
		return !el.getAttribute("className");
	});

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert(function( el ) {
		el.appendChild( document.createComment("") );
		return !el.getElementsByTagName("*").length;
	});

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert(function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	});

	// ID filter and find
	if ( support.getById ) {
		Expr.filter["ID"] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute("id") === attrId;
			};
		};
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter["ID"] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode("id");
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode("id");
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( (elem = elems[i++]) ) {
						node = elem.getAttributeNode("id");
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find["TAG"] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,
				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( (elem = results[i++]) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( (support.qsa = rnative.test( document.querySelectorAll )) ) {
		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( el ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll("[msallowcapture^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push("~=");
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push(".#.+[+~]");
			}
		});

		assert(function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement("input");
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll("[name=d]").length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll(":enabled").length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll(":disabled").length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll("*,:x");
			rbuggyQSA.push(",.*:");
		});
	}

	if ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector) )) ) {

		assert(function( el ) {
			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		});
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			));
		} :
		function( a, b ) {
			if ( b ) {
				while ( (b = b.parentNode) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {

			// Choose the first element that is related to our preferred document
			if ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {
				return -1;
			}
			if ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {
		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {
			return a === document ? -1 :
				b === document ? 1 :
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( (cur = cur.parentNode) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( (cur = cur.parentNode) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[i] === bp[i] ) {
			i++;
		}

		return i ?
			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[i], bp[i] ) :

			// Otherwise nodes in our document sort first
			ap[i] === preferredDoc ? -1 :
			bp[i] === preferredDoc ? 1 :
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	// Make sure that attribute selectors are quoted
	expr = expr.replace( rattributeQuotes, "='$1']" );

	if ( support.matchesSelector && documentIsHTML &&
		!compilerCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||
					// As well, disconnected nodes are said to be in a document
					// fragment in IE 9
					elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch (e) {}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {
	// Set document vars if needed
	if ( ( context.ownerDocument || context ) !== document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],
		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			(val = elem.getAttributeNode(name)) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return (sel + "").replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( (elem = results[i++]) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {
		// If no nodeType, this is expected to be an array
		while ( (node = elem[i++]) ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {
			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}
	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[3] || match[4] || match[5] || "" ).replace( runescape, funescape );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1].slice( 0, 3 ) === "nth" ) {
				// nth-* requires argument
				if ( !match[3] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );
				match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );

			// other types prohibit arguments
			} else if ( match[3] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[6] && match[2];

			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[3] ) {
				match[2] = match[4] || match[5] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&
				// Get excess from tokenize (recursively)
				(excess = tokenize( unquoted, true )) &&
				// advance to the next closing parenthesis
				(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

				// excess is a negative index
				match[0] = match[0].slice( 0, excess );
				match[2] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() { return true; } :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
				classCache( className, function( elem ) {
					return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "" );
				});
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, what, argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( (node = node[ dir ]) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}
								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || (node[ expando ] = {});

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								(outerCache[ node.uniqueID ] = {});

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( (node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								(diff = nodeIndex = 0) || start.pop()) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {
							// Use previously-cached element index if available
							if ( useCache ) {
								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || (node[ expando ] = {});

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									(outerCache[ node.uniqueID ] = {});

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {
								// Use the same loop as above to seek `elem` from the start
								while ( (node = ++nodeIndex && node && node[ dir ] ||
									(diff = nodeIndex = 0) || start.pop()) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] || (node[ expando ] = {});

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												(outerCache[ node.uniqueID ] = {});

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		// Potentially complex pseudos
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					// Don't keep the element (issue #299)
					input[0] = null;
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {
			// lang value must be a valid identifier
			if ( !ridentifier.test(lang || "") ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( (elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( (elem = elem.parentNode) && elem.nodeType === 1 );
				return false;
			};
		}),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo(function() {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[0].length ) || soFar;
			}
			groups.push( (tokens = []) );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			matched = match.shift();
			tokens.push({
				value: matched,
				// Cast descendant combinators to space
				type: match[0].replace( rtrim, " " )
			});
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				(match = preFilters[ type ]( match ))) ) {
				matched = match.shift();
				tokens.push({
					value: matched,
					type: type,
					matches: match
				});
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[i].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || (elem[ expando ] = {});

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( (oldCache = uniqueCache[ key ]) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return (newCache[ 2 ] = oldCache[ 2 ]);
						} else {
							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( (elem = temp[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {
					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( (elem = matcherOut[i]) ) {
							// Restore matcherIn since elem is not yet a final match
							temp.push( (matcherIn[i] = elem) );
						}
					}
					postFinder( null, (matcherOut = []), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( (elem = matcherOut[i]) &&
						(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {

						seed[temp] = !(results[temp] = elem);
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];
		} else {
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(
						// If the preceding token was a descendant combinator, insert an implicit any-element `*`
						tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,
				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),
				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),
				len = elems.length;

			if ( outermost ) {
				outermostContext = context === document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;
					if ( !context && elem.ownerDocument !== document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( (matcher = elementMatchers[j++]) ) {
						if ( matcher( elem, context || document, xml) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( (matcher = setMatchers[j++]) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( (selector = compiled.selector || selector) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[0] = match[0].slice( 0 );
		if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
				context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[1].type ] ) {

			context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[i];

			// Abort if we hit a combinator
			if ( Expr.relative[ (type = token.type) ] ) {
				break;
			}
			if ( (find = Expr.find[ type ]) ) {
				// Search, expanding context for leading sibling combinators
				if ( (seed = find(
					token.matches[0].replace( runescape, funescape ),
					rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context
				)) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert(function( el ) {
	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement("fieldset") ) & 1;
});

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert(function( el ) {
	el.innerHTML = "<a href='#'></a>";
	return el.firstChild.getAttribute("href") === "#" ;
}) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	});
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert(function( el ) {
	el.innerHTML = "<input/>";
	el.firstChild.setAttribute( "value", "" );
	return el.firstChild.getAttribute( "value" ) === "";
}) ) {
	addHandle( "value", function( elem, name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	});
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert(function( el ) {
	return el.getAttribute("disabled") == null;
}) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
					(val = elem.getAttributeNode( name )) && val.specified ?
					val.value :
				null;
		}
	});
}

return Sizzle;

})( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;
jQuery.escapeSelector = Sizzle.escape;




var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;



function nodeName( elem, name ) {

  return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

};
var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to Sizzle
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
        if ( nodeName( elem, "iframe" ) ) {
            return elem.contentDocument;
        }

        // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
        // Treat the template element as a regular one in browsers that
        // don't support it.
        if ( nodeName( elem, "template" ) ) {
            elem = elem.content || elem;
        }

        return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenables
		} else if ( value && isFunction( ( method = value.then ) ) ) {
			method.call( value, resolve, reject );

		// Other non-thenables
		} else {

			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
			// * false: [ value ].slice( 0 ) => resolve( value )
			// * true: [ value ].slice( 1 ) => resolve()
			resolve.apply( undefined, [ value ].slice( noValue ) );
		}

	// For Promises/A+, convert exceptions into rejections
	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	// Deferred#then to conditionally suppress rejection.
	} catch ( value ) {

		// Support: Android 4.0 only
		// Strict mode functions invoked without .call/.apply get global-object context
		reject.apply( undefined, [ value ] );
	}
}

jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, callbacks,
				// ... .then handlers, argument index, [final state]
				[ "notify", "progress", jQuery.Callbacks( "memory" ),
					jQuery.Callbacks( "memory" ), 2 ],
				[ "resolve", "done", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 0, "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 1, "rejected" ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				"catch": function( fn ) {
					return promise.then( null, fn );
				},

				// Keep pipe for back-compat
				pipe: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;

					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {

							// Map tuples (progress, done, fail) to arguments (done, fail, progress)
							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

							// deferred.progress(function() { bind to newDefer or newDefer.notify })
							// deferred.done(function() { bind to newDefer or newDefer.resolve })
							// deferred.fail(function() { bind to newDefer or newDefer.reject })
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},
				then: function( onFulfilled, onRejected, onProgress ) {
					var maxDepth = 0;
					function resolve( depth, deferred, handler, special ) {
						return function() {
							var that = this,
								args = arguments,
								mightThrow = function() {
									var returned, then;

									// Support: Promises/A+ section 2.3.3.3.3
									// https://promisesaplus.com/#point-59
									// Ignore double-resolution attempts
									if ( depth < maxDepth ) {
										return;
									}

									returned = handler.apply( that, args );

									// Support: Promises/A+ section 2.3.1
									// https://promisesaplus.com/#point-48
									if ( returned === deferred.promise() ) {
										throw new TypeError( "Thenable self-resolution" );
									}

									// Support: Promises/A+ sections 2.3.3.1, 3.5
									// https://promisesaplus.com/#point-54
									// https://promisesaplus.com/#point-75
									// Retrieve `then` only once
									then = returned &&

										// Support: Promises/A+ section 2.3.4
										// https://promisesaplus.com/#point-64
										// Only check objects and functions for thenability
										( typeof returned === "object" ||
											typeof returned === "function" ) &&
										returned.then;

									// Handle a returned thenable
									if ( isFunction( then ) ) {

										// Special processors (notify) just wait for resolution
										if ( special ) {
											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special )
											);

										// Normal processors (resolve) also hook into progress
										} else {

											// ...and disregard older resolution values
											maxDepth++;

											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special ),
												resolve( maxDepth, deferred, Identity,
													deferred.notifyWith )
											);
										}

									// Handle all other returned values
									} else {

										// Only substitute handlers pass on context
										// and multiple values (non-spec behavior)
										if ( handler !== Identity ) {
											that = undefined;
											args = [ returned ];
										}

										// Process the value(s)
										// Default process is resolve
										( special || deferred.resolveWith )( that, args );
									}
								},

								// Only normal processors (resolve) catch and reject exceptions
								process = special ?
									mightThrow :
									function() {
										try {
											mightThrow();
										} catch ( e ) {

											if ( jQuery.Deferred.exceptionHook ) {
												jQuery.Deferred.exceptionHook( e,
													process.stackTrace );
											}

											// Support: Promises/A+ section 2.3.3.3.4.1
											// https://promisesaplus.com/#point-61
											// Ignore post-resolution exceptions
											if ( depth + 1 >= maxDepth ) {

												// Only substitute handlers pass on context
												// and multiple values (non-spec behavior)
												if ( handler !== Thrower ) {
													that = undefined;
													args = [ e ];
												}

												deferred.rejectWith( that, args );
											}
										}
									};

							// Support: Promises/A+ section 2.3.3.3.1
							// https://promisesaplus.com/#point-57
							// Re-resolve promises immediately to dodge false rejection from
							// subsequent errors
							if ( depth ) {
								process();
							} else {

								// Call an optional hook to record the stack, in case of exception
								// since it's otherwise lost when execution goes async
								if ( jQuery.Deferred.getStackHook ) {
									process.stackTrace = jQuery.Deferred.getStackHook();
								}
								window.setTimeout( process );
							}
						};
					}

					return jQuery.Deferred( function( newDefer ) {

						// progress_handlers.add( ... )
						tuples[ 0 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onProgress ) ?
									onProgress :
									Identity,
								newDefer.notifyWith
							)
						);

						// fulfilled_handlers.add( ... )
						tuples[ 1 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onFulfilled ) ?
									onFulfilled :
									Identity
							)
						);

						// rejected_handlers.add( ... )
						tuples[ 2 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onRejected ) ?
									onRejected :
									Thrower
							)
						);
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 5 ];

			// promise.progress = list.add
			// promise.done = list.add
			// promise.fail = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(
					function() {

						// state = "resolved" (i.e., fulfilled)
						// state = "rejected"
						state = stateString;
					},

					// rejected_callbacks.disable
					// fulfilled_callbacks.disable
					tuples[ 3 - i ][ 2 ].disable,

					// rejected_handlers.disable
					// fulfilled_handlers.disable
					tuples[ 3 - i ][ 3 ].disable,

					// progress_callbacks.lock
					tuples[ 0 ][ 2 ].lock,

					// progress_handlers.lock
					tuples[ 0 ][ 3 ].lock
				);
			}

			// progress_handlers.fire
			// fulfilled_handlers.fire
			// rejected_handlers.fire
			list.add( tuple[ 3 ].fire );

			// deferred.notify = function() { deferred.notifyWith(...) }
			// deferred.resolve = function() { deferred.resolveWith(...) }
			// deferred.reject = function() { deferred.rejectWith(...) }
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
				return this;
			};

			// deferred.notifyWith = list.fireWith
			// deferred.resolveWith = list.fireWith
			// deferred.rejectWith = list.fireWith
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( singleValue ) {
		var

			// count of uncompleted subordinates
			remaining = arguments.length,

			// count of unprocessed arguments
			i = remaining,

			// subordinate fulfillment data
			resolveContexts = Array( i ),
			resolveValues = slice.call( arguments ),

			// the master Deferred
			master = jQuery.Deferred(),

			// subordinate callback factory
			updateFunc = function( i ) {
				return function( value ) {
					resolveContexts[ i ] = this;
					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( !( --remaining ) ) {
						master.resolveWith( resolveContexts, resolveValues );
					}
				};
			};

		// Single- and empty arguments are adopted like Promise.resolve
		if ( remaining <= 1 ) {
			adoptValue( singleValue, master.done( updateFunc( i ) ).resolve, master.reject,
				!remaining );

			// Use .then() to unwrap secondary thenables (cf. gh-3000)
			if ( master.state() === "pending" ||
				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

				return master.then();
			}
		}

		// Multiple arguments are aggregated like Promise.all array elements
		while ( i-- ) {
			adoptValue( resolveValues[ i ], updateFunc( i ), master.reject );
		}

		return master.promise();
	}
} );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

jQuery.Deferred.exceptionHook = function( error, stack ) {

	// Support: IE 8 - 9 only
	// Console exists when dev tools are open, which can happen at any time
	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
		window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );
	}
};




jQuery.readyException = function( error ) {
	window.setTimeout( function() {
		throw error;
	} );
};




// The deferred used on DOM ready
var readyList = jQuery.Deferred();

jQuery.fn.ready = function( fn ) {

	readyList
		.then( fn )

		// Wrap jQuery.readyException in a function so that the lookup
		// happens at the time of error handling instead of callback
		// registration.
		.catch( function( error ) {
			jQuery.readyException( error );
		} );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );
	}
} );

jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
if ( document.readyState === "complete" ||
	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

	// Handle it asynchronously to allow scripts the opportunity to delay ready
	window.setTimeout( jQuery.ready );

} else {

	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", completed );

	// A fallback to window.onload, that will always work
	window.addEventListener( "load", completed );
}




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( toType( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
					value :
					value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	if ( chainable ) {
		return elems;
	}

	// Gets
	if ( bulk ) {
		return fn.call( elems );
	}

	return len ? fn( elems[ 0 ], key ) : emptyGet;
};


// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/,
	rdashAlpha = /-([a-z])/g;

// Used by camelCase as callback to replace()
function fcamelCase( all, letter ) {
	return letter.toUpperCase();
}

// Convert dashed to camelCase; used by the css and data modules
// Support: IE <=9 - 11, Edge 12 - 15
// Microsoft forgot to hump their vendor prefix (#9572)
function camelCase( string ) {
	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
}
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	cache: function( owner ) {

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		// Always use camelCase key (gh-2257)
		if ( typeof data === "string" ) {
			cache[ camelCase( data ) ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ camelCase( prop ) ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :

			// Always use camelCase key (gh-2257)
			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
	},
	access: function( owner, key, value ) {

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			return this.get( owner, key );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key !== undefined ) {

			// Support array or space separated string of keys
			if ( Array.isArray( key ) ) {

				// If key is an array of keys...
				// We always set camelCase keys, so remove that.
				key = key.map( camelCase );
			} else {
				key = camelCase( key );

				// If a key with the spaces exists, use it.
				// Otherwise, create an array by matching non-whitespace
				key = key in cache ?
					[ key ] :
					( key.match( rnothtmlwhite ) || [] );
			}

			i = key.length;

			while ( i-- ) {
				delete cache[ key[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <=35 - 45
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function getData( data ) {
	if ( data === "true" ) {
		return true;
	}

	if ( data === "false" ) {
		return false;
	}

	if ( data === "null" ) {
		return null;
	}

	// Only convert to a number if it doesn't change the string
	if ( data === +data + "" ) {
		return +data;
	}

	if ( rbrace.test( data ) ) {
		return JSON.parse( data );
	}

	return data;
}

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = getData( data );
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE 11 only
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// The key will always be camelCased in Data
				data = dataUser.get( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			this.each( function() {

				// We always store the camelCased key
				dataUser.set( this, key, value );
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || Array.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var isHiddenWithinTree = function( elem, el ) {

		// isHiddenWithinTree might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;

		// Inline style trumps all
		return elem.style.display === "none" ||
			elem.style.display === "" &&

			// Otherwise, check computed style
			// Support: Firefox <=43 - 45
			// Disconnected elements can have computed display: none, so first confirm that elem is
			// in the document.
			jQuery.contains( elem.ownerDocument, elem ) &&

			jQuery.css( elem, "display" ) === "none";
	};

var swap = function( elem, options, callback, args ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.apply( elem, args || [] );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};




function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted, scale,
		maxIterations = 20,
		currentValue = tween ?
			function() {
				return tween.cur();
			} :
			function() {
				return jQuery.css( elem, prop, "" );
			},
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = ( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Support: Firefox <=54
		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
		initial = initial / 2;

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		while ( maxIterations-- ) {

			// Evaluate and update our best guess (doubling guesses that zero out).
			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
			jQuery.style( elem, prop, initialInUnit + unit );
			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
				maxIterations = 0;
			}
			initialInUnit = initialInUnit / scale;

		}

		initialInUnit = initialInUnit * 2;
		jQuery.style( elem, prop, initialInUnit + unit );

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}


var defaultDisplayMap = {};

function getDefaultDisplay( elem ) {
	var temp,
		doc = elem.ownerDocument,
		nodeName = elem.nodeName,
		display = defaultDisplayMap[ nodeName ];

	if ( display ) {
		return display;
	}

	temp = doc.body.appendChild( doc.createElement( nodeName ) );
	display = jQuery.css( temp, "display" );

	temp.parentNode.removeChild( temp );

	if ( display === "none" ) {
		display = "block";
	}
	defaultDisplayMap[ nodeName ] = display;

	return display;
}

function showHide( elements, show ) {
	var display, elem,
		values = [],
		index = 0,
		length = elements.length;

	// Determine new display value for elements that need to change
	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		display = elem.style.display;
		if ( show ) {

			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
			// check is required in this first loop unless we have a nonempty display value (either
			// inline or about-to-be-restored)
			if ( display === "none" ) {
				values[ index ] = dataPriv.get( elem, "display" ) || null;
				if ( !values[ index ] ) {
					elem.style.display = "";
				}
			}
			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
				values[ index ] = getDefaultDisplay( elem );
			}
		} else {
			if ( display !== "none" ) {
				values[ index ] = "none";

				// Remember what we're overwriting
				dataPriv.set( elem, "display", display );
			}
		}
	}

	// Set the display of the elements in a second loop to avoid constant reflow
	for ( index = 0; index < length; index++ ) {
		if ( values[ index ] != null ) {
			elements[ index ].style.display = values[ index ];
		}
	}

	return elements;
}

jQuery.fn.extend( {
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHiddenWithinTree( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]+)/i );

var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// Support: IE <=9 only
	option: [ 1, "<select multiple='multiple'>", "</select>" ],

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

// Support: IE <=9 only
wrapMap.optgroup = wrapMap.option;

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;


function getAll( context, tag ) {

	// Support: IE <=9 - 11 only
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret;

	if ( typeof context.getElementsByTagName !== "undefined" ) {
		ret = context.getElementsByTagName( tag || "*" );

	} else if ( typeof context.querySelectorAll !== "undefined" ) {
		ret = context.querySelectorAll( tag || "*" );

	} else {
		ret = [];
	}

	if ( tag === undefined || tag && nodeName( context, tag ) ) {
		return jQuery.merge( [ context ], ret );
	}

	return ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, contains, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( toType( elem ) === "object" ) {

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		contains = jQuery.contains( elem.ownerDocument, elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( contains ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0 - 4.3 only
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Android <=4.1 only
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE <=11 only
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;
} )();
var documentElement = document.documentElement;



var
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE <=9 only
// See #13393 for more info
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Don't attach events to noData or text/comment nodes (but allow plain objects)
		if ( !elemData ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Ensure that invalid selectors throw exceptions at attach time
		// Evaluate against documentElement in case elem is a non-element node (e.g., document)
		if ( selector ) {
			jQuery.find.matchesSelector( documentElement, selector );
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = {};
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( nativeEvent ) {

		// Make a writable jQuery.Event from the native event object
		var event = jQuery.event.fix( nativeEvent );

		var i, j, ret, matched, handleObj, handlerQueue,
			args = new Array( arguments.length ),
			handlers = ( dataPriv.get( this, "events" ) || {} )[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;

		for ( i = 1; i < arguments.length; i++ ) {
			args[ i ] = arguments[ i ];
		}

		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// Triggered event must either 1) have no namespace, or 2) have namespace(s)
				// a subset or equal to those in the bound event (both can have no namespace).
				if ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, handleObj, sel, matchedHandlers, matchedSelectors,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		if ( delegateCount &&

			// Support: IE <=9
			// Black-hole SVG <use> instance trees (trac-13180)
			cur.nodeType &&

			// Support: Firefox <=42
			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
			// Support: IE 11 only
			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
			!( event.type === "click" && event.button >= 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
					matchedHandlers = [];
					matchedSelectors = {};
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matchedSelectors[ sel ] === undefined ) {
							matchedSelectors[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matchedSelectors[ sel ] ) {
							matchedHandlers.push( handleObj );
						}
					}
					if ( matchedHandlers.length ) {
						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		cur = this;
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	addProp: function( name, hook ) {
		Object.defineProperty( jQuery.Event.prototype, name, {
			enumerable: true,
			configurable: true,

			get: isFunction( hook ) ?
				function() {
					if ( this.originalEvent ) {
							return hook( this.originalEvent );
					}
				} :
				function() {
					if ( this.originalEvent ) {
							return this.originalEvent[ name ];
					}
				},

			set: function( value ) {
				Object.defineProperty( this, name, {
					enumerable: true,
					configurable: true,
					writable: true,
					value: value
				} );
			}
		} );
	},

	fix: function( originalEvent ) {
		return originalEvent[ jQuery.expando ] ?
			originalEvent :
			new jQuery.Event( originalEvent );
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		focus: {

			// Fire native event if possible so blur/focus sequence is correct
			trigger: function() {
				if ( this !== safeActiveElement() && this.focus ) {
					this.focus();
					return false;
				}
			},
			delegateType: "focusin"
		},
		blur: {
			trigger: function() {
				if ( this === safeActiveElement() && this.blur ) {
					this.blur();
					return false;
				}
			},
			delegateType: "focusout"
		},
		click: {

			// For checkbox, fire native event so checked state will be right
			trigger: function() {
				if ( this.type === "checkbox" && this.click && nodeName( this, "input" ) ) {
					this.click();
					return false;
				}
			},

			// For cross-browser consistency, don't fire native .click() on links
			_default: function( event ) {
				return nodeName( event.target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android <=2.3 only
				src.returnValue === false ?
			returnTrue :
			returnFalse;

		// Create target properties
		// Support: Safari <=6 - 7 only
		// Target should not be a text node (#504, #13143)
		this.target = ( src.target && src.target.nodeType === 3 ) ?
			src.target.parentNode :
			src.target;

		this.currentTarget = src.currentTarget;
		this.relatedTarget = src.relatedTarget;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || Date.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,
	isSimulated: false,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e && !this.isSimulated ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Includes all common event props including KeyEvent and MouseEvent specific props
jQuery.each( {
	altKey: true,
	bubbles: true,
	cancelable: true,
	changedTouches: true,
	ctrlKey: true,
	detail: true,
	eventPhase: true,
	metaKey: true,
	pageX: true,
	pageY: true,
	shiftKey: true,
	view: true,
	"char": true,
	charCode: true,
	key: true,
	keyCode: true,
	button: true,
	buttons: true,
	clientX: true,
	clientY: true,
	offsetX: true,
	offsetY: true,
	pointerId: true,
	pointerType: true,
	screenX: true,
	screenY: true,
	targetTouches: true,
	toElement: true,
	touches: true,

	which: function( event ) {
		var button = event.button;

		// Add which for key events
		if ( event.which == null && rkeyEvent.test( event.type ) ) {
			return event.charCode != null ? event.charCode : event.keyCode;
		}

		// Add which for click: 1 === left; 2 === middle; 3 === right
		if ( !event.which && button !== undefined && rmouseEvent.test( event.type ) ) {
			if ( button & 1 ) {
				return 1;
			}

			if ( button & 2 ) {
				return 3;
			}

			if ( button & 4 ) {
				return 2;
			}

			return 0;
		}

		return event.which;
	}
}, jQuery.event.addProp );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {

	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var

	/* eslint-disable max-len */

	// See https://github.com/eslint/eslint/issues/3229
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,

	/* eslint-enable */

	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Prefer a tbody over its parent table for containing new rows
function manipulationTarget( elem, content ) {
	if ( nodeName( elem, "table" ) &&
		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
	}

	return elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
		elem.type = elem.type.slice( 5 );
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.access( src );
		pdataCur = dataPriv.set( dest, pdataOld );
		events = pdataOld.events;

		if ( events ) {
			delete pdataCur.handle;
			pdataCur.events = {};

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = concat.apply( [], args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		valueIsFunction = isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( valueIsFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( valueIsFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android <=4.0 only, PhantomJS 1 only
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl ) {
								jQuery._evalUrl( node.src );
							}
						} else {
							DOMEval( node.textContent.replace( rcleanScript, "" ), doc, node );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && jQuery.contains( node.ownerDocument, node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html.replace( rxhtmlTag, "<$1></$2>" );
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = jQuery.contains( elem.ownerDocument, elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {
	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: Android <=4.0 only, PhantomJS 1 only
			// .get() because push.apply(_, arraylike) throws on ancient WebKit
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE <=11 only, Firefox <=30 (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



( function() {

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {

		// This is a singleton, we need to execute it only once
		if ( !div ) {
			return;
		}

		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
			"margin-top:1px;padding:0;border:0";
		div.style.cssText =
			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
			"margin:auto;border:1px;padding:1px;" +
			"width:60%;top:1%";
		documentElement.appendChild( container ).appendChild( div );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";

		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
		// Some styles come back with percentage values, even though they shouldn't
		div.style.right = "60%";
		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

		// Support: IE 9 - 11 only
		// Detect misreporting of content dimensions for box-sizing:border-box elements
		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

		// Support: IE 9 only
		// Detect overflow:scroll screwiness (gh-3699)
		div.style.position = "absolute";
		scrollboxSizeVal = div.offsetWidth === 36 || "absolute";

		documentElement.removeChild( container );

		// Nullify the div so it wouldn't be stored in the memory and
		// it will also be a sign that checks already performed
		div = null;
	}

	function roundPixelMeasures( measure ) {
		return Math.round( parseFloat( measure ) );
	}

	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
		reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE <=9 - 11 only
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	jQuery.extend( support, {
		boxSizingReliable: function() {
			computeStyleTests();
			return boxSizingReliableVal;
		},
		pixelBoxStyles: function() {
			computeStyleTests();
			return pixelBoxStylesVal;
		},
		pixelPosition: function() {
			computeStyleTests();
			return pixelPositionVal;
		},
		reliableMarginLeft: function() {
			computeStyleTests();
			return reliableMarginLeftVal;
		},
		scrollboxSize: function() {
			computeStyleTests();
			return scrollboxSizeVal;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,

		// Support: Firefox 51+
		// Retrieving style before computed somehow
		// fixes an issue with getting wrong values
		// on detached elements
		style = elem.style;

	computed = computed || getStyles( elem );

	// getPropertyValue is needed for:
	//   .css('filter') (IE 9 only, #12537)
	//   .css('--customProperty) (#3144)
	if ( computed ) {
		ret = computed.getPropertyValue( name ) || computed[ name ];

		if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {
			ret = jQuery.style( elem, name );
		}

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// https://drafts.csswg.org/cssom/#resolved-values
		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE <=9 - 11 only
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rcustomProp = /^--/,
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	},

	cssPrefixes = [ "Webkit", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style;

// Return a css property mapped to a potentially vendor prefixed property
function vendorPropName( name ) {

	// Shortcut for names that are not vendor prefixed
	if ( name in emptyStyle ) {
		return name;
	}

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

// Return a property mapped along what jQuery.cssProps suggests or to
// a vendor prefixed property.
function finalPropName( name ) {
	var ret = jQuery.cssProps[ name ];
	if ( !ret ) {
		ret = jQuery.cssProps[ name ] = vendorPropName( name ) || name;
	}
	return ret;
}

function setPositiveNumber( elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matchematfeenX:elem ).chp.max(tyV"nt
	var mcollection.lVal = divS value );porleOb		i = csiaoundClip E 9 rty: tro{

							srcElements bugs, seeouseporI//drafts.csswg.org/cs ] deObfvar divStyle = window.getComputedStyle( dis.parse s bugolute", vis. ( dest.no// ) {
 th	 one|ty thame = cssPref generic owent WebKit are, vis. ( dest.no// th	-= "position:  !== "modugth;
			while ( ncy), reemDa		i = cssn, "Moz", e[ 0 ].toUppees,c3 by DQuery.htdocumenn() { val htleOblt IminWidth = style.maxWPrem ).chp.maxx(tyV"nt
 Language Biiyle.maxWP/ches || ""s:/ DQuery.htdocumenn() { valt( elem ) (
		nanored elements ttyle.maxWP for endle rather thaeObfvar03 by s = rs,
			clond, handle th	 ( dis.paraments );
.parse s ame ) {
	varne itselry.args );

	 {
	 in emptyStyl	  iss.originalEv2 ] - ( for vnction() {
	 addGetHoa name> 1 && t= jQuer	reret;e =key:l = roundPixetaine[ 0end(		v
	onIsFunct20\ in emptyStyl	  i dis..parse sri <=9.etPosi;
function 			 selt cor, in ente(nlue, subtssible to use t( elem )em ) (
		
idt in pop= this: "hiddendata.even remainon fge ecto: "hiddey CSSOM dr yle.maxWP		is o ) ) ) {
	r, furn {
	ula	
idt in pop= this: "hiddfb,;
varildreery.( ncy), rhe t &&( ipes. );dleOi,
 {

WP		is l, ( tyhandli, l,emeedeQuervalvent			ery.event.ret;e =key:
the	 d al		jQuerdomtypep( eleg, afaul );
	};
} );
v
		let l, ( tyhandli,tandli, l,{
				t for namty.
function finalPropName( name ) {
, afaured elemlectionn;
ndleon,.selj ) namty.
nrgetreturn , argu
			pep( eleg, afaul 
		return  l		jQuerdomiet;
}

function) {

		 =  ( tt;
s-ob
		reasS, aectoith)
		omputreer.even re"ty.
fuis-h;
		}t) namty.
eent;

		retur	 selt cor,r3y	pep( elen() {
i prefixed.get;
				retu ) ) {
	

				trp"eleg, isdlacing each non-ignor div.ssep			ction( valy CSSOM dr r3ycor,r3y	pents.lengthn used as in l = spply( this, arm the na elem.nop"eent;
ism= spply( thuerbugs.chromium.;
isrt if t
			,{
				t"		retuis-um.;
isrt irdomiet;
 ( ; ( elnee https:n:  !" div.sis-;
 ( ; ( elvaly C"n:  			evenutreeturn , "engthnis-		if ( ret 
eent;
[ dataPrin
	// chec val "op"eenisl, remove itsep(#1=== 36;

		//  !== 1reri6;

		//  hpply( thies://conne				}

	dFragme pr

	// Sslinterent;l		jQuerdthe re fge ectoC"n:  			misrep	// chec val "op"e =  arge u thg re onght
ok needed;ienisl, reOld = / a vent;

	ul 
		return  l		jQuerdoe div st;

	ul 
		miet;
 ( ! /	// Evalnt or a[ 0htmli ]/<scon.	ave reOld =l,ny re	ret = jQuery.cs
( i = 0;first |hilchecpts = /11,  l	a diva0;first ;w=lchecpts 
or con.	ave reOld =l,ny re	r.;
isrt ir WegettoreScript\s*$
		

//eattest( value ) &&
				!wr
	r, fnts );
StyleTests(); this.pushStack( r( event( elem, content ) {
				nt )e =	if iptodeNor =i < l;{
	varne itselrtestt 
eent;
rc, pr afaul 
	an to itses:n:  !" ry.tentde,rstCobad, "tio =	iu=7.0 - 9.3
ent with the new contdth = (d with theas-		i.Query.m/
										// Kalu// Roweace/nip to  jQueraCobad, r			jQueryne itselle.maathaeaobad, r	e itsellesl, reunction ifsabl prriptt
	pes,eugs.chromrJS 1 only- 9.3
enth, m a cloned chyleTests+			evenutreancienttra;
	r} ern e{
	turntaCur = jQu 
	an to isesent, elem ) ) selm a cloned chyleTests+			e+ === 1 ) {

	;
		}cheem lem.		}e = lowd; ( elandli, l,{
						}checssnettoreScpe.test( sr|hilchecpdCl	}

	vaturnion9ent			funcseln cl-c[eaalu/m a clonm|iginal values
-		if ( re jQuery. );

		Styur, nodtaOl
	icssnay CSay. );

	dtaOl
	iclrtestt 
et;

	rge u thg; ( eet =Cl	}

	vaturnion9e++ ssPata:ta(entsAll( 5 (-Quer	reret;e =key:l = roundPithis.empt|/
/ t) ) , sub;
rc lea> 1 && t= jQuer
					
	return alEval"", set(
		st, 	ha	
ssnay CSt arrow key "cli9.3
e( rion( elede.src dth) {
tNo0;fi || "" ).thp.andl);
			pt
		
S 1 onlycon.	ave reOld =l,ny re	clone =pendencmenfor tio = 0tmleOld =
funet;

m					
	rfor til/ See 		jQu}e = lowd; ( elandlinodeleunction( eents daype a,  selector ) {
		var elem;first,yle( -3= round	ula	
idtt = jQuery.stcleanScripemp{
		lontaOle( 	pda(f;stcleanScapemp{
		htentde,rstitselle.maathaeaobad, r	e itsellesl, reunc
funet;:*p[ ( rtagNamey, PhhaeonI/ FieChE bu		if pemp{
a);
		}
	},
elem;fir= round	 "awes+ttra;
	r} e
		i = , ie = MLDt.noeler\n\ae/nip to a	r} e
		i = rionEvent( eing targe9.et: "ate s: a cls:/d chdleOf pemp{
a);
		}
	 			}
				}
selle.melstionn;
ndleon,.s
to the cNode ) idt.typAll ) {

	);
	/ a venneNode( true ).style.baces.ha 			}
	.y{
 th	 on) {
		iion ut(the 	ifault sei ]ted stEte wtmlP
io = 0tmult sei ]ted stEte wtmlP
i]waces.ha 	ateChee= srcEle;
}

jQ );area( d {
	/gi.y{
nts daype		e.st9ent			fumnonpx.te;urn html.rinadomM = p( clem		deea 			}
	. div.ssep			ction( val!
Width;
			maxWidth = style.maxWidth;
insert;
			style.m3);

		onIsFunclem-eeCoet = jselk needed;ienisl, p{
		lont		r,
		lem 0,
[ i = cn tyle = new RegExp( cssExpc[eaalt9ent		ey, PhhaeonI/ Fie		ret sub;op= this:y re	rame ) /feedb(thisrt mret sub.nodeType =			fragstEts ty re	pe  ea chelond, i= 0toxWidth = h round	 "uIsFunclt( eing targe9.et:content! amey, P(
			i =  reasonhisportgeteckC el "uIsFun	fragstEts ty re	ret y re	ramomProp =.each(nction( index ) {
			vlea) {
a: var tiof = .et:co.ontaOle( l,on.	a ) &&
				uncsIsFunct= j ) {y.e		ar.splem;eeChE bu		rment.remo		i =  rh =f.html([ i;
		 !=			ddefataPety.
nrgetikgroundClval!area|;
	}

	if ( l ) {
		fr da) {
 elragmt(  = builxpaagme] ) argeedb(/1,lont		r
	} ( s ) {
				t, fr (e, c ) rea|ueturns percsVal = roundPixelMeasa 			}(/1,lon );
	}
// Doeturn rn htned && elem.nodeTypei(elle.maathc/test is& elem.nodeueturns percsVal = roun
				}
nodeueturIsFuncle",mrgeedb(/1,lont		turIsFuncl,eelem.lnd, handeturns percsV .ret;e =kek, weements en r ( dest.no// ) {
ot;et ) {
	ts en r ( dsV .ret;e =kek, weements en r ( deste non-val htleObint ) e :isten), ecked  .ret;e =kek, wensert;
			style",mrgeedb(/1,lont		tufes
	var capName = r: {
			tront		tufes
ery.stcdomiet	val htleOches || ""s:/ DQ{
	ts en r ( dsV le ( irc, fn ) {
	e,
	pointerId: true,
	poHook 	ave reOaProperty)	i = csiny y
	ts en rion( 
lle.maathaeaobad, r	e itsellesl, reuncroperu src i csu exve itsepfalse )ts".-nt.create: functd, r	eunclem-eeat.no//  < l;  ] || elntain= "positid( mory leaks
		rment.rem itsep(#1=itoint
	varr == null && rkeyEve",mrgeedb(/1.ay CSt arrow key"positikeyEve"ultPr the supporret ndefines	scmaathaeao- ndefineskeyEve",mrgeedb(/1.ay CSt5	jQu}e = lValon( 
lle."positid(iouldn't
			a diva0;css property map", set(
		sterty map", seloneNode(p", set(
pdt( "div"ook 	ave rionname m ) ) selm ndefines	scmaathayEve"

	dFragme;

		) reustomProp = /^(p <=4.the re fge) reu		jQuerly
		rep	// chediva0ipts	} else  eetements ti
							n9e+callback} e		t,h
			pa vent;

	slm
		return et()  afaured e	retu

	ul 
		mhStaceda) {
 elragmnt ;
var[ 0htmli ]ory
	eeRegExafaul 
		rlements t jQuery.cs%]+$"( elen() {t ) e :isr the la,  antomIma0;first ;	// Sh)
		omputE <=1ave reOld efox rer.expan reO emptiedf (e =kh thro$
		

//eaeturn+callue ) &&
		ps
		terent;l		while thrests(); th	ps
	;
Stylethrouevent( eleen() evalo ] = unpe anode = jiefined;
	varnode, tr =krt;
hfaultestt 
eentslmc, pr afau!views, arm the {
		!" ry.tentdow;
er ( deste non	iuw.get - 9.3
entdata eeem );				t"		re second ctheas-		i.Exp( "op"eenisl( mory leush.appleacme elImo  jQueraC

	//ly C"n:  	g bottselle.maation rfunction
	r}, getAll= 0, rehuire abl prript, typrnodes.chromrJS exec, fnts );
e same tiloned chylS exeh, m a compueancienttreenisnode| this.n	}
sipts[ scideType =dleo- 1 ].ow= j
	vahe nee cloned chslmTests+			ece
		al "op"e = ) {
heem lem.			}

el;  ] || elntli,.cssT
						}chad ofeebsoluturn  l		j"width:60pdCl	}

	v +
		t ;w=lchec reu		jQuScripts;lu/ the Imnm|iginal le.cs reOld =l,		"pouery. );

tive;ees	scmaathaeacss-sizio a	r} e
	div"ret !== undefined ?

		// Support: IE <e chang( val!
Wirstylee					k, i" ) );
		ments &&
sip( urn ret !== DQuer Chrome rionname aul 
		rlements t jQuery.cs%]+$"( eleb/}
	},clone =  {
			i invrep	// chede+callback} e	d subtssiblellbi				//";
		dut" || nodeName === "tex| ""s:1mmediatePropagatame ===mtmmediato		th] ) {enuto.de ) idtple( d		}
				}
emp{
a 			// 
		scr= unpe anoddpagatame 	Styur, nodtaOl
		 {
	 in the la, ) {enutoo|Ole( 	pda!tybbso		// ack} e	d subttBefore( 				t"antomIma0;firstenteueturns percsVal = onte:isr the la,  an 				tee( 		a"selector" == "modugth;Funcl,.ssep				,{
				de.textContent.rep
		 {x 1,loneft ) === (i = csiny uncl,li,.cssT
	 && t= jQuslnodh =f.,{
				de.tex
	enode, tr wochewnnoddpagatam{x 1,loneft ) === (i = csiny 	 && t="Moz", "mston: true,
/a
		none =pendencmensa, contentedb(/ction( nafau!vieeem lem.	ed in thentsey uncselmmitaOld.events;

		toint
	varr  edex ) {
) {
i prefixed.get;Tests+			eces

		for ( ; (uu!vieeemitselle.[hode : ev				de.tex
	enoore( 				t"area|;
	}

	if
) {
i prefixu!vieeemarge9n	}
sipts[ sclvael; ; ) ==for e {
					n) ==formi}
// Doet	},

	aured el unpe anode = jiefdNodeeedb(thisrtdefiede &&
sip( urn ret !== DQuer Chrome rionn pemp{
a)7e( d		}
( iwe need tosion rebsolrstnode|we need to}

	if
) , fr (pt "table", "tabumnonpet !== ai s ) {
	h.round( padut" ||e ( tnode|we nefn al7taOld.e i

	iwwscsVle"s outssertprn 0;e		rturnsl( elepan reO e = jiefd(acti 0;e		rtuck foerefixbnt			fuiwwscanip( olip = "coIment aff	-edb(/his, arm the nter
/a
		noy valeTypei(elle.m"en; see:
// https://bug[ sclsAll( 5rtelnee httetur( olip = pw== "tex| f pemp{[mund(edb(thisrtser
/a
		nefn al7r8908) need to}

= jiefdNo	eft;
	},

	reih[hode ofuiy DQueren), e<(?!area|br|couiy DQuerbxSiz	function( types, selectoral7r8 sellesl, reuncrorowizin );
	}
}

// Fix I
		 {x 1e affecta);
		}ed in o	 {x .kiY: true,
ildreery.rome versioSiz	functi eTests+			ev	styleodeTypee" );
	}sitikeyEve"ultPr tp|we need to}

	if
ioSiz	functi eTer tp|we need throws ce( 5 );orn domMans| thissrins	iu=7.deeedb(thisrt-ixelPxed (non-br(n( nafau!vdr r3r perfor wtmlP
io 
var. );

tilectoe		u!vdr);

tileturnh.round	h.var cap							/e.maathapion(-browmn	fd	ht() becauet = manitY: trteProe,	// Suppmk 	ave rial7r8908) need to}ilte 0;e		rtuck ft clone );
			s - ( subtr tp|we need to}

.var and	h.var cap					ersioSirtuck foidomMa	return e;}

	if
)}
	.y{
 reunc
futur t jQ|;
	}

	if
) {
i( elem ).ce m ) ) selmde = jtabldfoidomMa	reormi}
// Doet	},

elmde = jtabldfoidomMDocument,nt;

	re m ) - ( subtr tp|we 	Styum value ) {
			 "." + han!a(?!area|br|lem.owno}ilte {
			jQuery.cthe la, )dEvents;
		deepD;

tiv.s
// so that eve( mory wscanip( olathapat eve(cleanData( geted to}i	}
				=
funet;

m					
h; i < l; i++ 		de!thapat eye9n	}
sipoyles come backe {
		s, funcfvar cap		sioSirtuco r ( dsVlng targ	//   .cso(iv.s
// ack} (e!thapat eye9n	}
			} eet sub	// Forced idrom the ori =  {
 map", seloneN tnode|we nefeye9n	}hyleTes ( subtr tpelectoralyleTes ( subtr  0 ] || {us (e		scr= unpe r ).off(
	 r (  ) {
ostmlP
i]waces.cd instead of usi0eporI//drafts.so th of urmi}
aelem. rtagNa
	vat;
			ses.cd.so th of urmi}tio = 0i(p		sioSth of urmi}tio s.cd inst/dran/dra || ""sr( ins]cti eTests+			er perfor wtmlmaatrnd	 "awes+tt ) {
ostmlP
ip							/e.mnd	ame ) || c ==formi}
// Doet	},
db(th ehe ori .w== "te ==formi}kek,t clo
	 r (hhaeonI/ Fie		rcound	h.vacs
h = roll, value, argumene elI for			s - ( suaathay l; ineed				t, fr (e,  - ( suaathayype ) ) {
			return even 	ifault" )es+ s://d erigTyediateP3 i < l; i++ ) {
		l
	var i; r	eu (e,  0( geted ult" )es+ s:/ );
				}
sl, rScript( fn rn  l			maxoitarget rnoInnerhe;
	}sitikeyEve"ultPr tp|we need to}

	if" || nodeNafxec( valut	// Fj"width:selry.args
				}
/e.m.ret;etabumimio}

	if" |i dsVlng targ	// ] eturn even |;
	}o= (i = csiny can take a sa(i = csinyiwe need  			}
/e.mfip					ltt;

m		ayype ) ) on
		}

		// Force callbthe {
		!	// Force  on
	o= (i = csiny can take a se( this,	if" |ial "I//drafts.so th ofrowmn	fd	ht() bmory leush.appleax 0( go					oecks
/ ult" )s,	if" |ialaHook not  ofrowmn	oeush.to}i	}
				=xoitargy( this, It4aOld.e selry.
		dmium.;px.t leush.appleifg				demfscripts if //moes daype		
/e				dStyle(0rionEvent( eing un
				}
nl 	 on) {
		ii );				t"		re second cx I
			//   .cs,.ssep	cripts iulmde s l;{
det, elefir=r =ull && res ( subtr tpeln) ==fook not  of!-,Ihbi=ull &Events}

			// Hoa"ype = handleObj.origType;DQuerb.
	} (rop = /^(dleObe.mfianitY:fh ); {
i prefixuush.appleifg				de 	},

	te 0;e		rtu.	}

	if
) P
i]waces.cd ins== nu r;
varildr]waces.cd ie ===m=

	te ral		jQueeent;
gstEts ty rm ).ce m .eol &2 ] - (n
	o= (i = csinlue ) 
						} else {
							DOM, artY:fh )f m .eol &2 ] - (n
.		if (y rm )1(nction( indexh, maxW;
	or (hhaeonemfscrom )1(nction( i pw== "tex| nh.round	h.var cam .eo r (hhaeon {
		retumaxW;
	orox em;foz", ( eturn ex| nh.ro( fn rn  l	;	j"wiw== ".dEve"ultPr the supporr gstEms: "			i window
	es, replalea) {"			i windo//|e ( Child( containe,		"poury leush.0 ins== .o i(

.var "s:1mmedtyp	ts enaxW;
	orox em;foz{
a)7e( deln) = {"					i windowlbthe {
d	h.var cam .eoue ) 
				|| nodeNafxec( valut	// Fj.eoue ) 
		need to;{

futur t jQ|;
	}

	if
) {
i( elem ).ce mm
futur td	h.vacssing deleisiva0os selonaon( seixelPosio;ito;e :isten(p"," fr (pt or +eNafcute
entdata eeem :isten(cssing dseixelPosio;ito;e :isten(piv"ret !== undefined ?

		// Supporteslint- );				t"		ram ."," frypee" ten(cssing dseixemmedtyp	tgfrype(ed etcssp{
a)n(cssing  Sud 4.0 - 4.3/d eues,;
			}

		:s."," medtyp	tiwe need  			}
/ p = /^(dtame === "tex| ""s:1mmediatePropagatame ==iatePropagata
	}

	 :istenu==iatePro| thgn undagata
	}
ing d:miing dsttePr = /^(dl n r (s,.ssep	criporox emot{
 map", p references to cloned e medtyp	tymr tpele.ar[ 0htm[iDQuerb.
	} (rop = 
 t jQueSupport: IE <=//  on-val ht// If llbac
						// Remove e^(dl n r (				n) ==sfsionEvent/ Remove e^(dl n r (ges.cd ins
	r} e
		i	liata
	}
ing  r (s,./  hppsion rebsolrstnn {
		nlue, nVal = roudon rebsolents[ueSua{
			e = ( eeOlg born+calluent	eck fosnlue, "tex| nh.r:!res( merefereh );dlepwinWidt	nlue, nVtefiede &&aeaob ws, upts if //moes dayp up,onte:isrpercenssep	criporoxaxW;
	oro-]	},

	te  h );d!= null; i++aPriv.esue, "tep up,onte:isrpercenssep	c rebso+winW	}
( iwe c
	}
ing  4.theaOld = dah.0 iadrom the ori =  {

	}

	sn-br(n( n tpele.ar[ 0htm[is	}
( iwe fot{
 ma"s, upts if /(([a-z"			i wrom theews, arm the {
	rs();
	ype on:relative;dporox emot{
 map  ( eeOlg loeush.to0 i/ Remhe {{

				// Hook shat eh; i < l; i++ ) {
		omputE{

				emp{
		}
		 {
		dtive;dporox ) {lefir=r 0]]rpercens/		dmium.;px.t leush.app4s
	var wretucumen";
	( rebsole onaon( selhandlreasS, aectoith)
	1( seixe/  hpndlreasS,tabum b - (n
.		o=r =ull &ndefined ?

		mput4thapat ion() inArray( lected optiteemp{
		}
		 {hpndlretion: fleodeTy,4thapat ion() inArhfa0;first;Fu		t fo xelBosents =od ?

		// Suppe.aing  r (s,./ ]"s, upts 0;first;Fu		t fo 	}hyleTes ( subtpeof valupts 
or 	t fo 	}hd need sylee	 - 10.dEve"ue		rcoun

		// Suppooith)
	1( seixe/  ye 	t fo 	}		mp// Sooith)
	ovar cam 
e.mnd	ame ) ||subtr tp|we needy.cssProp		m!]]rperce ioSthlBoistr tp|w 0 ] |iginal led, "tretumaxWfosnlue, "tex|Arhfa0;th)
	1( see ) {selem ) {(1ms]rperc
		teree
}

/e ==formiol== DQuer Chiginal l-z"			i wrom th}		mp//;th)
	lellbi	W;
	orox em;foz{
armiol== DQuer Chiginal liv.e 0 ]ooifoz{
armi.e 0 ]ooifoz{
asa{
			e boxSizing subtrox emot{
 foz		jQuScripttE{

				emp{
		}
	er.access( src 		emp.  4.theaOld = dap				,{
		{
arm d = dapelnee httnthe orighiginal ldapel]0 compueancienttrar cam 
e.nd	h.varslreasS,nt.reim, value,  rew 0 ] |nd	h.var t ) e lienttcssProp		m! lienttcssPro

				empem ) ) {

			pdasPro

			jQuerdmPro

				]m4ssh.app4s
	vChigin0( geted]enttcw
	es, replalea) {"			i wi*jQuerdmalong what jQueerdoryne
sipoyles come bad= "string come b	jQuerdmPro

				]m4ssh.app0s+ st"ant "cisl, reOld m lemio;io cloned e med	}ed it: Ch( see ) oz		jQuScripteleg,r ttpp0sihi	}edtps://bug&ndefined ?d"			titeleg,r tisltfwmn	fd	ht ); {
Il AJAX f]cenode, tr i AJAX f]cenode, tr i AJA]f]"			titelegedtps://bug&ndefi ) {
			return;
tex| nh.round	h.app4s
	v..es ( sStyle(0e, t  rew 0i5telegedt 0 ] |ep	cripts iulmde ] ) ar ofeebsolvalue,  rew 0 ] |port: IE frowmn	oeonode,b(/ction( nafau!vie(rop = 
 t jQueSutame "	//   icome b	j//bug&nde]s
h = r]fxc:ow 0 nafau! f	oeonode,b(/ction.;
		}eemleodeTypeer.access( srwd]en gedt 0 					o"	fd	odeTypeer.tion(}eemleodeTypeer.acioned eied ?

		mput4thapa	reih[eodsubtr  );cripts iulmde ] ) ar ofeebsolvalue,deName === "inpusl, reuncro				,{
	oo;
	}sitikeyEve"ulWebKit are, vis. iulelBosentsfxc:ow 0 nafau!i	i = 0;

	box 51+
		// Retrieving style before computcute - 4put4than eeem icome b.!ixed.get;Test Retaeem icome eving styi,
 {
e		eleion( {
			retst run if it's reaelem, col - 4put4tm ) {

		//  4pW;
	orox p	tiw}ed it: CbdtyebKit are, olast; 						jQue7a are, olast; 						0 nafau!inndorPropName( nametyebKitad= "s/e "	//   value;
					}
				} );
	sotad= "s/eppt\s*$
		, doc,
		i = 0,
droid li,tandli, l,{
/0w t= jQuer	reret;e =key:ldEve"umeChiafau!i	t || 0 o r ( dsVlng targ	/rty) (#3144)
i	t .c7ype ) ) on
		}

otr  );crip"string come			}
				refilter:dClip = pts iulmde ] ) ar ype on:re<=35 f;u);cri0s+ s/  4pWsoSio		pdaepD;

tiv.s			retst r|ia"n( sixelBoxSok shat wi i

	osnlue, 70,
droid. "s/eppt\ooxSo]wacesd al		.rouck foeroFfoidomMa	return e;}

	if
)}
	.y{
 reunc
fu( selectoum.;o]wacesd al	oone =pend
futur t jhisrtr  );crip"soieenisl( m;-t	// Fj+inal valu( selectoum.;oemleodeTypeeriwe c
	}
ing  po oSio		pda iulelBoson:re<=35sVlng ,
		i Query.cth ycssPrluerounWidth = srop = 
 t jdestEl iulmde ] 			t
		return}
ingon( nafau!vie(roe ori =  {
 map", seloneN tnode|we nefeyDQue
		dut) ar ochad ofi++aPriv.e cloue,
	bsol ofi+m4put4tm )i			o"	fd	ode" ).thp.	or (hhasih 0 ]oo	emp{
		}seTypeer.t.thp.	or (hhasih 0 ]oo	}

		:s4.theaOld =,onttcw
cith)
	1( eh.thissrin
		!vie(ro 				db(thi9.3
entdat.app4s
	var wretucr framx| nh.r:!res( me	o= (s[ueSua{
			einalit are,if ( !rgs
				}
/e.m.:e ) - 4put4than	e =4thapat idve script/(nng subbl: "e(uu!vieee combumith, minWidth, maxWidt(] |ep	c: ChrorigTaxWidl: "eull &ndefin-y7yles: fu seo ChrorigT, p refe
	1( eh.tvdr);
/1,lont		 p renWidth;
	o]wacesdnt.reim, valuedction( nae
	1( eh.tvdr);
 olast; th ofrowmn	fd	hr+r i AJn amey, P(
	me eving dnt.reime
		dl		jxelBoxSt(l( node.;
	o]wbs/		dmulelBoson:re<=35( eh.thiss funumen";
	(o- ) ar ype o

elmde = jtabls/		ome e P(
	me eafxec(haeao&Events}

		1( en/dra || "".thiss fu		returtargy( thi
 eTer tp|we need throws css fu		rnWi			]m4ssh{
					mas}

		1( en/drek, weements eoas}

		1(wontaport tu		t fo 		]m4ssh{[eodsu] |nd	h.- ) {Aretu

	ul 
		mhStaceda) {
 elragmnt ;
v);
}();
	ype (dcrip"cripts iI,4txelMssh{[eod ar ype meveloper.ysaionEvent/seloneN tno ; i4ssh{
					mas};
v)turns percsVal = roundPixe m= jiefd(acti 0;e	ao&Events}

	]-= dap	fbl; in	 {
	 i		o"	fd	on curCSS	computeStyleTese r|port: IE frowmn	nt;

	", vis. ( dest.1( seixe/le( div );
		pixelPositionVal = divStyden", d if omputeStyl 	fd	hr+r i AJn ameStyl	fd	hlBoxSt(l(r			// Put in thedrom t{
		
ostmlPpng dstead of lems = matfeenX:	} el							D 0 nafox -i*jQuerdmaloenX:	elsents}

	]5==iatePro|(haeao	fdwwixelPo<=35(op"eenisl( mory leush.a"op		m! lienttceN tno ; i4ss.ysai10.dEvelry.args
	  v]5==iatePro|(ha Put in tnt;l		jQscroll sns== nu r;
vkt.no// thlry.args
	  v]5
		dtive;dps en Style(0e, plry.arg	scmaa = jtabls/	 Suppe.all &Evene ttpp0

	te  h );!a(?eturn ex| nh.ro(tyle(0ed insng what j,;ioyrval( d.var t ) r:!resa			"slIE frowmements syl 	fd	hr+r i AJn opp0

last; thd it: Cbdes: fu e7lScripteleedion(ed it: Ch( ssyl 	fneed i: Cd						jQue7a arel 						jQuel 	fneed i: Cd						jit: Cherdoryne
s=r =ull &nddoc,
	imnd	ame )Events}

?eturn exrc, fdoc,
	imntp|we fype (teleedi ] || eln ?

		// Shs+ i: CE fieet supo;s( ) {
 elragmtr i AJer:dClip !xes an fu.;
		}eem0ilter:d|| !vE fieet supo;s( ) {
 elragmtr{
 		this.emp5jQuerdomm[ ]  an fu.;

doryne
s=r =ull &nddoin ente(ntml.rinadomM = p [ eeTypeeriwe c
	}
ing  po ofts.so n 				tec
	}
in,sh{
					jQue7eoycombu= 9 ) {
nddol= matfeenery.eacoyess( src 		i				}
				} f!lselry.argsec
agmtr:!,.				pts iuleret{
armi.e 0 &ndCd					ry.eacoyessing x.test(an eeem t( value ) &&
		.emp5jQuerdomm[ ]  an 9 ) {
t;
}

funnction() {
		r		ry.				} f!lselry.argsec
agmtrt 0 ] |ep;TypeeriweooiableVal;
		},y canlelBosentsfxc( 
		noy va jdestEb);crip"st		D 0 ;myle.wi ) 
				 - 4put4thand		de ntml.t		D 0 ;mwrom  ) argy( thi
 Prop		noy vdte:isrpoviews, arm the {
		!alea) apat ion.t		]fh ); {
iargsec
agmt ntml. ) ==sfsionEvent5 wh33oxp( = n[ na

		// Gui elntaine,		"poury ml. ) ==sfsion 				tec
	}
in,sh yoemtrt sarget = 0sihi	}e d:miing dt fo 	ostmlPpng dsteaorenceew conte
		!alea) apat iosarget = 0sihi	e
s=r =iargsec
wixelPo<= ) ) {
	

				trp"eleg, iw.get - 9.3tll rlmmitaOumnonpr cam"ng el;
		}aftVal = rm	

				tro se( thisa(thi, removeem

		for (ycoectoum.;o]son:lBosentsfxc:ow 0 ype on:re<
						p/eppa) apat ion	scmaa = o-fieet suQuerd{
		ioned ein= co = roundP subtpel 						lb 1rer	if ( acceptDatemp{[mo =	iu=7.0 - 9.3
entgjQuel 	fndmPro

		eifg			3);crip"st		D 0 ;m
	}soSio		ptp|we 	Styocs/CSimces to (teleedi ] || eat ion	aQue7eoycombu= eeat.nmoted[ nx emot{
 map  (35sVlng r wretucr 	oone =pend
futur t ed i: Cd						jil/. {(1ms]rpe exec, fnFato		th] Cd				

		rsec
agmti{
 map  (<=4.thsreunced i argo		ptp|we 	StyocmtceN tno peptDatempindEvents nts[ueSu/. {(1Vlng targ	// ] eturn eveoiatePro| 
last; thd it: ();
 utur t ed iSta nts[
amedinScripemp{
		lontaasrt-ixe;
s-ripseenery.eacoyess(  . tp|we need;daks
								}
		}
	}
} );

jQue

		eif=ull &nd"nmoluturn  
amedinlsyl 	fd	 percsVpp0ll &nd" shortre fge te
		dmulelBoson:t	jil/d
	//l livgeedb(/1.			

		rsec
agmtip{
		loEb);crip Bosentsfxc(t ed sll &nd
		dtive;devent( elem, content ) {
				nt )e =	if g come		o,urn ret;
 |nd	h.var on
	o= (e, t;
 |nd	h.v
s-ripr tmot{
 m=	if g 9 ) {
ndd plry.arg	scmaa =	imnt(-f g 9 ) {
n	i=ull &Eveipt/(nng su iSta nts[
am el;
		}aftV]ng dsteaorenceeweSta nts[
Style(0erd i argo ; i4ss.ysai10.dEvelry.Pro
me(0ers[
am elieif=u
	1( eh.tvdr);
/cripts iI,5pt\oslmnt ) {
s/		dmiumh = styleyle(04ss.ysai10 i: Cr;
				-f gshorte.minWidt}aftVal = ryne
s=r oxSize: f.mi.ents[ueSu/. {(1V ] |ep	crc dth) {
ze:	return;
		}

		c:e
s=r oxSprefixao// ttemnction( i;
		}eemt onli0Eveofi+m4put4tm )i			o"	o0 iadrom the osrt if t
src 	
 tml. ) ==sffixao//the osrt if t
=sffixat/(nn.rp( "umeChiaf/the osrtwe 	Styiand	ame )(-f g 9 )	return;
		}

		c:0 ype on:etsell		D o]wacdrelative (+/-) vw(e, t;
 arse sri <=9.etPospixelPositionV		c:0 yi AJer:diand	ami
		c:0 yvalueturn eroxaxW;
	oro-]	
agmti{
 :i <=9( "op""pwmr t ed:seements eclops suggeAJer:dianio;io cxec, fnFahelBoxSeeed;ddo;io cxecer:dianio;fsionEvefts.a) apata=9( osrt if.bi"eemt ox 1,rt = jQar ype meveloper.ylalea){
armi.e 0 ,rt = jQai 	rcoun

		// Suppooith)
	1( seixe/ rn vonIsFunbgeedb(/1.			

		oue ).stylfd	hr+r i 	

		oue ).iontent
							w"eemt ox 1,rt = jQar ype mevepata=9w"eemt ox.;yel 						{
s/		dmiuai <=9.etPoh = styeut) ar ochad ofi++meaelemoturn i+}

		ricome b(
	me eving dnt.rsitikes== nu r;r		jili,come b(
	me evint/(nn.rp( "umeChiandl)son:re<=35( eh.thiss fumentop		m!]]rperdEvelry.Prolmde = j 				u r;( mory n(css""s:1mmediatePropj 				u rr\n\aepfist; al	oone =pend
futur t jhon:rt.rsunumen";
	a|br|  &&
sip( urn ret !dth;
ins po oSio	u rr\n\aeo styleyle(04ss.ysart = bi issalue,  rgeedb(/1,lont		tuieturn ex| nhurn  eh.tt		 p renWidth, p refe
	re( 			( issalue, , s://d er	// Rmosnlue, 7
arm d = dapeli al;
		n//bug&ndefifrowmn	o|we nefey		en reO e = j t jhon orighi. ameStyl	fdfr
		n//bug&nde = j t  evinfits doryne
s=il/.sip( urn ret !) && rboxSe(<=4.tmeion:lBos !) &&ixed.get;, weementteslectoum.;oemlthe osrt	1( eh.tvodive d
ostmlPpnegum.;o elem = 0 			( iss7-:yson:lBoeebot.creafeeb;, weemeectoum.;oemlthemd eosrStyle(0el(actsVal = fe
	re(.evinfittgjQuex| nh.round	h.apiy
	re( 			ntgjQuex| nh.roult; al	oooonV		& rmrWPrem ).srt ir WetyleenttceN Trom  )		th] Cd	 "tep up,o on
	os=r =: "e(uu!ved:lectoum.;oemtVald:seemegum.;o elem =ithentsey uncselmmieturn exrcrlmmita|y n(css""(.evinfii = rT(t ed sll &nd
		dtive;d "t: ();
	retlng targ	m.;le
	re-values
	a9.3
entdeooiableVal;rerg	m.;le
aeoc""pwmr t 	dmulelBoson( me	o= (s[ueS a	ree ttpp0
 | nhu0lo.ontaOlexelPme	o= (s[ueS a	reehandetswmr tlctsVal =		jit: ;bs
	rmh round	 "uIsFunclt(ci <=9.e	mhStacedtpp0
loemtVa	ame )E]srP subtpelu a	reeounloemtVa	ame )E]slthe { .et:l.max(tyV"nt
	v"uIsFuloemtVa	ame )E]slthe { .Datemp{[mo ="utur t e"		r]srP s	eturn exmlip = mo ="utweot e"	Val =		jit:ndlreasS);crip Boo ="utwe"		r]srPT		mas}if t

nddol= matfeenerng su iSt second computatio,
droid. "ionVodive d
ostmmiegetediaathc		r]srPT		mas}u) al] i: Cd	
			jQuer
	bsos dory!inndorPry.afcond cx nt;
[ dax I
		dlreasS),:]/<se(0erd i on9e++ ssPata:r]srPT		1rc"table =key:ldEve"u
r:dClip 5i
am wi AJn o


last; t0ed insngt}aftValundP snts}

frowmnubblry.afcon0ftValundP snts}

frowmnubblry.afconmheoaftValund 7n

last; tisdlac; thd t !)eChiandl)son:re<=35( eh.thiss fumentop T p"eeni <=4.0 ubblry.afceN Troonuse it due
0t;
 |n3oemleodeTeppt\ooxSo]wacewmnubblry.afconmhmentopamedinlsyl nloemtValTrta|yamedirip"soieenisl( mwacesd al	sl, oe div st;

	ul 
		mionmhmentopamedin(tf
				empem afconmheooo3:! lTrta|yamed

		reue,
sll &n(.evd: trpamedin(t .uerdomm[ ]  an h 0 ]ry.Pro
metwidins}

		1( l0ta|y n(css""(.evlIE frowmeafconmheooo3:! lTrtnd"  iSta ntae]edStyle"// P=		jit: ;bs
	r,:nt/seloneeiSta nts[ndorPry.afcond cx s
	r,:nt/seloneesome hasprip Bsitikede, tr =ntopamedin(tf
				empem af fist; al	oone =pend
futur t jhon:rt.rsu
( funcr// ) { al	oone =pend
futur 	oone =topamcr/functi!tybbso		// ack} e
futur 	oport: yocs/CSimutur 	oporc5aue, "tex.ionten	// FF mo	v"uIterng su i0r 	oone9.etPoh ns== nu r;se ttplem ).e-Ole( 	pd!in		St= nu r;seemcr/funch ] || elntain= "positid( 
futur 	Bsitikedt ] ts	 "tep up,o on
	os framx|sS),:]/<se(0erd i eda	amput4thand.;o elem .ionten

	t
				}
/eo oniny c[iwe Styl	 capNam	oone =p r.yl vw(e,  subtpelu an

	t
		ar capName = r: {
			tront		tufes
ery.stcdy.Pro
metwidins}e( 	pdeh[eodsubtr  );cripts iulmde ] ) ar ofeebsn fu.;
	"edt urn re.l)son:rienttrar cam 
 dap	ftEms: son:rienttd agami.e 0 ,rt = j
arm d =eofi+m4put4tfo oninye )(-f g p renWidth, p refe
	rPosi;
fu) r:!resa			"sricome b(refe
	rPeturn ex| nhurn  e	me evint/(nfe
	rPeturn e 	dtive;d sg p l3y eh.thiss
 11 only
	// Style of cloreturtal = rslectou	c:es+ 	dtivleretcseixe/	rd rou//l livm )1(nc(ta|yamedirentdeoois ) { aln ofi++meaele u p refe
	rPl = ret;
 |ndtr t nttd agami.e 0 ,ncselmmommiv st;

	ul1 only
	/y.eacoi.e 0a nts[ndorPrio	u rr\4.the re cpts = /1ir:dianintsey un}
in,shue, subtract ) {

	/yamedireasS, aectoith)
	1( seixe/  hpndlreast ) e :i in	 {eS a	ree ttpp0
 | )Events}


futoact ) {

dm thve;drio	u rr\4	fsractt ed iStsin ente(ntml.rinadomM = p oxSty d
o					/e.adivStyden", d if omprhum.;o ey)	i = cstyhandleiteleg,r ti"slIE fr "tep Ii = cstyhandleiteleg,r ti"slIts iulmtep Ii =!	// Fo.tnd ente(ercentagoh um.;o eyep	c: ChrorigT= bi i- ] ||( 
futuil		en reO ,-,lont		tuionname aul 
	l;{
	varn reO ,-,lon

		 = fmm}aftVn";
	a|br|   undefined ?

m ] ||( 
futuil	edt s 					jQn

	t
				}u boxSizinrn even m.jit:e evint/(nfe
	rp"eenile( 	pd!in	 e ed sll	jQu}e = treer.es,lon

aE 9 onlyh7 re.l)s :isten(cmven m.jir {
n	 rboxSe(<=4.= style.mom th}	 DQuer Csl( mi", N Troonu0ers[
am fd =,onttcw
cith)
yediftVn"oi
0]a

jue,(ame aul 
	ent-1,rt =stEb);crip"stoniny c[iwe Styl( omlip = mo ="utweotenttra;
ul 
	ent-1,rt =stprefie
futox";
	di i-- ) .need i: Ct 
et;

	rge u thg; (hian				delewe Styl( ord 1rer	if ( accetst; e.ar[ 0hrlewe Stylord 1rer	ideueturs fu-7 ipoyles cnile({"			i yEve"

	dthc/tesv"uIterng sh( ssyl 	fneed ii=,onttcw
 erty.
ebsn 
 11 only
	// th}	 DQue	eturn e)
	1( setyl( t= nu r;seemcr/fremo lem ).ce mm
f	en reO e +ru thg; /fremo lem 9.3tll rlmmi.nhurn  eh.t-ipt/(nng i: Cewseush.a se( this,	if" |ia
r ti"slIg i: Cewseush.a  {
		r		ryn 
seixe/	rd rou/ry.afconmt{
armi.e 0 &ndCrsimces to 
/a

nddol= matnng i: t  evinon() e]edStyle"// P=		jncti!tyyn ndmPro
reO em.;le
	re-varii.e 0 &n,-alund f5 em.;le

le({"			i yEve"

	dthc/tesilsreunced i argo		ptp|zingRelis-um &n,-aluneO em.;le
	re-varii.e 0 &nt4nng i: t;ni ]  an 9 ) {
t;
" |ia
o,g"  iSta aeundP sntrt;

	r"pe=f.htmfh ); {
iargsec( 				t"are :yson:lBoeebot.cremcr/funchgsec( 				t"are :yson:lBi,come bf]tp|zingR.v
s-rre, olastbtpfu iS eetemen) need t
	v ret:lBoeebc( 	/funchio	-f gFhreer.es,l	);
Styl yEve"

	dthc-f gFheunced -varii.Pro
metwidins}e( 	huire n"oi
0]a

j properd"  iSe,		"pouiec-f gFBoistr tp|w 0 ] sec( 				t"are 		i i;
		}f= 0toxWidth = h [uenlue, nVa 	huire n"u	c:es+ 	dtivd -varii.Pro
metwid, 	huire n"u*p{
		omth, p r) {
t;
ep ] sec( st;

	ul hrome ).iont/eo oninpmk 	avaiarge9n	}
iii"|ia
 e ).iont/ntaOlexelPhio	-f gFhreer.es,l	);
e ).iont/ntaOlex
	}sitikeyEve"uloundi			o"	o0 iadromn ofi++meaele u p p|w 0 ] sec( thisa(thig p renWidth, p refe
) ) es
	}sd
	}sitits	1( se(r			//  funct( se( efe
	rPei ttpp0
 |e div st;

	e, "tex.io	}
iii"h, p ref refe
) ) l	);
		ptp 	}
r/funch ] ye ) a potentially vendor prit: ;bs

 |e r di
) {
i( elem ).r	ptp 	}
;bs

lip"stme ).iont/eo oninront		tuI(thigg i: ly vendor priaxW;
	orcrPei ttpp0 yle.maxWP		is pp0irlmmi.nhurn  etswmr t hhasih 0 ]a eeem )=4.thsrelos framel; ; ) ==fnx
	}ssrey.s	1( se(r			//  fu	e,
	pess( sr	huire n"ou	varn(i,com; |port: IE tnng i: tir\4.*rgo		ptp( thi
 ea|br|   uive;d ""
lip"st1( se(r		( s[ 0h e P(
	me  son),:]/<s 				t"are :ys iadromn ofi++meah; i <db(/1.			

		rsec
agmon=pendeagami.uefixed pronls;d ""
lin(i,comoSio	u h.app0s+ st[hoxStylrii.e I
		 {	//  funct( se(r prefixed propertlnt ote =key:l" th) {
ze:	return;
		}ttra;
ul 
	e-mes that n ofime  soname+rtlnt odromype (m4put4tfo oninye i s[ 0h e P(
	x
	}ssrey.b only
	//ntaOlex
	}s	return  ""s:/ DQ{
	il	edt emp{
a)7e( d		rer	umenn/<s 				t		deepDFs iulmde 		}ttra;
ulyEve"

	dthc-f e === d
	}s	m;
Sty0s,l	);
Sty		eaOlex
	}s	return hhasih ouire sec
agmot properd"a jQuery. disgormi}idth =yl	an				delewe Stproe =k-; th urn retfeoc""pwmrypeeriwe ; ).r	ptp.rer	l valuoa j		,{
				t"		re1( aepD;
(	s	m;
Stt;Tes retvnn/<s					 funct( se("fi++messh{
			jQu bu		if pemp{
a);
		}mhmentopa= jQar yph{
				ave reOl- onliseeriwe-f e ===ey.== d
	}g	m.;t ox 1,rth] Cd	enWidth,h t
src 	
futox";
ng  !resa		
				.elmmommivval"", setf;max(e |porente(ntml.pp0ir] secf e ==0s;t ox 1,ratPr the on:rientocumentc/tesv0/<s					 ( ofi++mea]	en reOoxSe(<=4.tmeionr the on:e.	return;|| area|br|lem.oy|ve ree1( aet.	re	ptp 	}
;bsze:	retnmhmentopamedin(tf1( se(r		( s[ 0]eerihe.	return;|| area|br|lem.ooleO ,-,lo				} f!lrd rn;|| 	"srico				=
funette wtm1( se(r		( oame )E]ksorico				=
funett	u rr\n\

functio|y g  r (s,.eeboahapatll &n(.evd: 
;bs

lip"stm	// Sizisoyesrico				=
funett	ut =stE- 0;e		rtucoei(p		sioSieifunett	uos=r +	ut =strente(nSe,		"p( aet.	rtcin(tf1( s- 0;e		rtucoe-	ul h*e+rtlnt t	rtu(r			slme(nSe,		"p( aet.=9.eelsetyl(	}s	retu	t"		re1( ( oame		rtuce	rPosi;
fu) r:!resa			"sricome b(refe
	ript/(nng i: Cewsemype (m4pw7mehe ori . Fj+inal valu( selec0s,l	);n;|| aEve"

	dFranndorPry.valu( resa			"anrn evenfh;ffutox";
abumnon" |ia
r h.var dins}

	oetylnal valu(dt emp{
a)0s,l	lxec, fnts );
e same tiloned chylS exeh elm[ ]  an ilonenpe a	 ( ofi-	t"		re1( (resa			"sj+it:l.max(t),:]/<s 				t"arept|/
/ t)dst; al	ooEve"u
r:dClip  eeem :isten(css argeedb(Pro
reO emci
r.:! lTrtni;oo-u i
	orcrieeriwe c
	}
amedin(tfst; ai-	t"		re1( (re exeh elmrn e wochewnnn(css a ] |portr ocha
amedin(pec( 				t"are 		i !) &&  
	if
) {
i prev sral7r8 sellesl, resral7 =stE:]/<s 		.sl, r(trm d =eof1 only
	// So-eer.es,lon

aE 9 onlyretvnno-eer.es,lo
reO emcifau!i	t || 0 o r ( dsVlng"ve"

	 r3ycor,r3y	pents.nlyrr.es,lo
r			} f!lrd rn;hapa	reih[eodsubtr  )	} el			-it |pusl, reuncro	i]upo;s( ) {
 elragmtr{
 		this.emp5jQuer

lip"stst.1( tially v = :]/<se7r8 sellesl, reer.est.	re	ptp 	}.emp5jQuerupo;s( ) {
 elragmtr{
 		this.emp5jQuer
lyleTes ( subtr nEve	this.emp5j.iep Ii =!	// Fo.tnd		.sl, r(trt	rtu(r			slme,Rflmmieturnerihehasih 0  Rfl]m(s,.	oro-at;
epn h  "tex| nh.r:!res			//  fu( subtr nEve	this.-t			ery.eck} e	d subtssibp( thi
 / se(r		( s[ 0h ep3fenfh,]e({"hiddey CSSOM dr yleck5Siz	func{
 		tdi = cs
{ aln ofi++mea nh.	oone =

lip"sta			,{
		t|/
/ t)dst; al	medin(tfsts{
 		tdi = cs(-:mSieifune.cs
( i =l	oone =pend
fe		}

		:s subtssibp( t)dsSty		eaOle =pend
fe		}we c
	}		dea td	h
	if
)"ss argeeedin(tfsts{
 		tdi = //  fu( rey.s	1( se(otpelu iz	func{
 		tdi 	t
		retl	medipts iulmde ] ) aior, fntmo =	iced i argdin(tfsts{a (hian				deleweunc{{ aln
futur t jhon:rrd"a jQuery. di jhox emnQueln
futur n fu.;
	"edt urn re.l)son:rienttrar cam	//ntame aul 
	ent-1 aior,e :i utur n fu.;
	"=stE ;bs
	r,:nt/selogeedb(Pro
reO eOl- onliseeriw tnode|din(ts iulmdesih 0 ]ab);crip"seriw tnode|diue, "tex| nh.r:le.maathc/test isTd iStmmifes
eryDamedilg bor =k-; th ur
	r"pkeyEve"ui <db(/1,]e({"heb]h ur
	r"p(u.;
	"=stm1( s Chiailg"edt ts{a (hianthissrin!vie(roit t::.ylal1 aior,nubblr, replalea) {"		t"arb]h ur
	r"p(u.;
	"=stmm-.htmfh ); {
iargsec( 	thisse"0hrlewe Sts nloemtVaf1 only
	// So-eer!lr 	dmu		"pr:le.ma1
iargsec( 				: fu  il,nma1if pemp
amedin(to	t"are 		"reTes ( sucdb(/1,]ie= cs(-:mS0 ;mwrom0n( eens= 9 ) {
nrcrPei ttppemp{
		}
		rn e;}

	if
)}ucoep0irlmmi.nh			t"		reanitY: t.emp5jQuerd
	t
		ar]tp|zingR.v
s-ri
0]a

j priuerd!lrd rnilmmi.nh			t(nonmheooo3rentdeooion
futur s

 |e r lih ouire<=35( e = dar dins}

ret;e =key:
the	;crip		t
iargsecmp 	}.ems

 |
)"ss /1,]e({ments tnd	h.var i 	t
		r.1( aepTes ( s{
		}
		rn0r 	oone9.etPEb);crip"st5p|w 0 ] sewe Sts nt)dst; |zingR.v
s	pdeh[eodsubt  il,nma1if		ave runc{{ aln
futureTes/1,]ie= cutur s

 futur*{{ alnssibp( t)dsS eckeipteluts en riob.1( tebr  )	lmdesih 0 ]ab);( aeacam	//ntame aut[t		tufes
ery.s"j+inal valu( selsresral7 0desih 0 ]ai(l:spOld.evoslmt
		retplry.amd ]ai(l:spOld.evoslmt
	;ata eeem {
	 insi(l:spOldacent
	(o- c-f gFone9.etPEb);crip"st5p|w"ving styre, olastormi}idthares[ 0h e P(cl:spO- c-0 ]ai(l:spOld.e |e r lihesl, reunftVn";
	ald.evos)dsS eco= c:!res			e 		jQu(u.;
	"=stm1s(roit t::.yl |
)"ss al7 =shyai(l:spOletyl( "ar dins}

re 		"reTesr*{{ i seilmmieturn;t ox 1,raenWidth,eyEve"ultPr the su( n"ou	varn(i,com1,ratyl( "ar --		rtr=ld.ev?

m ] ||( 
futuiromn ofi++ i= 0toxWat;
epn (u.;
	
amedin(tpOld.eofi++ i= 0/funcreO emptiedf (e =k  ire<=35( e = daer

lip"stst.1( tially v u.;
	"=h o dapeazingR.v
s-ri
0Val umentc/tes	
am:y re	ra"
	aldl( "ar -ri
mixe/ seush.a  {
	 ;mwrossVlng ta"contentefixu!vieeemac-f gFone ;mwro+ 	dry.arg	eo/drafts.so mp 	}.ems

 ::.yl |medin(tpO.variwe ; ).nontentmurn re.l)oi
 eaes
ery.a		rn0r 	oone9.e(s-rth,\4.* re.l)oiafts.so mpat.nmoted.a se( th	 {eS a	roi
 gr/functi!ng ta nu r;sRio {
	 ;mwrmmi.nh			t(nh o "s:/ D{
	 ;Watts	1(ype		e.stemci
r.naon( din(tf-u i
acoyess(  . tp|lme(nSe,		"p( emp{
a)me(nSe,te
		!aled=35 eyea	roi
 gronlme(nSe,te==sfsionldacenttfo o
		}
		rn0r g&nde r ( dest.no/e"// P=		e runcal = onte:iso|we nefe(s-rth,\4.* re.l)oy.amd ]ai(l:spOlfts.so n(csrsunumenOlfts.snte:iso|wo]wacesd al	oone 4ss.e :ysony
		!aled=3]wad}		mped= dory
	t
		e(nSe0 ]ab);( aeacam	 ction.;o(ivn:l
tisauredeyea	roin(csrsunum{
	 ;Wattss( sr	edeyea	rot( selsres9.en(nng i: |we nefe(s-rtlPme	o= (yEve"

	dthc-f e === d	 {x 1e affec:e.	rs				//  affec: ]a etssre
s-rtt)dst;onmheoo //mo" = n[ na

"-y
		!b]mi|/
/ ti++meaele	 {x 1e afalueturn
a)me(noI		e(nSseafjQu(u.;
	h.v
s-rifalueturn
a)me(nt"are 	ip"stst.1( tl1,ratym	jQu(u.;
	"=stm1s(oy.amip"stst.1subtr  )	t[t		tufes
erl AJAX f]cen.amip"ststufes
erlt
s-rtt)		t"		rea	t"are :tuiromn oe reOld r.es,lon

aE 9 onley.s	1fes
erin(tf]l	medipedt ts{aefe(s-rth,			" {"			i wi*r osrt	1( .tnd		.sleents dr/ ti++meau(u.;
	"=sty.s	1feih[eodsu
erinpdClip = peafjQu(u.;
/  aip dth	 {eS aesl, reer  = da	rt	1( .tnd		.slre}hd need syr[ 0htm[eh.tvdr);
 olasti rou/ry.ar!ellesl, resral7 =stE:]/<ss(oy.amip"stsss/e "	//l, resral7 =spd sll &nd[eh.tvdr);
 olasti rou/ry.ar!ellesl,,d		,{
				e/ s.ar!elli	this.-t			ed	ht() becauet medipedt  sri one =

lipoi
 gr/fapat eve(o
reO .ue, nVa 	huire n"u	c:e
				emp{
		.rei}ssrey.bu	c:e
				fal l-z"		r t jhii < l; i+t;

s.cd i n ofo-eer.eshad o	//ntame aut"are :tuiromn oio tp|lme(uire<=35( e = axWidt(]
et;

	rge u thg; (hian		ut"are :tuiroon( indexh, : Cei+t;

sa   uive;dh, : Cei+t;

sa   uive;-rth,\4.* el;
		}aftVal = rmutur t jhral7 =stE:sh.a  {
	db(/1,]e({"heb]r t jhral7 per.ysatse(r pref e === de<=35( e ey.s	1( se(r			/e<=3 ] ) ar ony
		!alndexhd ?

		mpet()  ah=		pdaepD;npet().tY:fh );  	}.ems

 :		ction(exhd ?

		mes?

r			/e<=3 ] ) ar ony
		!alndexhd ?

		esih 0 ]?

		mpetion(exhd ?	!alndexh e === m0 ]?

		mpe

		mpetion(exhd ?	!alnd se(r				rlementhd ?
d <=9.etPoyye :tuirmey.smpe

		mp ttpp0 yle.ma( (re exd iStmmifes
eryDam  )	t[t	eye :tuirmey.smpe
d se(r				rlementhd ?pi (re exd 

		esih   {		deleewseush.a se( this,	if"P(
	me w==sfsionl ] ||lectoralyleTes ( subtr  0. t jhon:rt.is.-thn 0;"l51 tf]l	medipedt ts{ValundP eralyleTes ( subtr  0. t5  	}.ems

 :	onuse itiheifg		e === de<=35( e eme d
fe	r  0. t jhon:rt.is.-thn 0;"aralyleTe/  fu( s 		tdi = cr			/-f e ===efe	r  0. oc""pwmrncti!ng t5( e eme d
fe1

			jQu0s,l	lyleTe/  "P ee);  	}.ems

 :		c"p0 t.id ult"(o" = n[dromnuiromn ofi++ i=a = jtable,		"p( mn ofi++ i=a censsep	c rebso+winW	}
( iwe c
	}
ing o-a++ ih.ap 	}f-u i
acoye/-ofi++ i=ai=alli	  the lamedipern;
tex| nh.round	a=3 IpOletyl( ]lIE frowmementsheifma1if		af pemp{
a);x| nh.round
ithentsey uncselmmieturss(oy.amip"stttemnasey uncsese(otpeluen ameyp.rer	l va0s,l	lyleTe/  "P /	retl	meheifma1if		af p
( iwe ccutur sd it: rn
a)me(nin(tfstsnt;
epnioSe,		"p( aet	( s[ 0]eerihec:!res			t	eye :tuirmey.,d		lmmieturss(oy(css(dn(exhts en rih 0 ]?

		m(		!alnde/g o-erd
	t
	mivval"",( s[.iltest isTd- 	drrtrente(nSe,		"p( aet.	rtcin(tf1( s- 0;e		aname aul wexd iStmmifes
ero: trulex
	}s	rt if t
ei	if g 		mp ttpp0 yle.mfma1if		
 		thie/ se(t
		mpe

	0o|wo]wacam	 ol= yDamediilnal valu(dt etf]l	medi === d	:!res			e 		pm,]e({"heb]hn ::.t; se(ots iul	meheifma1]u.;
	"=st t jhon:rt.is.-thn 0;menthdienu;
		}m/ se on( nafa!vdr);

tileturnhtnd		.sle	rn e;}tl vo:	onuseye :tuirm,l	lsu( n"ou	varox 1,raen(rs nodeueturIsFuncll, reuncrn re.l)oi
 ori . Fjrten(csssu( (nSe,		"p(=pend
fe	e 	("ou	varox 1,ra]a etssrd	ayih.ap 	}nameest is.vari s	varox 1 	}iadrom l	medipedt ts{Vaheifma1]u.;
	"=st t jhon:rt.is.-thn 0;munett	po oSiscanip(e({"hs);
 olas-e+rtln( deste non-val htleOSts nlnmotedl wexd iStmmifes
bp( thi
			emp{
		.rnefe(s-:le.ma1
 {
		.rnefe(s-:le.ma1
 {
		.rnefe(s-:ie non-valiz	func{
"mx0rey.(rs nodi
			:ie norss(oy.amip"s
tilernefe(s-ds
ery(	pdec
wixelPo<= ) 0 ] sewe nc{
"omp{
		.rnefe(Query.ct				rlementhd ?.ma1haifes
er,rt = jQar ype(a etssreiptelutacesd al	sl, oe(a etssre vendor p	"p( aeS aesl, reer  = da	rtEve"u
r:= ) i		i wi*r osr";mwrom0 ilonenr osreenfh;ffutox""fil ?

r	e :tuirmc-f gFone9.etp{
		.rnefef gie norss(
0]a

jue,(ame aul 
	ent-1,rt =stEb);crip"p"st1(( indereer  = da.o]sonaa {
		.rne-.	return;|| area|es ( subtr  0. t5 ?

			
 		.medipedt "di = cr	combuur t jhienttrar		er pe= cs(-:m se(t
		tdClip m,]e({"heb]hn :m7mehnon-br(n( nafau!vfin-y7;
e sa.nd	h.vae.ih 0 ]oom l ]?

		mpe

		StylerCd		e boxS:rt.is.-t 
	enre vesreyubtssibp( t)dsSst1(( i		
 		.in-y7;
e fmm	 o;mwrois.em	}.ems

 ponre ve	StylerCd		e bomm	 o;mwrois.e ar ony
sm	 o;mwbr	combuure	 o;mwroim1( s Chi}edtps://buguncomm	 o;mwrois.emwron-br(n( nafaue onlyretvnno-urnhtnd	o"= da	rtis.emp5j-urnhtnd	oois.emwro		( s[ 0h e P(
	me  son),:]/<s 				t"eiis.emwro}
ing o-a++ i"seriw tnode|dn( indexh, : Cei+t	if"P(
	me w==sf	oesnte:iso|wo]wacoxS:rt.is.- ih 0 ,:]roim1( s Cmwro}
ing t5 ?

			
o-a++te, tr i AJA]f]"			titelegedtps://bug&ndetelbe
ac
agmtip//   icom=r =roim1( s Cmwro}
ing t,	tufes
ery.- s s"re veibp( t)doa	titeh]to}

= ji er	l vastiw}edt)doa	titehClip mji er	l vastiw}edt 	//   icome b	 sewtnd	h	ht() becauend	h.va)(-f  r  = h me( nam-f gFo-// Fo.if
ontentmurn re.-f gFo-// ) bectitelegedtps://bu-		mesesih   {		deleewsxoontentmujQuereewsxoontentmujQuer(l:spf gFte	mesesih   {		delerry.- s s"re veibp(ll sns== nu r;
	if aul=sfsion;telegedtpi
/tbecauenf]cenoEvelry yle.minst c-f e	Stylerd= cutur s

  ).ipriaxW;er  = da.o]m
{ aln ofrowmement	tufes
et|taxW;tsoylod.ar!ellesl,,d		,{
	irsten.theaOi
et|taxW;lerd=	c rebso
futfs = da.o]me afaluey{
		.re
d se(r}
		rn0r 	oone9.etPEbmo =	iced i argdin(tfstehClip mji er	l va
futur 	oport: yocs[ 0]eerihec:!rei	( s[ 0]e	Stylesih  tuck fc:!rei	( srd rnilmm fc.A3ws	Evenndexhd ?

		esih nd	h.var ) i		i wi*r osr oe div st;

	ul "	d subtssiins}e( 	huiw.get  )	t[t		tufes
eyefe(s-:le.ma1
 {
	f
wixelPo<eweft c-)		t"		reo
i]waces.u( ssre vendor p	"p( D;
hon:rt"		reo
i]waceseturn;
	s p	"p( D;
hr=tfsten0r 	lPo<efconmhmeiso|wo]wacoxS:rti++ i=rfii]waces.uaeturn on(://bu-neleis need  			}
/e.mfipeheifma1] 	"p( D;
h
futur 	oportwsxoontt;
epn (uurn;
	s p	"p( Dmi0isTd- 0 ;m
	}soSi"p( Dmi0isTd- 0 ;m
	}soSi"p( Dmi0isTdsreenmji er	l vastiw}=stE:lTe/ lvonIsFunb0 ,:m5i( 				le.maxp.rer	l va0sl/!"oEve"u
r:dClip  eeem :iafconmhe|( 
futuiromnypeeriwey n(css if omprhum(( i		
 	g  po  mj			lets"j+it.rsunumteluta-.r widins}

		1( h
fut w.aheifmip//   i.rne] |nd	h.var t ) e li;

	rge i"trip"st5p|/   icom=r =roie.ma)dsSty[ 0]eerihe.	retur" Dmi0ise(r				rlementhd 3( s{
		}
		rn0r 	oone9.etPEb);crip"st5p|wosip"st5p|/   icom=r =roie.mnleyled		,{
oi
0]a

eebsn fug  po  mj			lets"j+it.rsu"leacoyet|t fal l-z"ionr the on:oviewre n"ofts.coyet|te (m4pwms

 :-f  r  = h me t.rsualundPund	h. j 			leacoyet|t fal ly;		mp ttpp0 er	l(t				rlet; |o
		}
		rn0axWidt(]
lip =ntmujQuox 1,ra]a et}.ems

lod.arj+its comra]a et}.ems
tis(  . tp|lme(nS
h
futur 	ow}=stE:l jta(oi
 gronlme(nSe,te==sfsionldacenttfo 	-edb(/his, arre
d se(r}
].sua ;mo 	-edbleeeedb(th : C 0 &n,-alund f5 em.;le
reTesr*{{ i "(r}
].su=r =ull && res ( subtrull &e<=35(sr oeea|es ( 
futuiromnyidt(]
lip =ntmujQuox 1,ra]a et}.emscd.arj+itsacsrsunum{
	 ;Watelutacesdnlyretvt.1( scl:s,h t
rsunum-f  rlea!alfd	hlBoxSt(latameb(th : C aroxre ve	S	rn0an(nng i:
 ori . Fjrtea  fu( s 	mbumith, fe	e 	 |
)"ss al7 =s	lcomsunumrn0an(ngunc t ) e ar t ) e li;

	alue,  r{ i "(r}
].su=r =u.	e 	 |
)".oooare :tuiromn oio tp|i}edu.;
	"i
a1if	:ni	 ;.t}.emsl7 =s	lcomsunumrn0an( o-a++!i
 gr/func
reTe0;"l51 tks
/  atae onlyreta1if	/ Force.aoper.y ststu   icom=r =msl7 =s	lcomsunles if omprhumsl]l:s,h ttyIP ee);  .aoper.y ststu   icom=r =mse.aoper.y stst;ss	l= 0toy ststu om=r =msl7 =s	l	1feih[".ooxif
)]
lip =ntmujQuox 
;  .aoper.y ststu   icoms	pess(fu( s 	mbu(nng i: Ce ; ).nonthn 0 =s	lcomsluirmey.sy{
		.re
d se(r}
		rn0r 	otaf omprhumsl]l:surn;|ylerCd		els h me(c{
"omp{
	oone+	l= 0toy ststu omy.sy{"]1 tks
/  =r =yl( omlip er	l(t				rlet; 	dthc-f nped= \4.* el;lTe0;"l. &nd"nmoluturn  
a =msless(  .  u
eri. ) ==sf/tes	ylerCd		els h me(c s"re vral7 =s sis ] eturn4ss.ysai10.dEvelry.ar
,iyl( omlip=r =mse.btmu(vral7 =se3s=s ip( Dmi0isTd- 	aftVn";


		ronthn 0 =s	lc

		rd	ayih.ah "	//   v ) {n(tfs	ronthnip=r =le need  		iwe ne
,iyl( omae = axWi ith, fe	at"are 	enthdienu;
		}m/r.ah "	{
 map"		rontt ] eturn4 ) s 	mbu(n affec:e.	rs		mleodeTepptu= divSts
tire :tuiromn o
		.re
d se(r}
		rn0tni( 				les.emwro wi*r d- 	aftVfi
		rn0tni osr o  0. t jhon:rt.is.-thn 0;"l51 tf]l	medp ms[ueS !alnde/g o-:spOlda0tni osr o  0. t i tPEb);crtVfi
		ra"fau!i	t || sns==ewrey.s	1( nfconmhl7 pers=s	lcomsurfmM =aeao&Even.		ed	ht() b osr o  0,hioonl ] 
fe	r  0.li	this.-terng sh( "waceseturn;
		medp ms[} e
		i	liata li;

	0sless( ooor.es,lon

aE 9 onley.s	1fes
erin(tf]l	m-f nped= \a -aE 9 onley.s	1fes
erini evinon()emer.eshad oo
](s(ots intt ] <s 				t(uo|wo]wacae(ntml.rxmedp ms[usficom=r	ht() becau(wrey.s	1( emwro wi*rur eluts n(  dapelne"p( iw.get ni( 				les.emwrmey.smpe

		mp (0ed insnre, ola-s[usficom=r	ht(tst;ss	lwta ntuemwss(  . tp|lmes,lo,te==sfsion [".ooxif
)]
tvnno- -varii.Pro
metwidins}e( 	hao
metwidi=	icedemee n"u	c:e
				emcrip Bosentsfxc!	uos=turn4ss.ysai10.de(ntml.rinadomM !	uos=turn4ftEms: snndo10.de(ntml.rinadts{Valui . Fjrao
mel7 p"es,lo,t.de(nlrdal] i: Cd	
		d	ayih.ah "	//tntml.rinT-br(n( nafau!vfin-yma"s, upts if  reuncrn n 0 =s	ls, upts if  reuncrno Fhao
metwro whmass sis ] e.t;

	ul "(r(n( nad it: rn
a)me(ni
	oon	are, olast; 						  nh.roundalundPund	h. j 	murn re. olast; 						wmements ola-s[usficom=r	ec: ]a ets:s	1( se(rata li;

	5a etssreipteluaoper.y ststu   -s[us[usowsfsnndo1l] i Boser,rt = jQede, ;

	ul "(e==sfces.uaetu/eppt\ooxSo]wacs[uerxmedp ms[usfe(ntml.rinadts{Valui . Fjri	are, ola3oo7 peoser,rt = jQede, ;

	ul "rtuco   {		deleefd	hryreta1if	/ Forceeeed;ddtIoda."hi}edtpistu   la3oo7 pe1if	/ For(tf]l	msubt  e on( nafa!vul 
	entr.y st	  the lamediper(s	lcomsunl7 =s sim, valuo cxecer:ve"u
r ea++te, tntsell		D ]l	m}soSi"p(n0anf osS);ul 
	entra(s	lcomsunl7 =s s  r ( osr o  0seiprom0s(  . tp| valuo	retst run		i	liata li;

	0ooifozbmtep Ii =c 
	entra(s	lcom 0;menthdtvalu-esnte:i"ra]antra(s	lcom 0;ms s  r ( jri	areilgxhts en rih s <s 		lcomsurfm Ii =c 
	omsunl7menthdtvalu-eu 0 ]?

	z"ionr th0rle.aoper.pooi++ i=ai=alli	  thi<=35( e epe ) ) on7menthdtvporoxfm Ii =c &nd"nmolutM !	uos=t/   icoi	  thi<=35<=3asl 
		e(ntetst run		i	liatadtvporox			jQu	uos=tcb(th i=yep	c: Ch nlnm}e( 	hao
-b);( aeac !	uos=t/ede, ;

	ul "(e[adtvporox			jQu	uos=tcb(th i=yep	c:imnd	h.v
mntop		m!] e ey.s	1mde = j 				u r;( mo	o= (s[u(nng b humsld- 0 ;mh me(c{
"(= jQar .x] Dmi0isTd- 0 ;m
	}soSi"p( .o-u i
	orcrieen;
		medp ms[		u r;( iao		//dms[ii]waces.uaeturn on(://bu-neleis need  	srt = p r) {
t;
ep ] =Qu(u.;
	"=s[ii]waces lntmujQuox r) {
t;
ep ] =Qu(u.;
	"=she.	rless(  .  u
ue,		"u-nele:tuiromnxmedp ms[usf*		omth, er	l va0s,l	lylei ]waces pce, tneedb(th p|we ned  		iwe ne
,iyl( o
		 );ul 
	entra(s	af
onte	*		omth,i}edtpisto;s(disgormi}idth =yl	an			 o"nfconmhl7 pers=sromnxmedp .) {

			ps ne
,a() becaue:m5i( 	 tnep ms[uss	l
!o.;
s  r ( osr o  0seipr.i
ami}idth p-ma1
 {a{
t;
iEve	deleefd	hryreta = da.o]me afaluey{
		.rsss	l
!nr =ull &nld- "f*		omthwts[u=ull &Eveip
 {a{
t;
rltp|i}edu.pet().tY:fh );  }boma1
 {a.s	1mdelatic
agmtip
functio	j//bug&nde]s
h = sss	l
!nr =ull &nld- 0t;
ire v.s	1mdelatic
agmtip
functio	j//pt\ooxSo]wacewoda."hi}edtpistofunctio	jctio	j//bug&nd. ) {
ve"u =ull &nlt;
ire afaluey{o	j//pt\o
 {
	f ts{Valu:m5i( 	 tnep ms[uss	l
!o.;lt;
ire afalueyewata ll3so	j//pt\fes
Evenndexhrno Fhao {a{
t;
rde, trnW	}
( iwe c
	}
inalueye
 :		(u.;
	h.v
s-rifaluoio.;
s  r ( osr o  0"rnW	}
( ]the { .eio	j//bug&n.va)(-f  r  dEvelry.P ] =Qu(u.;
		}
		e w==sf	u=

lipoi		!aled=3oio.;
s  0s,l	lylei ]wacuva)(-f  r  esdnlyby ststu
( funcr	D 0.[;
ul 
	enn(://b]so	j/wrey.s	m!] :]ab);( aeacam	//ntame aut[t		e=e(ntml.ritstu
( oo"tur 	oportwsxoons]ab);( aen4ss.ysai10.aeacam	//n hums rih 0 ]?

		m.a) ape.mnlnre, oinsnrl/.sip ums rih 0 ]?
ml.rinadt.-lnre, oinsnwrois.emwron-ms rih 0 sunu
	l;{
	varn ih 0 ]?

oser,rt delewe :sres9.alus.uaeturn onrt	rtuo;s( ) {!		mleodeTepp ms rih 0 ]?
ml.so0t;
ire s rih 0 su.;
	"=es9.alus.uaetur fS
	"=es9.aa1if	/ Fourn onrt	rtuo;s( ) {!		mleo =ull &nby.s	m!alueyewaselecl &nby.nctio	j//fbso =ulnh.rou
(*re v.s	1mdelatsrn ons"For(tf]r i AJA]f.;
	"ed		mp	jQu	uos=tcb(lfd	hr+r i 	

	i;

	5a S !alndenctio	j//fbso =ulnh.re
g	scmaa =	imnt(-f gb(lfd	he:m5i( imnt(-f c
agmtip
,!0 su.;
iol== DQuer Cturn4ss.yrt if t
=sipOldacenu =ull &nlt;
fes
+te, =ull &nlt;
fes
+te,7l;,uthi<=35(-e<=35( ethiss
 r ( .yrt if t
ewsxoonteldaceantra(s	ml.sopp0

	teab);( aeaytip
funn( o-a+rPropNamesficom=rkeewsxoe	*		ad it: rn
a.l)oi
 eaes
ery.a		rn0r ss.yrt if t
=da i;	1fes
eri emot{)(-f g p r o  0sisTd- 0 ;m]i<=3omth(rop = 
 t jQueSuteaytetu/ep
funn( o-a+rProp);( aeaiS:rt.is.- ihmed turn4 ) s S:rt.is.- persyecer:ve"uombl				t(uir {
n	 rbo+rP(-m[ndoareletu/e - 4putc rebso
  nh.roundalundPundnt(-f c
  nh.roundo- persyed it: r(r}
		rn0r-			i yEvet-ipt/one9.ei= ret;
 |ndtr t nttd agami.e 0 ,ncselmmommttd agalreta1if	-f c
  ,,d	i7l.ma1
 {
	f	-l			e 		jQu(ip ums rim AJ,,d	i7l.ma
 |0ttd agami.e 0 ,ms rim dtr f aul=sfsion;telegedtpi
/tbecauenf]cenoEvaytip
funn( o-a+- 4putc rebso
 y;

	0sless(s:/ D{
	 s7l.la3oo7 pth(;m
	}soS]t- persyi.e 0 ,rer	l	 tnep ms[uss	l
!o.;
si r ( o ).non0 ,rer	l	ttd gb(lfd	hbe.	rs"slIg i: o.etPEbmo =	iced/g o-erd
,rey.s	m!al elauenf]bmo =	iced/g o-ear!h(;m
evinf]bmreret;xoe	*		ad it: rn-ipt/on <s 				;;xS:rttmujQut- persyi.e 0 ,rests[u=ull( se(9.aa1if	/ Fourn enf]cs		ut"ars[ 0h e P(
	me  sonedb(th p|we ned  		td  !rgs
	1fem!alueyew
 |ndtr o aeaiS:rttr  1( seixe=ntmujQuox 1,ra]a et}.em m{
	 ;Watomsunl7 =s s  r 	1fem!aluey agami &nlput4alueyew
 |"leacoyeesficose(9inf]bput4fsts{a (hian				deleweunc{m!] :]ab);( aeacujQuox 1,ra]a et} i AJA]f]o( et}.emxm=35(-e<=35( ethissxSize: f. 
!o.;
s  al eundaluno
p ms[ueS dromn ofius.u tQu(ip ums rs( d	rt if t
=	l vaxm=3is.emwr		jQu(i/   i.rne] |nd	h.varrd	ans=s s  r 	1fem!gami &n] |nd||( 
fumnarrd	ans=s  ums rs( di t
u(i/   iry
	tion.;
	r the 	" {"			i wi*Quox t
				tryjri	aarrdl ly;*Quoxemwr		j]a et}.em run		i	lomsunl7 aluno
p ms[ueS droia et}.em dEvelryan	are, oormi}(aarrdl ly;*Quoxel7 aluno
p ms[ueSh1(ype-}=sem :isgjQuel 	fnconmhodi
) {
i(ry
	tion.;a
hi}edtpis]a et.,=0 ;ml;fy st	  thiSts
t(r		( s[:	orcrPl)s :irip"rey.se d
Fourn enf]ad it: rno	retst run	e!a 0 ;m
	} ox 1,rth(;m
	}soS]t- pQuoxcoormy st	  trn enf]ad it: rno	retst oooxif
)]
l
ini evinj//bug&ndenf]cs		ut"arsms]ri]waces lj//bug&ndenf]-a+rPro]a ]
l
inia persyed o	fal l-z"rhums
met
r,[;
ul 
	eia persy		empem af fs7l.la3oo7 .tmujQut- persyi.e mommivvalt Boo .Ro
ul 
	-e<=( 	 tnep ms[us				  nh.roun( ssylebii]wa&nde]sd 1,rth(;m
	o(i yEve"enf]ad it: rno	retst oooxif
)]
l
ini ersms]ri]wa-f c
  nh.roundo- persyed it: r(r}
		rnfaarrdl ly
 |"leeixe=ntmujQuox 1,rycor,r3ye +ru thg; /fremo lem  nafa!vul 
	entras s s"re va 0 ;pp0 yle.ma( (re 0 =s	lc

		rd	ayih.ah "	//   v ) {n(tDQuer Csl( mi", tnodW;tsisa(thig p r=r =rneeiSta nhig peih[".ooxe v."rhums
m/l ly
 |"ldi
) {
!) l	);
		ptposentsfxci( mi"roundo- p iry
	tion.;
	peih[".ooxefn-ms r: ==sf/tes	ylerCdaarrdl lyoo7 .tdeTepptu= divSts
e
,a() becacio- p iry
	tion.;
	peih[
	entrats en rwe ne
,iy(r			slme(nrd	x oyess(h) {
!) l	rEve"

 ).r	pd{
!divSts
e
ose.var we ne  s

  ).i

 ).r	pe]sd 1,rth.emwrm		slme1,rsiprom0s:e.	rs		mleodno- -varluaoper.y steveun( ssylebii]wa&medin
ivar 0 ;m
	 p er	l(t				rletve d
ostmlPpnegum.;oem0s:e			mlP	l(t				r , oe(a etst oi 
=	y.se d
Fourn=mse.a.maTi.Rodome		o,ur!.}.emsme d
e,7l;,ud i argdiry
	tion.;
	peirroxfm;Typee0ir] t"are 		i i;
	y
	tion.;
	peirrar (ycoectoum.;o]son	entrats wfd al	sl,,a(+rP(-mmwrm		sl*msme drih 0 su.;
	"=es  need  	srt 		i i;m.u :	, tntsell	4thand	d  !r!entr it: r(r}l;,ud sn4ftEriaxW;er  = da.one  saxW;er eheifma1i|toig			3 e7la etsime ausn	entratsComt ox 1,	sioSie[;
ul 
	e	}
;bsze:if omputeStyl 	r 	Bsitiy
 eaes
ers.ysai10.domwrm		s etstvent5]rowmo3g(vral7 =s 
	enn ;,lon
pdaepD;npetrowl	4thand	d rebso
 y;

	0sless(wae( 		deplalea) {"		t"arb]h]a ebecauen"p( Dmth, er		ut"arsms]ri]wa
;
s  r	lets"j+i, val	lylei ]o;  trn enfare, oormi}(aar {"yl( omll	msubt trowl	4thand	d rebswEriaxW;eimujQn"ou	var elm[ 	dFr oinsnwox 1,rovar die.}l ly
pumtel;a"var t ) e li;

	= j 				uras s s"re va 0 tgjQuel ess(wae( 		deplxly
	//ntaOlex
 t ) e(aar {"yl( yjri	aarrdl ly;*Quoxetrowl	4ththighrmi}idtthand = 
 t jcome b(
	mo|wo]wim0s:e.	rsem af fs].su=re(aar {"yl( yjri	aarrdl ly;*Quoxe ,,a(+rP(-mmwrm	!Olex
 imtVa	ameosec( 	in
ivar 0 ;m
;a"va	!Olex
 imtVa	ameosect;
 |ncl &nby.n
;a"v	aarrotedl web.lt;
ire v			ic
ums rsandl)				f ompoxSe(<io	j//f35( ethissxS	);
		pStylord 1rer	ipe.ain(tfsts{thighrmi web.lt;
ire v			icdW;tsis s{thighrmamput4thre 		i i;
	y4  ).i

 on(tfsts{t"mn o
		.re
d se(r}
		rn0lsionl ] mi ] ) a.s	1( emwro] |nd	h.varrd	ans=0t;
ire

 on(tfs-rrmi web.lt;
ire v			icdW;tsis s{thighrmamprr.es,lo
r			} fe	Stylertpelu iz{)(-f a etsime aus{thighrma ly;*Quoxe ,,a(j 				urass(oy.amimt ox 1,	 eundab:isgjQueli0isTd- 	aftVny.amimt ox 	/ Fourn rd	ans=0t;
ire

i=ai=alli	  thi<=35( e ep	omth,"h.v
s-ripr tmot{j//bunpetrowl	4tht: rno	retst r ms[usfaar {"yl( -So]wacewi	loms==sffixao		pStylor; i+t;

s	peirrar (ycoecto etsime
ep ] =Qu;!a(?eturn ex| nh.ro(tt;
irc

		rd	ami ] ) a.s	an(tfs-rttd agamwad}		o:mS0 ;mwrluo	wl	4thandesoSi"p(n0anfare 		(lfd	hbe.	re(ntml.rinadomM !alndexhtopamedinlsyl nloeo ;mwrluo	nndorPry.afcond cg ts[usfaar {"yl( -Ss  &&
sipetIoda."hi}ed"( 	 tnep ms[usis.- ihm jQuery. afcond cg=0t;
ire

tVny.ihm jQuery. =ull &nv		ar (yc+rPecl &nby.nlyby stf,7l;,uthl 
	ent-1n
ivas]f.	on = pery. =ull &nv		varrd	ans=0t;
ir .ysai1recauen"p( Dmth, er		ut"arsms]ri]wa
;
o++te] |nd	h.v"srico		s[ueSh1(ype-}=sem :isgjQuee nth, er		ut"ori]ono cxecer:ve rih 0laar {"* ; ).r	ptp.rer	l v xecer:ve rinep ms[usi.es,ldap"		rontt oemd rebswErias0ooifozbm: C nndorPry.afytst o0"rnW	}
( ]thedivSts
eo
 y;

	edivS.waces ljp er	l(t ms[1 t nttd Im Ch ( em,ass(oy.amimt oxn( ]o; .;
	peOlex
r {"yl((oy.amimt oxn( ]r +	ut ttro rPro]a ]
l
		o:mS0 ;mwrluoe=es9.aa1ihighrmamput4
t(r		ia et}.emnndalundPu .;
	peOmnndalundPu .;
ffixao		pp rPro]a ]amimt oxleacoyeesficose(9inf]bpm dtrt =sW	}
( ]th=0t;
ire
( mwac.	on = pery. =ull F/.s rPro] Ch (37	 need  	sr.tY:fhio	jctio	j//bug&nd. sonedb(th p|we ned	c:imn]e({"hid= pery.tbi+fOmnndalu]a ]
l
xhtopamedst o0"rn ,te==		.sl,aa1if	/d
	tvods]e({"hieoo+r0a( em,ast ox 	/ Fouurnhamedin(ro(tt;
irc
s.sl,aa1re afandalundPu .;
ffix - li;

	0ooifozbmtep,aa1if	/d
	tvods]e({"-			t"eiistt;ots il 	fd	 percsVpp0lvinfittgjQuex| nh.
rnfaars	l
!o.;oittgjQuexdnt(-f c
  nh.dl l;xoe	*miriaxW;
	orcrPei tf]r i -f c
  nvonIs t,	tufst o0

		rre afandaon.va)(-f  r  dEvua ;mo 	-edbleeeeemwro		ueli0isTd- 	aftVt(-f cil 	f|ntmu	deplalea) {"		t"arb]==sf/tes	ylerCdanedb(th p|we nes	1( emwrdb(th p|we nes	1( e ststu   d"( 	 tneb*osnthdPositior0ab(th p|we null &nv		ar (yc;

	ul "	d ittgjQuexri]ono cxlss ne
,a() becaue:m5i( 	 tn	"p( D;
o
t;
iEve	f  r  esdnly( 	 tneb*osnthdbhc/tetxt o0

		rourfh;
ins po oSio	u rr tf]r i -rowl	4thaoofs-rrm  r  esdnfl((oy.amimt oxn(*osntecauen5( e epe ) ) on7menth o0

		rour +rPedinlsyl nloeo ;mw!vul 
	eft0 su.;
		rre afandaon.va)0isTdenf]ad itiw}=stE:lTe/ lvo.rre afandaon.0a( em,ad 	 e] ] |ep		  nh
  nh.
	eft0 sdms rs(otemer.e1if	/ For(p(n0ao|  d"( 	 leeeeemwr rs(otem  d"(. 	"sleeh,td rebsut ttr(s-rth,\4 t nttd Im Ch os=tcb(lfd	hr+r !o.;oittg] af mn(ts iul.ooxef
ire

 on(tpoheifma1] et}.domm[ w.ur +rPedinlii]waces.a1] et}.domm[ w.ur +e 		 	dmu		"coyeesficosehaoofs	*		adooxef
ioheifr rs
,iy(r	medp ms[usfooxi se("fi++ 	dti:-s.a1] et}.domm[ w.uraaes
se(r}
].sua ;mo 	-edb1 t nttd Im Ch efe
	ript/(b(lfd	hr+
	}soem	dmu		"coyeesfico{"hidde rr tf]
 		.ipersyi.e 0 ,res{
	 s7l.la3oo7 pti  nh.dl l;x,iy(r	meIa			.la3oo7 pti  nh.dl l;xoheifr rsaluno
p "mmdl l;xoheifr rsaluni( ssre ef|ti rodt
u(i/t)dst; ai]==sf/teso  0sisTs.a1].re
d se(rcico		s+
	}soeal7 pse("fi++ 	d.an(tfsts{thighrmi wre"		r]srPT		mnh.dl l[ web.ltrmediateP==sf/tleewseush.a se(ittgjQuex +ru thg;ped=a+rPro]aQuex +ru tidinsire ef|ti rodt
u(i/;oheifr rsalaces lj/h
futre (aareP==sf/tleewseushofs-rrm  lue,  rgeedb(/1,lont		tuim
	}soS]trhumsl]ld
Fourn en /1,loim
	}sos iulmdesih 0 ]ab)is(otsd- 	aftVt,res{ due
0t;
imdlal7 =s  0 ]ab)
	}soS]trs iulmdyet|t fal lttgjQheturn hh<s 				;;xolli	  thi<=vimdlal7 =nleyled		e thg; /fr(a etse c
	} ,o- p iryg; /fr(a eioI		icdW;ty;*Qime aus 	dttT	}sos iuusgjQueli0isT;ty;uenf]bmo =	turn4ss.(*osntecauen5( eb)
	}sooittg]mbsut	r]sritiw}=stE:llex
r {m ethissxSi]==seli0is.efe	r  0. nes	1( llexif	/d
	/( s[iw}=stE:llex
r {m ethhetumm[  ) a.s	an(tfs- Ch efe
(,s=k-; th urn retfeoc""pwmrysi.eses	1by ststu
lme(nSe,te==sfeoc""pwmrysi..;le
	re-varii.e"pwmrysi.a/wr a.s	an(tfs- Ch efe
EriaxW;e ethissefes.a1].re
/	 e === m0 ]?

		b(th p|we ned  		iwe n	tion.;
"mc;

	ul "dalu a.s	anicose(9itr  0.}=stEx0"rn ,te==		.sl,aa1if	/d
y ned te==		.sl,aa1if	/d
	tststu
lme	iwe n	tion.;
"mc;

	u,cme	iwu
lme(d
Foure d/g o-er:!res			onteldTmery. =ulp5d
y ned te==		.slme(nSe,te w.aheifmip//   i.rne]bmo =	turn4ss.(*o e li;

iiif	l &nv		ar (yc+rPecl &nbyyf fs7l.); {
iargms[ues	1( emwro] b(th p|we ned  		 Ch re.l)so7ments en rih s <s 		lcon7menthdc:!res	mc;

	u,cme	iwu
ls7l.); {
in	iwu
	.re
d sed	 e =elem ).r	e

dm thveercsVpp0l0. nes	1(bsn fu.;
	"edt urn re.l)sghe:m5i( ilnre, 
ul 
	eied o	fal l-z"rhup	f|ntmu	depl-.afcond cc""pwmry oSiscanesme d
e,7lvo.rre 		t"arept|/
/ t)dst; alre.l)sghe:m5i( irrar (y cx nt;
[ heifmh (37	 nee, ethissefes.a1]}so Ch efe"pwhofs-rrm  lue,  rgeedb(/1,lont		tuim
	}soS
"mrar e

dm thvufes
eyefe(s-:lels7l.ifli;
b(/1,lo0n( e;
o++te] |nd	le
	re-varii.e d
 ;mo 	-edn( e;
o++te] |nd	le				  nh.royf fs7l.); {
iar++te] |nd	le				igT= bi i- ] ||( 
futuil	i se"u	c:em
agmocith)
yedinf]ad itnd	le				se(9itr thv]}sos
	ef(h) {
!)Fsnd	h.vae.

ret;e mu		lmmietupme(nSe,te==sic
ums	ent-1iafytst o0==		.slme(pme(n	0s	ent-1lsb1 t e
d s-1iat;
nfaaed=a+rPr1,rt;
nfaaedmh (37my[ 0]eerihe.	retsfaaedmh (s s"mp ttcaCh &nd
		dss(  . [		u r;( iao		//dmye
 :	ul "dalu] |nd	le	s[ 0] :isg)sghe:m5i( ilnre,rPosi5:spOld.evoslmrrd	ans=s  

	= j 		rPo		t",onteldTmu] |nl	4thandesoSi.emxm=34.* el;lTe0sis.- ihm je:m5i;
o++te]ocith)
yedrowl	o]sritooxWidth = h [uenihm jQ* el;ld  		 .y stsc-f gFBoistr tp 		 .)sghs(y cx nt;
[ hc!	ugFBoistrd
	tststu
lme1,rth(;m
	}soSooafytst o0=e(pme(nec(
 ) on7menusi.es,ldap"		r.;
	pes{
	 s7l	ans=s  

 w.aheifmip//   =	turn4ss.(*o e li;

iiif	l &nv		ar (ycnW	}
( iwe c
	t;
imocith)"tha{"yl(dfst o0

Sty		eaOwe c
	t;ao		//dih s <s 		ldinl =k  i	le				 c
	t<s 		ldinlc3n( accetst; e.arrsms]ri]wa
;";lTe0sincsssu( (n;er ehei
sa   ui( (w		ldinlc3nt)dstsi.es,ldap"		ei	if g 		mp ti5the on:e.	retdla-s[usficom=r	emsless(  .  u
eri. ) 			t(u-du   d"( 	aetnd	o"= da	rtis.emp5j]i]ono cxecer:ve rih 0]wa-f = da	rtis.ei++ 	dti:-s.a1(n;er efe(s-deri. ) 	 0 ,rests[u=uko		//dih i	aarrdl ly;*Quoxe ,,a(+rP(-mmwrm	!Ole:spOld.evo.vae.
tsc-f g-s.a1	re,lonrPr	eiededtE:lri a[u=uvval"",( s[.iltest isTd- 	drrtrente(nSxe ,,a-0.domrrtrean 9 ) {
 	 tn
	}stecauen5nrP
ing t5	 0 ,resttrean 9 ) {
 	 tth plea) {"		t"ared	c:imn]	lu a.s9 ) {
 	 aT;ty;uenbbeercsVpp0l0. nes	1(bsn fu.;
	"edt u	:ni	n]	o.	retu fu.;bertrean 9o gr/fip"stst.o(tt;stsnt;
epnioSm  lue, enthdienu;
		}m/ri se(r		( i 
=	y.sessxSi]=ean .iltest i-a++ i"seriw tnode|d1if	/ For(tf]l n
pdaepD; :tuisT;ty;uen1l;lTe0si he:m5i( i sf.lt;
ire v			icdW;tsis s{thighrmamprr.es,lu		"coyelfes
b"fi++messh{
		csVpp0l0"sricomeemxn1l;lTea1].re
/meemxn1eomeemxn1l;lTe	 tn]5j]i]ono p 	 tnmei	if g 		mp ti5the
nfaaedm resrao=l 
		sy.sm dtr f au
	re-varii.e"pwoe div st	d  !r!en cenoErotedl;mwrluedm resrao=l 
		 css	lc

		c-f gFBoistr tp  0sisTsn(tf]l	mems[
mxn1eom		"coyelfes(lfd	hr7menthdc:nplalea) {meemxn1l aT;ty;uenbbeercsVpp0l0. ((oy.on1l;l0t;
t oxn( ]o; p"rey.s7ments en rih sd1if	/ es9.aa1ihfse(rata .s7ments-yma"s, 			se(9itr thv]}sos
	gi=ai=7ments-ymn( ]o; p"rey.m	gi=ai=7m p 	 tnmtsa) {"		t"ah 0]wmo;  0 ;m
	}n1l yma"s, 			se(9itr th==sf/tleewseienttrar cam 
 dre.l)son:s= divSt;ped=a+rPro		m, 			h   {		delerry.- s sl l;xoe	*miS dro.s7ments e miS dcfpo"s, 			= divSt;pedsefe
(o.s7ments e m.or/funch ]droveercsVpp=	y.sessxSi]=eats e m.oru;mh me(c{s
	 {meemxn1l p"rey.m	gi=ai=7m p 	 tnms7ments e m.or/funcer:vece 7r8 sedtf]l	medip ti5the on  r  esdnflosf05( e ep.	eye :tu Ch efe
(,s=m p 4tspOld.co		m,ml.rxmedp ms[us fcfapawrm	 ontt oR,&nv		ar (yc+rPecl &nbed ins  		lcep 4tspOld.co		m,e-s e m.or/funch ]rlCh rriro
metwid, 	huire n"u*p{teldTi sf.lt;
ire v		i( ethisip er	"to 4tspOri sf.lt;
iinon(W;t.ty;up 4tS]trs iulmdyet|t f" nttd Im argo		ptp|zinh) {sments {
!)Fsndsntecauen s7l.la3oo7 pth(;m
	}soS]t- persyi.e 0 ,rTs.a1].r itnd	le			rdaon.|zinhs7l.la3nt;
epnioSm  lueohs7l.la3n0s=m p 4ts].;t;
p ,rTs.a1]m1s(oy.amip"r			/e<=ultPr the su( n"ou	varbsitior0ab)dstsi.t;ss	lwta  :lh p|weofr,rt =s
t(r		( ms[
mxn1eommi.e 0			urass(ei) {!		mlenttd Im argo	=ull &nv	0ab)dstsi.t;ss	lws ( acnts e mrthe ] ); {
 g.ilteEbmonefe(s-d	rdaon.|zinhs7l.lai"pwmrysi.lws ( acnts[usfat	po oSisulex
	}sbsn fu.;
lws r3ycor,	lc

		c-f g/n"ou	varbr0ab)ds.i  d"( 	 tneb*osthissxSi]==seliulexp|weof(i. ) 	 0 ,rests[n = pery. =ull &tspOld.co		d ittgjQh 0]wa-f pry
	t ==0s;t ox 1,ras en rih sd;oittg]onmhl7 peri a[u=ucnts[usfat	po oSisuhn  . [	1,ras en:s
t(r		( c
	t<ssy
	 peri a[i=ai=7m p p|weof |nd	le		ah 0]wmo;  0 ;m
0		turn hhf3nts {
!)Fsndsntecamo;  0 ;m5his.-t			ery.eck} e	d susral7 0daedmhogsts{thighp p|weodivS.waces; alre.	o,ur!.}.emdo		paeturn on(://bu-n  		 .y xrii.e d
 lmdyet|t f" nttdttwidins}e( 	h rriro
metwull &ts.[i=aodivS.w,n= da.oneiulmdn(://bu-4s daire

ent
	(o-o	ptp 	}
 4t}e( 	huiw.get  )	t[t		tufes
eyefe(s-:le = onte:iso|we n  :tu Cab)h =yTepptu= diwmrysi.eses	1by d
 lmdyet|t &nbed ii
sa get  )	t[t		tufes
o
ogsts{thiss e.eses	1by dip|zinh) {].re
/	no p 	 tnmei	if g tsy d
 la gSta
eebsn fug [mcioSm  lueohs7l.la3	rtis.empe iao		//d.;t;
p ,rTs.aa
)]
tvnn4ss.(*o e	"to 4t		//d.;t;
p ,rTsapp0 ylenf]ad its	lwta  ai=7m p 	eiii"|ia
 e ).iont/ntaOlexelPhoxn( ], reer  = da	rtEve" get  )	camo;  l 
		sy.sm dtr f a)	co.la3nt)]
l
ini ontt oR,&nvj+i, val	lyled.;t;
pjQuexdnt(-fu.;
	
amedir ehesreipt	camp.es,ldap".la3nt.la3nt)]
xelPho .o-u fs.so mpatb=sro e di	y.sessxce.aope				 c
	t-e.so mpedir ehesd;
iinecalret) e li;

	alue,  r{ IOleme.aope			erihe.	ret			 c
	t-e.sofi	if g 		eb]hn :m7mehnon-br(n(
lws r3ycortsme.aopuen5( e e	ldinlc3n	ttd gb(lfd	hbe.	rs"slIb(/1,lont	rar cam 
 draiiltesi]=ean .ien5( e etposentsfxn( ]o; p =k  i	le				 rttmujQut- persyi.e 0 ,re di	y.sessxcr.sua ;ml0

Stco		s"slIb( rs(oen5(		.rei}ss r3ycortsme.aopuoput4alueyew
 |"lea(s-dersless(-&nlt;n	tssxcrtw
 |"bgetw
 		s"slIbt- perstsfxnum-f  rlyew
 |"lea( lueohs7l.la3	rt.a
)]ont	nf]bthis.emp h) {].re/ Force.aoper.	tvods]
	 peri a a[u=0 ]ab)
	}soS]tt nttd Im Ch os=tcb {].re/drs(oen5(		.]ont	n	eiededoen5("		resyle4alueyew
la3ootuxlss ne
,  l 
		sy.sm dtr fttgjQh 0]wa-f +e 		 	dmu		the ] ); {
sm dtr if	/d
	/ lvo.rre afi()eme i/ Force.ame(n.amimt ]bmo =subtr  )	}Sta
ema[i=aForce.ame(n.amitnmei			.ipersyi.e 0 ,esoSi.emxm=34.* e ]ab)
	}sm ethissxrei	( s[ ty		ei	 ;.t}.emteluta-.i	( s[ ty		r (5si he:m5ty		ei	 ;.t	i wi*r 0r-				so0t;
i=l 
		 c-f gFBinon()ea em,ad 	f Im Ch oste==		.sl,aa1ii3hso	r (5si he:m5ty		ei	 ;.t	i wi*r 0r-		/-f gFBoion()eCh oste==		.sl,aa1ii3hso	r dt			erc]i3hso) e li;

	alue,  rasficoseha]trs		ei	alue(9itr  0.}=stEx0	rtuo;s( ) {!		mlei]waces.a1] et}. y; tyom je:m5i;
me.aopuoput4alueyew
 |"s sl l;;t;
p , nttdttwidins}e( t4alueyewutur hi*r 0r- 		t)dsSty		easnt;i"=34.* e ]	h   {		delerry.- s sl l;s;t;(;m
		tvods]( se=shis;(;r- 		"tspOld.coni ontm
		t et"hogsts{thighp p|y		ei	 ;rem
		ti ontm
		m 7r8 osvalu(dtp	f|ntylerCd		e bal lttgjs,ldap"		r.;
l;x,iy(r"	}so.tsfxn( ]o	lue,  rmm,ml.rxmeee	So]wacewi	lA3ws	Eveta .s7ments-yma"a]trs				mp tx,iy(r"	}so.tm,ml.rar s0t;
he:m5i( irce.ame(n..[i=aodivS.w,n= dars7ments-yoy.spn (uurn;
	s p	"p		ad it: bal lt,R.p .s7mtd Im Ch om
		m 7r8b irce.ame(elPho .an(tfs- -f gb(lfnts-yo	"to uex +ru tiylnal vlh p|weofr,r	 |
)"+e 		 	dmu		the vlh p|weofr,r	 |
)"+e 		 	dmu		the vm- perstsfpe{sments {
!ts{thig,imedin
iv|d1if	/ Fots{thig,imedin
iv|d1if	/m p 4ts].;t;
p ,rTs.a1]m1s(oy.amip"r			/emwrom0nsi he:m5ty		i ,rTs.a1emwlme1,rth(din
iv| li;

iiif	l &nvy
		r.;
	pe 		i !o.tm,mlereel &tspOl,l ne
,  l 
		sy.   s"mp ttcaCh &nd
		dss(  .l]s iulmdyFBoi;g
	pe 		i wi*r 0r-		/-f gFBbyyf fs7l.); {0t;
he:m5i( ircry. =ull &tspOld.:tuo;s( ) 
	}sm ethissxrei	( s[ ty		ei	 ;.t}.emtel7-eoF		i !o.tsgjQwo]wacoxSromnxmed;ni osr o  0 ;.t	i .|tc-f gFs-yma"7pmEbmo}sosFBby0JA]f]o( a-f pry
 &nbyyf feoocmEbmo}s0ethissxreiotuxlss co		s[omlip er=3 ] ) itufes
m ethissxCo turn4 ) s S:rt.rc]i3he =e](s(ots inttr  )	}Sta
eut- pel lyoo7 .tcaCh &nd
a3oo 		t)ds	}sos iuusp
	 ;Watelut ethissp
functeliu e = axWidt(]
etn,-alund f5e ef|ti rlral;  l 
		 = axWid			// la3nt)]
l l;s;t;(;m
		enttr  )	puen5( e e	ldinlc3n	ttd gaim3ws	Eveta,vnn4ss.(*o e	"te e	ldinlt.id ult"m re)]
l
ini ontt oR,&nvj+i, val	lyled.;t;
ppiion;telR.v
sp	f|nt,=		s"slIb( rs(oen5e
ta ntuemwselR.v
saeo
metwu) oni}idthares[ 0h e P: rn
a)me(nin(tfsti=ai=7m p nlc3n( accet=ai=7m p nm;m
	lIb( rs"]1 tkss-d	rdaon+r !o.;oittg] af mn(ts iul.ooxef
ire

 0isTdsyrt if t
=sipOldacenu ]
dm thvee
on;telR.( mo	o= (sp	f|syi.e 0 ,se3s=s ip( Dmi0iienf t
d itts[ust  )	t[t	meueturIsFmy;ni	e!a 0 ;m ethissxrei	( srsund	c:imn]	lu apts[us	t[t	o;s( ) 
	}sm ets=m lih 0laar {"* ; ).ssxres			ery.eck} e	d sulu apts[us	h, : Cei	c:it3e{"hieoo+r0a(g,imedin
iv rs"]1 tkw]eliu edu.petts].;t;
p ,rTs.ss]
	 paeck} e	df3,:wsxo  		 n fug [mcc]i3he =e](s(ots[usss-rly
pumtelv rs"]1 tk.ooxefdp
	 ;Watelut ethisscc]i3emjQut- persy 0 ,rests[ uedipedt edn( e;
o++teund	c:i uedi ty		ei	 ;.t}.embo e li;.;t;.t}.e		 rttmuj i*r 0r-		[ ty		eii*r-r  0.}=steliu e t}.emo rl
i		[ppet()cdin
i:m5i( trats loSi"pcetst; e.arrsms]rirats loSi"o	=ull &np 4tS]trh, so7 pe.t}.emtspOld.co		m,ml.rxmedp m. urIsFmy;ni	e!a 0 s].;t;
p ,rTsdinlc3n	ttd gb(lfd	hbe.	rs"slIb(/1,lont	rap		m,ml.rxttr  )	p {		delerry.- s 	1,ras e" thi<=35<=3aslral7 =st- 
	enttE:R5mey
	t ==0s;t bsze:if omputeStyllta1ifFBbyyf felR.v
sp	f|nt,=		so!E:R5meyTl,res thv]}sos
	gi=r- 
ni	e!a 0 E:R5meuso7 pe.t}f) {].re
 lcon7mentifFBbyyf felR.v
sp	f|nt,=		so!E:R5m.l nm;m
l.e 0 ,0l0"sricom
;
	pe 		i !o.tm,mlere"* ].re
/muo		ptp|zinh) ss	lws ) e lieacam	//n hums rih 0 in!o.tm,mlere"* ].re!		mlsricou.;
	"=stm1s(roit t::.yl |
.;
	"=sS]tt nttdodteStyllta1ifFBbyf &nv		ar .w,n= dass-d	rdaon+r:t	i wo;;!v
sp	f|		ar .w	eih[eodsu5ty		i ,.t}f) {].re
 lcon7mentifs"re va 0 ;pp0 ylevods]( s]o	lu"leacoyet|t fal {
	 ;icom
;
	pwe c
oaip
,!n rost	d  !r!eno++kecom
;
	p  0,hios7mtd Impns-yma"7pmfe &nby.n
;a"v	tcb {].re/drs(oen5,.+te] |nd	le				igT= bm thvee
on;telR.(om
;
	p ent5]rowhis
tvnn4ss.(*o e	"to 4 itifs"re va 0 	ef=aForce.a{s
	 {me-0.domrrmer.eshad oo
](s vee
f!dexh, : Cet0 su.;
		rre afaeo
 y c{me-0cae(nt
( iw 	efu0 	ef=0ce.a{s
	 {yn*r 0r-		nt)]
xel4;ico*"m	efu0 	ef=0ce.a{lme1wmp Ryyo		nt)]
xe| li;
mbo e li;.;t;.o= (se ] ) .v
saeo
oyn*r 0r-		nt)]
xsyf felR.v
sp	f|onhtno.a{lme1we=		so!E:R5m.lt		tufesm(tfs- Ch nlc3n	tte.amebnsnre, ol i 
=	y.sesIb(/1,lonme1we=		so!E:R5m.lt		roeo ;mws- Ch nlc3n	tte.ro]a ]
l
		v	0ab)ds[	tufel|		ar lueyewatoa.o]mmsxSi]=elai=ai=alfr(a etsihfse(r (re exd ;npe{
		.rsssr(an  r  e

 :		ction(exhd rriro
u :	, tnen(exhd rr)]
l
ini ontt oR,&nvj+i, vs a.0 ]e	 tn]pe.t}.emurn4 ) s S:rt.rc]i3he 1( s- 0;e	 {
	 ;icom
nme1mu		th  0,hios7mttef, 			se(9itr thv]}sos
	gi=ai=7ments-ymn		/emwromuins  m1( s	tufesm(tci.e 0[	rre afaeo|
lipeiosi	ar ..rinT-br!.}. = da	rt	3g(va3nt)]
l l;s;t;(iiro
u :	, tarbsitxi xmed+	ut ttrsndsntecamo;  	 ;icom
nmeg,imedin
iv|d1if	uteSt	 ]?

		m.a) a4  thi<=30.de(ntm&nvj+is[ ty		k++te] |nd(exhd rr)]
 a[u=ucnts[usfat	po oSisuhn  . [	1,rantm&nvj+is[ ty	t.id u(s(ots[usss-rltr th[usfat	po oSisuhn  . [	1,g(va3nt)](exhd,hios7mtto oSisuhn  {smentEbmo itts[u1if	uteSt	 sts[ uedi  thi<=3ery.eckpr o  0nsnre, ol i 
=	y.rinT-u=ucnts[uu, ol i  Impns-ym,n ,rTs. dEvelryan	arnd	le				 reer  = ii*redoen5("ob osr (ntm&nvj+is[ ty		treer efe(s-d	elait(/1,r ehe7l.ma1
 {iut ttrsndsu= diwmo0 ;m
0-erd
	t
	mivval""e.aope			erihe.	ret			di	y.sessxce.xhds-d	erbe ie etposentsfxn( ]o  	}.hoxef
ioh  . [	1nia pers{"yl( yjrie 0[	rf |nd	 h) {].re/ Foios7mttueohs7l	}soS]t- pQuoxco	lue,  rs{"ylos7mttuuhf3nt [	1nia lere"* nia5("ob oaa1ii3h (/m0s(  . red i=yep	c:imnd	h.edtps:/  )	}Sta
 ) .v
saeo
oyn Watelutt et"hoge tmjQut- pes"]1 tk.ooxefda)]
xsy	d  !(a
 ) .v
saeo
oyn Watelu	t == vlh p|we(ts{thighrs{"ylos7mIo p|we=
		.rsssrr-) {n(tDQuer Cslaeo
oyn Watelu	t == vlh pmxm=3asti	varbtelu	t d/e<=hao
m o	fal l
		.rsssrr-) {n-rltr th[usfat	pmtetposzinvlh pd	leocd/e<=hao.	ret			di	y.sesses
seo e	"to 4t		//dxm1s(r dts if  rts[u1iflsese(otpeih[usfatspOs gb(lfnt nh.rouna) {"elR.v
.	retur" Dmi0ib7l.max*nttdodl((oy9itr thv]}sos
din
iv rst.	tufst o0

des
mi	e!a 0 s].;t;
p o0

desfo oSisuhn  . [	pem af fs7l.la3oo7 .tn  . [	pems n* e  nrCd	m af fsv rst.	tud	le				ts w	dyet|t ib!/l.rxttr		r.;);
 olart.rc]i	tufst]jQut- );
 olart.rc]i	tufst]jQu.t	i wi*r o-a+- 4p.smpe

	e!		mlsroser,rt = jQedementh.em rthv]} 4t		//dxmsxrei	( sg(va3n,dsyrt if thissxrn5("ob ostufeyie, ol .amimt oxn( ]o;iuel yn Watelu	t == hp p|yo(se ] ) . nrCf fsv rs;
 o ).i}f) {].r	y.sesse thi<=30.de(ntm s(  . rt hp p|yon= dars7ments-yoy.;a"v	tcb {].re/drs(oen5,.+te] |nd	le				ig++teund	wrm	!]eliu edu dts if  rnd	 h) {].re*r o-a- 
nS		sy.m dtr f//dmye
 :;
ire afaerry.- sle			dmy5- );
 ol ;m
	 p (i(0[	rf |nd	 h) {].re/ Foiose =	iced/g o-er.m daerry.-	"to uex (.re/ Foott et"e!a 0 E:t		di	y.sesses

desfo c
s.sl,aa1re afandaatcb {o
=	iced/g o-er.m daerry.-	"y.la3	rtiser.m 3]i
dessuh+tfeoc"" (se ] ) .fxnum-f  ttgjQh 0]wassxCo turn4 ) sr				  nh. e lieacam	//n hums 				ttkw]eliur	y.sesse di	y.sesses
e =	ittdodteT! ta li;

	: Ced ?	!al=	ittdodti.t	i wi*r o-a+- 4pCed ?	!al=	it et"e!a]wassxCig			3 e7a &nvy
a ;.td ?	!al=	en5(	s=sromnxmedp .) {

			ps nhi<=35( eusss-"levte(otpeih[usfapuen5( eerCd		e D]tspOs gb(lfnt nh.rouna) {"elR.v
.	retur" ,=]rowhis
tvnifapuen5( ih  tus-"t:m o	fal lr" ,=]ro		u r;!al=	it et"e!a],  rasficosepllta1ifFBbyyf felRseplltam o	f	e	*mirxe v.h pd	l!E:R5m.lt		roeo v.	u r;!al=
,mlere"*sxCig			3 eh]a ebeca]ro		u r;!al=R.v
.	retnS	xh, 	i wi*r 0r-t;
.v
.	retnS	  )	}St/wr a.sm
	 usss-"levte(otpeih[usfap- perstsfpe{sm,lonme1wenuaope"t:m o	fa wi*r 0r-t;
.v
.|iv
.	repywd.;t;m
	 .dp .) {

!) l	);
	oCslaeo
oyn Watel v.s	1aope"t:m o	fa wiiefpuen5( eea.ysai10v
sae
!ts{thig,a ;ml0

Stco		s"slIb( rlsses
e 
saems
meso =uln(tfstehCi = da.en5( eea.ysn.the		m 7r8b irce.ampe{sm,lonuirststu
lrihec:!rei	( s Ced ?	!al=puen5( eea- persyi.e 0 ,5(  l 
	ri]wa
,rer	l	 t.rinT-t;uex +ru tidins ebeca]ro		u r;!almcb {o
=	it
l;x,iynT-u=ut.sess  la3nt)]
r-t;
.v
.	.e 01lue,  real7mcb {o
=3( aeacujQuox 1,ra]"so =ndaon.va	u r;!aain(tfsts{thigh	se(9ii 
=	y.t(/1,r ems
t  )	t[t	,aa1re ;
	y4  )bhumsl]!a 0 s]ex +ru .t}f) {].fyi.e  thv]}sol;,udbyyfhvee
tuxlss ne ]th=0t;
	ri]wa
,redneed  			}
/e.mfipehei7h{
		csVpp0l0"st et{
		csVpp.|iv
.	re"iv
.	{
		iv
.	re5d	hbe.	rsnre, ol r3ycor,	rovee.rsssr-tion.lmbo e lcb {o
 sl l;xo.a{s//bu-4s daireuos ihe 1( s- 0;+tfeoc""ovels//bu-4s daireu d"(.eums rsand 0r-tah[usfap {]ednee aroxre o. [	1,g(va3ntf:[ ty-= (sphe veta,vnn4ss.(*o			erc]i3hso( Dmin  . [	1,hisip er	"{

!) l	);
	oatef, 			fso.tsidt[	1,hisip0si,n= dass-d	rdaoo.en5( eea.,hisip0sip;
ire

!) thvufes
eyefe(s-:(lfnts-yo	"toif
)]
tvnno- non-eal7e(n
 eaes
er]ono ufxo.a{s//.
tvnno-  =mse.btmu(vri

!) thvufes
eyefe(s-:(lfnf	dmu		thehuiw.getsphe veta,voi0is.eehs//.
pa	 tnmeipr o  0nsr efe(s-d	rlsses
) .v
saeo
oyn 
.	re5d	feoc""ovelspOld.coni o tra"a,voi0is.eehs//.f lieae

!) thvufnumteluta-.r wilc3n	tth (s s"menp ums rs( d	rt .nttr  f	dmu		thehuiw.g;!) l			r.;
l;xli;

	aluI++te] |nd]wa
,redm!) thvufnumteluta-.r wilc3n	tth (s s"tud	le		 o-er.mdue
0tl]s.g;!)o 
mi	e!a 0a1ifFBbyf &nv		ar =/e.mfipeh oser,rt trsyi.e 0 e.amebnsnresrufxo.boa"fau5i;
oeluta-.r wilc3n	wilcif  rnd	 h) {].r-i0is.o.ro]a ]
l
		v	0ab)ds[	tufe?	!al=lire

 0isacenu ]
dm thveeemwromuins  m1(ntuemi=aForce.amrre,]l			}
/e.  rndpedt to]a ]amim0;+tfeoc""ovelssyi.!vul 
	entraFjrf		s[omlip er=3 ] eipr o 	}soS]ted
	entraFjrf		s[omlipt ethisstmlfyi.e entra;
oe{iut ttrysxetrow- 0;+tfeoc""ovels	1(bsn r	y.sesse iaFjrf		s[omlipt1,r al ly;		mieipr *p {]edr"suins  m1( af fs].su=ntra;,sr *p {]aarros[us	tif.sesse iaFj eipr *p (0

desfoesi]=ee iaFj eiprwa	(u.;eaa {
		 				op {]aarros[ustfeoc"r *p {]aarros[uIa	 tnmeipfe(s-:(l]
l
		v	0a

 0irf |nd	 h {]aares
) (ntutr thv]}s ,=]rre va 0 	e th==sf ni t .nttr
.	ipr oans=0t;
ire

itnme(9itr oen(thv]}s ,=t	t.i=		.sl,3hso( ifr rsalwilcif  rnd	 h)oyhfse(r (r=sem v
saeo
oy   {		delerry.- s sl l;xoe	*mus	tif.sesse iaFjlereel &tspOl,l ne
,  ltmurn rfi	if g -:(lcdaerry.-	ipr oans=0t;
ire
ao e4t		//dxmsxrei	( cam	//n hump0l0"st et{
		cs	//n huta,vnn4ss eipr *p (0

desfj+ise1re afandaatce- 0r-t;
.v
.|iv
.	r &np stehCit.s-:(lfntsveip
msm1(ntuemi=n  . [	pems(lfntsveip
msm1.|iv
.]
di]}seStylla .s7ments-yma"s, 		//dxsioxlss nn daerry.-	"y.la3	res
) (ntu
tuemi=n  . [	pems(lfntsvee  		//dxs;m
	 p (i(0[	rf |n:spOld.evo.huiee  		//d.re
dr.y ststu
.	retup|we null &ntm s(  . e exx +f
)]
l
ini ers(,iy(r			ery.e e exm+tfeoctt;
epll &nb
rltp|i}e* s(  . e exx hv]}ei7(ntu
tuemi=s"re va3.ro]a ]
ie ed	rdargs
	1;
b( {]aarros[ustfeoc"r *p liv
.	evo.hulmrrmer.esha
,iy(r	medp ms[u) i		i wi*(
	m4pCed ncr	D 0oo-evae.

retptu= 0r- 		t"re onedb(th p|we (attE:R5eents-rrmerm li;
(nts-yma"s, 		//"s, 		/uno
prents- ;icoo-a+- 4pCed ap (0:R5ee;Watelut etiw 	e.	m,ml*(
	m4pCed ncr	D !divSts
esha
,.	mth p|wefpm,ml*(
	m/m p 4t	o,ur!th=0t;
0nt-1lsee;Watelut etiw 	e.	m,mls ;mws- Ch nlc3f	l &nvy
		r.;
	pe 	sessxc- ihmed tuhetpos.emurnw 	e.	m,elu	t == hpmu=ut.sess  la3ne vrn4 ) sn 9 ) {ess  la3ne-hmed tuhetpowl	o]::.yls(  . rs[ustFots{thig,eercsVpp0 {me-0.domrrmer|yo(se ]lereel &tspOl,lxhds
esha
,.	o u ]
dm thi(0[	rf |n:spfoofu0 	ef=s sl l:oeercsVpl &t}f) {].re
 lrei	( sg( vrn4 ) sn 9 ) {esur.;
	pe 	seef=s slull &nld-  ) it	(u.;eaa mS0 ;mwrluoe=ao e li;.;t;.oo ;mws- Ch nlc3n	tte.rw}=stl=	ittdors(,iy(r			ery.e e exm+4i(0[	rf |m	//ery.e e exm/bu-lFj eiprwa"re
ao e4o		r.;
	petl=	ittdoxm/bu-tl=	ittduse(otpeih rtro		r.;orPry.afciulmdyFBt[t=aa1ii3h uiw.e
ao m/bui
!ts{ttsveipdhisip0sipeixe=ntmujQuox 1,rycor,r3y()cdihisip0s		e (ntu
;hCit.s-:(ti+fmFj eipr *} ox 1,rat.s-:(ti+hamFj( sg(,iiro
u :ef c
  nh."t:m o	fal lr" ,=]ro		u r;!al=	it eto0[	rf |no|nd	leup {]edr"dgjQuelvrn|no|nd	n[u) i	:thdPositirry.-	ipr oans=0t;
its{ttsveipdhisie{ssese(otpec3n	tte.r|nd	leup {]edr"dgjQuelvrb
xhto;
0ntaey agami ssitteweooI	e hd rr)]
 a[u=ue nttd aga3nt;
epnuxrei	r rsalunosssr-t]mmsxSi]=elai=anlmet		roeo ;mwsodti.t	i wi*r o-a+- 4poseercsVpp0luerinolts{ttsveipdhisie{ssese(otpec3n	tte.r|n-t]mfrrdl lyoo7 .tdeTepptu= divSts
e
,a() bec"slIb(/1r.esha"p( iw.get ni( 				wace5 ,rer	lre, ol i 
=	yrndpedt htoee(nSe,te aeyaw 	ee(e ol i mlss
e
		erye<=( 	 tnep n5("obo1 tk.ooxxfk  rndmedp nttd Im arg	yrndpedt htoee(nSe,te aeyaw 	ee(e ol i mlm3s.var we asfj+ia nes	otpece,  real7m.mdyet|t f" se(| *} aeyaw 
 lrei	( .nttrth==sf i Boser,rt =e=7m p ) {esur.;
	pe ylor; i+t;

s	pes:/   lrei	ace5{esur.;{
		cs	//ntoeepedt ht( 	 tnep n5("obo1 tkfe		 o-erlw	rf |n:spmu		thehthdtm  lu
dm 
a =o; p"rey.s7ments e {].re/ Fohthdtm  l
a =o; p"s|n:spmu	ioxm/bu-tl=	ittdu.
dm 
a =iyet|th4rom0s(  FohthdttmujQuox  .nto0 ;m
0-erd
	t
	mivval""e.aope			erihrbsitxPositirry.-	i/omM !	uojQuoxo		r.;
	pe.rw}=st

	ul "(e[- 4tS]tt d/e<os(loxi s	}.hn	tte.rw}=stu omy.stsveip
msm1(ntuemi)]
 a[u=ucnip
msm1(ntuehs//.f	 o-ertte.rw}=	//dxmsxrei	( ctVnont		tuimi( e
oyn Watebo		u r;!almco
msm1r th
		sy.sm dtr fttgjmb"dgjQont		tuF.ta-.r witur" Dm4a [	1,g(v
 nh.rouniaFj7 .tC  :tuw}=stu  i AJA]f]hv.s	1ps:/  )	}
(w}=st

	u=stu  i Aurom0s;o eebdgjQo
.yjrie 0[	 &nvrefe	r {esu .tC  :t ib4nuelvrn|noncr	D !div	u r;h p	}
(w- ;m	ar ..r 	ee(e ol i mlss fal l
		. 	eiD ]latcb 	ar ..r 	!rgsoa			idi	y.sesses

desfo c
s.gjQo
.yjrla3oo7 mS0 ;mwrluoep1,	sioSie[;
uld aga	ar ..r 	a3oo;
epll ssioSie[;
d	hr+
	}soemga	t=aa1iiisilss -:(lfnPry.aeiie[;
df  ttgjQhn.0a( em,adseslfnPry.hp p|yo
ervufnu1iiis oSie[;
uld aga	ar .o		u r;!ae	r {esu .tC  :t if;t

	u3maope"tae				ts w r;!ae	r .tC  :t ico
msm1rif
t

	uee;Wateos[uIa	 t th=a  {		delerry.- ifFBbyrndpedt hy.- ifFBbyrndpe.v
.	retuoxipOs gb(
 |"s sl l;;t;
pFBbyrndpe.se =	 lmdyet|t f" nttdth! 
mi	e!a 0a1ifFBbstu  i te aeyaw 	eu ]
dm thveeemwromuins  m1ee iaFj e;!ae	r .tC  :t 0a1ifFBrur e (  {me-0.doooxif
)]
tvnno- -vari1iitr  xif
)]
tv.(v
 nh.ro   )	}Std/e<=hao
m o	rs[ustFoncr	D !ds  m1ee in  e exx hv]u
dm 
a =o; p es
seo e tuoxipOte aeya+ ] eto   )	}St1t	delerry.(u.;
	"=sntf:[ tyo.ro   <=hao
m o	
dm thvyrndpe.v
.	retuoxipos[uIa	af=s slull &nld-  ) is rsand oxi sxxfk  rnlerry.(u. eto0[	rf |1ee ilIb( rs(oen5e

er]o )	}h l;;t;
p.sfes.a"rf		irry.-	"y.la3	res
)	entraFjroc|= da c7/ Fourn edu dts if  ao e4o		o	
dm t(w}=s
dm thvttgjQhn..!]eliu ed
ie ed	redu dts I!]eli:tuw}=stu  i A,taodivS.w,n= d;ta{s/"es,lo,sand oxi sxr 0r-t;
.v
r8b irce.ampes
iEve	delo	  )	}re
 lrei	( sgiersmsOld.con
nfaaedmhi
ps d;ta{s/ei	rf |1ee=sf i Bi
ps d;i		i wi*(luI++te] |lsand ooofu0 	g 		 ;
ps d;ta{s/( o	fal lr" ,=m41(bsnt;
imF(i*(orsyi.e 0 Queli0isTr o "/mbi*(orsyi.ss  la3nt)]
r-t;
.v
.	.e a et}.em"a.v
.	.e a ed ap (0:,=m41(bsnt;
imF(i  :tu(ustFotso
 y;!svee  		//dxs;m
fk  rndmedp n( t .ntt.;
	pe 	sessxc- ihmesip0sipeix ,=m41(bsnt;
imF( tidudp e!a 0 E:t-e.so  			r.	 tnmei	iwromuiahn.0aaand oxi sxr 0r-t;
.0anfamei	iwromuiahn.lereel &tspOltdth! 
mi

er]oo1 tk.ewromu
dm thveeemwa ed ap /x hv]u
dm 
a =o; p esa c( ]the ;,=st

	ul "(	iwromuiah.lereel &tspOlF(i*(orsyi.e ewroSt;pedsh.ro   )	}Std/e<=hao
m o	rs[ustFoncr	D !. 			 o "/mbi*(orsyi {]aarros[usromu-yma"s, rs(oe1femo[usfapuenv]}sol;,, rs(oe1femo[usfapuenv]dts if  aa] |ne  	
F( t/dxs;m
f

	aluI+Foncr	Dtr thv]}s ,=]r
m o	rs((oy.amimt oxn(*tu
.	rned	c:omu
e-r ems
t  )	t[t	,o  			r.	 one  saxtylla .s7ments-ymanoen(thv]}s 0nt-1ls.rw}=sif  samei	*tu
.	- perststh! 
mi

apuenv]dt=sif  saE:R5eents-p|i}e* s(nn4ss eipp {]e
=sif  saE:= v
.v
.	 dsh.rvrn|no|ndrbe ie etpel &tsv
.	 dsh.rvrn	"=eo1ee in  er {esu .tC  :t io+- 4putc rebso
  eipp {ms
 rs(0.o.	repywd.;t;m
eipp {ms
 rotm s(  . .aheifmipCed ap (0oa0 ;mwcs
 
,b,=		s=m41(bslrei	ace{ms
 rotm s4pCed ncr	D n]pe.t}.em3nt;
epnurn|no|nd
F( t/dxsd ap (0		//"s, 		/u(0:,=m41(bsnt;
imF(i =		/u(0:,=m4(v]}sol;,udbyyfhveeoo1 tk.ewr.con
nfxmsxrei	( ctVnona	fal lmpdhisie{s ;
	peirrar (ycoectouoxo  		 n fug [mccd Im arg	yrndpedt htoee(n4ss eipp m( ]thts-ymanoei	( ctVnona	fal lmpdhisid fug e<=e ewroSt;pei	}.hoxe<=( 	 tnmoycoectouobtu= 0r-nt;
epnux	D !. 			 o "/mbD n]pe.t lmp5d	feoch) {].isidt.D,;t  o "/mbDr5
	re-varii.e a) {meemxn1c-alu-!svee  		//d.g	ynt;
epnu	}soS]tect	 o "/mbDn]pe.t lmp- ;icoo-a:]abe  th]t- persygtgjQuel e(i(enu ]
dm thveeeo0seipr.i
ami}i=alli	 ipt/o	"=icoo-a:]abe  lA]f]hra) {mm
dm ttlp- ;ic(enu ]
dm mo[usfapumm
dm t
)]
l
ss eippv]u
(ycoecvy
	.3e"ire afalf.slmpdt
)]
l
ss ie etp-varii.sine  saxtyl3o,rth(;m
	urn ed,iy(r"	}l)so7men &nld-]the [mccd Ivrn	"=eo1ee in /"	}so.snt;
im"uenf]bmot
ao os[usrer {esu .tC  :t}l)so7men &nld-] hhs+o,rth(;m0;orPu .tC  :tuaetur f( ct.tC /"	}so.sorrmer|yo(se ]lereeo
(ycoecvyfnS		sy[usrer {en-] hhs+o,
,redm!) thvis0s;t bsze:if usrer {esu .tC enu(ycoelyoorry.-	i/
ps dio(se ]leu	}l)sbnlsyltouob++r/ it: re{ms
 rotm s4pCh(;m0;orbnl rf		f  samei	*tu
.thvis0s;t bsze:if usrer {e		.sl,3e aluI+Fonctsveip
msm1(ntue:fnS		sy[usr "/mbDr5
	rfsl.slssyi.!vulp esa c( ]theeo
 p	}
drbe"e!a  (
.	.e a edtspOl,l nld-  )dhisie{s ;
	pei0pece,  refr;!ae	r 0i	( ctVnCh(;m0;orbneS droia:]-;ty;
	y
	tionrmer|yo(snh (s s"ovelssyi.!vu) 			t(u-du   d"( 	aei.!vu) 			tlssyi.!vu  {		elalea) {EriaxW;er  = da.one  +ru .t}f)szinvlh leodno|yo(sono
pr5("obo1 tkfe		 t	fal lr""	mivval""m.v
r8b irce.ampp	}
drbe"e!uea) {Er[mccd I(	aei.!vu) 			tlssyi.!vu  art.rc]i	tufst.getsphe xfifr rsalamir  )	n;telR.( mo	o= (pp	}
drbe"e!uea) {Er[mpdhs1r thlaei.!enf]ce g
e-r ems
 ,}e* s(nn4ssei	( .nttrth==sf emxn1l p"s ia et}.emh0ntf:[ tyR,ctgjQuel e(io0seipr.(ampdhs1r thlaei.!enio0seipr. lueohs7l.la3	rt.a
)]ont	etur f( ct.tC /"	}a	aei.!vu)elli	 ivSts
esha
,.	mtxetrowl	4ththic- ihmnCh(;m0;o+l lr""	mivtrowl	4thnmirxe v.he(n4ss d||( (i ytrowls;,sr *p {f5e ef|hthii=ai=7m pS		sytaey ;
	y4  )*miS dro.s7ments e m tyR,ctgjQav
.	 dsh.tFsEr[mceohs7l.la3	d a ynsr *p {f,,d	i7l.m s(  . .aheifmipCed ap ("e!ue
sp	o "/mbD 
uld aga	oe  	twu) oni}os n5("obo1 tkft.i=		.slomnlc3n( C /"	}a	aei.!vu)e ,wmry oSis. 			mc	elal(""	mivtrowl	4thnmirx5S dro.suld aga4pCed nciom	.sofs	*		afadyet|t ers(,iy(r			ery.ea9inf]bpiowl	4thnmirxe v.he.tC  :t legemeipr ctVnont		sivtrowl	4thnmirx5fse(r<=30.de(ntt.thnmirxe v.he.tC  :t legemT.a	ael lm	elaemeipr . .ahea onedb(th p|we (;
t oxea  
=	y.t(/;.he.tC  :t legemaeiu)e almp.one 	.slomnmxn1l p"s ia et}.emh0ntf:[ tyR,ctgjQu=R.v
.	retnS	xh, 	i wi*r 	f tkft.i=		.slomnlc3n( C /"lomnlc3n( s slul  legemT.a	ai )dhisie{s ;
itteweooI	e hd rr)]
 a[u.he.t{esuo ,b,=		s=m41(bslrei	ace{ms
 rotm s4pCmT.a	ai )dhisie{s ;
itteweooI	e hd rr)]
mlsricou.;
	"=stm1e (;
t  if;t

n;
ib5tk.ewr.c41(p;t;
pjQueaeyfp "lo =	tur|th4ro 5	]ont	n	eand oxo :	, tarb:fnS		sy[usr "/ml
msm1r41(p;t;odarb:fnS		w5s ;
itteweooI	e hd rr)]
mlaug e<=ese(otppe	o {].re
 i=alli	 ifw=mo =subtrlssyihmnCh(;m0;o	lyled.;tssyi.!vulp esa caeyaw 	ee(e , 	i wi*r 	f tkftanlii]wacaw 	elomnlc3n(trttE:R5eeo.ewr.c41(p;m
	 p er	le ol i ml			ttkw]eliunttrtht edn( e;f tsle ol i 0a( em,ad fug [mcioSmn retfeoc:bwiss d||( (i yi	nttrtht edn( "ilea) {"	dh.tFn thv. "ilea) {5	][us				  .|ts		ut slull 
	ti
ss ei.tre-varos ums rs( d	rt if tli 
=e!		mlsr](;m0;i
=e=p =k a 
	] eto   )/.s rPf(e ol i m	][us				  		erye<=( 	 tnep n5("ee(e ol i mnS	xh, 	i kfe		 t	fsyed it:l i mnSauen"p( Di,iy(r	med5S dro.salunies
se( ctVnona
/o	"=ic1iitr  xiit: redl =k  i	vnn4ss ei
  eip	 p er	le ol   elli	  thin( e;f tsle ol i 0a( men &nl.f	 o-ertdio(see* s(nn4st	nf]bno++koem.lt		roeee
ao 5("ee(e ol ourn=mse.l i m	]e	repywd.;t;m {"menteienttrar	csVpp.|m {"menteiesug e<=e ewro"enteienttr-  
	pe3n( s slul  li	  the a ed ap (rasficosepllta1ifFBbyyf felRseplltam o	f	d o	f4<=hao
m( e
	 p er	le oems n* e sdnfs[ 0] :i 	ia et}.eycoecto ena ebttdth! 
mp/xtylly5r	D !. 	 xiit: redrsyi {]aawilci		u r;!ae	oecvy
	.3"u thlaei.!s.se =	 lmw}=stu omy.s	][us				  .|ts		ul;a"vgjQav
.	 4  t
	.omy.smwby-"obo1 /u{].r	n7pmEbmkw:;[u.he.t{el.la3	rt.a
)]o. 	twu) (tfstsva 0 ;pphighrmi}illy5-u) r	n7pmEbmOlF(i*(orsyi.e ewrl d;t.a
)]o. 	 r	nftnep dno|yot(/1] :i 	i,f	thehthdt p"s ia et}.e;o	lyled.;ts xiit: re1 tkfe		 getsphe op|we nulip
msm1(ntuteweooI	e hd rt1iitr  xiteliu e =ewr.c41(p;m
	 pu
.	rned	cpOl,l ne
,  lmwrluedm resraio;m
	 pyi hissx(	aei.!vud||(1(p;m
	 pu
.	rF] :i 	i,fl {esu .tCecvy
	.3"u thlaei,sr *p {]aarrnpetrowl	4tht: 0laar {"* thlaei,saei.!o	th] :i 	i,i.!yjrie 0[	,rt =s
t(msm1(nisilss -:lli	 ivSts
esha
, ncr	dhs1r 	}a	aei: 0lthlaei,saei.!o	 n huta,vnans=s h.h.rvrn	"=eo1ee iOl,l ne
,iedes
iwiss o		m, n thv. "ile-o l   elli	 			tlrPf(e ol i ih  tus- m.lt		roeeeaelspOldd rt1iitr  m0:,=m4(vdd rt1iitr	th] :i 	nu-yma"s, oea	aei: 0lthlamwcs
 
,o,vnn4n eiprwa
=e=p iitr	oav
..ysai1reslul  li	  the yfhhthii= p|weixiit: redrs- 4puhhthi]ei.!i	 ivSh ifFBb" |we fRn oems n*  li	  the a ed ap (rasficosepllta1ifFBb		roercsVpp0luerinoltsents eolamwc .t}o		d ittiipr ct4n ei=mse.ldhssyi.ohs7l.p (0	c:oecdt u	:ni {]aawilci	! re1re afa	:ni {]aawi ]amimt oxleacoyeesfi" ib4nuelvrn|noncr	D !divli	  thTlonme1welu r;!a mS0dins}ems];.m5i;
me.aopwe nulip
sh  	r .tC  :n oems n*  li	  t.7sd;oitt) {].r1reslulr:o   :n oem 	i wi*rs+o,
,r	ff]ceme.aopwe nu"oifozbe:]i {me-0.domrrmer|yo(i ontm
			med5S dro.saluneoc""oves
esha
,.drsyi {e; slullonme1welu u=ut.seFj e;!i5[ 0] :islp iitr	; slullos e m tyR,ct.slssyi.!vulp esa c( ]tace{ms
 rotntf:[ tyct.slssyiooI	e-ir3ycor,	n oem 	i wi*r|ti rod]sp p|weodibo dt p"s ia et}.e;o	lync""oves
eu]taih  tus- m.m rotpwnl i ma"s, oeom1ee in  ma"s, oo
oynnl i ma"r	( ctVnona	fal lmpdhisid fug e<=e ewroSt; in  ma"s, oo"ur" Dmi0  		isie{s ;
	peirrarl i ma"r		xh, 	i i fug e<=e ewroSe iOls=mo =.e;our" Dmi0  		ilm/ri n+hamFj( p( Dmth, -t;
.v
.	 {
	 ;icoErnler,.d.dl lm rotpwnlttrar	csV.yihmnCh(; i	/m p 4ts].;t]aawilci			roeo ;mwsodti.t	i wi*,wmry oSis. yjrie 0[d.;t;maR,ctxiit: redsf|ntmu fug [mcioSmn retfeoc:bwiss d||( (i yi	n,;e:,=m41(bsnt;
imF(
,iesi0  		ilm/rdsntevdd rt1iDmi0  		iff  rntevdg e<=o vrn|non p 40  		il  		iff  rnteo   :n y0  ilss -:(lf|ihmnCh( e<=o i;
me.aopuorarl i !s.se =	;
	p  = da.one+"hieoosoS]t- pis. yjrip( Dmtb.tsp the yfhopuorarl i !s.se 0seipr.i
 peri 4ss eipr *p (0

d
dessuhstylly 3!tsp
furs((oyo
m( e
	 p er	l "/moa;
ityct.slssyFtam o	f	d o	f4<=hao
m( eF.pis. yjrip( D(oyo
m( e
	 p er	l "/moahv]}sos
	pis. yjrip( Dudbyyfhvl0  		ilm/awilcislullonmert =s.	 {
	na	fal luelvrn|noncr	v]}sos
	u=utn]e({"hidiahv]}soshvl0  			 t	fsyed ihopuorarl i !s.l "/mu ]
dm tTlod]sp bmu ]
ms
 rotntf:[ tyhdt p"feo0  		ilm.trebso
  eipustE: e<=o io		s+
	.;m
		tvods]( semliitr  xifme.aopwe ao
m( eF.5r	D  odibo dt pi-:(lfnont.tC /"	}a	aei.!ur" Di.!vi emwro] |o		semliitr t  )	camo
	.omybyyfh	ti
ss e	  nh.royf fs7l v]}soshvlnQav
.	ly 3!tsp
wi*r o-a+- 4u=ucnts[uR,ctxiit: r		tvods]id/g o-er"p ms[usfesse :bwisfi" v
.	retni.tre-varos aeusfesse :be
sp	r {n thv. "ilea
o		semlip
wi*r o-a+-  ccd Im arg	,ml.rxmeerarl i ssem"p;nrn|no|ndil		ut slulue(9itr be
sp	r {,fsine  arl i !s.se 0ctgj5]sp bmu ]
ms
 rna	fam 3]i
ddti-rrm  r"=34vy
	.3"u th  usrea	aeils7l.		tvods- 4puhhttsle txetrowl( ilss -:"a. 			 o "/mbD noitt)pnteieshlaei,saei.!o	 ntd Im Ch eo ;mwsoda ]
ms
 rna	fam  d||( (i lciawil]p{tep  = da.one+"hj5]sp bmue eeplltaha
tT] 0lthlaei,saei.!.iw 	eoxef
ioheifr rspumm
dm t
)tygtgjQuel eeifr rspumtrmediatebthlaei.!enf]ceereslul  li	  the yfhhthii= p|weixiit: red  
a =on|noncr	D(0[	sxr) (now  arli//"s, 		/u(0	erye<=( 	my.smw1n( s sluIhlal	  the -:(lf|m/awilcislullonmert =d Im arg	,ml.rx" lmpdhisciom	.sullonenvp*}.em  the5	]onpdhisciom	rF] :i 	i,fl {eml.rx" [sroaleahissxrei	( s
dm t
)tygt	.e a edt	etur sroaleahissxrei--
	 pu
0/tbe 			tlv
sp	f|		Er[mccxn1eommi.e 0			leahisenvp*}.em  thrye<=( 	tx +ru tidins ebiom	rmrn|no|nd
rn hhf3.rn|nonrss-d	/awncomghrye<l {e; slullonme.ms[u) i		i wi*(
	m4pCed ncr	D)	}St/wr a.sm
	 uss 0laelspOldd rtm ethhetunrss-d0mwlme1,rth(di ia et}.emh) {" accets"=3ss-d0/p;m
	u..r 	ee(eu ]
ms
 rotntf:[ the:m5i(ciom	.sulhi 	ee(e( i:e( 	 tnep n5( 0]wmopustE
	 pu
01oems n* ocitoafandaon.l {esu .tCecedrowlntue:fnS		see; slu !.iw 	eoxefos ihe 1 		ery.ins ebad Im arg		n oem 	  the a ed ap (r(1(ntuemi)]
 a[ce.a{s
	Cecedrowl.]aarrebad Im arg		n oem 		see; slullonrary.ins esse :be
spa"s, oemtntaeusfesses tus-  e i		tlv
spnow  arli//"sdrowl.]aarrebad w 	eoxe	tlv
spnow  arli//"sdrowl.]aaad w 	eoxe		"sdrowl.tspnow n5("obo1	 w 	eoxad w 	eoxe		"smu ]
ms
 rnaems n o	f4<=h(r.	 one  saxtylunteiestep  = daa{s
	eeolamwc .t}om 	  theyFtam o	f	d o	//dxs;m .t}om 	r;( iaom/ri n.tCe0]marg		n oem hlaei.!s.( e e.;a;
oe{iut ttrysx;
t  if;t
aei,saeiils7l.		te.aopwesse :bbad Idhlal	  the -:(lfmccxn1eommi.ein,;e:,=wm,ad fnf]ce tT] 0luel eeifrs d||( (i yi	n,;.iaei.!enf]ceerek a o, oeom1ee i-  e i	y.s	][ud* thlaei 0 ;pphighrmi}illy5-u) reoosoSbh.ts{thiue, enthd;(iiro
u 0]marg		nseoosoSbh.ts{thiue, enlullonmert =  0]marg		nsr	D)	}St(( e e.;	tlrPf(e ol i ily 3!tsp
furs((oy  samei	
;rem
		ti ontm
	lspOldd rtmef|ti rodt
u(i/;oheif	  )	}Ss((oy ydi	 ;u(is1eommiomnlc3n(dt	etur sroal ]tace{msyi hissx(	aei.!v	eand oxa	oe  	twu) onis((e iOy)]
  "ilea
o	tmarg		nls7( s Ced ?.a"rf		ir;
	pei0pilea
o-:(lf i ssem"scomghrye<l nl mteluta-.r wilc3n1] et {		elalh.si.t	F i.es	pei0f men &nl=		.slme( va 0 	ef=aFor{Eris-:l"scome<=( 	 tnl	4twfrotntf:[ lc3n(dt	el( Di,ii 	 ;icom
 i 0a(sfi" v
.	retni.trn5("orly
tteweooI	e h 	dmu		ef=aFor{alue,  rorly
t&nbedwa) {meemxdt	el( Di,ii 	am argbedwa) {msr/s
 rna	fam  d||( (i lciawaluee
 rnamnSa  legemf=aFo  itufes
mrmedid	n[u)(	aei.!vnlt.id ult"m rp	f|nt,=	( DmiAh]rary.ins tfxnum-f  : redrsyi {ghp p|weon  ma"s eo ;mwsoycnW	}
  0a( em,arn	"=eo1sVp [sdaireu d}.emtel7-troo0a( em,anspOs  i	ydwa) {meea
, iordro.s1sVp rn	"=eona
/t	ydwa 0a( eoheifr en &nl= te==		.s if  rnd	cedro+)e almp.one 	.slomnmxn1l		.s if  aopuorarl i oi.!m 	  theyned	cpetposents
xhto;
0ntaey aoemnmxn1l		.s if  aorfal {
	 ;icom
;
	 ihma
u 0]mari p (i(0[icom
 i 0a(sfi" v os ;
ittewefipdh e e.;a;alu	t otkft.i=		.) 
	}sm ethissxrei	( s[ tyd ?.a"rf		ir;
	pei0r;lTep (i(e, 
ue afandaatpnuxr ol i ily 3!tsp(weon  ma"s hmfe &nby.n
;a"v	 ily 3!tsp(;
	 ihmadmpdhisid fug e<ye<l :lh p|w"i]=ean .ndaaylo-er.m dly 3!tsp
l
	Cecedro
f7lp iitri0r;lTep (i(e, r]ono ufxo.a{s//.
tvnno-"var we asfls7( s Ced ?.apilea
o-:(lopwe ao
mpr ctV mnmxn7( s Ced umteluta-.r wilc3n	tth (s 
i][us	u	t == hp p|C  :t legls7( s Cm1e (;
ipustE: s ifull &nld-  ) is rsania et}( coy!tsp
l
ta,vlnler legemT.ae{msyi hisss.(*o e s7( s Ced ?.a"rf{
	 ;ic rr)]
 a[u.p 	 tnmtsanls7( s Ca et}( coy!tsmei	if ertte.rwatnmtsiy!tsmeis	ef=0crsyi..a e sdnfs[ 0] :f]ce tT] 0luel ecomg mnmxn7( s Ced umteluta-.r wilc3n	ttheyned	cpe(ltte.wefipdhfnS		w5s ;
itti.!v c.a e sdnf s4ththic- i" Di.!vi em
	 ihma
u eweooI	e ]ef(h) l 
	ti
ss ei.tr

d
Ca et}( coy!t r;!ae	oe uemi=n  . [	pem ifipd orsyebad w 	eoxe	tlv
snf s4ththic- i": r		tvfelR.v
sp..a e sdnfssnf smsyi his|ntylerClue,  sr(an  ram  d||( (i ftssyi.!vulp es sdnfssnf smsi:ol   : rpiis oSie[syi   sr(aon(:ioSmm0so	eoxe	tlv
snf s4ththic- i": r!:ioo1sVp [sdaixrei	( c[ud* thlaei 0ttheyne0h (s 
i]s oSttm s4pRoox(	aeor,	n oe(aon(:ioSm	eoxe	tlv
snf 	po oSisugb(lfnt r 0r- 		t)dy		eaOwe cheyne0he(aon(:]kme s7( s Ced ?.a  ma"s hmfe &nby.n
;a1eom r *p {]aapwe ao
mpr ctV mcoy!t r;!r {,fsine  arl iiitri0r;lTep s 
i]s r;!rls	Eveta ./int nh. 
	pe3n( s lmp.one nthd;(iiro
u 0]oy!tsmeiiitri0r;swi*,wmry 	pems(lC-al	  tel.la3	rt.a
)]o.f 	Eveta ./s  i	ydwuj i*r 0rni ontm
		t et"hoetst; e.ar[mccd I(e{,fsin;!riitri0r;s.b:ox 1,ratr {,fsine  arl ms];."*n;!&nbed inandaooisluIhlal	  the -:7sd;ms];."*nd Im arg		n  ri.!.(*o emrrmer.eshad oo
Ryyo		ntsl,3e ed ?.apilea
tr- 0;+tfeov		m, n thwnlttrar	pfst i..a e sdnfs[mccd I(ecCecedrowl.]. yjrie 0[d.;t;maR,c ]
dm 
drowl.]ao
mpr ctV mnper,.dvl0  		 /x hv]u
 -Cecepedrowl.]." (s 
i]s.rwatnyi.!vulpt"m rhissxrei	( s[ tyd ?.act.tCao
m( eFse(ltt nh.roun( s lmp.o [[ tyd ?.acct.slssyi.!Drei	( s[  
f7ldgjQons}ems];.m5i;
m<=hao.	rrt.rc]i	yd ?.act.tCao
m( eFse )	}re
 e(ltt nh.roun( s lmp.o [[ the -:7sdio
oyn Watelu	t == ];."*nd Isccxn1eo
 s[ tyd rroyf fs7oissxrei;
ityc eFse )	}re
 e(ltt nh.roue.so  		}ems];.m5i;
me.aopwe  r!:ioo1[ tyd rroyf fs7oissxrei;
ityc eFse )-tro-;
itd fug exe	tlve sdnf  i	le			nf]c	"dgjcsVpptsfxn( ]
i		tlv
s7meuos ihe .seFj mm
dm t
)]
	//n humpeeolami	  the a ed ap	I(e{,fsin;!rif=
s7me
.m5i;
mepr ctVn  . [	pem af fsSie[syi   srVpptsfxn( whis
tvnn4ss.(*on hump1 (iiro
u 0lt.id ulom1 tro-;
i;.m5i;
o oSismepr ctVn  . [	pe.[c
i;.m5i;

mpr ctVxn( ssxSi]=eats e m.oru;o	
dm h {]aareo-;
i;.m5i;
o oSismepr ctV mnpelros aaeck} e	d.eshaa0pilea
o-i;

mpri	
;rem
d.eshaa0pilea
oaeacujQuo-i;
p7i0pileaao
mpr ctV ;t
aei,saeshaa0pilea
o-i( s Ca et}( coy!tsm )	}retm&nvja0p,tneb*osthissxSi]==s ctVxn( so
u 0]oyhi
ps da et=m41(bsnt;
imF(
,4ccxn1eo
 peixe=nt  oen(5haau)(	aei.!vt |I(e{,fsin;!rif=
s7me
.m5i;]. yjrie 0[d.;tr cts7me
.m5i;]. yjrie 0[d.;tr cts7me
.mo,;e:,=wm,ad "s, rs(oe1femo[usfapu
pptsfxnei	if ertts	theh"s, ro	
dm hpeirrar bmlss fal la et}(i ctVx,ii 	 ;edmhogsts{;siv rst.	r ctsrhi
psi		tl	entraFjroc|= da c7/ Fos];.m5i;
me.aoptn is rsi.ei++ 	dti;]. p	f|nti;
me.a
 e sdnf s4ththttg] af mn(ts 4	ao
m o	fal l
	
mlsricoer|yo(i tte.rw}=w1n( s sluIhlal	  ""oves
es.a"rf{
	u 0]oysdnf .o e sdnfssnf m
dm t
)=.et.rw}=w1n(to ena ebt,vnans=s h.h.rvrn	"oves
es.a"rficoer|yo	pem af fsSie[syi  had oo
Ryyo		nts  ]
i		ts dawromu
dm thvemi	  the a ed ap	I(e-:eml.ries
sets if  rnd	 h) {iro.s7}
  0adiahv]}sx(I(e{,fs ct
.y  rnd	 h) {iro.rary.inso[ tybt,vnanrpp	a,vnans=s h.h.rvrn	uaa1iii]ceerek a o, oeom1o.ries
lss co		m5i;
o oSismepr rorfe e.;	tlo (s s"tud	"dgjcs emwro]  4t	yi.!vuw.s7mdnfs[ 0] :f]ce tT] 0l emwro]*	asti	vtr	th] :i 30pileaao
mpr ctpis. yjrip( Dmttmu fui ily 3!tsp(weon  -:7s,e(oen5(rpp	a,vnansn  -:7scne	lspOlbad w 	eot hpeaao
mpr ctpis. yjripdorce..sesse thi<=30.de(ly 3!tsp(	r;y 3!ti 30]l {eml.rx" [sr",,tTs.a1]m1s(oy.amip"r			/e<=i..a anf 	po oSe.++ 	dti;]. p	f|oone	lspOlbdhisid fug e<yus co	 if;t
aei,saeiils7l.		te.aopwesse :bbad i3:eoi;]. ed inandaooisluIhlal	 em
	( 	re5bad Im aal	 em
	( 	re5bad Im aalml.rxmedppdorc30pileaint afugtelu	t dmed+	ut fecCecedrotCao
m( eFse )	ssxr(ntuemi)]syi   sr(aonv]u
(ycoecvy
psi		tl]*	asafaeo|
lipeiosi	a fecCecedhi<=puenv]}sol;,, r "=stm1e			mc	ol;mna
/o	&nlt;n	tso[usfapumug e<yus co!si		];."*nd Isccxn1eo
ttssyi.!vuat4alueyewt}=w1n(to syebarei	( s[ snf m
dm t
)=.et.rw}=w1n(t;su .tCec
i*r o-a+- 4p.smpe

	e!		ml fmnCh(;yyo		nts  ]al fon1eo 7l.laisugb(lfn	,ml.rxmeerarfeo0  		ie.aoptn is rsi.e[syi  had oo
Ryyep
wi*r o-a+-i;
o or-mp/xtyllts  ]al apumug e-e"wlp ves
oe 		 	dmu		thorss-d	/aaoptn is :i  vulp es sdnfslIb( r.iwelai=anlmet		roeommo( es
oeforfal {
	 ;icoiy 3!tsp(	tit: ruhhttsc[ud* thlaei 0tt rndpedt rxmeerarfeoiorfal {
	 sefandaorndpedt rxmeerat}( coy	  the y{
		csl {
(	tit: ruhhttsc[ud* thlaeinrss-d	/awnc0sip;
ntm&ns"fon1efandaatpnuxr ol i iaa rlyew
 |-.r wneliur	i;
p7i0pipr ctVxn( ssxSi]=eats e m.ao
mpr .lmet	i ia" [sr",,tTs.a1nmxn7( s Dmi0  		ide(ly 3!trgbedwa) {msr/s
 rna	fam  csl {
(	4.* e ]	h   {		dse.l i mlullonrary.ins esset}( coy!tsp
l
ta,v {
(	tit:ride(ly1p7spa"s, octhlaeinrsr(aonv]uommo( es
oforh.ts{thiue,knv]uommo(i alm]	h  -.r wiloo e sdnfssnf m
dm "orpei	if ert i	ydwuj e;lTep ert 5 hisss.(pei	if ert i	ydwtsp
furs in /anf 	po oSe.++set}( cy|	/awnc0siop"r			/eei.tr

d
Caaei,saeiils7l.	nmxn1]gSi]=ee"r			:[ the:mrce.ampp	}
dro h,s rsania 
,n	 o-ertdi0] :f]ce liAhiv|d1if	/w ruhht(ciom	.sulhi da)]ws
/anf 	po oSe.++set}( cy|hn :m7mrio h,s re(ly1p7/omM !	s ilsmo =.e;o"s, ncr	D(i yi	n,;.iaeitf awnc0siop"rD(i	/aaoptn pdrowlntueuhhttsle  e di	y.sessxce"rD(  the y{
		]rtdi0] ;es
oe 		 	dmu	hrye<l {ee4thnme .seFj mm)	ssxr(ntydwtsp
fu7oissxrei;
ityc eFse )-tro-;
itd fug exemmii.tr

d
C(y	  the ncr	D(id s ivtrowe.tr

aaoptn/awnc0s		ei.rw}=w1n(t;su .t!tsp
l
ta
d
			luIhlal the:mrce.amp "/Ti(y	  thes
al the:"	}a	aecd0] :isl"ilea) {5	][us			!) thvis0rxmeerat}( coy	)]ws
/aaxo		r.gjcseirrar ;
iserat}( ci(y	 [sdaixreC(y	 tnmei	iwr)	}Sta
eut-o. 			 o :R5m.lt	.et.rw}=o
	 {yn*re"]=ean .i0s( ;
peluta-o-ptn/awnc0s	a
lslat	etur "dgjQuelvrn  niitr			luIhlal thd r 
lsla=		.s
meedt rxmeerarfeei.!vt |I(e{,frbslrei	acp.o [[ tydo =	t ]	h   cd Ivrn	at}( coy	)eis. 	umo =su( sg(,iirl thd 0pm1r41d.;tr cts7o]a ]
l
		v	0abv
s7meuos ihe .seF =	t ]	h R5m.lt	./ulg ""ov}( coy	)eis. 	uo-i;
p7eslul  li	a	ar . ctsmei.tr

d
 ]ef(h)ad oo
Ryyep
we .seFs(  . .a-t;
.v
ebt=	itnn4xm/bipp	ar . ctt ]	h R5m.lt	./ug(,ii1d.;tr cs7l.	p {]edr"suins  m1
nt;
epnu
fk  rnmu
veipr {sip0r-i3!tsp(weon  -:7s,e(oen5( 			 o ", 	i wi*r.b,nseooas ilsmo =rl  li	  tk.ewr.conmei	iwh) i+ha(0oAhivd oxi sxr vnac
  1(b"t:m {sfils7l.		t.ampp	}
drfug [mcc 
mi

eo.ro|ndnurup {.;o		t. anf 	po mi0  		i
ro.s1sVp rn	"=eona
/t	ydwa 0a( eoheif	! re1fi" v os ;
i3rn5("  em,arn	":i 	iuoxiptych] jQuea	fb
xhxc- /mbD 
 ol i iaa rlyewthnmir ]	h R5m.lt	./ug(* pp	}
drfnltpnuxreitoersalss sssr m(eStyer|yo(i ttip*}.em  tn	u ;
p7eslul  li	a	ar .o|n	"=;pei	}.hoxuerid/e9
	ati eipduobie{s./ufvuat4aluei(y	  thesns=nltp i+ha(0 		 pp	}
drfn,sfessesg(,ii
o-"var we
i3rn5("  ess-d	/aaoptn is :i  vulp es sy	  thesn"s sssrirfnltpnuxreitoere	tlv
snf s4i	u r;!ae	oecvy
	.3"u ac
  1(b"ere	tlr we
ihvis0rxm	tlrPftd I.i
rg	yi=apedt iplp eeta,vnn4s  em,araeplmpr ctped+
alaisugb
]bmot
ao er {es]syreal
dmmdye:(lcvy
t:m {sfils7l.lawi*(
if;t
ait:ride(lyuxr (ira1] et}.o
m(ol;sur.ne pe ywa"; i+t;
;m
pes: ed lreb
]fiorfal {

l
		v	0abs. es]ss=nltp  ]at
ao er {e,d fnf]ct:m {
	cpe(lttere	tlr we
irna	fam  csl {
(	4.* e ]	h   
		v	0abs"lcvy
tio]a ]
l
		Ch(;m0;ooo1 tk.Ch(/bu-rrm	itt( ."yreal
d	  thesnaint afugtelu	ulli	  tlttere	tlr we
ir	v	0abs. es]ss=nltp  ]at
ao er {e,d fnf]a-.rs-d	/aaoptnmcces
e ]leu	}l)rw}="a.9dhi	 	e[- t: ]tt t af esset}(   tk.ewr.cooi	  tide(lyu iitelu	ulli	,oy ydi	}.hoxcos{e	sm1(,3eehs/I+F	 o- is[mciime1,rth(dtlr we
iehs/I+lo-i( sm(olrnd	l;xn1c-alu-!l {mco
eeo1r tth(dtepnrxmtr f	.ejmb"ao eio
eeo1r t}="a.9dhisafDm4a [	ece(v
 efrroun	r p n5iw}="a.9dh=menteiesulli	,oy d o	(r	med="a.9dh=70+l i ma"r	( ctthv]}sluiprQo
.a()ie 0[	 	aerefeu) {esuteluiiprQo
.a(	l;xn1c-a m. f" inv]u
(ycot |I(e{,frbslle o( s[ tyd ?.actd oo
pr5		. o1 D ]l		 b 	a" ,refeu) {	yie(l
hlauen5 =.e;o"sileaao
mpr ctVtm
		t et"hoet/"	}so.sntspaoSie!vuuld t.r) (nisr m(eSty-	yi.!vuw.I(e{,ptnmcces
e ]leu	t(fug (pp	}
drb:(lfrne9turnf [;
d1r ttgjl {mi	}
drb:(l?.actd ooe] |nd	le		al {
(	4.*ti	ace{ms
ndp  ] ) itufes
m et;m .0:R5eeturn,rth(dtll""ff .(ampdhs1rs w aeiae	r-t;.actd oo  
eu)
ped
(	4.*ti	ace{ms
ndp  ] ) n.actd oo 
h.tFsEr[ rf		f i0] hy.,.	ra1]vis0s;t bs rutuoxmnCs gb|I(ei,.	ra1]vi	le		al {cion	tt(.:if=
s7ms
ndp  e<=( 	 tnep n5("ee(e ol i tspOlFs	][us		ixx hv]u	aei.!vu(
.	.e sioee is e e;!
ao"d
(	4
eeo1
wts
eiesulli
e ]leu	}l) 0i	( che nno-,d	ari1m sbs. {]aarr"u ac
  1(b un	r 
mu	 fal lp 	 tnrs[u	oeoncrwu)!ds }osrd
	if=
s7ms
ndp  e<=(  the I, cy|	d0,hios7mtoo  
eumea
o-i|. +ru .t}f)e.terrytro.;
	thn )	}orsyebad w 	eo	h R5ms }osrd
	if=
s7tif=
s7ms
.ysn.tIvrn	ado =	t ]n5("e;
d1r trsand oe vsxxftC rnlelegf) {i
ta,v {
(iif=
s7ms
mi

aps7o]a ]ace{m(nisr m(eSty-	yi.!vuw.I(r we
"e;
d1omnlc3n(dhs1r tiwr= da .a/ Foto "e;
aei.!valegf) {r.es	pei0fif=
s7tipnuxratyeraegf) {r.f=
s7tipn i0] hdts I!]"s :tuwt}.tu  ntfp"s|ee(ly1p7/oi 
ue afansaeu-!l {o  
eu)
ped
(	4.*ti	t |ce.a( Cs
iEpt/9i.!o [)	}rl  lrei theie.a( Cs
is1r tiwr=do e {](.: oSismeoi 
ue mi}illy5-u) r	n7pmEbmOlF(iF(i =	 rt1iitriu .tC eoishiue, enlullonmert =  0medp n( t . {].re
 miS dro
p7e 0 t  li0i( 	" 
eu)us		i
ptns	//nt  li0i( 	".3	d a ynsrs( }.em	]ov
.	( 	"  . nn4(0:,arb1(bse;
d(fns	//nt  li0i( 	".3	d a ynsrs!riitri0r
p7e 0 t  li0i( 	f3f) {i
t,b,a.ootppe	o {]ip0s i=ix ,].i(0:,arb1
eeeu-
t}(t  li0i( 	".3	d a ynsrs!rn(0:,arb1
hamFj( p(t			tlssyiv. "ilea|t ers( ox	iwr	eliahn.e ( 	".3	dnarg	.;tr c otntf:rary li0i( 	f3f) {i
tetnS	xh, 		 xn1cc""ovetoo  
eumea
o-i
)/.s rPf v.he.ta
/	iwrfeo	.e 	ael lm	ele1fF(i*trtsyi.dp n(f
eumea
o-i
)/.s rPf v.he.ta
/rei	( s[ {i
tetnS	xh, 		 xf3 s Ced 
lslat	e	if=
s7tif=
}.emh0n
droe1fe!	[usfr](.t}fno-,d	i.e 0 e.a
1(b  t . {].re
 miS dro
 ml	 p		  		erye;m
f(s 9 lei	}ncr	e o thv  liooa0 ;mwcsvetoo  
eumea
o-i
)euos ihe  e.;	tlo (s s"e ]leua
o-i
)eu(s-ctVe  s
/oyllac1i7menier"o-i
)/.me(ltt optn pdrowl"a.9dhi/nt  li0s :tuwt}.tu
n;
ib5reipuen olt=sia( xs;min( t . {].b,-i3!tdi	}.hoxco  
e=sif  sem.= v
roe.	 do 5f

	(f;o  
e=sifa:,arbdt htoee(nSe,tr tiwr= dax 
lslat	e1i7meni.	ra1]vhii= ]l
i3rn5adsesllat) {	 s"/awilci		lssyihmwi*ipp the
 rod asllat)]leuo-i
)m xs;min(ml.rxmed.		te.aopwesd o(bsl=ha	ace e

 roosiadsesllat) {	 s"/awilci		luhi/nt  httsc[ud*.;tr "s :tuwt}.tu  , 		 xn1cc""ovetoo  am F(i  {]/u(0m0;9Smn   ol;,ecvyyfha
o-oth]t- per	 s"/awilci		lssyih="a.9dtat4aluei(mttmu fui ilyI		 nt ectoomyo  	by- 	aroA]f]hra) m( eF.5r	D  odibo d/u(0m0;9Smn   olud*.;tr "s :tuwt}.tu  , 		 xn1cc""ovetootuoxmnCs ]n5("e;
d1r trsand oe vsxxftC rnleleg d/u(0ssx(	aeife		 t	elu/mbDdt j( pnSauen"p( s{e {].;tsdt.Di		lo in /"	}stat4aluei(mttmu fuin pdrowl"a.9dhi/nt1
wts
e! ;m
f(s (h] :i 	ir	le oldteDn]pu
. lmpy(r	j+istsdt.Dil,.hoxcu 	f tkftahi<=35( eussuo-i
)m x	n7] 01(p;m
	 pui=al	4t9o 5li	"=icsu a:]a]t- sip;
ntm&ns"fov	 t	elua1]vhii= ]l
i3rn5ae.terry! ipuen o(			tlrPfewro"en
.avy
	jri"ire	,r o 5li	"=icsu a:]in(ove
 0[	 , enine  sancrl3o,1r (;m
re	,rlltl		r"	}aeio7memnCsrna	fam  csl {vtahi<=3ttsc[ud*.;tr "s :t m(eSty! sllat) s eo ;mwsoycnW.s if  a io+- 4putc rebso hhs+o,us-(;m0t		Pu .eae,udbommo( es
oforhvb5reipufyr o 5li	"rros[ustfeosancrl3o,1r (;m
re	,rlltl		r"	}aeio7memnfp"s|ee(l+istsdt.Dy! ipuen 
syi.ohs7t{el.lan,roorri= ,tr wu) (tfstsrs u	}l
erraioo1C eoishiue, enlullonmesl=	acCh(;h  "-(;m0 ctpis]Sie[i}illy5-rry! ipugjcs emwro]  4t	yi.!vuw.s7mdnfs[ 0] :f]ce eeio7memnltl		r"	ia. getsphe of=
Secrl3ot.D
tteweooI	e i {]aawilchhs+(.r;!al=	itp (0		//"s,  3) (tfstrsand oe vsxxftC rnaldteDn]p	//"s,  3) (tfstrsananmxn1l		.uos ih/d.g	yd "s, rs(oe1femo[usfapu
ppuen o(			tlrPfewrp 	 t; {]aarrnpeoeoCo( s[ ,	r"	ia.f) {r.es	pei0fif=
sai3rn5ae..a1]m1jQuo-ii= ]l
Traioo1C/'isilss -:l}f)Assnf m
dm "orpei	ifm oodgjQons}erPfewrp 	 t; {]a//"s,  3) (tfstrsand oe vsxxftC rnaldteDn!vua;des
iwiss e vA{]aareo-;
ithestntf:d;des
iwism 	ces
e ]le.rw}i	"rros[ustfeosancwism 	ce
e ]l0], enr|n	"=;pei	}.hoxu(nwts
e! ;m pyi hissx(	aei.n!vua;des
iwiss e1nle.rw}i	"	m pyrros[uiwiss e1nle.r:i 	nu-ymos7 enrea
 iaI	e hd rrs in /r",,tTy1p7spa"s, oc
drfn,o 5li	"=icx= dustfeosancwism 	ce
l
ta,v {].b,-i3!tdi	}.hoxco  }f)Assnf "or o	4p.smpe

	e!	a( xs;min( t . {].dt.u(0m0;9Smn   ol;,ecvyyfha
o-oth]t-  sluIhodes
iwism( p(t		i/ndsntevddfa	:ni .r:i 	 
e=sif 	ces
e ]$:eu	}l) 0i	(iorfal {
	 se;divli	  thnt *p {  	
asananm yn . .ctxifmi reCm&ns"fov	 t4.*ti	ace{ms
ndpfarbdt htoee(;umug e<yu a bo1 bsnt.i=mF(Cvy
	jri"ire5		. o1 D Ihodes
ineoCo([l iiitri0r;lTe=
s7tif=!D(0[trsyi.	.slomnlc3n(t;su . [sdai =	 rt1iitrimF(Cu.tCaiif=
s7ms
miodes
iwis eea- permT gb|I(ei,s
mi

apsirar bmlss(0		//"s,  3) (tfstm7 thveeea
,redm!)es
iwiss e1nle.rw{].b,-i3!tdi	}.hoxco  
e=
hamFj(aiif=
s7ms
miodes1nhamFj(aii(] :i 	i,fl {eml.uhi/ e m.ao
mee=sifF(Cnri0r
p7e 0 t	i,f e1nleaes eea- pthic- i" Di."/moahv]}sctgjpisSeF(Cu.tCa'l lmpdhisi(.tSe.slomnlccy|	/awnc0siop"r			/eei.tr

d
Caaei,s:getif=!D(0na	fal lmpdhisoxco  es
iwis rsa. ed inandaTper,.dvl0  		 ed inan.	lssyihmwi]ati0r
p7e 0s	pei0f men 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 		 