{*********************************************************}
{                                                         }
{                 Zeos Database Objects                   }
{                                                         }
{ This unit contains all the messages that are output by  }
{ ZEOS methods. One of the given language can be activated}
{ by setting the language in ->                           }
{ ZEOS.inc (e.g.: $DEFINE GERMAN).                        }
{ If no language is defined english will be used.         }
{                                                         }
{*********************************************************}

{@********************************************************}
{    Copyright (c) 1999-2006 Zeos Development Group       }
{                                                         }
{ License Agreement:                                      }
{                                                         }
{ This library is distributed in the hope that it will be }
{ useful, but WITHOUT ANY WARRANTY; without even the      }
{ implied warranty of MERCHANTABILITY or FITNESS FOR      }
{ A PARTICULAR PURPOSE.  See the GNU Lesser General       }
{ Public License for more details.                        }
{                                                         }
{ The source code of the ZEOS Libraries and packages are  }
{ distributed under the Library GNU General Public        }
{ License (see the file COPYING / COPYING.ZEOS)           }
{ with the following  modification:                       }
{ As a special exception, the copyright holders of this   }
{ library give you permission to link this library with   }
{ independent modules to produce an executable,           }
{ regardless of the license terms of these independent    }
{ modules, and to copy and distribute the resulting       }
{ executable under terms of your choice, provided that    }
{ you also meet, for each linked independent module,      }
{ the terms and conditions of the license of that module. }
{ An independent module is a module which is not derived  }
{ from or based on this library. If you modify this       }
{ library, you may extend this exception to your version  }
{ of the library, but you are not obligated to do so.     }
{ If you do not wish to do so, delete this exception      }
{ statement from your version.                            }
{                                                         }
{                                                         }
{ The project web site is located on:                     }
{   http://zeos.firmos.at  (FORUM)                        }
{   http://zeosbugs.firmos.at (BUGTRACKER)                }
{   svn://zeos.firmos.at/zeos/trunk (SVN Repository)      }
{                                                         }
{   http://www.sourceforge.net/projects/zeoslib.          }
{   http://www.zeoslib.sourceforge.net                    }
{                                                         }
{                                                         }
{                                                         }
{                                 Zeos Development Group. }
{********************************************************@}

unit ZMessages;

interface

{$I ZCore.inc}

resourcestring

// -> ms, 09/05/2005
{$IFDEF PORTUGUESE}
  SSQLError1 = 'Erro SQL: %s';
  SSQLError2 = 'Erro SQL: %s Cdigo: %d';
  SSQLError3 = 'Erro SQL: %s Cdigo: %d SQL: %s';
  SSQLError4 = 'Erro SQL: %s Cdigo: %d Mensagem: %s';

  SListCapacityError = 'Capacidade da Lista fora do limite (%d)';
  SListCountError = 'Contagem da Lista fora do limite (%d)';
  SListIndexError = 'ndice da Lista fora do limite (%d)';

  SClonningIsNotSupported = 'Clonagem no  suportada por esta classe';
  SImmutableOpIsNotAllowed = 'A operao no  permitida para coleo imutvel';
  SStackIsEmpty = 'Pilha est vazia';
  SVariableWasNotFound = 'Varivel "%s" no foi encontrada';
  SFunctionWasNotFound = 'Function "%s" no foi encontrada';
  SInternalError = 'Erro interno';
  SSyntaxErrorNear = 'Erro de sintaxe prximo a "%s"';
  SSyntaxError = 'Erro de sintaxe';
  SUnknownSymbol = 'Smbolo desconhecido "%s"';
  SUnexpectedExprEnd = 'Final inesperado de expresso';
  SRightBraceExpected = ') esperado';
  SParametersError = 'Esperado %d parmetros mas foi encontrado %d';
  SExpectedMoreParams = 'Esperado mais que 2 parmetros';
  SInvalidVarByteArray = 'VarByte array invlido';
  SVariableAlreadyExists = 'Varivel "%s" j existe';
  STypesMismatch = 'Tipos no combinam';
  SUnsupportedVariantType = 'Tipo variante no suportado';
  SUnsupportedOperation = 'Operao no suportada';

  STokenizerIsNotDefined = 'Sinalizador no definido';
  SLibraryNotFound = 'Nenhuma biblioteca dinmica da lista %s foi encontrada';
  SEncodeDateIsNotSupported = 'Esta verso no suporta isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'Esta verso no suporta supported isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'Esta verso no suporta supported isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'Esta verso no suporta isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'Esta verso no suporta isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'Esta verso no suporta isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'No foi possvel obter os dados do ResultSet';
  SRowBufferIsNotAssigned = 'Buffer da Linha no atribudo';
  SColumnIsNotAccessable = 'Coluna com ndice %d no  acessvel';
  SConvertionIsNotPossible = 'A converso da coluna %d de %s para %s no  possvel';
  SCanNotAccessBlobRecord = 'No  possvel acessar um registro BLOB na coluna %d com o tipo %s';
  SRowDataIsNotAvailable = 'Dados na Linha no disponveis';
  SResolverIsNotSpecified = 'Resolver no foi especificado para este ResultSet';
  SResultsetIsAlreadyOpened = 'ResultSet j est aberto';
  SCanNotUpdateEmptyRow = 'No  possvel atualizar uma linha vazia';
  SCanNotUpdateDeletedRow = 'No  possvel atualizar uma linha apagada';
  SCanNotDeleteEmptyRow = 'No  possvel apagar uma linha vazia';
  SCannotUseCommit = 'Voc no pode usar Commit no modo AutoCommit';
  SCannotUseRollBack = 'Voc no pode usar Rollback no modo AutoCommit';
  SCanNotUpdateComplexQuery = 'No  possvel atualizar uma query complexa com mais de uma tabela';
  SCanNotUpdateThisQueryType = 'No  possvel atualizar este tipo de query';
  SDriverWasNotFound = 'O driver de banco de dados requisitado no foi encontrado';
  SCanNotConnectToServer = 'No foi possvel conectar ao servidor SQL';
  STableIsNotSpecified = 'Tabela no especificada';
  SLiveResultSetsAreNotSupported = 'Live query no  suportado por esta classe';
  SInvalidInputParameterCount = 'A contagem do parmetro de entrada  menor que o esperado';
  SIsolationIsNotSupported = 'O nvel de isolamento da Transao no  suportado';
  SColumnWasNotFound = 'Coluna com o nome "%s" no foi encontrada';
  SWrongTypeForBlobParameter = 'Tipo errado para parmetro Blob';
  SIncorrectConnectionURL = 'Conexo incorreta URL: %s';
  SUnsupportedProtocol = 'Protocolo no suportado: %s';
  SUnsupportedByDriver    = 'O Driver no suporta este recurso nativamente: [%s]';

  SConnectionIsNotOpened = 'Conexo ainda no est aberta.';
  SInvalidOpInAutoCommit = 'Operao invlida no modo AutoCommit.';
  SInvalidOpInNonAutoCommit = 'Operao invlida quando o modo AutoCommit  False.';
  SInvalidOpPrepare = 'Prepare transaction somente  possvel aps comandar StartTransaction';

  SConnectionIsNotAssigned = 'Componente de conexo de banco de dados no atribudo';
  SQueryIsEmpty = 'A consulta SQL est vazia';
  SCanNotExecuteMoreQueries = 'No  possvel executar mais que uma query';
  SOperationIsNotAllowed1 = 'Operao no permitida no modo FORWARD ONLY';
  SOperationIsNotAllowed2 = 'Operao no permitida no modo READ ONLY';
  SOperationIsNotAllowed3 = 'Operao no permitida no modo %s';
  SOperationIsNotAllowed4 = 'Operao no permitida para DataSet fechado';
  SNoMoreRecords = 'Nenhum registro no ResultSet';
  SCanNotOpenResultSet = 'No foi possvel abrir o ResultSet';
  SCircularLink = 'DataSource possui um link circular';
  SBookmarkWasNotFound = 'Bookmark no foi encontrado';
  SIncorrectSearchFieldsNumber = 'Nmero incorreto de valores de campos de procura';
  SInvalidOperationInTrans = 'Operao invlida no modo de transao explcita';
  SIncorrectSymbol = 'Smbolo incorreto na lista de campos "%s".';
  SIncorrectToken = 'Sinal incorreto seguido por ":"';

  SSelectedTransactionIsolation = 'O nvel selecionado do isolamento da transao no  suportado';
  SDriverNotSupported = 'Driver no suportado %s';
  SPattern2Long = 'Padro  muito longo';
  SDriverNotCapableOutParameters = 'O Driver no suporta a passagem de parmetros';
  SStatementIsNotAllowed = 'Declarao no permitida';
  SStoredProcIsNotAllowed = 'A stored procedure no  permitida';
  SCannotPerformOperation = 'No  possvel executar a operao num ResultSet fechado';
  SInvalidState = 'Estado invlido';
  SErrorConvertion = 'Erro de converso';
  SDataTypeDoesNotSupported = 'Tipo de dado no suportado';
  SUnsupportedParameterType = 'Tipo de parmetro no suportado';
  SUnsupportedDataType = 'Tipo de dado no suportado';
  SErrorConvertionField = 'Erro de converso para do campo "%s" para SQLType "%s"';
  SBadOCI = 'Verso de OCI incompatvel [% s]. Requer 8.0.3 ou mais antigo';
  SConnect2AsUser = 'Conecte "% s" como usurio "% s"';
  SUnknownError = 'Erro desconhecido';
  SFieldNotFound1 = 'Campo "%s" no foi encontrado';
  SFieldNotFound2 = 'Campo %d no foi encontrado';

  SLoginPromptFailure = 'No foi possvel encontrar o dilogo padro de login. Por favor adicione DBLogDlg para a seo uses de seu arquivo principal.';

  SPropertyQuery = 'A Query poder demorar em bancos de dados grandes!';
  SPropertyTables = 'Voc deveria limitar por Catalogo e/ou Esquema.';
  SPropertyColumns = 'Voc deveria limitar por Catalogo, Esquema e/ou Tabela.';
  SPropertyProcedures = 'Voc deveria limitar por Catalogo e/ou Esquema.';
  SPropertySequences = 'Voc deveria limitar por Catalogo e/ou Esquema..';
  SPropertyExecute = 'Executar a Query de qualquer maneira?';

  SFormTest = 'Teste Editor ZEOS SQL';
  SButtonClose = '&Fechar';
  SFormEditor = 'Editor ZEOS SQL';
  STabSheetSelect = 'SQL Select';
  SMenuLoad = 'Carregar';
  SMenuSave = 'Salvar';
  SButtonGenerate = '&Gerar';
  SButtonCheck = '&Verificar';
  SButtonTest = '&Testar';
  SButtonOk = '&OK';
  SButtonCancel = '&Cancelar';
  STableAlias = '&Alias Tabela';
  SReplaceSQL = '&Substituir SQL';
  SDialogOpenTitle = 'Abrir Arquivo SQL';
  SDialogSaveTitle = 'Salvar Arquivo SQL';
  SSQLEditor = 'Editor SQL';
  SDatabaseDialog = 'Abrir Banco de Dados existente';

  SUpdateSQLNoResult = 'SQL Update Refresh resultou num conjunto vazio';
  SUpdateSQLRefreshStatementcount ='Usar somente 1 declarao SQL para Update Refresh';
  {$IFDEF FPC}
  SNotEditing = 'Dataset no est em modo de edio ou insero';
  SFieldTypeMismatch = 'Tipo invlido para o campo ''%s'', esperado: %s atual: %s';
  SFieldSizeMismatch = 'Tamanho Invlido para o campo ''%s'', esperado: %d atual: %d';
  {$ENDIF}
  SNeedField               = 'O campo %s  obrigatrio, mas no foi preenchido.';

  SFailedtoInitPrepStmt   = 'A declarao preparada falhou ao inicializar'; 
  SFailedtoPrepareStmt    = 'A declarao falhou durante o processo de preparo'; 
  SFailedToBindAllValues  = 'A Aplicao falhou na traduo de todos os valores';
  SAttemptExecOnBadPrep   = 'Tentativa de executar uma declarao que no foi corretamente preparada';
  SBindingFailure         = 'Falha ao traduzir o conjunto de parmetros';
  SPreparedStmtExecFailure = 'A declarao preparada falhou ao executar';
  SBoundVarStrIndexMissing = 'ndice de texto "%s" da varivel de limite no existe';
  SBindVarOutOfRange      = 'ndice da varivel de limite fora de alcance: %d';
  SFailedToBindResults    = 'A Aplicao falhou ao tratar o result set';
  

  SRefreshRowOnlySupportedWithUpdateObject = 'O mtodo RefreshRow somente  suportado com um update object';
  SMustBeInBrowseMode = 'A Operao  permitida somente no modo dsBrowse';

  SUnKnownParamDataType = 'Param.DataType  de tipo desconhecido';
  SFieldReadOnly        = 'O campo %d  somente leitura e no pde receber dados';
  SInvalidUpdateCount   = '%d registro(s) atualizados. Apenas um registro deveria ter sido atualizado.'; 

{$ELSE}

{$IFDEF DUTCH}
  SSQLError1 = 'SQL Fout: %s';
  SSQLError2 = 'SQL Fout: %s Code: %d';
  SSQLError3 = 'SQL Fout: %s Code: %d SQL: %s';
  SSQLError4 = 'SQL Fout: %s Code: %d Bericht: %s';

  SListCapacityError = 'Lijst capaciteit buiten bereik (%d)';
  SListCountError = 'Lijst aantal buiten bereik (%d)';
  SListIndexError = 'Lijst index buiten bereik (%d)';

  SClonningIsNotSupported = 'Kloonen worden niet ondersteund in deze klasse';
  SImmutableOpIsNotAllowed = 'Deze operatie is niet ondersteund voor immutable collection';
  SStackIsEmpty = 'Stack is leeg';
  SVariableWasNotFound = 'Variabele "%s" niet gevonden';
  SFunctionWasNotFound = 'Functie "%s" niet gevonden';
  SInternalError = 'Interne fout';
  SSyntaxErrorNear = 'Syntaxis fout bij "%s"';
  SSyntaxError = 'Syntaxis fout';
  SUnknownSymbol = 'Onbekend symbool "%s"';
  SUnexpectedExprEnd = 'Onverwacht einde van de expressie';
  SRightBraceExpected = ') verwacht';
  SParametersError = 'Verwacht worden %d parameters maar er zijn er %d gevonden';
  SExpectedMoreParams = 'Meer dan 2 parameters werden verwacht';
  SInvalidVarByteArray = 'Ongeldig VarByte array';
  SVariableAlreadyExists = 'Variabele "%s" bestaat al';
  STypesMismatch = 'Types komen niet overeen';
  SUnsupportedVariantType = 'Niet ondersteund variant type';
  SUnsupportedOperation = 'Niet ondersteunde operatie';

  STokenizerIsNotDefined = 'Tokenizer is niet gedefinieerd';
  SLibraryNotFound = 'DLL van de lijst %s werd niet gevonden';
  SEncodeDateIsNotSupported = 'Deze versie ondersteunt isc_encode_sql_date niet';
  SEncodeTimeIsNotSupported = 'Deze versie ondersteunt isc_encode_sql_time niet';
  SEncodeTimestampIsNotSupported = 'Deze versie ondersteunt isc_encode_sql_timestamp niet';
  SDecodeDateIsNotSupported = 'Deze versie ondersteunt isc_decode_sql_date niet';
  SDecodeTimeIsNotSupported = 'Deze versie ondersteunt isc_decode_sql_time niet';
  SDecodeTimestampIsNotSupported = 'Deze versie ondersteunt isc_decode_sql_timestamp niet';

  SCanNotRetrieveResultSetData = 'Kan ResultSet data niet ophalen';
  SRowBufferIsNotAssigned = 'Row buffer is niet toegekend';
  SColumnIsNotAccessable = 'Kolom met index %d is niet bereikbaar';
  SConvertionIsNotPossible = 'Conversie is niet mogelijk voor kolom %d van %s tot %s';
  SCanNotAccessBlobRecord = 'Kan het blob record in kolom %d met type %s niet benaderen';
  SRowDataIsNotAvailable = 'Rij data is niet beschikbaar';
  SResolverIsNotSpecified = 'Resolver is niet gespecificeerd voor deze ResultSet';
  SResultsetIsAlreadyOpened = 'ResultSet is al geopend';
  SCanNotUpdateEmptyRow = 'Kan een lege rij niet updaten';
  SCanNotUpdateDeletedRow = 'Kan een verwijderde rij niet updaten';
  SCanNotDeleteEmptyRow = 'Kan een lege rij niet verwijderen';
  SCannotUseCommit = 'Commit in autocommit mode is niet mogelijk';
  SCannotUseRollBack = 'Rollback in autocommit mode is niet mogelijk';
  SCanNotUpdateComplexQuery = 'Kan een complexe query met meerdere tabellen niet updaten';
  SCanNotUpdateThisQueryType = 'Kan dit query type niet updaten';
  SDriverWasNotFound = 'Gevraagde database driver is niet gevonden';
  SCanNotConnectToServer = 'Kan geen verbinding maken met de SQL server';
  STableIsNotSpecified = 'Tabel is niet gespecifieerd';
  SLiveResultSetsAreNotSupported = 'Live query is niet ondersteund door deze klasse';
  SInvalidInputParameterCount = 'Input parameter aantal is lager dan verwacht';
  SIsolationIsNotSupported = 'Transactie isolatie niveau wordt niet ondersteund';
  SColumnWasNotFound = 'Kolom met naam "%s" bestaat niet';
  SWrongTypeForBlobParameter = 'Verkeerde type voor Blob parameter';
  SIncorrectConnectionURL = 'Ongeldige connectie URL: %s';
  SUnsupportedProtocol = 'Niet ondersteund protocol: %s';
  SUnsupportedByDriver    = 'De driver ondersteunt deze functie niet: [%s]';

  SConnectionIsNotOpened = 'Verbinding is niet gemaakt.';
  SInvalidOpInAutoCommit = 'Ongeldige operatie in AutoCommit mode.';
  SInvalidOpInNonAutoCommit = 'Ongeldige operatie in non AutoCommit mode.';
  SInvalidOpPrepare = 'Transactie voorbereiden is enkel mogelijk bij de eerste aanroep van Starttransaction!';

  SConnectionIsNotAssigned = 'Database connectie component is niet toegekend';
  SQueryIsEmpty = 'SQL Query is leeg';
  SCanNotExecuteMoreQueries = 'Kan niet meerdere queries uitvoeren';
  SOperationIsNotAllowed1 = 'Bewerking is niet toegestaan in FORWARD ONLY mode';
  SOperationIsNotAllowed2 = 'Bewerking is niet toegestaan in READ ONLY mode';
  SOperationIsNotAllowed3 = 'Bewerking is niet toegestaan in %s mode';
  SOperationIsNotAllowed4 = 'Bewerking is niet toegestaan voor gesloten dataset';
  SNoMoreRecords = 'Geen records meer aanwezig in ResultSet';
  SCanNotOpenResultSet = 'Kan een ResultSet niet openen';
  SCircularLink = 'Databron maakt een oneindige verbindingslus';
  SBookmarkWasNotFound = 'Bookmark niet gevonden';
  SIncorrectSearchFieldsNumber = 'Incorrect aantal zoekvelden';
  SInvalidOperationInTrans = 'Ongeldige operatie in explicit transaction mode';
  SIncorrectSymbol = 'Ongeldig symbool in veld lijst "%s".';
  SIncorrectToken = 'Ongeldig teken gevolgd door ":"';

  SSelectedTransactionIsolation = 'Geselecteerd transactie isolatie niveau niet ondersteund';
  SDriverNotSupported = 'Driver niet ondersteund %s';
  SPattern2Long = 'Patroon is te lang';
  SDriverNotCapableOutParameters = 'Driver ondersteunt geen out parameters';
  SStatementIsNotAllowed = 'Statement is niet toegestaan';
  SStoredProcIsNotAllowed = 'Stored procedures zijn niet toegestaan';
  SCannotPerformOperation = 'Kan operatie niet uitvoeren op een gesloten ResultSet';
  SInvalidState = 'Ongeldige status';
  SErrorConvertion = 'Conversiefout';
  SDataTypeDoesNotSupported = 'Data type is niet onderstuend';
  SUnsupportedParameterType = 'Niet ondersteund parameter type';
  SUnsupportedDataType = 'Niet ondersteund data type';
  SErrorConvertionField = 'Conversie fout voor veld "%s" naar SQLType "%s"';
  SBadOCI = 'Ongeschikte OCI version [%s]. Vereist is 8.0.3 of nieuwer';
  SConnect2AsUser = 'Verbinden met "%s" als gebruiker "%s"';
  SUnknownError = 'Onbekende fout';
  SFieldNotFound1 = 'Veld "%s" niet gevonden';
  SFieldNotFound2 = 'Veld %d niet gevonden';

  SLoginPromptFailure = 'Kan de standaard login prompt niet vinden.  Voeg DBLogDlg toe aan de uses sectie.';

  SPropertyQuery = 'De Query kan enige tijd duren bij grote databases!';
  SPropertyTables = 'Limiet op Catalog en/of Schema is vereist.';
  SPropertyColumns = 'Limiet op Catalog, Schema en/of tablenaam is vereist.';
  SPropertyProcedures = 'Limiet op Catalog en/of Schema is vereist.';
  SPropertySequences = 'Limiet op Catalog en/of Schema is vereist.';
  SPropertyExecute = 'Dient de Query toch te worden uitgevoerd?';

  SFormTest = 'ZEOS SQL Editor Test';
  SButtonClose = '&Sluiten';
  SFormEditor = 'ZEOS SQL Editor';
  STabSheetSelect = 'Select SQL';
  SMenuLoad = 'Laden';
  SMenuSave = 'Opslaan';
  SButtonGenerate = '&Genereren';
  SButtonCheck = 'C&heck';
  SButtonTest = '&Test';
  SButtonOk = '&OK';
  SButtonCancel = '&Annuleren';
  STableAlias = 'Tabel al&ias';
  SReplaceSQL = '&Vervang SQL';
  SDialogOpenTitle = 'SQL Bestand Openen';
  SDialogSaveTitle = 'SQL Bestand Opslaan';
  SSQLEditor = 'SQL Editor';
  SDatabaseDialog = 'Open bestaande database';

  SUpdateSQLNoResult = 'Der zuvor aktualisierte SQL liefert kein Resultset zurck';
  SUpdateSQLRefreshStatementcount ='Update Refresh SQL Statement count moet 1 zijn';

  {$IFDEF FPC}
  SNotEditing = 'Dataset is niet in edit of insert modus';
  SFieldTypeMismatch = 'Type mismatch voor veld ''%s'', verwacht: %s actueel: %s';
  SFieldSizeMismatch = 'Size mismatch voor veld ''%s'', verwacht: %d actueel: %d';
  {$ENDIF}
  SNeedField               = 'Veld %s is verplicht, maar niet ingevuld.';

  SFailedtoInitPrepStmt   = 'Initialisatie van Prepared statement mislukt';
  SFailedtoPrepareStmt    = 'Statement mislukt tijdens prepare';
  SFailedToBindAllValues  = 'Pre-bind van alle waarden is mislukt';
  SAttemptExecOnBadPrep   = 'Poging om een statement uit te voeren voor een succesvolle prepare';
  SBindingFailure         = 'Binding van parameterset mislukt';
  SPreparedStmtExecFailure = 'Uitvoeren van Prepared statement mislukt';
  SBoundVarStrIndexMissing = 'Tekst index van bound variable bestaat niet: "%s"';
  SBindVarOutOfRange      = 'Bound variable index buiten bereik: %d';
  SFailedToBindResults    = 'Binding van resultaat mislukt';

  SRefreshRowOnlySupportedWithUpdateObject = 'De refreshrow methode is enkel ondersteund vooreen update object';
  SMustBeInBrowseMode = 'Bewerking is enkel toegestaan in dsBROWSE status';

  SUnKnownParamDataType = 'Param.DataType is onbekend';
  SFieldReadOnly        = 'Readonly veld kan geen waarde toegewezen krijgen: %d';
  SInvalidUpdateCount     = '%d record(s) gewijzigd. Slechts 1 record had gewijzigd mogen zijn.'; 

{$ELSE}
// <- ms, 09/05/2005

// -> ms, 03/05/2005
{$IFDEF GERMAN}
  SSQLError1 = 'SQL Fehler: %s';
  SSQLError2 = 'SQL Fehler: %s Code: %d';
  SSQLError3 = 'SQL Fehler: %s Code: %d SQL: %s';
  SSQLError4 = 'SQL Fehler: %s Code: %d Meldung: %s';

  SListCapacityError = 'Die Listenkapazitt bersteigt die definierte Grenze (%d)';
  SListCountError = 'Der Listenzhler ist auerhalb seiner definierten Grenzen (%d)';
  SListIndexError = 'Der Listenindex ist auerhalb der definierten Grenzen (%d)';

  SClonningIsNotSupported = 'Diese Klasse kann nicht geklont werden';
  SImmutableOpIsNotAllowed = 'Diese Operation ist bei nicht nderbaren Collections nicht erlaubt';
  SStackIsEmpty = 'Der Stack ist leer';
  SVariableWasNotFound = 'Die Variable "%s" wurde nicht gefunden';
  SFunctionWasNotFound = 'Die Funktion "%s" wurde nicht gefunden';
  SInternalError = 'Interner Fehler';
  SSyntaxErrorNear = 'Syntax Fehler bei "%s"';
  SSyntaxError = 'Syntax Fehler';
  SUnknownSymbol = 'Unbekanntes Symbol "%s"';
  SUnexpectedExprEnd = 'Unerwartetes Ende des Ausdrucks';
  SRightBraceExpected = ') erwartet';
  SParametersError = 'Es werden %d Parameter erwartet, aber nur %d Parameter gefunden';
  SExpectedMoreParams = 'Es werden mehr als zwei Parameter erwartet';
  SInvalidVarByteArray = 'Ungltiges VarByte Array';
  SVariableAlreadyExists = 'Die Variable "%s" existiert bereits';
  STypesMismatch = 'Inkompatible Typen';
  SUnsupportedVariantType = 'Nicht untersttzter Variant-Typ';
  SUnsupportedOperation = 'Nicht untersttzte Operation';
  SUnsupportedByDriver    = 'Der Treiber untersttzt dieses Feature nicht von haus aus: [%s]';

  STokenizerIsNotDefined = 'Tokenizer wurde nicht definiert';
  SLibraryNotFound = 'Es wurde keine der in %s gelisteten DLL''s gefunden';
  SEncodeDateIsNotSupported = 'Diese Version untersttzt "isc_encode_sql_date" nicht';
  SEncodeTimeIsNotSupported = 'Diese Version untersttzt "isc_encode_sql_time" nicht';
  SEncodeTimestampIsNotSupported = 'Diese Version untersttzt "isc_encode_sql_timestamp" nicht';
  SDecodeDateIsNotSupported = 'Diese Version untersttzt "isc_decode_sql_date" nicht';
  SDecodeTimeIsNotSupported = 'Diese Version untersttzt "isc_decode_sql_time" nicht';
  SDecodeTimestampIsNotSupported = 'Diese Version untersttzt "isc_decode_sql_timestamp" nicht';

  SCanNotRetrieveResultSetData = 'Die Ergebnismenge kann nicht ermittelt werden';
  SRowBufferIsNotAssigned = 'Der Zeilen-Buffer ist nicht zugewiesen';
  SColumnIsNotAccessable = 'Auf die Spalte (Tabellenfeld) mit dem Index %d kann nicht zugegriffen werden';
  SConvertionIsNotPossible = 'Eine Konvertierung der Spalte (Tabellenfeld) %d von %s bis %s kann nicht durchgefhrt werden';
  SCanNotAccessBlobRecord = 'Auf den BLOB-Datensatz in Spalte (Tabellenfeld) %d vom Typ %s kann nicht zugegriffen werden';
  SRowDataIsNotAvailable = 'Die Zeilendaten (Datensatzdaten) sind nicht verfgbar';
  SResolverIsNotSpecified = 'Fr diese Ergebnismenge wurde kein sog. "Resolver" angegeben';
  SResultsetIsAlreadyOpened = 'Die Ergebnismenge ist bereits geffnet';
  SCanNotUpdateEmptyRow = 'Eine leere Datenzeile kann nicht aktualisiert werden';
  SCanNotUpdateDeletedRow = 'Eine gelschte Datenzeile kann nicht aktualisiert werden';
  SCanNotDeleteEmptyRow = 'Eine leere Datenzeile kann nicht gelscht werden';
  SCannotUseCommit = 'COMMIT kann im AUTOCOMMIT-Modus nicht verwendet werden';
  SCannotUseRollBack = 'ROLLBACK kann im AUTOCOMMIT-Modus nicht verwendet werden';
  SCanNotUpdateComplexQuery = 'Ein Query, dessen Ergebnismenge aus mehr als einer Tabelle stammt, kann nicht aktualisiert werden';
  SCanNotUpdateThisQueryType = 'Diese Art von Queries kann nicht aktualisiert werden';
  SDriverWasNotFound = 'Der angegebene Datenbanktreiber wurde nicht gefunden';
  SCanNotConnectToServer = 'Kann keine Verbindung zum SQL Server herstellen';
  STableIsNotSpecified = 'Tabelle ist nicht spezifiziert';
  SLiveResultSetsAreNotSupported = 'Ein "Live Query" wird von dieser Klasse nicht untersttzt';
  SInvalidInputParameterCount = 'Es wurden weniger Eingabeparameter angegeben, als erwartet';
  SIsolationIsNotSupported = 'Der gewhlte Trasaktions-Isolationslevel wird nicht untersttzt';
  SColumnWasNotFound = 'Eine Tabellenspalte namens "%s" wurde nicht gefunden';
  SWrongTypeForBlobParameter = 'Falscher Typ fr einen BLOB-Parameter';
  SIncorrectConnectionURL = 'Falsche Verbindungs-URL: %s';
  SUnsupportedProtocol = 'Nicht untersttztes Protokoll: %s';

  SConnectionIsNotOpened = 'Die Verbindung zur Datenbank ist noch nicht hergestellt';
  SInvalidOpInAutoCommit = 'Ungltige Operation im AUTOCOMMIT-Modus';
  SInvalidOpInNonAutoCommit = 'Ungltige Operation auerhalb des AUTOCOMMIT-Modus';
  SInvalidOpPrepare = 'Transaktion vorzubereiten ist nur beim ersten Aufruf von Starttransaction mglich!';

  SConnectionIsNotAssigned = 'Die Datenbank-Verbindungskomponente ist nicht angegeben';
  SQueryIsEmpty = 'SQL Query leer';
  SCanNotExecuteMoreQueries = 'Mehr als ein Query kann nicht abgearbeitet werden';
  SOperationIsNotAllowed1 = 'Die Operation ist im FORWARD ONLY Modus nicht erlaubt';
  SOperationIsNotAllowed2 = 'Die Operation ist im READ ONLY Modus nicht erlaubt';
  SOperationIsNotAllowed3 = 'Die Operation ist im %s Modus nicht erlaubt';
  SOperationIsNotAllowed4 = 'Die Operation ist bei einem geschlossenen DataSet nicht erlaubt';
  SNoMoreRecords = 'Es gibt keine weiteren Datenstze in der Ergebnismenge';
  SCanNotOpenResultSet = 'Die Ergebnismenge kann nicht geffnet werden';
  SCircularLink = 'Die DataSource hat einen zirkulren Verweis';
  SBookmarkWasNotFound = 'Das Lesezeichen (Bookmark) wurde nicht gefunden';
  SIncorrectSearchFieldsNumber = 'Die Anzahl der Suchfeldwerte ist nicht korrekt';
  SInvalidOperationInTrans = 'Ungltige Operatio im Zustand einer expliziten Transaktion';
  SIncorrectSymbol = 'Falsches Symbol in der Feldliste "%s".';
  SIncorrectToken = 'Falsches Token gefolgt von ":"';

  SSelectedTransactionIsolation = 'Der gewhlte Transaktions-Isolationslevel wird nicht untersttzt';
  SDriverNotSupported = 'Der Treiber wird nicht untersttzt: %s';
  SPattern2Long = 'Das Muster (Pattern) ist zu lang';
  SDriverNotCapableOutParameters = 'Der Treiber beherrscht keine Parameter';
  SStatementIsNotAllowed = 'Diese Anweisung ist nicht erlaubt';
  SStoredProcIsNotAllowed = 'Diese Stored Procedure ist nicht erlaubt';
  SCannotPerformOperation = 'Auf eine geschlossene Ergebnismenge knnen keine Operationen ausgefhrt werden';
  SInvalidState = 'Ungltiger Status';
  SErrorConvertion = 'Konvertierungsfehler';
  SDataTypeDoesNotSupported = 'Der Datentyp wird nicht untersttzt';
  SUnsupportedParameterType = 'Der Parametertyp wird nicht untersttzt';
  SUnsupportedDataType = 'Der Datentyp wird nicht untersttzt';
  SErrorConvertionField = 'Konvertierungsfehler bei Feld "%s" nach SQL-Typ "%s"';
  SBadOCI = 'Die OCI Version 8.0.3 (oder lter) wird bentigt! Aktuelle Version: %s';
  SConnect2AsUser = 'Verbinde zu "%s" als User "%s"';
  SUnknownError = 'Unbekannter Fehler';
  SFieldNotFound1 = 'Das Feld "%s" wurde nicht gefunden';
  SFieldNotFound2 = 'Das Feld %d wurde nicht gefunden';

  SLoginPromptFailure = 'Der Standard-Login-Dialog konnte nicht gefunden werden. Bitte DBLogDlg in die USES-Sektion der Haupt-Unit hinzufgen';

  SPropertyQuery = 'Die Abfrage kann bei groen Datenbanken eine Weile dauern!';
  SPropertyTables = 'Sie sollte durch die Angabe von Catalog und/oder Schema eingeschrnkt werden.';
  SPropertyColumns = 'Sie sollte durch die Angabe von Catalog, Schema und/oder Tabellenname eingeschrnkt werden.';
  SPropertyProcedures = 'Sie sollte durch die Angabe von Catalog und/oder Schema eingeschrnkt werden.';
  SPropertySequences = 'Sie sollte durch die Angabe von Catalog und/oder Schema eingeschrnkt werden.';
  SPropertyExecute = 'Soll die Abfrage trotzdem ausgefhrt werden?';

  SFormTest = 'ZEOS SQL Editor Test';
  SButtonClose = '&Schlieen';
  SFormEditor = 'ZEOS SQL Editor';
  STabSheetSelect = 'SQL aus&whlen';
  SMenuLoad = 'ffnen';
  SMenuSave = 'Speichern';
  SButtonGenerate = '&Generieren';
  SButtonCheck = 'Syntax &Prfen';
  SButtonTest = 'Befehl &Testen';
  SButtonOk = '&OK';
  SButtonCancel = '&Abbruch';
  STableAlias = 'Tabllen-Alias';
  SReplaceSQL = 'SQL &ersetzen';
  SDialogOpenTitle = 'SQL Script ffnen';
  SDialogSaveTitle = 'SQL Script speichern';
  SSQLEditor = 'SQL Editor';
  SDatabaseDialog = 'Existierende Datenbank ffnen';

  SUpdateSQLNoResult = 'Translate : Update Refresh SQL delivered no resultset';
  SUpdateSQLRefreshStatementcount ='Translate : Update Refresh SQL Statement count must be 1';

  {$IFDEF FPC}
  SNotEditing = 'Das DataSet ist nicht im "edit" oder "insert" Modus.';
  SFieldTypeMismatch = 'Der Typ fr Feld ''%s'' stimmt nicht. Erwartet wird %s der Typ ist aber momentan %s';
  SFieldSizeMismatch = 'Die Gre des Feldes ''%s'' stimmt nicht. Erwartet wird  %d die Gre ist aber momentan %d';
  {$ENDIF}
  SNeedField               = 'Translate: Field %s is required, but not supplied.';

  SFailedtoInitPrepStmt   = 'Translate: Prepared statement failed to initialize';
  SFailedtoPrepareStmt    = 'Translate: Statement failed during prepare process';
  SFailedToBindAllValues  = 'Translate: Application failed to pre-bind all values';
  SAttemptExecOnBadPrep   = 'Translate: Attempt made to execute a statement before a successful preparation.';
  SBindingFailure         = 'Translate: Failed to bind parameter set';
  SPreparedStmtExecFailure = 'Translate: Prepared statement failed to execute';
  SBoundVarStrIndexMissing = 'Translate: Bound variable text index "%s" does not exist';
  SBindVarOutOfRange      = 'Translate: Bound variable index out of range: %d';
  SFailedToBindResults    = 'Translate: Application failed to bind to the result set';

  SRefreshRowOnlySupportedWithUpdateObject = 'TRANSLATE: The refreshrow method is only supported with an update object';
  SMustBeInBrowseMode = 'TRANSLATE: Operation is only allowed in dsBROWSE state';

  SUnKnownParamDataType = 'TRANSLATE: Unknown Param.DataType';
  SFieldReadOnly          = 'Translate : Readonly field can''t be assigned a value: %d';
  SInvalidUpdateCount     = 'Translate : %d record(s) updated. Only one record should have been updated.'; 

{$ELSE}
  // -> fduenas, 28/06/2005
{$IFDEF SPANISH} //Spanish translations
  SSQLError1 = 'Error SQL: %s';
  SSQLError2 = 'Error SQL: %s Cdigo: %d';
  SSQLError3 = 'Error SQL: %s Cdigo: %d SQL: %s';
  SSQLError4 = 'Error SQL: %s Cdigo: %d Mensage: %s';

  SListCapacityError = 'List capacity fuera de lmites (%d)';
  SListCountError = 'List count fuera de lmites (%d)';
  SListIndexError = 'List index fuera de lmites (%d)';

  SClonningIsNotSupported = 'La Clonacin no est soportada por esta clase';
  SImmutableOpIsNotAllowed = 'Operacin no permitida en colecciones no modificables';
  SStackIsEmpty = 'La Pila (Stack) est vaca';
  SVariableWasNotFound = 'Variable "%s" no encontrada';
  SFunctionWasNotFound = 'Funcin "%s" no encontrada';
  SInternalError = 'Error interno';
  SSyntaxErrorNear = 'Error de sintaxis cerca de "%s"';
  SSyntaxError = 'Error de sintaxis';
  SUnknownSymbol = 'Smbolo "%s" desconocido';
  SUnexpectedExprEnd = 'Fin de expresin inesperado';
  SRightBraceExpected = ') esperado';
  SParametersError = 'Se esperaban %d parmetros pero solo %d fueron encontrados';
  SExpectedMoreParams = 'Se esperaban ms de dos parmetros';
  SInvalidVarByteArray = 'Arreglo VarByte invlido';
  SVariableAlreadyExists = 'La variable "%s" ya existe';
  STypesMismatch = 'Los Tipos no coinciden';
  SUnsupportedVariantType = 'Tipo de Variant no soportando';
  SUnsupportedOperation = 'Operacin no soportada';

  STokenizerIsNotDefined = 'El objeto Tokenizer no est definido';
  SLibraryNotFound = 'Ninguna librera dinmica de la lista %s fue encontrada';
  SEncodeDateIsNotSupported = 'Esta versin no soporta isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'Esta versin no soporta isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'Esta versin no soporta isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'Esta versin no soporta isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'Esta versin no soporta isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'Esta versin no soporta isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'No se pueden obtener datos del Resultset';
  SRowBufferIsNotAssigned = 'Buffer de lnea no asignado';
  SColumnIsNotAccessable = 'La columna con ndice %d no est accesible';
  SConvertionIsNotPossible = 'La conversin no es posible para la columna %d de %s a %s';
  SCanNotAccessBlobRecord = 'No se puede accesar al registro del blob en la columna %d con tipo %s';
  SRowDataIsNotAvailable = 'Datos de lnea no disponibles';
  SResolverIsNotSpecified = 'El objeto Resolver no est especificado para este ResultSet';
  SResultsetIsAlreadyOpened = 'El Resultset ya est abierto';
  SCanNotUpdateEmptyRow = 'No se puede actualizar una lnea vaca';
  SCanNotUpdateDeletedRow = 'No se puede actualizar una lnea borrada';
  SCanNotDeleteEmptyRow = 'No se puede borrar una lnea vaca';
  SCannotUseCommit = 'No se puede usar COMMIT en modo AUTOCOMMIT';
  SCannotUseRollBack = 'No se puede usar ROLLBACK en modo AUTOCOMMIT';
  SCanNotUpdateComplexQuery = 'No se puede actualizar una consulta compleja que haga referencia a ms de una tabla';
  SCanNotUpdateThisQueryType = 'No se puede actualizar este tipo de consulta';
  SDriverWasNotFound = 'No se encontr el controlador de base de datos solicitado';
  SCanNotConnectToServer = 'No puede conectarse al servidor SQL';
  STableIsNotSpecified = 'La Tabla no est especificada';
  SLiveResultSetsAreNotSupported = 'La consulta actualizable no es soportada por esta clase';
  SInvalidInputParameterCount = 'El nmero de parmetros de tipo Input es menor al esperado';
  SIsolationIsNotSupported = 'Nivel de aislamiento de transaccin no soportado';
  SColumnWasNotFound = 'Columna con nombre "%s" no encontrada';
  SWrongTypeForBlobParameter = 'Tipo incorrecto para el parmetro Blob';
  SIncorrectConnectionURL = 'URL de conexin incorrecta: %s';
  SUnsupportedProtocol = 'Protocolo no soportado: %s';
  SUnsupportedByDriver    = 'Translate: Driver can not support this feature natively: [%s]';

  SConnectionIsNotOpened = 'La conexin no ha sido abierta todava';
  SInvalidOpInAutoCommit = 'Operacin invlida en modo AutoCommit';
  SInvalidOpInNonAutoCommit = 'Operacin invlida en modo No-AutoCommit';
  SInvalidOpPrepare = 'Translate : Prepare transaction only possible on matching first(!) Starttransaction';

  SConnectionIsNotAssigned = 'El componente de conexin a base de datos no est asigando';
  SQueryIsEmpty = 'La Consulta SQL est vaca';
  SCanNotExecuteMoreQueries = 'No se puede ejecutar ms de una consulta';
  SOperationIsNotAllowed1 = 'Operacin no permitida en modo FORWARD ONLY';
  SOperationIsNotAllowed2 = 'Operacin no permitida en modo READ ONLY (Solo lectura)';
  SOperationIsNotAllowed3 = 'Operacin no permitida en modo %s';
  SOperationIsNotAllowed4 = 'Operacin no permitida en un dataset cerrado';
  SNoMoreRecords = 'No hay ms registros en el Resultset';
  SCanNotOpenResultSet = 'No se puede abrir el Resultset';
  SCircularLink = 'Datasource hace una referencia cclica';
  SBookmarkWasNotFound = 'Bookmark no encontrado';
  SIncorrectSearchFieldsNumber = 'Nmero incorrecto de valores de bsqueda';
  SInvalidOperationInTrans = 'Operacin invlida en modo de transaccin explcita';
  SIncorrectSymbol = 'Smbolo incorrecto en la lista de campos "%s".';
  SIncorrectToken = 'Token incorrecto seguido de ":"';

  SSelectedTransactionIsolation = 'El Nivel seleccionado de aislamiento de transaccin no est soportado';
  SDriverNotSupported = 'Controlador %s no soportado';
  SPattern2Long = 'Patrn de bsqueda demasiado largo';
  SDriverNotCapableOutParameters = 'El controlador no tiene cualidades para manejar parmetros';
  SStatementIsNotAllowed = 'Sentencia no permitida';
  SStoredProcIsNotAllowed = 'El procedimiento alamacenado no est permitido';
  SCannotPerformOperation = 'No se puede efectuar la operacin en un resultset cerrado';
  SInvalidState = 'Estado Invlido';
  SErrorConvertion = 'Error de conversin';
  SDataTypeDoesNotSupported = 'Tipo de datos no soportado';
  SUnsupportedParameterType = 'Tipo de parmetro no soportado';
  SUnsupportedDataType = 'Tipo de datos no soportado';
  SErrorConvertionField = 'Error de conversin del campo "%s" al Tipo SQL "%s"';
  SBadOCI = 'Versin de OCI [%s] no aceptable. Se requiere versin 8.0.3 o menor';
  SConnect2AsUser = 'Conectando a "%s" como usuario "%s"';
  SUnknownError = 'Error desconocido';
  SFieldNotFound1 = 'Campo "%s" no encontrado';
  SFieldNotFound2 = 'Campo %d no encontrado';

  SLoginPromptFailure = 'Cuadro de Dilogo por omisin para autenticacin no encontrado.'+#10#13+
                        'Por favor agregue la unidad DBLogDlg a la seccin uses de la unidad principal de su proyecto.';

  SPropertyQuery = 'La Consulta puede tardar un poco en bases de datos extensas!';
  SPropertyTables = 'Debera limitarlas mediante Catalog y/o Schema.';
  SPropertyColumns = 'Debera limitarlas mediante Catalog, Schema y/o TableName.';
  SPropertyProcedures = 'Debera limitarlos mediante Catalog y/or Schema.';
  SPropertySequences = 'Debera limitarlos mediante Catalog y/or Schema.';
  SPropertyExecute = 'Desea ejecutar la consulta de todos modos?';

  SFormTest = 'Prueba del Editor ZEOS SQL';
  SButtonClose = '&Cerrar';
  SFormEditor = 'Editor ZEOS SQL';
  STabSheetSelect = 'Seleccionar SQL';
  SMenuLoad = 'Cargar...';
  SMenuSave = 'Guardar...';
  SButtonGenerate = '&Generar';
  SButtonCheck = 'C&hecar';
  SButtonTest = 'Pro&bar';
  SButtonOk = '&Aceptar';
  SButtonCancel = '&Cancelar';
  STableAlias = 'A&lias de la tabla';
  SReplaceSQL = '&Reemplazar SQL';
  SDialogOpenTitle = 'Abrir archivo SQL';
  SDialogSaveTitle = 'Guardar archivo SQL';
  SSQLEditor = 'Editor SQL';
  SDatabaseDialog = 'Abrir base de datos existente';

  SUpdateSQLNoResult = 'Translate : Update Refresh SQL delivered no resultset';
  SUpdateSQLRefreshStatementcount ='Translate : Update Refresh SQL Statement count must be 1';

  {$IFDEF FPC}
  SNotEditing = 'El Dataset no se encuentra en modo de edicin o insercin';
  SFieldTypeMismatch = 'El Tipo de dato no coincide para el campo ''%s'', se espera: %s, actual: %s';
  SFieldSizeMismatch = 'El Tamao de dato no coincide para el campo ''%s'', se espera: %d, actual: %d';
  {$ENDIF}
  SNeedField               = 'Translate: Field %s is required, but not supplied.';

  SFailedtoInitPrepStmt   = 'Translate: Prepared statement failed to initialize';
  SFailedtoPrepareStmt    = 'Translate: Statement failed during prepare process';
  SFailedToBindAllValues  = 'Translate: Application failed to pre-bind all values';
  SAttemptExecOnBadPrep   = 'Translate: Attempt made to execute a statement before a successful preparation.';
  SBindingFailure         = 'Translate: Failed to bind parameter set';
  SPreparedStmtExecFailure = 'Translate: Prepared statement failed to execute';
  SBoundVarStrIndexMissing = 'Translate: Bound variable text index "%s" does not exist';
  SBindVarOutOfRange      = 'Translate: Bound variable index out of range: %d';
  SFailedToBindResults    = 'Translate: Application failed to bind to the result set';

  SRefreshRowOnlySupportedWithUpdateObject = 'TRANSLATE: The refreshrow method is only supported with an update object';
  SMustBeInBrowseMode = 'TRANSLATE: Operation is only allowed in dsBROWSE state';

  SUnKnownParamDataType = 'TRANSLATE: Unknown Param.DataType';
  SFieldReadOnly          = 'Translate : Readonly field can''t be assigned a value: %d';
  SInvalidUpdateCount     = 'Translate : %d record(s) updated. Only one record should have been updated.'; 

{$ELSE}

{$IFDEF ROMANA}


 SSQLError1 = 'SQL Eroare: %s';
  SSQLError2 = 'SQL Eroare: %s Cod: %d';
  SSQLError3 = 'SQL Eroare: %s Cod: %d SQL: %s';
  SSQLError4 = 'SQL Eroare: %s Cod: %d Mesaj: %s';

  SListCapacityError = 'Capacitatea listei este n afara limitelor (%d)';
  SListCountError = 'Contorul listei este n afara limitelor (%d)';
  SListIndexError = 'Indexul listei este n afara limitelor (%d)';

  SClonningIsNotSupported = 'Clonning nu este suportat de aceast clas';
  SImmutableOpIsNotAllowed = 'Operaia nu este permis ori colecia nu este modificabil';
  SStackIsEmpty = 'Stiva este goal';
  SVariableWasNotFound = 'Variabila "%s" nu a fost gsit';
  SFunctionWasNotFound = 'Funcia "%s" nu a fost gsit';
  SInternalError = 'Eroare Intern';
  SSyntaxErrorNear = 'Eroare de sintax lng "%s"';
  SSyntaxError = 'Eroare de sintax';
  SUnknownSymbol = 'Simbol necunoscut "%s"';
  SUnexpectedExprEnd = 'Final neateptat pentru expresie';
  SRightBraceExpected = ') ateptat';
  SParametersError = 'parametrul %d a fost ateptat dar %d a fost gsit';
  SExpectedMoreParams = 'Mai nult de doi parametrii sunt ateptai';
  SInvalidVarByteArray = 'Arie VarByte invalid';
  SVariableAlreadyExists = 'Variabila "%s" deja exist';
  STypesMismatch = 'Tip nepotrivit';
  SUnsupportedVariantType = 'Tip variant neasteptat';
  SUnsupportedOperation = 'Operaie nesuportat';

  STokenizerIsNotDefined = 'Simbolistica nu este definit';
  SLibraryNotFound = 'None of the dynamic libraries can be found: %s';
  SEncodeDateIsNotSupported = 'Aceast versiune nu suport isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'Aceast versiune nu suport isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'Aceast versiune nu suport isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'Aceast versiune nu suport isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'Aceast versiune nu suport isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'Aceast versiune nu suport isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'Nu pot returna  Resultset data';
  SRowBufferIsNotAssigned = 'Row buffer nu este asignat';
  SColumnIsNotAccessable = 'Column with index %d nu este accesibil';
  SConvertionIsNotPossible = 'Conversia nu este posibil pentru coloana %d din %s n %s';
  SCanNotAccessBlobRecord = 'Nu pot aceesa nregistrarea blob n coloana %d cu tipul %s';
  SRowDataIsNotAvailable = 'Row data nu este disponibil';
  SResolverIsNotSpecified = 'Resolver nu este specificat pentru acest ResultSet';
  SResultsetIsAlreadyOpened = 'Resultset este deja deschis';
  SCanNotUpdateEmptyRow = 'Nu pot updata o nregistrare goal';
  SCanNotUpdateDeletedRow = 'Nu pot updata o nregistrare tears';
  SCanNotDeleteEmptyRow = 'Nu pot terge o nregistrare goal';
  SCannotUseCommit = 'Nu poi folosi COMMIT n modul AUTOCOMMIT ';
  SCannotUseRollBack = 'Nu poi folosi ROLLBACK n modul AUTOCOMMIT ';
  SCanNotUpdateComplexQuery = 'Nu pot updata un query complex cu mai mult de un tabel';
  SCanNotUpdateThisQueryType = 'Nu pot updata acest tip de query';
  SDriverWasNotFound = 'Driverul pentru baza de date nu a fost gsit';
  SCanNotConnectToServer = 'Nu ma pot conecta la serverul SQL';
  STableIsNotSpecified = 'Tbelul nu este specificat';
  SLiveResultSetsAreNotSupported = 'Live query is not supported by this class';
  SInvalidInputParameterCount = 'Input parameter count is less then expected';
  SIsolationIsNotSupported = 'Transaction isolation level nu este suportat';
  SColumnWasNotFound = 'Coloana cu numele "%s" nu a fost fsit';
  SWrongTypeForBlobParameter = 'Tip greit pentru parametru Blob';
  SIncorrectConnectionURL = 'Conexiune URL incorect: %s';
  SUnsupportedProtocol = 'Protocol nesuportat: %s';
  SUnsupportedByDriver    = 'Driver nu poate suporta aceast facilitate : [%s]';

  SConnectionIsNotOpened = 'Conexiune nu este deschis inc';
  SInvalidOpInAutoCommit = 'Operaie invalid n modul AutoCommit';
  SInvalidOpInNonAutoCommit = 'Operaie invalid n modul non AutoCommit ';
  SInvalidOpPrepare = 'Prepare transaction only possible on matching first(!) Starttransaction';

  SConnectionIsNotAssigned = 'Nu este asignat o component Database connection';
  SQueryIsEmpty = 'SQL Query este gol';
  SCanNotExecuteMoreQueries = 'Nu pot executa mai mult de un query';
  SOperationIsNotAllowed1 = 'Operaia nu este permis n modul FORWARD ONLY ';
  SOperationIsNotAllowed2 = 'Operaia nu este permis n modul READ ONLY';
  SOperationIsNotAllowed3 = 'Operaia nu este permis n modul %s ';
  SOperationIsNotAllowed4 = 'Operaia nu este permis pentru n dataset nchis';
  SNoMoreRecords = 'Nu mai sunt nregistrri n Resultset';
  SCanNotOpenResultSet = 'Nu pot deschide Resultset';
  SCircularLink = 'Datasource makes a circular link';
  SBookmarkWasNotFound = 'Bookmark nu a fost gsit';
  SIncorrectSearchFieldsNumber = 'Numr incorect of search field values';
  SInvalidOperationInTrans = 'Operaie invalid n modul explicit transaction';
  SIncorrectSymbol = 'Simbol incorect n lista de cmpuri  "%s".';
  SIncorrectToken = 'Incorect token dup ":"';

  SSelectedTransactionIsolation = 'Selected transaction isolation level is not supported';
  SDriverNotSupported = 'Driver nesuportat %s';
  SPattern2Long = 'Pattern is too long';
  SDriverNotCapableOutParameters = 'Driver nu este capabil s mnuie parametrii';
  SStatementIsNotAllowed = 'Statement nu sunt permise';
  SStoredProcIsNotAllowed = 'The stored proc nu sunt permise';
  SCannotPerformOperation = 'Nu se pot face operaii cu Resultset nchis';
  SInvalidState = 'Stare invalid';
  SErrorConvertion = 'Eroare de conversie';
  SDataTypeDoesNotSupported = 'Tip de dat nesuportat';
  SUnsupportedParameterType = 'Tip parametru nesuportat';
  SUnsupportedDataType = 'Tip dat nesuportat';
  SErrorConvertionField = 'Eroare de conversie pentru cmpul "%s" n TipSQL "%s"';
  SBadOCI = 'Bad OCI version [%s]. Version 8.0.3 or older is required';
  SConnect2AsUser = 'Conectare la "%s" ca utlizator "%s"';
  SUnknownError = 'Eroare necunoscut';
  SFieldNotFound1 = 'Cmpul "%s" nu a fost gsit';
  SFieldNotFound2 = 'Cmpul %d nu a fost gsit';

  SLoginPromptFailure = 'Nu gsesc fereastra de dialog implicit pentru login. V rog adugai DBLogDlg n seciunea uses.';

  SPropertyQuery = 'The Query may last a while on large databases!';
  SPropertyTables = 'You should limit it by Catalog and/or Schema.';
  SPropertyColumns = 'You should limit it by Catalog, Schema and/or TableName.';
  SPropertyProcedures = 'You should limit it by Catalog and/or Schema.';
  SPropertySequences = 'You should limit it by Catalog and/or Schema.';
  SPropertyExecute = 'Query va fi executat oricum?';

  SFormTest = 'ZEOS SQL Editor Test';
  SButtonClose = 'n&chide';
  SFormEditor = 'ZEOS SQL Editor';
  STabSheetSelect = 'Select SQL';
  SMenuLoad = 'Deschide';
  SMenuSave = 'Salvare';
  SButtonGenerate = '&Generare';
  SButtonCheck = 'Verificare';
  SButtonTest = '&Test';
  SButtonOk = '&OK';
  SButtonCancel = 'Revo&care';
  STableAlias = 'T&able alias';
  SReplaceSQL = '&Replace SQL';
  SDialogOpenTitle = 'Deschide Fiier SQL';
  SDialogSaveTitle = 'Salveaz Fiier SQL';
  SSQLEditor = 'SQL Editor';
  SDatabaseDialog = 'Deschide baz date existent';

  SUpdateSQLNoResult = '"Update Refresh SQL" furnizat nu este un recordset';
  SUpdateSQLRefreshStatementcount ='Declaraia "Update Refresh SQL" ca numr trebuie s fie una';

  {$IFDEF FPC}
  SNotEditing = 'Dataset nu este n modul de editare sau inserare';
  SFieldTypeMismatch = 'Tip nepotrivit pentru cmpul ''%s'', ateptat: %s actual: %s';
  SFieldSizeMismatch = 'Dimensiune nepotrivit pentru cmpul  ''%s'', ateptat: %d actual: %d';
  {$ENDIF}
  SNeedField               = 'Translate: Field %s is required, but not supplied.';

  SFailedtoInitPrepStmt   = 'Translate: Prepared statement failed to initialize';
  SFailedtoPrepareStmt    = 'Translate: Statement failed during prepare process';
  SFailedToBindAllValues  = 'Translate: Application failed to pre-bind all values';
  SAttemptExecOnBadPrep   = 'Translate: Attempt made to execute a statement before a successful preparation.';
  SBindingFailure         = 'Translate: Failed to bind parameter set';
  SPreparedStmtExecFailure = 'Translate: Prepared statement failed to execute';
  SBoundVarStrIndexMissing = 'Translate: Bound variable text index "%s" does not exist';
  SBindVarOutOfRange      = 'Translate: Bound variable index out of range: %d';
  SFailedToBindResults    = 'Translate: Application failed to bind to the result set';

  SRefreshRowOnlySupportedWithUpdateObject = 'TRANSLATE: The refreshrow method is only supported with an update object';
  SMustBeInBrowseMode = 'TRANSLATE: Operation is only allowed in dsBROWSE state';

  SUnKnownParamDataType = 'TRANSLATE: Unknown Param.DataType';

  // <-- added by tohenk
  {$ELSE}
  {$IFDEF INDONESIAN}
  SSQLError1 = 'Kesalahan SQL: %s';
  SSQLError2 = 'Kesalahan SQL: %s Kode: %d';
  SSQLError3 = 'Kesalahan SQL: %s Kode: %d SQL: %s';
  SSQLError4 = 'Kesalahan SQL: %s Kode: %d Pesan: %s';

  SListCapacityError = 'Kapasitas List diluar jangkauan (%d)';
  SListCountError = 'Jumlah List diluar jangkauan (%d)';
  SListIndexError = 'Indeks List diluar jangkauan (%d)';

  SClonningIsNotSupported = 'Class ini tidak mendukung kloning';
  SImmutableOpIsNotAllowed = 'Operasi tidak diperkenankan pada koleksi yang tidak dapat diubah';
  SStackIsEmpty = 'Stack kosong';
  SVariableWasNotFound = 'Variabel "%s" tidak ada';
  SFunctionWasNotFound = 'Fungsi "%s" tidak ada';
  SInternalError = 'Kesalahan internal';
  SSyntaxErrorNear = 'Kesalahan Syntax di dekat "%s"';
  SSyntaxError = 'Kesalahan Syntax';
  SUnknownSymbol = 'Simbol tidak dikenali "%s"';
  SUnexpectedExprEnd = 'Tidak dibutuhkan, akhir dari ekspresi';
  SRightBraceExpected = ') dibutuhkan';
  SParametersError = '%d parameter dibutuhkan tapi terdapat %d parameter';
  SExpectedMoreParams = 'Dibutuhkan lebih dari dua parameter';
  SInvalidVarByteArray = 'array VarByte tidak valid';
  SVariableAlreadyExists = 'Variabel "%s" sudah ada';
  STypesMismatch = 'Tipe tidak sesuai';
  SUnsupportedVariantType = 'Tipe variant tidak didukung';
  SUnsupportedOperation = 'Operasi tidak didukung';

  STokenizerIsNotDefined = 'Tokenizer belum ditentukan';
  SLibraryNotFound = 'Tidak ada library ditemukan: %s';
  SEncodeDateIsNotSupported = 'Versi ini tidak mendukung isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'Versi ini tidak mendukung isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'Versi ini tidak mendukung isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'Versi ini tidak mendukung isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'Versi ini tidak mendukung isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'Versi ini tidak mendukung isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'Tidak dapat mengambil data Resultset';
  SRowBufferIsNotAssigned = 'Row buffer tidak disediakan';
  SColumnIsNotAccessable = 'Kolom dengan indeks %d tidak dapat diakses';
  SConvertionIsNotPossible = 'Konversi tidak dimungkinkan pada kolom %d dari %s ke %s';
  SCanNotAccessBlobRecord = 'Tidak dapat mengakses rekord `blob` pada kolom %d dengan tipe %s';
  SRowDataIsNotAvailable = 'Data Row tidak tersedia';
  SResolverIsNotSpecified = 'Resolver belum ditentukan pada ResultSet ini';
  SResultsetIsAlreadyOpened = 'Resultset sudah terbuka';
  SCanNotUpdateEmptyRow = 'Tidak dapat meng-update row kosong';
  SCanNotUpdateDeletedRow = 'Tidak dapat meng-update row terhapus';
  SCanNotDeleteEmptyRow = 'Tidak dapat meng-hapus row kosong';
  SCannotUseCommit = 'COMMIT tidak dapat digunakan pada mode AUTOCOMMIT';
  SCannotUseRollBack = 'ROLLBACK tidak dapat digunakan pada mode AUTOCOMMIT';
  SCanNotUpdateComplexQuery = 'Tidak dapat meng-update query kompleks dengan lebih dari satu tabel';
  SCanNotUpdateThisQueryType = 'Tidak dapat meng-update query dengan tipe ini';
  SDriverWasNotFound = 'Driver database yang diminta tidak ada';
  SCanNotConnectToServer = 'Tidak dapat terhubung ke server SQL';
  STableIsNotSpecified = 'Tabel belum ditentukan';
  SLiveResultSetsAreNotSupported = 'Live query tidak didukung oleh Class ini';
  SInvalidInputParameterCount = 'Jumlah parameter Input kurang dari yang dibutuhkan';
  SIsolationIsNotSupported = 'Level Isolasi Transaksi tidak didukung';
  SColumnWasNotFound = 'Kolom dengan nama "%s" tidak ada';
  SWrongTypeForBlobParameter = 'Salah tipe untuk parameter Blob';
  SIncorrectConnectionURL = 'Salah koneksi URL: %s';
  SUnsupportedProtocol = 'Protokol tidak didukung: %s';
  SUnsupportedByDriver    = 'Driver tidak mendukung fitur: [%s]';

  SConnectionIsNotOpened = 'Koneksi belum dibuka';
  SInvalidOpInAutoCommit = 'Operasi tidak valid pada mode AUTOCOMMIT';
  SInvalidOpInNonAutoCommit = 'Operasi tidak valid pada mode non AUTOCOMMIT';
  SInvalidOpPrepare = 'Persiapan transaksi hanya mungkin pada (!) Starttransaction pertama';

  SConnectionIsNotAssigned = 'Komponen koneksi Database tidak ditentukan';
  SQueryIsEmpty = 'Query SQL kosong';
  SCanNotExecuteMoreQueries = 'Tidak dapat meng-eksekusi lebih dari satu query';
  SOperationIsNotAllowed1 = 'Operasi tidak diperkenankan pada mode FORWARD ONLY';
  SOperationIsNotAllowed2 = 'Operasi tidak diperkenankan pada mode READ ONLY';
  SOperationIsNotAllowed3 = 'Operasi tidak diperkenankan pada mode %s';
  SOperationIsNotAllowed4 = 'Operasi tidak diperkenankan pada dataset tertutup';
  SNoMoreRecords = 'Tidak ada rekord lagi pada Resultset';
  SCanNotOpenResultSet = 'Tidak dapat membuka Resultset';
  SCircularLink = 'Terjadi hubungan Datasource circular';
  SBookmarkWasNotFound = 'Bookmark tidak ada';
  SIncorrectSearchFieldsNumber = 'Salah jumlah nilai field pada pencarian';
  SInvalidOperationInTrans = 'Operasi tidak valid pada mode explicit transaction';
  SIncorrectSymbol = 'Simbol salah pada daftar field "%s".';
  SIncorrectToken = 'Token salah setelah ":"';

  SSelectedTransactionIsolation = 'Level Isolasi Transaksi terpilih tidak didukung';
  SDriverNotSupported = 'Driver tidak mendukung %s';
  SPattern2Long = 'Pola terlalu panjang';
  SDriverNotCapableOutParameters = 'Driver tidak mampu menangani parameter';
  SStatementIsNotAllowed = 'Statement tidak diperbolehkan';
  SStoredProcIsNotAllowed = 'StoredProc tidak diperbolehkan';
  SCannotPerformOperation = 'Tidak dapat melakukan operasi pada Resultset tertutup';
  SInvalidState = 'Sate tidak valid';
  SErrorConvertion = 'Kesalahan konversi';
  SDataTypeDoesNotSupported = 'Tipe Data tidak didukung';
  SUnsupportedParameterType = 'Tidak mendukung tipe parameter';
  SUnsupportedDataType = 'Tidak mendukung tipe data';
  SErrorConvertionField = 'Kesalahan konversi field "%s" ke Tipe SQL "%s"';
  SBadOCI = 'OCI version [%s] tidak sah. Dibutuhkan versi 8.0.3 atau terdahulu';
  SConnect2AsUser = 'Koneksi ke "%s" dengan user "%s"';
  SUnknownError = 'Kesalahan tidak diketahui';
  SFieldNotFound1 = 'Field "%s" tidak ada';
  SFieldNotFound2 = 'Field %d tidak ada';

  SLoginPromptFailure = 'Tidak ada dialog Login default. Silahkan tambahkan DBLogDlg ke klausula `uses` pada file utama.';

  SPropertyQuery = 'Query mungkin berlangsung lama pada database besar!';
  SPropertyTables = 'Batasi dengan Katalog data/atau Skema.';
  SPropertyColumns = 'Batasi dengan Katalog, Skema dan/atau Nama Tabel.';
  SPropertyProcedures = 'Batasi dengan Katalog dan/atau Skema.';
  SPropertySequences = 'Batasi dengan Katalog dan/atau Skema.';
  SPropertyExecute = 'Apakah Query jadi dieksekusi?';

  SFormTest = 'Tes Editor SQLZEOS';
  SButtonClose = '&Tutup';
  SFormEditor = 'Editor SQL ZEOS';
  STabSheetSelect = 'SQL Select';
  SMenuLoad = 'Ambil';
  SMenuSave = 'Simpan';
  SButtonGenerate = '&Generate';
  SButtonCheck = '&Cek';
  SButtonTest = 'T&es';
  SButtonOk = '&OK';
  SButtonCancel = '&Batal';
  STableAlias = 'Alias T&abel';
  SReplaceSQL = 'SQL &Replace';
  SDialogOpenTitle = 'Buka File SQL';
  SDialogSaveTitle = 'Simpan File SQL';
  SSQLEditor = 'Editor SQL';
  SDatabaseDialog = 'Buka database yang tersedia';

  SUpdateSQLNoResult = 'Tidak ada Resultset pada Update Refresh SQL';
  SUpdateSQLRefreshStatementcount ='Jumlah Statement pada Update Refresh SQL harus 1';

  {$IFDEF FPC}
  SNotEditing = 'Dataset tidak dalam mode edit atau sisip';
  SFieldTypeMismatch = 'Tipe tidak sesuai pada field ''%s'', seharusnya: %s aktual: %s';
  SFieldSizeMismatch = 'Ukuran tidak sesuai pada field ''%s'', seharusnya: %d aktual: %d';
  {$ENDIF}
  SNeedField               = 'Translate: Field %s is required, but not supplied.';

  SFailedtoInitPrepStmt   = 'Gagal inisialisasi Prepared statement';
  SFailedtoPrepareStmt    = 'Statemen gagal sewaktu proses persiapan';
  SFailedToBindAllValues  = 'Aplikasi gagal dalam penggabungan pendahuluan semua nilai';
  SAttemptExecOnBadPrep   = 'Percobaan eksekusi statemen dilakukan sebelum persiapan berhasil.';
  SBindingFailure         = 'Gagal menggabungkan parameter';
  SPreparedStmtExecFailure = 'Prepared Statement gagal dieksekusi';
  SBoundVarStrIndexMissing = 'Teks variabel indeks "%s" tidak ada';
  SBindVarOutOfRange      = 'Variabel indeks diluar jangkauan: %d';
  SFailedToBindResults    = 'Aplikasi gagal pada penggabungan ke Resultset';

  SRefreshRowOnlySupportedWithUpdateObject = 'Metode RefreshRow hanya didukung oleh obyek Update';
  SMustBeInBrowseMode = 'Operasi hanya diperbolehkan pada status dsBrowse';

  SUnKnownParamDataType = 'Param.DataType tidak dikenal';
  // <--- end added by tohenk
  SFieldReadOnly          = 'Translate : Readonly field can''t be assigned a value: %d';
  SInvalidUpdateCount     = 'Translate : %d record(s) updated. Only one record should have been updated.'; 

  //--- begin added by ORMADA --------------------------------------------------
{$ELSE}
{$IFDEF RUSSIAN}
  SSQLError1                               = '  SQL : %s';
  SSQLError2                               = '  SQL : %s  : %d';
  SSQLError3                               = '  SQL : %s  : %d SQL: %s';
  SSQLError4                               = '  SQL : %s  : %d : %s';

  SListCapacityError                       = '     (%d)';
  SListCountError                          = '     (%d)';
  SListIndexError                          = '     (%d)';

  SClonningIsNotSupported                  = '    ';
  SImmutableOpIsNotAllowed                 = '     ';
  SStackIsEmpty                            = ' ';
  SVariableWasNotFound                     = ' "%s"  ';
  SFunctionWasNotFound                     = ' "%s"  ';
  SInternalError                           = ' ';
  SSyntaxErrorNear                         = '   "%s"';
  SSyntaxError                             = '  ';
  SUnknownSymbol                           = '  "%s"';
  SUnexpectedExprEnd                       = '  ';
  SRightBraceExpected                      = ') ';
  SParametersError                         = ' %d ,  %d';
  SExpectedMoreParams                      = '  2- ';
  SInvalidVarByteArray                     = '  (VarByte)';
  SVariableAlreadyExists                   = ' "%s"  ';
  STypesMismatch                           = ' ';
  SUnsupportedVariantType                  = '  (variant) ';
  SUnsupportedOperation                    = ' ';

  STokenizerIsNotDefined                   = '  ';
  SLibraryNotFound                         = '     : %s';
  SEncodeDateIsNotSupported                = '    isc_encode_sql_date';
  SEncodeTimeIsNotSupported                = '    isc_encode_sql_time';
  SEncodeTimestampIsNotSupported           = '    isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported                = '    isc_decode_sql_date';
  SDecodeTimeIsNotSupported                = '    isc_decode_sql_time';
  SDecodeTimestampIsNotSupported           = '    isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData             = '    (Resultset)';
  SRowBufferIsNotAssigned                  = '   ';
  SColumnIsNotAccessable                   = '    %d';
  SConvertionIsNotPossible                 = '    %d  %s  %s';
  SCanNotAccessBlobRecord                  = '    blob    %d   %s';
  SRowDataIsNotAvailable                   = '  ';
  SResolverIsNotSpecified                  = '    (ResultSet)   Resolver';
  SResultsetIsAlreadyOpened                = '  (Resultset)  ';
  SCanNotUpdateEmptyRow                    = '   ';
  SCanNotUpdateDeletedRow                  = '   ';
  SCanNotDeleteEmptyRow                    = '   ';
  SCannotUseCommit                         = '  COMMIT  AUTOCOMMIT ';
  SCannotUseRollBack                       = '  ROLLBACK  AUTOCOMMIT ';
  SCanNotUpdateComplexQuery                = '        ';
  SCanNotUpdateThisQueryType               = '    ';
  SDriverWasNotFound                       = '    ';
  SCanNotConnectToServer                   = '   SQL ';
  STableIsNotSpecified                     = '  ';
  SLiveResultSetsAreNotSupported           = '      ';
  SInvalidInputParameterCount              = '   is   ';
  SIsolationIsNotSupported                 = '    ';
  SColumnWasNotFound                       = '     "%s"';
  SWrongTypeForBlobParameter               = '   Blob ';
  SIncorrectConnectionURL                  = '  (URL)  : %s';
  SUnsupportedProtocol                     = ' : %s';
  SUnsupportedByDriver                     = '     : [%s]';

  SConnectionIsNotOpened                   = '  ';
  SInvalidOpInAutoCommit                   = '     (AutoCommit)';
  SInvalidOpInNonAutoCommit                = '      (non AutoCommit)';
  SInvalidOpPrepare                        = '      (!) StartTransaction';

  SConnectionIsNotAssigned                 = '    ';
  SQueryIsEmpty                            = 'SQL  ';
  SCanNotExecuteMoreQueries                = '    ';
  SOperationIsNotAllowed1                  = '       (FORWARD ONLY)';
  SOperationIsNotAllowed2                  = '        (READ ONLY)';
  SOperationIsNotAllowed3                  = '    %s ';
  SOperationIsNotAllowed4                  = '      ';
  SNoMoreRecords                           = '   (Resultset)  ';
  SCanNotOpenResultSet                     = '    (Resultset)';
  SCircularLink                            = '  (Datasource)   ';
  SBookmarkWasNotFound                     = ' (Bookmark)  ';
  SIncorrectSearchFieldsNumber             = '   Incorrect number of search field values';
  SInvalidOperationInTrans                 = '    ';
  SIncorrectSymbol                         = '     "%s".';
  SIncorrectToken                          = '   ":"';

  SSelectedTransactionIsolation            = '     ';
  SDriverNotSupported                      = '   %s';
  SPattern2Long                            = '  ';
  SDriverNotCapableOutParameters           = '    ';
  SStatementIsNotAllowed                   = '  ';
  SStoredProcIsNotAllowed                  = '   ';
  SCannotPerformOperation                  = '       (Resultset)';
  SInvalidState                            = ' ';
  SErrorConvertion                         = ' ';
  SDataTypeDoesNotSupported                = '   ';
  SUnsupportedParameterType                = '  ';
  SUnsupportedDataType                     = '  ';
  SErrorConvertionField                    = '    "%s"  SQLType "%s"';
  SBadOCI                                  = '  OCI [%s].   8.0.3  ';
  SConnect2AsUser                          = '   "%s"  "%s"';
  SUnknownError                            = ' ';
  SFieldNotFound1                          = ' "%s"  ';
  SFieldNotFound2                          = ' %d  ';

  SLoginPromptFailure                      = '     .   DBLogDlg   uses   .';

  SPropertyQuery                           = '        The Query may last a while on large databases!';
  SPropertyTables                          = '  (Catalog) /  (Schema)';
  SPropertyColumns                         = '   (Catalog),  (Schema) /  (TableName).';
  SPropertyProcedures                      = '  (Catalog) /  (Schema).';
  SPropertySequences                       = '  (Catalog) /  (Schema).';
  SPropertyExecute                         = '    ?';

  SFormTest                                = 'ZEOS SQL  ';
  SButtonClose                             = '&';
  SFormEditor                              = 'ZEOS SQL ';
  STabSheetSelect                          = ' SQL';
  SMenuLoad                                = '';
  SMenuSave                                = '';
  SButtonGenerate                          = '&';
  SButtonCheck                             = '&';
  SButtonTest                              = '&';
  SButtonOk                                = '&';
  SButtonCancel                            = '&';
  STableAlias                              = '& ';
  SReplaceSQL                              = '& SQL';
  SDialogOpenTitle                         = ' SQL ';
  SDialogSaveTitle                         = ' SQL ';
  SSQLEditor                               = 'SQL ';
  SDatabaseDialog                          = '  ';

  SUpdateSQLNoResult                       = '   (Refresh)   ';
  SUpdateSQLRefreshStatementcount          = 'Refresh     ';

{$IFDEF FPC}
  SNotEditing                              = '  (Dataset)      ';
  SFieldTypeMismatch                       = '    ''%s'',  %s : %s';
  SFieldSizeMismatch                       = '  ''%s''  , : %d : %d';
{$ENDIF}
  SNeedField               = 'Translate: Field %s is required, but not supplied.';

  SFailedtoInitPrepStmt                    = '   ';
  SFailedtoPrepareStmt                     = '     ';
  SFailedToBindAllValues                   = '  - ';
  SAttemptExecOnBadPrep                    = '     .';
  SBindingFailure                          = '   ';
  SPreparedStmtExecFailure                 = '   ';
  SBoundVarStrIndexMissing                 = '     "%s"  ';
  SBindVarOutOfRange                       = '     : %d';
  SFailedToBindResults                     = ' (bind)  ';

  SRefreshRowOnlySupportedWithUpdateObject = '   (RefreshRow)     ';
  SMustBeInBrowseMode                      = '      (dsBROWSE)';

  SUnKnownParamDataType                    = '   (Param.DataType)';
  //--- end added by ORMADA ----------------------------------------------------
  SFieldReadOnly          = 'Translate : Readonly field can''t be assigned a value: %d';
  SInvalidUpdateCount     = 'Translate : %d record(s) updated. Only one record should have been updated.';

{$ELSE}

//--- added by Petr Stasiak - pestasoft.com ------------------------------------
{$IFDEF CZECH}
  SSQLError1 = 'SQL chyba: %s';
  SSQLError2 = 'SQL chyba: %s kd: %d';
  SSQLError3 = 'SQL chyba: %s kd: %d SQL: %s';
  SSQLError4 = 'SQL chyba: %s kd: %d Hlen: %s';

  SListCapacityError = 'Kapacita seznamu je mimo rozsah (%d)';
  SListCountError = 'Poet seznam je mimo rozsah (%d)';
  SListIndexError = 'Index v seznamu je mimo rozsah (%d)';

  SClonningIsNotSupported = 'Klonovn nen v tto td podporovno';
  SImmutableOpIsNotAllowed = 'Tato operace nen povolena na nemniteln "collections"';
  SStackIsEmpty = 'Zsobnk je przdn';
  SVariableWasNotFound = 'Promn "%s" neexistuje';
  SFunctionWasNotFound = 'Funkce "%s" neexistuje';
  SInternalError = 'Intern chyba';
  SSyntaxErrorNear = 'Chybn syntaxe "%s"';
  SSyntaxError = 'Chybn syntaxe';
  SUnknownSymbol = 'Neznm symbol "%s"';
  SUnexpectedExprEnd = 'Neoekvan konec vrazu';
  SRightBraceExpected = ') oekvn(o/a/y)';
  SParametersError = '%d parametr oekvno, ale %d existuje';
  SExpectedMoreParams = 'Je oekvno vce, ne 2 parametry';
  SInvalidVarByteArray = 'Nesprvn VarByte array';
  SVariableAlreadyExists = 'Promn "%s" ji existuje';
  STypesMismatch = 'Nesouhlasn typy';
  SUnsupportedVariantType = 'Nepodporovan typ variant';
  SUnsupportedOperation = 'Nepodporovan operace';

  STokenizerIsNotDefined = 'Nen definovn "Tokenizer"';
  SLibraryNotFound = 'Neexistuje dll knihovna(y): %s';
  SEncodeDateIsNotSupported = 'Tato verze nepodporuje isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'Tato verze nepodporuje isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'Tato verze nepodporuje isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'Tato verze nepodporuje isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'Tato verze nepodporuje isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'Tato verze nepodporuje isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'Nelze zskat data "Resultset"';
  SRowBufferIsNotAssigned = 'Nen piazen dkov buffer';
  SColumnIsNotAccessable = 'Sloupec s indexem %d nen pstupn';
  SConvertionIsNotPossible = 'Pevod sloupce %d  nen mon z %s na %s';
  SCanNotAccessBlobRecord = 'Nelze pistupovat k blob zznamu ze zloupce %d pes typ %s';
  SRowDataIsNotAvailable = 'dkov data nejsou pstupn';
  SResolverIsNotSpecified = 'Nen specifikovn "rozklada" pro tento vsledek';
  SResultsetIsAlreadyOpened = '"Resultset" byl ji oteven';
  SCanNotUpdateEmptyRow = 'Nelze aktualizovat przdn dek';
  SCanNotUpdateDeletedRow = 'Nelze aktualizovat smazan dek';
  SCanNotDeleteEmptyRow = 'Nelze vymazat przdn dek';
  SCannotUseCommit = 'Nepouvejte COMMIT v mdu AUTOCOMMIT';
  SCannotUseRollBack = 'Nelze pout ROLLBACK v AUTOCOMMIT mdu';
  SCanNotUpdateComplexQuery = 'Nelze aktualizovat komplexn dotaz pro vce, ne jednu tabulku';
  SCanNotUpdateThisQueryType = 'Nelze aktualizovat tento typ dotazu';
  SDriverWasNotFound = 'Poadovan databzov ovlada nenalezen';
  SCanNotConnectToServer = 'Nezdailo se pipojen k SQL serveru';
  STableIsNotSpecified = 'Tabulka nen specifikovna';
  SLiveResultSetsAreNotSupported = '"iv" dotaz nen podporovn v tto td';
  SInvalidInputParameterCount = 'Poet vstupnch parametr neodpovd oekvanmu potu';
  SIsolationIsNotSupported = 'Mra izolace transakce nen podporovna';
  SColumnWasNotFound = 'Sloupec s nzvem "%s" neexistuje';
  SWrongTypeForBlobParameter = 'Nesprvn typ pro Blob parametr';
  SIncorrectConnectionURL = 'Nesprvn tvar URL adresy: %s';
  SUnsupportedProtocol = 'Nepodporovan protokol: %s';
  SUnsupportedByDriver    = 'Ovlada nepodporuje tuto vlastnost: [%s]';

  SConnectionIsNotOpened = 'Spojen nen oteveno';
  SInvalidOpInAutoCommit = 'Nesprvn operace v mdu AutoCommit';
  SInvalidOpInNonAutoCommit = 'Nesprvn operace v mdu NE AutoCommit';
  SInvalidOpPrepare = '"Prepare" transakce je mon pouze jako prvn! Starttransaction';

  SConnectionIsNotAssigned = 'Nen piazen komponent "connection"';
  SQueryIsEmpty = 'SQL dotaz je przdn';
  SCanNotExecuteMoreQueries = 'Nelze spustit vce, ne 1 dotaz';
  SOperationIsNotAllowed1 = 'Operace nen povolena v mdu "FORWARD ONLY"';
  SOperationIsNotAllowed2 = 'Operace nen povolena v mdu "READ ONLY"';
  SOperationIsNotAllowed3 = 'Operace nen povolena v mdu "%s"';
  SOperationIsNotAllowed4 = 'Operace nen povolena pro zaven zdroj dat (dataset)';
  SNoMoreRecords = 'Nejsou dal zznamy';
  SCanNotOpenResultSet = 'Nelze otevt vsledek dotazu';
  SCircularLink = 'Datasource vytv cyklick dotaz';
  SBookmarkWasNotFound = 'Zloka neexistuje';
  SIncorrectSearchFieldsNumber = 'Nesprvn poet vyhledvanch poloek';
  SInvalidOperationInTrans = 'Nesprvn operace v explicitnm transaknm mdu';
  SIncorrectSymbol = 'Nesprvn symbol v seznamu poloek "%s".';
  SIncorrectToken = 'Za ":" nsleduje nesprvn znak';

  SSelectedTransactionIsolation = 'Vybran mra izolace transakc nen podporovna';
  SDriverNotSupported = 'Ovlada %s nen podporovn';
  SPattern2Long = 'Pattern je pli dlouh';
  SDriverNotCapableOutParameters = 'Ovlada nen schopen pijmat parametry';
  SStatementIsNotAllowed = 'Pkaz nen povolen';
  SStoredProcIsNotAllowed = '"stored proc" nen povolena';
  SCannotPerformOperation = 'Nelze provst operaci na uzavenm vsledku dotazu (Resultset)';
  SInvalidState = 'Nesprvn stav';
  SErrorConvertion = 'Chyba pevodu';
  SDataTypeDoesNotSupported = 'Tento typ dat nen podporovn';
  SUnsupportedParameterType = 'Nepodporovan typ parametru';
  SUnsupportedDataType = 'Nepodporovan typ dat';
  SErrorConvertionField = 'Chyba pevodu sloupce "%s" na SQLTyp "%s"';
  SBadOCI = 'patn verze OCI [%s]. Je vyadovna 8.0.3 nebo star';
  SConnect2AsUser = 'Pipojit k "%s" jako "%s"';
  SUnknownError = 'Neznm chyba';
  SFieldNotFound1 = 'Sloupec "%s" neexistuje';
  SFieldNotFound2 = 'Sloupec %d neexistuje';

  SLoginPromptFailure = 'Nelze najt vchoz pihlaovac dialog. Prosm pidejte DBLogDlg do sekce USES vaeho zdrojovho souboru.';

  SPropertyQuery = 'Dotaz me bt posledn u vlelkch databz!';
  SPropertyTables = 'Mlo by bt limitovno katalogen a/nebo schmatem.';
  SPropertyColumns = 'Mlo by bt limitovno katalogem, schmatem a/nebo nzvem tabulky.';
  SPropertyProcedures = 'Mlo by bt limitovno katalogen a/nebo schmatem.';
  SPropertySequences = 'Mlo by bt limitovno katalogen a/nebo schmatem.';
  SPropertyExecute = 'M se dotaz pesto vykonat?';

  SFormTest = 'ZEOS SQL Editor Test';
  SButtonClose = '&Zavt';
  SFormEditor = 'ZEOS SQL Editor';
  STabSheetSelect = 'Select SQL';
  SMenuLoad = 'Nast';
  SMenuSave = 'Uloit';
  SButtonGenerate = '&Generovat';
  SButtonCheck = '&Kontrola';
  SButtonTest = '&Test';
  SButtonOk = '&OK';
  SButtonCancel = 'Z&ruit';
  STableAlias = '&Alias tabulky';
  SReplaceSQL = 'Nah&radit SQL';
  SDialogOpenTitle = 'Otevt SQL soubor';
  SDialogSaveTitle = 'Uloit SQL soubor';
  SSQLEditor = 'SQL Editor';
  SDatabaseDialog = 'Otevt existujc databzi';

  SUpdateSQLNoResult = 'Update Refresh SQL nevrtilo dn vsledek';
  SUpdateSQLRefreshStatementcount ='Poet Update Refresh SQL pkaz mus bt 1';

  {$IFDEF FPC}
  SNotEditing = 'Dataset nen v editanm (edit), ani vkldacm (insert) reimu';
  SFieldTypeMismatch = 'Nesprvn typ pro sloupec ''%s'', oekvno: %s aktuln: %s';
  SFieldSizeMismatch = 'Nesprvn velikost sloupce ''%s'', oekvno: %d aktuln: %d';
  {$ENDIF}
  SNeedField               = 'Sloupce %s je poadovn, ale nezadn.';

  SFailedtoInitPrepStmt   = 'Pipravovan pkaz nelze inicializovat';
  SFailedtoPrepareStmt    = 'Pkaz selhal bhem ppravy procesu';
  SFailedToBindAllValues  = 'Aplikace zkolabovala ped ppravou vech hodnot';
  SAttemptExecOnBadPrep   = 'Pokoute sespustit pkaz ped dokonenm jeho ppravy.';
  SBindingFailure         = 'Chyba pi zskvn sady parametr';
  SPreparedStmtExecFailure = 'Pipravovan pkaz selhal pi vykonvn';
  SBoundVarStrIndexMissing = 'Index textov promn "%s" neexistuje';
  SBindVarOutOfRange      = 'Index promen je mimo rozsah: %d';
  SFailedToBindResults    = 'Aplikace selhala pi zskvn vsledk dotazu';

//FOS+ 07112006
  SRefreshRowOnlySupportedWithUpdateObject = 'Metoda "refreshrow" je podporovna pouze v "update object"';
  SMustBeInBrowseMode = 'Operace je povolena pouze ve stavu dsBROWSE';

  SUnKnownParamDataType = 'Neznm parametr.typ dat (Param.DataType)';
  SFieldReadOnly        = 'Sloupec pouze pro ten neme bt piazen k hodnot: %d';
  SInvalidUpdateCount     = '%d zznam() aktualizovno. Pouze jeden zznam byl zmnn.';
//--- end added by Petr Stasiak - pestasoft.com ------------------------------------

{$ELSE}

//--- added by pawelsel --------------------------------------------------------
{$IFDEF POLISH}

  SSQLError1 = 'Bd SQL: %s';
  SSQLError2 = 'Bd SQL: %s Kod: %d';
  SSQLError3 = 'Bd SQL: %s Kod: %d SQL: %s';
  SSQLError4 = 'Bd SQL: %s Kod: %d Komunikat: %s';

  SListCapacityError = 'Przekroczona pojemno listy (%d)';
  SListCountError = 'Licznik listy poza zakresem (%d)';
  SListIndexError = 'Indeks listy poza zakresem (%d)';

  SClonningIsNotSupported = 'Ta klasa nie obsuguje klonowania';
  SImmutableOpIsNotAllowed = 'Niedozwolona operacja na niezmienialnych kolekcjach';
  SStackIsEmpty = 'Stos jest pusty';
  SVariableWasNotFound = 'Nie znaleziono zmiennej "%s"';
  SFunctionWasNotFound = 'Nie znaleziono funkcji "%s"';
  SInternalError = 'Bd wewntrzny';
  SSyntaxErrorNear = 'Bd skadni przy "%s"';
  SSyntaxError = 'Bd skadni';
  SUnknownSymbol = 'Nieznany symbol "%s"';
  SUnexpectedExprEnd = 'Nieoczekiwany koniec wyraenia';
  SRightBraceExpected = 'Oczekiwano znaku )';
  SParametersError = 'Oczekiwana ilo parametrw: %d, znaleziono: %d';
  SExpectedMoreParams = 'Oczekiwano wicej ni dwa parametry';
  SInvalidVarByteArray = 'Bdna tablica VarByte';
  SVariableAlreadyExists = 'Zmienna "%s" ju istnieje';
  STypesMismatch = 'Niezgodno typw';
  SUnsupportedVariantType = 'Nieznany typ danych';
  SUnsupportedOperation = 'Nieznana operacja';

  STokenizerIsNotDefined = 'Nie zdefiniowano tokenizera';
  SLibraryNotFound = 'Nie znaleziono adnej z bibliotek dynamicznych: %s';
  SEncodeDateIsNotSupported = 'Ta wersja nie obsuguje isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'Ta wersja nie obsuguje isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'Ta wersja nie obsuguje isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'Ta wersja nie obsuguje isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'Ta wersja nie obsuguje isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'Ta wersja nie obsuguje isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'Nie mona pobra danych wynikowych';
  SRowBufferIsNotAssigned = 'Nie przypisano bufora wiersza';
  SColumnIsNotAccessable = 'Kolumna o numerze %d jest niedostpna';
  SConvertionIsNotPossible = 'Konwersja kolumny o numerze %d z %s na %s jest niemoliwa';
  SCanNotAccessBlobRecord = 'Brak dostpu do rekordu typu blob w kolumnie %d z typem %s';
  SRowDataIsNotAvailable = 'Dane wiersza s niedostpne';
  SResolverIsNotSpecified = 'Ten ResultSet nie ma okrelonego Resolver-a';
  SResultsetIsAlreadyOpened = 'ResultSet jest ju otwarty';
  SCanNotUpdateEmptyRow = 'Nie mona aktualizowa pustego wiersza';
  SCanNotUpdateDeletedRow = 'Nie mona aktualizowa usunitego wiersza';
  SCanNotDeleteEmptyRow = 'Nie mona usun pustego wiersza';
  SCannotUseCommit = 'Nie mona uy COMMIT w trybie AUTOCOMMIT';
  SCannotUseRollBack = 'Nie mona uy ROLLBACK w trybie AUTOCOMMIT';
  SCanNotUpdateComplexQuery = 'Nie mona aktualizowa zapytania zoonego z wicej ni jednej tabeli';
  SCanNotUpdateThisQueryType = 'Nie mona aktualizowa tego typu zapytania';
  SDriverWasNotFound = 'Nie znaleziono wymaganego sterownika bazy danych';
  SCanNotConnectToServer = 'Nie mona poczy si z serwerem SQL';
  STableIsNotSpecified = 'Nie okrelono tabeli';
  SLiveResultSetsAreNotSupported = '"Live query" nie jest obsugiwane przez t klas';
  SInvalidInputParameterCount = 'Liczba parametrw wejsciowych jest mniejsza ni oczekiwana';
  SIsolationIsNotSupported = 'Poziom izolacji transakcji nie jest obsugiwany';
  SColumnWasNotFound = 'Nie znaleziono kolumny o nazwie "%s"';
  SWrongTypeForBlobParameter = 'Bdny typ parametru Blob';
  SIncorrectConnectionURL = 'Bdny URL poczenia: %s';
  SUnsupportedProtocol = 'Nieobsugiwany protok: %s';
  SUnsupportedByDriver    = 'Sterownik nie obsuguje tej waciwoci natywnie: [%s]';

  SConnectionIsNotOpened = 'Jeszcze nie nawizano poczenia';
  SInvalidOpInAutoCommit = 'Bdna operacja w trybie AutoCommit';
  SInvalidOpInNonAutoCommit = 'Bdna operacja przy wyczonym AutoCommit';
  SInvalidOpPrepare = 'Przygotowanie transakcji moliwe jest tylko przy pierwszym(!) Starttransaction';

  SConnectionIsNotAssigned = 'Nie przypisano komponentu poczenia do bazy danych';
  SQueryIsEmpty = 'Zapytanie SQL jest puste';
  SCanNotExecuteMoreQueries = 'Nie mona wykona wicej ni jednego zapytania';
  SOperationIsNotAllowed1 = 'Niedozwolona operacja w trybie FORWARD ONLY';
  SOperationIsNotAllowed2 = 'Niedozwolona operacja w trybie READ ONLY';
  SOperationIsNotAllowed3 = 'Niedozwolona operacja w trybie %s';
  SOperationIsNotAllowed4 = 'Niedozwolona operacja przy zamnitym rdle danych';
  SNoMoreRecords = 'Nie ma ju wicej rekordw wynikowych';
  SCanNotOpenResultSet = 'Nie mozna otworzy danych wynikowych';
  SCircularLink = 'Datasource tworzy powizanie cykliczne';
  SBookmarkWasNotFound = 'Nie znaleziono zakadki (Bookmark)';
  SIncorrectSearchFieldsNumber = 'Bdna liczba pl do wyszukiwania';
  SInvalidOperationInTrans = 'Bdna operacja w trybie transakcji';
  SIncorrectSymbol = 'Bdny symbol w licie pl "%s".';
  SIncorrectToken = 'Bdny wyraz za ":"';

  SSelectedTransactionIsolation = 'Wybrany poziom izolacji transakcji nie jest obsugiwany';
  SDriverNotSupported = 'Nie obsugiwany sterownik %s';
  SPattern2Long = 'Wzorzec jest zbyt dugi';
  SDriverNotCapableOutParameters = 'Sterownik nie potrafi obsuy parametrw';
  SStatementIsNotAllowed = 'Niedozwolone wyraenie';
  SStoredProcIsNotAllowed = 'Niedozwolona procedura skadowana';
  SCannotPerformOperation = 'Nie mona wykona operacji na zamknitym zbiorze danych';
  SInvalidState = 'Bdny stan';
  SErrorConvertion = 'Bd konwersji';
  SDataTypeDoesNotSupported = 'Nieobsugiwany typ dannych';
  SUnsupportedParameterType = 'Nieobsugiwany typ parametru';
  SUnsupportedDataType = 'Nieobsugiwany typ danych';
  SErrorConvertionField = 'Bd konwersji pola "%s" na SQLType "%s"';
  SBadOCI = 'Za wersja OCI [%s]. Wymagana wersja 8.0.3 lub starsza';
  SConnect2AsUser = 'Poczenie z "%s" jako uytkownik "%s"';
  SUnknownError = 'Nieznany bd';
  SFieldNotFound1 = 'Nie znaleziono pola "%s"';
  SFieldNotFound2 = 'Nie znaleziono pola %d';

  SLoginPromptFailure = 'Nie znaleziono domylnego dialogu logowania. Prosz doda DBLogDlg do sekcji uses gwnego pliku aplikacji.';

  SPropertyQuery = 'Zapytanie moe chwil potrwa na wikszej bazie danych!';
  SPropertyTables = 'Powiniene ucili Katalog i/lub Schemat.';
  SPropertyColumns = 'Powiniene ucili Katalog, Schemat i/lub NazwTabeli.';
  SPropertyProcedures = 'Powiniene ucili Katalog i/lub Schemat.';
  SPropertySequences = 'Powiniene ucili Katalog i/lub Schemat.';
  SPropertyExecute = 'Czy mimo to wykona zapytanie?';

  SFormTest = 'Test Edytora SQL ZEOS';
  SButtonClose = '&Zamknij';
  SFormEditor = 'Edytor SQL ZEOS';
  STabSheetSelect = 'Wybr SQL';
  SMenuLoad = 'aduj';
  SMenuSave = 'Zapisz';
  SButtonGenerate = '&Generuj';
  SButtonCheck = '&Sprawd';
  SButtonTest = '&Test';
  SButtonOk = '&OK';
  SButtonCancel = 'A&nuluj';
  STableAlias = '&Alias tabeli';
  SReplaceSQL = 'Za&mie SQL';
  SDialogOpenTitle = 'Otwrz plik SQL';
  SDialogSaveTitle = 'Zapisz plik SQL';
  SSQLEditor = 'Edytor SQL';
  SDatabaseDialog = 'Otwrz istniejc baz';

  SUpdateSQLNoResult = 'Update Refresh SQL nie zwrcio adnych danych';
  SUpdateSQLRefreshStatementcount ='Wyraenie Update Refresh SQL musi zwrci 1 rekord danych';

  {$IFDEF FPC}
  SNotEditing = 'Dataset nie jest w trybie "edit" lub "insert"';
  SFieldTypeMismatch = 'Niezgodno typw dla pola ''%s'', oczekiwano: %s otrzymano: %s';
  SFieldSizeMismatch = 'Niezgodno rozmiarw pola ''%s'', oczekiwano: %d otrzymano: %d';
  {$ENDIF}
  SNeedField               = 'Pole %s jest wymagane.';

  SFailedtoInitPrepStmt   = 'Nie udao si zainicjalizowa przygotowanego zapytania';
  SFailedtoPrepareStmt    = 'Bd w wyraeniu podczas procesu przygotowania';
  SFailedToBindAllValues  = 'Bd aplikacji podczas przypisywania danych';
  SAttemptExecOnBadPrep   = 'Prba uruchomienia wyraenia przed zakoczeniem przygotowywania.';
  SBindingFailure         = 'Bd przypisywania zbioru parametrw';
  SPreparedStmtExecFailure = 'Bd wykonania przygotowanego zapytania';
  SBoundVarStrIndexMissing = 'Nie istnieje zmienna licznikowa "%s"';
  SBindVarOutOfRange      = 'Warto zmiennej licznikowej poza zakresem: %d';
  SFailedToBindResults    = 'Bd aplikacji podczas czenia do wynikw zapytania';

//FOS+ 07112006
  SRefreshRowOnlySupportedWithUpdateObject = 'Metoda refreshrow jest obsugiwana tylko przez obiekt typu "update"';
  SMustBeInBrowseMode = 'Operacja jest dozwolona tylko w stanie dsBROWSE';

  SUnKnownParamDataType = 'Nieznany Param.DataType';
  SFieldReadOnly        = 'Nie mona przypisa do pola tylko do odczytu wartoci: %d';
  SInvalidUpdateCount     = 'Liczba zaktualizowanych rekordw: %d. tylko jeden rekord powinien by zaktualizowany.';

{$ELSE} // default: ENGLISH


  SSQLError1 = 'SQL Error: %s';
  SSQLError2 = 'SQL Error: %s Code: %d';
  SSQLError3 = 'SQL Error: %s Code: %d SQL: %s';
  SSQLError4 = 'SQL Error: %s Code: %d Message: %s';

  SListCapacityError = 'List capacity out of bounds (%d)';
  SListCountError = 'List count out of bounds (%d)';
  SListIndexError = 'List index out of bounds (%d)';

  SClonningIsNotSupported = 'Clonning is not supported by this class';
  SImmutableOpIsNotAllowed = 'The operation is not allowed on not changeable collections';
  SStackIsEmpty = 'Stack is empty';
  SVariableWasNotFound = 'Variable "%s" was not found';
  SFunctionWasNotFound = 'Function "%s" was not found';
  SInternalError = 'Internal error';
  SSyntaxErrorNear = 'Syntax error near "%s"';
  SSyntaxError = 'Syntax error';
  SUnknownSymbol = 'Unknown symbol "%s"';
  SUnexpectedExprEnd = 'Unexpected end of expression';
  SRightBraceExpected = ') expected';
  SParametersError = '%d parameters were expected but %d were found';
  SExpectedMoreParams = 'More than two parameters are expected';
  SInvalidVarByteArray = 'Invalid VarByte array';
  SVariableAlreadyExists = 'Variable "%s" already exists';
  STypesMismatch = 'Types mismatch';
  SUnsupportedVariantType = 'Unsupported variant type';
  SUnsupportedOperation = 'Unsupported operation';

  STokenizerIsNotDefined = 'Tokenizer is not defined';
  SLibraryNotFound = 'None of the dynamic libraries can be found: %s';
  SEncodeDateIsNotSupported = 'This version does not support isc_encode_sql_date';
  SEncodeTimeIsNotSupported = 'This version does not support isc_encode_sql_time';
  SEncodeTimestampIsNotSupported = 'This version does not support isc_encode_sql_timestamp';
  SDecodeDateIsNotSupported = 'This version does not support isc_decode_sql_date';
  SDecodeTimeIsNotSupported = 'This version does not support isc_decode_sql_time';
  SDecodeTimestampIsNotSupported = 'This version does not support isc_decode_sql_timestamp';

  SCanNotRetrieveResultSetData = 'Cannot retrieve Resultset data';
  SRowBufferIsNotAssigned = 'Row buffer is not assigned';
  SColumnIsNotAccessable = 'Column with index %d is not accessable';
  SConvertionIsNotPossible = 'Convertion is not possible for column %d from %s to %s';
  SCanNotAccessBlobRecord = 'Cannot access blob record in column %d with type %s';
  SRowDataIsNotAvailable = 'Row data is not available';
  SResolverIsNotSpecified = 'Resolver is not specified for this ResultSet';
  SResultsetIsAlreadyOpened = 'Resultset is already open';
  SCanNotUpdateEmptyRow = 'Cannot update an empty row';
  SCanNotUpdateDeletedRow = 'Cannot update a deleted row';
  SCanNotDeleteEmptyRow = 'Cannot delete an empty row';
  SCannotUseCommit = 'You cannot use COMMIT in AUTOCOMMIT mode';
  SCannotUseRollBack = 'You cannot use ROLLBACK in AUTOCOMMIT mode';
  SCanNotUpdateComplexQuery = 'Cannot update a complex query with more then one table';
  SCanNotUpdateThisQueryType = 'Cannot update this query type';
  SDriverWasNotFound = 'Requested database driver was not found';
  SCanNotConnectToServer = 'Cannot connect to SQL server';
  STableIsNotSpecified = 'Table is not specified';
  SLiveResultSetsAreNotSupported = 'Live query is not supported by this class';
  SInvalidInputParameterCount = 'Input parameter count is less then expected';
  SIsolationIsNotSupported = 'Transaction isolation level is not supported';
  SColumnWasNotFound = 'Column with name "%s" was not found';
  SWrongTypeForBlobParameter = 'Wrong type for Blob parameter';
  SIncorrectConnectionURL = 'Incorrect connection URL: %s';
  SUnsupportedProtocol = 'Unsupported protocol: %s';
  SUnsupportedByDriver    = 'Driver can not support this feature natively: [%s]';

  SConnectionIsNotOpened = 'Connection is not opened yet';
  SInvalidOpInAutoCommit = 'Invalid operation in AutoCommit mode';
  SInvalidOpInNonAutoCommit = 'Invalid operation in non AutoCommit mode';
  SInvalidOpPrepare = 'Prepare transaction only possible on matching first(!) Starttransaction';

  SConnectionIsNotAssigned = 'Database connection component is not assigned';
  SQueryIsEmpty = 'SQL Query is empty';
  SCanNotExecuteMoreQueries = 'Cannot execute more then one query';
  SOperationIsNotAllowed1 = 'Operation is not allowed in FORWARD ONLY mode';
  SOperationIsNotAllowed2 = 'Operation is not allowed in READ ONLY mode';
  SOperationIsNotAllowed3 = 'Operation is not allowed in %s mode';
  SOperationIsNotAllowed4 = 'Operation is not allowed for closed dataset';
  SNoMoreRecords = 'No more records in the Resultset';
  SCanNotOpenResultSet = 'Can not open a Resultset';
  SCircularLink = 'Datasource makes a circular link';
  SBookmarkWasNotFound = 'Bookmark was not found';
  SIncorrectSearchFieldsNumber = 'Incorrect number of search field values';
  SInvalidOperationInTrans = 'Invalid operation in explicit transaction mode';
  SIncorrectSymbol = 'Incorrect symbol in field list "%s".';
  SIncorrectToken = 'Incorrect token followed by ":"';

  SSelectedTransactionIsolation = 'Selected transaction isolation level is not supported';
  SDriverNotSupported = 'Driver not supported %s';
  SPattern2Long = 'Pattern is too long';
  SDriverNotCapableOutParameters = 'Driver is not capable to handle parameters';
  SStatementIsNotAllowed = 'Statement is not allowed';
  SStoredProcIsNotAllowed = 'The stored proc is not allowed';
  SCannotPerformOperation = 'Can not perform operation on closed Resultset';
  SInvalidState = 'Invalid state';
  SErrorConvertion = 'Convertion error';
  SDataTypeDoesNotSupported = 'Data type is not supported';
  SUnsupportedParameterType = 'Unsupported parameter type';
  SUnsupportedDataType = 'Unsupported data type';
  SErrorConvertionField = 'Conversion error for field "%s" to SQLType "%s"';
  SBadOCI = 'Bad OCI version [%s]. Version 8.0.3 or older is required';
  SConnect2AsUser = 'Connect to "%s" as user "%s"';
  SUnknownError = 'Unknown error';
  SFieldNotFound1 = 'Field "%s" was not found';
  SFieldNotFound2 = 'Field %d was not found';

  SLoginPromptFailure = 'Can not find default login prompt dialog. Please add DBLogDlg to the uses section of your main file.';

  SPropertyQuery = 'The Query may last a while on large databases!';
  SPropertyTables = 'You should limit it by Catalog and/or Schema.';
  SPropertyColumns = 'You should limit it by Catalog, Schema and/or TableName.';
  SPropertyProcedures = 'You should limit it by Catalog and/or Schema.';
  SPropertySequences = 'You should limit it by Catalog and/or Schema.';
  SPropertyExecute = 'Should the Query be executed anyway?';

  SFormTest = 'ZEOS SQL Editor Test';
  SButtonClose = '&Close';
  SFormEditor = 'ZEOS SQL Editor';
  STabSheetSelect = 'Select SQL';
  SMenuLoad = 'Load';
  SMenuSave = 'Save';
  SButtonGenerate = '&Generate';
  SButtonCheck = 'C&heck';
  SButtonTest = '&Test';
  SButtonOk = '&OK';
  SButtonCancel = '&Cancel';
  STableAlias = 'T&able alias';
  SReplaceSQL = '&Replace SQL';
  SDialogOpenTitle = 'Open SQL File';
  SDialogSaveTitle = 'Save SQL File';
  SSQLEditor = 'SQL Editor';
  SDatabaseDialog = 'Open existing database';

  SUpdateSQLNoResult = 'Update Refresh SQL delivered no resultset';
  SUpdateSQLRefreshStatementcount ='Update Refresh SQL Statement count must be 1';

  {$IFDEF FPC}
  SNotEditing = 'Dataset not in edit or insert mode';
  SFieldTypeMismatch = 'Type mismatch for field ''%s'', expecting: %s actual: %s';
  SFieldSizeMismatch = 'Size mismatch for field ''%s'', expecting: %d actual: %d';
  {$ENDIF}
  SNeedField               = 'Field %s is required, but not supplied.';

  SFailedtoInitPrepStmt   = 'Prepared statement failed to initialize';
  SFailedtoPrepareStmt    = 'Statement failed during prepare process';
  SFailedToBindAllValues  = 'Application failed to pre-bind all values';
  SAttemptExecOnBadPrep   = 'Attempt made to execute a statement before a successful preparation.';
  SBindingFailure         = 'Failed to bind parameter set';
  SPreparedStmtExecFailure = 'Prepared statement failed to execute';
  SBoundVarStrIndexMissing = 'Bound variable text index "%s" does not exist';
  SBindVarOutOfRange      = 'Bound variable index out of range: %d';
  SFailedToBindResults    = 'Application failed to bind to the result set';

//FOS+ 07112006
  SRefreshRowOnlySupportedWithUpdateObject = 'The refreshrow method is only supported with an update object';
  SMustBeInBrowseMode = 'Operation is only allowed in dsBROWSE state';

  SUnKnownParamDataType = 'Unknown Param.DataType';
  SFieldReadOnly        = 'Readonly field can''t be assigned a value: %d';
  SInvalidUpdateCount     = '%d record(s) updated. Only one record should have been updated.';

{$ENDIF} // POLISH

{$ENDIF} // CZECH

{$ENDIF} // RUSSIAN

{$ENDIF}   // INDONESIAN <--- added by tohenk

{$ENDIF}   // ROMANA

{$ENDIF} //SPANISH

{$ENDIF} // GERMAN

{$ENDIF} // DUTCH

{$ENDIF} // PORTUGUESE

implementation

end.
