USE [Biblioteka]
GO

drop table Ksiazki;
go

/****** Object:  Table [dbo].[Ksiazki]    Script Date: 07/30/2008 16:36:31 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Ksiazki](
	[idksiazki] [int] IDENTITY(1,1) NOT NULL,
	[idautora] [int] NOT NULL,
	[idautora2] [int] NULL,
	[idwydaw] [int] NOT NULL,
	[rokwydania] [int] NULL,
	[tytul] [nchar](50) NOT NULL,
	[tytul2] [nchar](50) NULL,
	[cena] [numeric](18, 2) NULL,
 CONSTRAINT [PK_Ksiazki] PRIMARY KEY CLUSTERED 
(
	[idksiazki] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE ksiazki add constraint FK_KSIAZKI_IDWYDAW  FOREIGN KEY(idwydaw)  references WYDAWNICTWA(IDWYDAW) ON DELETE NO ACTION;
ALTER TABLE ksiazki add constraint FK_KSIAZKI_IDAUTORA FOREIGN KEY(idautora) references AUTORZY(idautora) ON DELETE NO ACTION;

insert into KSIAZKI(idautora, IDWYDAW, rokwydania, tytul) values(1, 1, 2002, 'Delphi Almanach');

insert into KSIAZKI(idautora, IDWYDAW, rokwydania, tytul) values(2, 2, 2000, 'Programowanie w Delphi 5');

insert into KSIAZKI(idautora, idautora2, IDWYDAW, rokwydania, tytul, tytul2) values(3, 3, 1, 2002, 'Projektowanie zorientowane obiektowo', 'Wzorce projektowe');

insert into KSIAZKI(idautora, idautora2, IDWYDAW, rokwydania, tytul, tytul2) values(4, 5, 1, 2002, 'Delphi 6', 'Vademecum profesjonalisty');

insert into KSIAZKI(idautora, IDWYDAW, rokwydania, tytul, tytul2) values(5, 1, 2002, 'Delphi 6', 'Praktyka programowania');

insert into KSIAZKI(idautora, IDWYDAW, rokwydania, tytul, tytul2) values(6, 1, 1999, 'Delphi 4', 'Tworezenie systemw bazodanowych');

insert into KSIAZKI(idautora, IDWYDAW, rokwydania, tytul) values(7, 1, 1996, 'SQL');

insert into KSIAZKI(idautora, IDWYDAW, rokwydania, tytul) values(8, 1, 2001, 'SQL w InterBase dla Windows i Linuksa');


select * from Ksiazki;

