use biblioteka;

drop table ksiazki;

CREATE TABLE ksiazki
(
idksiazki   int unsigned not null auto_increment primary key,
idautora	int unsigned not null,
idautora2	int unsigned,
idwydaw		int unsigned NOT NULL,
rokwydania	int unsigned,
tytul		char(50) NOT NULL,
tytul2		char(50) default null,
cena		decimal(4,2)
);
alter table ksiazki type=innodb;

create index ksiazki_idautora   on ksiazki(idautora);
create index ksiazki_idautora2  on ksiazki(idautora2);
create index ksiazki_idwydaw    on ksiazki(idwydaw);
create index ksiazki_rokwydania on ksiazki(rokwydania);
create index ksiazki_tytul      on ksiazki(tytul);
create index ksiazki_tytul2     on ksiazki(tytul2);

ALTER TABLE ksiazki add constraint FK_ksiazki_idwydaw  FOREIGN KEY(idwydaw)  references wydawnictwa(idwydaw) ON DELETE NO ACTION;
ALTER TABLE ksiazki add constraint FK_ksiazki_IDAUTORA FOREIGN KEY(idautora) references autorzy(idautora)    ON DELETE NO ACTION;

insert into ksiazki(idautora, idwydaw, rokwydania, tytul) values(1, 1, 2002, 'Delphi Almanach');
insert into ksiazki(idautora, idwydaw, rokwydania, tytul) values(2, 2, 2000, 'Programowanie w Delphi 5');
insert into ksiazki(idautora, idautora2, idwydaw, rokwydania, tytul, tytul2) values(3, 3, 1, 2002, 'Projektowanie zorientowane obiektowo', 'Wzorce projektowe');
insert into ksiazki(idautora, idautora2, idwydaw, rokwydania, tytul, tytul2) values(4, 5, 1, 2002, 'Delphi 6', 'Vademecum profesjonalisty');
insert into ksiazki(idautora, idwydaw, rokwydania, tytul, tytul2) values(5, 1, 2002, 'Delphi 6', 'Praktyka programowania');
insert into ksiazki(idautora, idwydaw, rokwydania, tytul, tytul2) values(6, 1, 1999, 'Delphi 4', 'Tworezenie systemw bazodanowych');
insert into ksiazki(idautora, idwydaw, rokwydania, tytul) values(7, 1, 1996, 'SQL');
insert into ksiazki(idautora, idwydaw, rokwydania, tytul) values(8, 1, 2001, 'SQL w InterBase dla Windows i Linuksa');



select idksiazki, tytul, format(cena, 2 ) from ksiazki;
select * from ksiazki;
--show columns from ksiazki;
