unit UserPlot;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TUserPlotFunc = procedure(X: Real; var Y: Real) of Object;
  TFuncGraph = class(TGraphicControl)
  private
    FRangeMinX: Integer;
    FRangeMaxX: Integer;
    FRangeMinY: Integer;
    FRangeMaxY: Integer;
    FUserFunc: TUserPlotFunc;
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property RangeMinX: Integer read FRangeMinX write FRangeMinX;
    property RangeMaxX: Integer read FRangeMaxX write FRangeMaxX;
    property RangeMinY: Integer read FRangeMinY write FRangeMinY;
    property RangeMaxY: Integer read FRangeMaxY write FRangeMaxY;
    property OnUserFunc: TUserPlotFunc read FUserFunc write FUserFunc;
    property Width default 50;
    property Height default 50;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Additional', [TFuncGraph]);
end;

constructor TFuncGraph.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 Height := 50;
 Width := 50;
 FRangeMaxX := 1;
 FRangeMaxY := 1;
end;

procedure TFuncGraph.Paint;
var
 X, Y: Integer; { wsprzedne rzeczywiste }
 RX, RY: Real;  { wsprzdne uytkownika }
begin
 inherited Paint;
 Canvas.Rectangle(0,0,Width,Height);
 for X := 1 to Width do
 begin
  { konwersja wsprzdnej X }
  RX := FRangeMinX + (((FRangeMaxX - FRangeMinX)/Width)*X);

  { sprawdzamy, czy istnieje funkcja zdefiniowana przez uytkownika;
    jeli tak, to j wywoujemy }
  if Assigned(FUserFunc) then
   FUserFunc(RX,RY)
  else
   RY := 0;

  { konwersja wsprzednej Y, operacja rysowania }
  Y := Round((1 - ((RY-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height);
  if X = 1 then
   Canvas.MoveTo(X,Y)
  else
   Canvas.LineTo(X,Y)

 end;
end;


end.
