unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    DrawPoly: TButton;
    NumSides: TEdit;
    Label1: TLabel;
    procedure DrawPolyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DrawPolyClick(Sender: TObject);
const
 PI = 3.14159;
var
 Sides: Integer;
 Count: Integer;
 PolyArray: array[0..15] of TPoint;
begin
 Sides := StrToInt(NumSides.Text);
 for Count := 0 to Sides do
  begin
   PolyArray[Count] :=
     Point(Trunc((sin(2*PI*Count/Sides)) * 30) + (Form1.Width div 2),
           Trunc((cos(2*PI*Count/Sides)) * 30) + (Form1.Height div 2));
  end;
 for Count := Sides + 1 to 15 do
  PolyArray[Count] := PolyArray[0];

 Form1.Canvas.PolyLine(PolyArray);
end;

end.
 