unit Picprint;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, ExtCtrls, Printers;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Image1: TImage;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    PHeight, PWidth: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
 PrnRect, ImgRect: TRect;
 CenterX, CenterY, X1, X2, Y1, Y2, SDiv: Integer;
begin
 Panel1.Caption := 'Printing...';
 Printer.BeginDoc;
 { Obliczamy wsprzdne rodka strony }
 PHeight := Printer.PageHeight;
 PWidth := Printer.PageWidth;
 CenterX := PWidth div 2;
 CenterY := PHeight div 2;
 { Obliczmy wprzdne drukowanego obszaru.
   Uwzgledniamy wspczynnik pomniejszenia }
 SDiv := SpinEdit1.Value;
 X1 := CenterX - (PWidth Div (SDiv*2));
 X2 := CenterX + (PWidth Div (SDiv*2));
 Y1 := CenterY - (PHeight Div (SDiv*2));
 Y2 := CenterY + (PHeight Div (SDiv*2));
 { Zapamitujemy je w zmiennej PrnRect }
 PrnRect := Rect(X1,Y1,X2,Y2);
 { Wsprzdne obiektu Image1 do zmiennej ImgRect }
 ImgRect := Rect(0,0,Image1.Width,Image1.Height);
 { Kopiujemy obraz z ekranu na drukark }
 Printer.Canvas.CopyRect(PrnRect, Image1.Canvas, ImgRect);
 Printer.EndDoc;
 Panel1.Caption := 'Printing Complete!';
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
 begin
  Label2.Visible := False;
  Image1.Picture.LoadFromFile(OpenDialog1.FileName);
 end;
end;


end.
