unit Prndlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Printers;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    FontDialog1: TFontDialog;
    Button3: TButton;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    Fname: String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
 begin
  Fname := OpenDialog1.FileName;
  Label1.Caption := 'Ready To Print: ' + Fname;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
 F: TextFile;
 TempStr, PageNum: String;
 Ctr, X, PHeight, LineSpace, LinesPerPage, CopyNum, NumCopies: Integer;
begin
 if PrintDialog1.Execute then
 begin
  Ctr := 1;
  AssignFile(F, Fname); { Zwizujemy zmienn z plikiem tekstowym }
  NumCopies := PrintDialog1.Copies;
  for CopyNum := 1 to NumCopies do
  begin
   Reset(F);             { Otwieramy plik }
   Ctr := 1; x := 0;
   Printer.BeginDoc;               { Rozpoczynamy proces drukowania }
   PHeight := Printer.PageHeight;  { Wysoko strony }
   Printer.Canvas.Font.Size := FontDialog1.Font.Size;
   Printer.Canvas.Font.Name := FontDialog1.Font.Name;
   Printer.Canvas.Font.Style := FontDialog1.Font.Style;
   { obliczamy liczb wierszy }
   LinesPerPage := PHeight div (Printer.Canvas.Font.Size * 2);
   { obliczamy odstp midzy wierszami }
   LineSpace := PHeight div LinesPerPage;
   PageNum := IntToStr(Printer.PageNumber);   { Numer strony }
   Label1.Caption := 'Now Printing ' + PageNum + ' Page ';
   while not Eof(F) do
   begin
    Readln(F, TempStr);      { Pobieramy z pliku kolejny wiersz }
    Printer.Canvas.TextOut(0,x,TempStr);  { Drukujemy go }
    x := x + LineSpace;                   { Zwikszamy wsprzdna pionow }
    Ctr := Ctr + 1;                       { Zwikszamy licznik wierszy }
     if Ctr > LinesPerPage then           { Jeli koniec strony... }
     begin
      Printer.NewPage;     { Nowa strona }
      x := 0;
      Ctr := 0;
      PageNum := IntToStr(Printer.PageNumber);
      Label1.Caption := 'Now Printing ' + PageNum + ' Page ';
     end;
   end;
   Printer.EndDoc;    { Wysanie danych na drukark }
   CloseFile(F);
   Label1.Caption := 'Printing Complete!';
   Label2.Caption := 'Number of Copies = ' + IntToStr(NumCopies);
  end;
 end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 FontDialog1.Execute;
end;

end.
