unit Edit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 Memo1.Text := '';
end;

procedure TForm1.Open1Click(Sender: TObject);
var
 InFile: TextFile;
 fname, InString: String;
begin
 if OpenDialog1.Execute then
 begin
  fname := OpenDialog1.FileName;
  AssignFile(InFile, fname);
  Reset(InFile);
   while not Eof(Infile) do
   begin
    Readln(InFile, InString);
    Memo1.Lines.Add(InString);
   end;
  CloseFile(InFile);
  Form1.Caption := 'Edit [ ' + fname + ' ]';
 end;
end;

procedure TForm1.Save1Click(Sender: TObject);
var
 OutFile: TextFile;
 fname: String;
begin
 if SaveDialog1.Execute then
 begin
  fname := SaveDialog1.FileName;
  AssignFile(OutFile, fname);
  Rewrite(OutFile);
  Writeln(OutFile, Memo1.Text);
  CloseFile(OutFile);
  Form1.Caption := 'Edit [ ' + fname + ' ]';
 end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
 Application.Terminate;
end;


end.
