unit ActXClockImpl;

interface

uses
  Windows, ActiveX, Classes, Controls, Graphics, Menus, Forms, StdCtrls,
  ComServ, StdVCL, AXCtrls, Project1Lib, Tbc;

type
  TActXClockX = class(TActiveXControl, IActXClockX)
  private
    { Private declarations }
    FDelphiControl: TButClock;
    FEvents: IActXClockXEvents;
  protected
    { Protected declarations }
    procedure InitializeControl; override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    function Get_Cancel: WordBool; safecall;
    function Get_Caption: WideString; safecall;
    function Get_Cursor: Smallint; safecall;
    function Get_Default: WordBool; safecall;
    function Get_DragCursor: Smallint; safecall;
    function Get_DragMode: TxDragMode; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_Font: Font; safecall;
    function Get_ModalResult: Integer; safecall;
    function Get_Visible: WordBool; safecall;
    procedure Click; safecall;
    procedure Set_Cancel(Value: WordBool); safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    procedure Set_Cursor(Value: Smallint); safecall;
    procedure Set_Default(Value: WordBool); safecall;
    procedure Set_DragCursor(Value: Smallint); safecall;
    procedure Set_DragMode(Value: TxDragMode); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_Font(const Value: Font); safecall;
    procedure Set_ModalResult(Value: Integer); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    procedure MakeBold; safecall;
  end;

implementation

{ TActXClockX }

procedure TActXClockX.InitializeControl;
begin
  FDelphiControl := Control as TButClock;
end;

procedure TActXClockX.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IActXClockXEvents;
end;

procedure TActXClockX.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  { Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_ActXClockXPage); }
end;

function TActXClockX.Get_Cancel: WordBool;
begin
  Result := FDelphiControl.Cancel;
end;

function TActXClockX.Get_Caption: WideString;
begin
  Result := WideString(FDelphiControl.Caption);
end;

function TActXClockX.Get_Cursor: Smallint;
begin
  Result := Smallint(FDelphiControl.Cursor);
end;

function TActXClockX.Get_Default: WordBool;
begin
  Result := FDelphiControl.Default;
end;

function TActXClockX.Get_DragCursor: Smallint;
begin
  Result := Smallint(FDelphiControl.DragCursor);
end;

function TActXClockX.Get_DragMode: TxDragMode;
begin
  Result := Ord(FDelphiControl.DragMode);
end;

function TActXClockX.Get_Enabled: WordBool;
begin
  Result := FDelphiControl.Enabled;
end;

function TActXClockX.Get_Font: Font;
begin
  GetOleFont(FDelphiControl.Font, Result);
end;

function TActXClockX.Get_ModalResult: Integer;
begin
  Result := Integer(FDelphiControl.ModalResult);
end;

function TActXClockX.Get_Visible: WordBool;
begin
  Result := FDelphiControl.Visible;
end;

procedure TActXClockX.Click;
begin

end;

procedure TActXClockX.Set_Cancel(Value: WordBool);
begin
  FDelphiControl.Cancel := Value;
end;

procedure TActXClockX.Set_Caption(const Value: WideString);
begin
  FDelphiControl.Caption := TCaption(Value);
end;

procedure TActXClockX.Set_Cursor(Value: Smallint);
begin
  FDelphiControl.Cursor := TCursor(Value);
end;

procedure TActXClockX.Set_Default(Value: WordBool);
begin
  FDelphiControl.Default := Value;
end;

procedure TActXClockX.Set_DragCursor(Value: Smallint);
begin
  FDelphiControl.DragCursor := TCursor(Value);
end;

procedure TActXClockX.Set_DragMode(Value: TxDragMode);
begin
  FDelphiControl.DragMode := TDragMode(Value);
end;

procedure TActXClockX.Set_Enabled(Value: WordBool);
begin
  FDelphiControl.Enabled := Value;
end;

procedure TActXClockX.Set_Font(const Value: Font);
begin
  SetOleFont(FDelphiControl.Font, Value);
end;

procedure TActXClockX.Set_ModalResult(Value: Integer);
begin
  FDelphiControl.ModalResult := TModalResult(Value);
end;

procedure TActXClockX.Set_Visible(Value: WordBool);
begin
  FDelphiControl.Visible := Value;
end;

procedure TActXClockX.MakeBold;
begin
  FDelphiControl.Font.Style := [fsBold];
end;

initialization
  TActiveXControlFactory.Create(
    ComServer,
    TActXClockX,
    TButClock,
    Class_ActXClockX,
    1,
    '');
end.

