unit Filepobj;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Printers;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    FontDialog1: TFontDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    Fname: String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
 begin
  Fname := OpenDialog1.FileName;
  Label1.Caption := 'Ready To Print: ' + Fname;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
 F: TextFile;
 TempStr, PageNum: String;
 Ctr, X, PHeight, LineSpace: Integer;
begin
 Ctr := 1; x := 0;
 AssignFile(F, Fname); { Zwizujemy zmienn z plikiem tekstowym }
 Reset(F);             { Otwieramy plik }

 Printer.BeginDoc;               { Rozpoczynamy proces drukowania }
 PHeight := Printer.PageHeight;  { Wysoko strony }
 LineSpace := PHeight div 60;    { Obliczamy odstp midzy wierszami }
 PageNum := IntToStr(Printer.PageNumber);   { Numer strony }
 Label1.Caption := 'Now Printing ' + PageNum + ' Page ';
 while not Eof(F) do
 begin
  Readln(F, TempStr);      { Pobieramy z pliku kolejny wiersz }
  Printer.Canvas.TextOut(0,x,TempStr);  { Drukujemy go }
  x := x + LineSpace;                   { Zwikszamy wsprzdna pionow }
  Ctr := Ctr + 1;                       { Zwikszamy licznik wierszy }
    if Ctr > 59 then           { Jeli koniec strony... }
    begin
     Printer.NewPage;     { Nowa strona }
     x := 0;
     Ctr := 0;
     PageNum := IntToStr(Printer.PageNumber);
     Label1.Caption := 'Now Printing ' + PageNum + ' Page ';
    end;
 end;
 Printer.EndDoc;    { Wysanie danych na drukark }
 CloseFile(F);
 Label1.Caption := 'Printing Complete!';
end;

end.
