unit Standard;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus,
  Addition;

type
  TStandardTab = class(TForm)
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    PopupMenu1: TPopupMenu;
    Label1: TLabel;
    Edit1: TEdit;
    Memo1: TMemo;
    RadioGroup1: TRadioGroup;
    ScrollBar1: TScrollBar;
    ComboBox1: TComboBox;
    ListBox1: TListBox;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    Help2: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    N11: TMenuItem;
    N21: TMenuItem;
    procedure RadioGroup1Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  StandardTab: TStandardTab;

implementation

{$R *.DFM}

procedure TStandardTab.RadioGroup1Click(Sender: TObject);
begin
 if RadioGroup1.ItemIndex = 0 then StandardTab.Color := clSilver;
 if RadioGroup1.ItemIndex = 1 then StandardTab.Color := clBlue;
 if RadioGroup1.ItemIndex = 2 then StandardTab.Color := clYellow;
 if RadioGroup1.ItemIndex = 3 then StandardTab.Color := clRed;
end;

procedure TStandardTab.ScrollBar1Change(Sender: TObject);
begin
 RadioGroup1.ItemIndex := ScrollBar1.Position;
end;

procedure TStandardTab.Button1Click(Sender: TObject);
var
 x: Integer;
begin
 { zerujemy obiekt Memo1 }
 Memo1.Clear;
 { dodajemy zawarto pola Edit1 }
 Memo1.Lines.Add(Edit1.Text);
 { dodajemy zawarto listy ComboBox1 }
 Memo1.Lines.Add(ComboBox1.Text);
 { dodajemy numer wskazywanego elementu listy ListBox1 }
 Memo1.Lines.Add('ListBox String  #' + IntToStr(ListBox1.ItemIndex+ 1));
 { w zalenoci od pl opcji ustalamy kolor obiektu Memo1 }
 if RadioButton1.Checked then Memo1.Color := clWhite;
 if RadioButton2.Checked then Memo1.Color := clAqua;
end;

procedure TStandardTab.Button2Click(Sender: TObject);
begin
 if CheckBox1.State = cbChecked then
  StandardTab.Font.Style := [fsItalic]
 else
  StandardTab.Font.Style := [];
 if CheckBox2.State = cbChecked then
  StandardTab.Font.Color := clPurple
 else
  StandardTab.Font.Color := clBlack;
end;

procedure TStandardTab.Button3Click(Sender: TObject);
begin
 Close;
end;

procedure TStandardTab.Button4Click(Sender: TObject);
begin
 StandardTab.Hide;
 AdditionalTab.Show;
end;

end.
