from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import numpy as np
from tensorflow.keras.callbacks import Callback
from scipy.optimize import linear_sum_assignment

def unsupervised_labels(y, yp, n_classes, n_clusters):
    """Algorytm przypisania liniowego

    Argumenty:
        y (tensor): etykiety referencyjne
        yp (tensor): prognozowane klastry (grupy)
        n_classes (int): liczba klas 
        n_clusters (int): liczba grup
    """
    assert n_classes == n_clusters

    # inicjalizacja macierzy zliczeń
    C = np.zeros([n_clusters, n_classes])

    # wypełnienie macierzy zliczeń
    for i in range(len(y)):
        C[int(yp[i]), int(y[i])] += 1

    # Optymalna permutacja z użyciem algorytmu węgierskiego
    # wyższa wartość zliczenia oznacza mniejszy koszt,
    # więc używamy –C do liniowego przypisania.
    row, col = linear_sum_assignment(-C)

    # obliczenie dokładności
    accuracy = C[row, col].sum() / C.sum()

    return accuracy * 100

def center_crop(image, crop_size=4):
    """Przycina obraz względem środka
    Argument:
        crop_size (int): Liczba pikseli do przycięcia z każdej strony.
    """
    height, width = image.shape[0], image.shape[1]
    x = height - crop_size
    y = width - crop_size
    dx = dy = crop_size // 2
    image = image[dy:(y + dy), dx:(x + dx), :]
    return image


def lr_schedule(epoch):
    """Proste harmonogramowanie współczynnika uczenia

    Argument:
        epoch (int): Na której epoce 
    """
    lr = 1e-3
    power = epoch // 400
    lr *= 0.8**power

    return lr


class AccuracyCallback(Callback):
    """Wywołanie zwrotne do obliczenia dokładności każdej epoki przez wywołanie
        metody eval().

    Argument:
        net (Model): Obiekt z modelem sieci do oceny. 
            Musi obsługiwać metodę eval().
    """
    def __init__(self, net):
        super(AccuracyCallback, self).__init__()
        self.net = net 

    def on_epoch_end(self, epoch, logs=None):
        self.net.eval()


