# Zaawansowane uczenie głębokie z TensorFlow 2 i Keras (Wydanie 2, zaktualizowane)

Ten zasób zawiera kody do książki [Zaawansowane uczenie głębokie z TensorFlow 2 i Keras, Wydanie 2, zaktualizowane](ftp - zaktualizować na Helion), opublikowanej przez [Helion](http://helion.pl). Znajdują się w nim wszysktie pliki niezbędne do uruchomienia projektów zawartych w książce.

**Zwróć uwagę, że przykłady kodów zostały zaktualizowane i działają tylko z API TensorFlow 2.0 Keras.**

## O książce
Zaawansowane uczenie głębokie z TensorFlow 2 i Keras (Wydanie 2) jest kompletnie zaktualizowanym wydaniem bestsellerowego podręcznika dotyczącego dostępnych obecnie, zaawansowanych technik uczenia głębokiego. Edycja ta, przygotowana pod kątem Tensorflow 2.x, wprowadzi Cię do praktycznych aspektów uczenia głębokiego w nowych rozdziałach dotyczących uczenia nienadzorowanego z użyciem informacji wzajemnych, wykrywania obiektów (SSD) i segmentacji semantycznej (FCN i PSPNET), co pozwoli Ci na tworzenie własnych projektów z użyciem najnowocześniejszych technik sztucznej inteligencji.

W książce tej pokazano w sposób praktyczny, jak bardziej efektywnie tworzyć projekty wykorzystujące najbardziej aktualne techniki sztucznej inteligencji z użyciem otwartoźródłowej biblioteki do uczenia głębokiego Keras.

Począwszy od przeglądu Perceptronów wielowarstwowych (MLPs), splotowych sieci neuronowych (CNNs) oraz rekurencyjnych sieci neuronowych (RNNs), książka wprowadza kolejno w coraz bardziej najnowoczesne techniki w miare jak badasz głębokie architektury sieci neuronowych, w tym Reset i Densenet,i jak tworzysz sieci autokodujące. Następnie poznasz sieci GAN i dowiesz się, jak dzięki nim można osiągnąć nowe poziomy wydajności sztucznej inteligencji.

Następnie odkryjesz, w jaki sposób wdrożyć wariacyjną sieć autokodującą (VAE), oraz jak sieci GAN i VAE umożliwiają generowanie syntetycznych danych, które wygladają bardzo przekonywująco dla ludzi. Nauczysz się również wdrażać metody uczenia głębokiego ze wzmocnieniem - DRL, takie jak głębokie metody gradientu i strategie, które mają kluczowe znaczenie dla wielu nowoczesnych wyników uzyskiwanych przez AI.

## Instalacja
Rekomendujemy użycie środowiska conda. Proszę pobierz Anacoda stąd: [Anaconda](https://www.anaconda.com/distribution). Aby zainstalować Anaconda :

`sh <nazwa-pobranego-instalatora-Anaconda3>`

Wymagany jest komputer z co najmniej 1 jednostką NVIDIA GPU (1060 lub lepsza). Przykładowe kody były testowane na 1060, 1080Ti, RTX 2080Ti, V100, RTX Quadro 8000 działających pod kontrolą systemu Ubuntu 18.04 LTS. Poniżej zamieszczono krótki przewodnik instalacji sterownika NVIDIA oraz CuDNN aby uruchomić wsparcie dla GPU.  

`sudo add-apt-repository ppa:graphics-drivers/ppa`

`sudo apt update`
 
`sudo ubuntu-drivers autoinstall`

`sudo reboot`

`nvidia-smi`

W czasie gdy przygotowywano tłumaczenie `nvidia-smi` pokazuje wersję sterownika NVIDIA 462.59 i wersję CUDA 11.2.

To prawie koniec. Ostatni zestaw poleceń wygląda nastepująco (niektóre kroki mogą wymagać dostępu z "sudo").


`conda create --name adlk`

`conda activate adlk`

`cd <katalog-z-zasobami-z-ftp>`

`pip install -r requirements.txt`

`sudo apt-get install python-pydot`

`sudo apt-get install ffmpeg`

Przetestowanie czy prosty model może zostać wytrenowany bez błędów:

`cd Rozdział 1 - Wprowadzenie do Keras`

`python3 mlp-mnist-1.3.2.py`

Końcowy rezultat pokazuje dokładność wytrenowanego modelu na testowym zbiorze danych MNIST, wynosi on około 98.2%.

### Alternatywna instalacja TensorFlow
Jeśli masz kłopoty z biblioteką CUDA (tzn. nie możesz załadować lub znaleźć `libcudart.so.10.X`), TensorFlow i biblioteki CUDA mogą być zainstalowane wspólnie z użyciem conda:

```
pip uninstall tensorflow-gpu
conda install -c anaconda tensorflow-gpu
```

## Rozdział 1: Wprowadzenie do Keras

1. [MLP na zbiorze MNIST](Rozdział1-Wprowadzenie-do-Keras/mlp-mnist-1.3.2.py)
2. [CNN na zbiorze MNIST](Rozdział1-Wprowadzenie-do-Keras/cnn-mnist-1.4.1.py)
3. [RNN na zbiorze MNIST](Rozdział1-Wprowadzenie-do-Keras/rnn-mnist-1.5.1.py)

## Rozdział 2 - Głębokie sieci neuronowe

1. [Funkcyjne API na zbiorze MNIST](Rozdział2-Głębokie-sieci-neuronowe/cnn-functional-2.1.1.py)
2. [Y-Network na zbiorze MNIST](Rozdział2-Głębokie-sieci-neuronowe/cnn-y-network-2.1.2.py)
3. [ResNet v1 and v2 na zbiorze CIFAR10](Rozdział2-Głębokie-sieci-neuronowe/resnet-cifar10-2.2.1.py)
4. [DenseNet na zbiorze CIFAR10](Rozdział2-Głębokie-sieci-neuronowe/densenet-cifar10-2.4.1.py)

## [Rozdział 3 - Sieci Autokodujące](Rozdział3-Sieci-autokodujące/README.md)

1. [Denoising AutoEncoders](Rozdział3-Sieci-autokodujące/autokoder-odszumiający-mnist-3.3.1.py)

Przykładowy rezulat dla losowych cyfr:

![Losowe cyfry](Rozdział3-Sieci-autokodujące/zapisane-obrazy/corrupted_and_denoised.png)

2. [Colorization AutoEncoder](Rozdział3-Sieci-autokodujące/autokoder-kolorujący-cifar10-3.4.1.py)

Przykładowe wyjścia dla losowych obrazów cifar10:

![Colorized obrazy](Rozdział3-Sieci-autokodujące/zapisane-obrazy/colorized_images.png)

## Rozdział 4 - Sieci GAN

1. [Deep Convolutional GAN (DCGAN)](Rozdział4-Sieci-GAN/dcgan-mnist-4.2.1.py)

[Radford, Alec, Luke Metz, and Soumith Chintala. "Unsupervised representation learning with deep convolutional generative adversarial networks." arXiv preprint arXiv:1511.06434 (2015).](https://arxiv.org/pdf/1511.06434.pdf%C3%AF%C2%BC%E2%80%B0)

Przykładowe wyjścia dla losowych cyfr:

![Random Digits](Rozdział4-Sieci-GAN/obrazy/dcgan_mnist.gif)

2. [Conditional (GAN)](Rozdział4-Sieci-GAN/cgan-mnist-4.3.1.py)

[Mirza, Mehdi, and Simon Osindero. "Conditional generative adversarial nets." arXiv preprint arXiv:1411.1784 (2014).](https://arxiv.org/pdf/1411.1784)

Przykładowe wyjścia dla losowych cyfr:

![Zero to Nine](Rozdział4-Sieci-GAN/obrazy/cgan_mnist.gif)

## Rozdział 5 - Ulepszone sieci GAN

1. [Wasserstein GAN (WGAN)](Rozdział5-Ulepszone-sieci-GAN/wgan-mnist-5.1.2.py)

[Arjovsky, Martin, Soumith Chintala, and Léon Bottou. "Wasserstein GAN." arXiv preprint arXiv:1701.07875 (2017).](https://arxiv.org/pdf/1701.07875)

Przykładowe wyjścia dla losowych cyfr:

![Random Digits](Rozdział5-Ulepszone-sieci-GAN/obrazy/wgan_mnist.gif)

2. [Least Squares GAN (LSGAN)](Rozdział5-Ulepszone-sieci-GAN/lsgan-mnist-5.2.1.py)

[Mao, Xudong, et al. "Least squares generative adversarial networks." 2017 IEEE International Conference on Computer Vision (ICCV). IEEE, 2017.](http://openaccess.thecvf.com/content_ICCV_2017/papers/Mao_Least_Squares_Generative_ICCV_2017_paper.pdf)

Przykładowe wyjścia dla losowych cyfr:

![Random Digits](Rozdział5-Ulepszone-sieci-GAN/obrazy/lsgan_mnist.gif)

3. [Auxiliary Classifier GAN (ACGAN)](Rozdział5-Ulepszone-sieci-GAN/acgan-mnist-5.3.1.py)

[Odena, Augustus, Christopher Olah, and Jonathon Shlens. "Conditional image synthesis with auxiliary classifier GANs. Proceedings of the 34th International Conference on Machine Learning, Sydney, Australia, PMLR 70, 2017."](http://proceedings.mlr.press/v70/odena17a.html)

Przykładowe wyjścia dla cyfr od 0 do 9:

![Zero to Nine](Rozdział5-Ulepszone-sieci-GAN/obrazy/acgan_mnist.gif)

## Rozdział 6 - Rozplątane reprezentacje w GAN

1. [Information Maximizing GAN (InfoGAN)](Rozdział6-Rozplątane-reprezentacje-w-GAN/infogan-mnist-6.1.1.py)

[Chen, Xi, et al. "Infogan: Interpretable representation learning by information maximizing generative adversarial nets. "Advances in Neural Information Processing Systems. 2016.](http://papers.nips.cc/paper/6399-infogan-interpretable-representation-learning-by-information-maximizing-generative-adversarial-nets.pdf)

Przykładowe wyjścia dla cyfr od 0 do 9:

![Zero to Nine](Rozdział6-Rozplątane-reprezentacje-w-GAN/obrazy/infogan_mnist.gif)

2. [Stacked GAN](Rozdział6-Rozplątane-reprezentacje-w-GAN/stackedgan-mnist-6.2.1.py)

[Huang, Xun, et al. "Stacked generative adversarial networks." IEEE Conference on Computer Vision and Pattern Recognition (CVPR). Vol. 2. 2017](http://openaccess.thecvf.com/content_cvpr_2017/papers/Huang_Stacked_Generative_Adversarial_CVPR_2017_paper.pdf)

Przykładowe wyjście dla cyfr od 0 do 9:

![Zero to Nine](Rozdział6-Rozplątane-reprezentacje-w-GAN/obrazy/stackedgan_mnist.gif)

## [Rozdział 7 - Międzydziedzinowe sieci GAN](Rozdział7-Międzydziedzinowe-sieci-GAN/README.md)

1. [CycleGAN](Rozdział7-Międzydziedzinowe-sieci-GAN/cyclegan-7.1.1.py)

[Zhu, Jun-Yan, et al. "Unpaired Image-to-Image Translation Using Cycle-Consistent Adversarial Networks." 2017 IEEE International Conference on Computer Vision (ICCV). IEEE, 2017.](http://openaccess.thecvf.com/content_ICCV_2017/papers/Zhu_Unpaired_Image-To-Image_Translation_ICCV_2017_paper.pdf)

Przykładowe wyjście dla losowych obrazów cifar10:

![Colorized obrazy](Rozdział7-Międzydziedzinowe-sieci-GAN/obrazy/cifar10_colorization.gif)

Przykładowe wyjście dla cyfr MNIST dla SVHN:

![MNIST2SVHN](Rozdział7-Międzydziedzinowe-sieci-GAN/obrazy/MNIST2SVHN.png)

## [Rozdział 8 - Wariacyjne sieci autokodujące](Rozdział8-Wariacyjne-sieci-autokodujące/README.md)

1. [VAE MLP MNIST](Rozdział8-Wariacyjne-sieci-autokodujące/vae-mlp-mnist-8.1.1.py)
2. [VAE CNN MNIST](Rozdział8-Wariacyjne-sieci-autokodujące/cvae-cnn-mnist-8.2.1.py)
3. [Conditional VAE and Beta VAE](Rozdział8-Wariacyjne-sieci-autokodujące/cvae-cnn-mnist-8.2.1.py)

[Kingma, Diederik P., and Max Welling. "Auto-encoding Variational Bayes." arXiv preprint arXiv:1312.6114 (2013).](https://arxiv.org/pdf/1312.6114.pdf)

[Sohn, Kihyuk, Honglak Lee, and Xinchen Yan. "Learning structured output representation using deep conditional generative models." Advances in Neural Information Processing Systems. 2015.](http://papers.nips.cc/paper/5775-learning-structured-output-representation-using-deep-conditional-generative-models.pdf)

[I. Higgins, L. Matthey, A. Pal, C. Burgess, X. Glorot, M. Botvinick, S. Mohamed, and A. Lerchner. β-VAE: Learning basic visual concepts with a constrained variational framework. ICLR, 2017.](https://openreview.net/pdf?id=Sy2fzU9gl)

Wygenerowane cyfry MNIST w funkcji przestrzeni niejawnej:

![MNIST](Rozdział8-Wariacyjne-sieci-autokodujące/obrazy/digits_over_latent.png)

## Rozdział 9 - Uczenie ze wzmocnieniem

1. [Q-Learning](Rozdział9-Uczenie-ze-wzmocnieniem/q-learning-9.3.1.py)
2. [Q-Learning on Frozen Lake Environment](Rozdział9-Uczenie-ze-wzmocnieniem/q-frozenlake-9.5.1.py)
3. [DQN and DDQN on Cartpole Environment](Rozdział9-Uczenie-ze-wzmocnieniem/dqn-cartpole-9.6.1.py)

Mnih, Volodymyr, et al. "Human-level control through deep reinforcement learning." Nature 518.7540 (2015): 529

DQN w środowisku wózka:

![Cartpole](Rozdział9-Uczenie-ze-wzmocnieniem/obrazy/cartpole.gif)

## Rozdział 10 - Strategie metod gradientowych

1. [REINFORCE, REINFORCE with Baseline, Actor-Critic, A2C](Rozdział10-Strategie/policygradient-car-10.1.1.py)

[Sutton and Barto, Reinforcement Learning: An Introduction ](http://incompleteideas.net/book/bookdraft2017nov5.pdf)

[Mnih, Volodymyr, et al. "Asynchronous methods for deep reinforcement learning." International conference on machine learning. 2016.](http://proceedings.mlr.press/v48/mniha16.pdf)


Strategia gradientu w ciągłym środowisku samochodu wjeżdżającego pod górkę:

![Car](Rozdział10-Strategie/obrazy/car.gif)


## [Rozdział 11 - Wykrywanie obiektów](Rozdział11-Wykrywanie-obiektów/README.md)

1. [Single-Shot Detection](https://arxiv.org/pdf/1512.02325.pdf)

Detekcja 3 obiektów za jednym razem (ang. Single-Shot)
![SSD](Rozdział11-Wykrywanie-obiektów/obrazy/Figure11.13.2.detection_smooth_l1.png)

## [Rozdział 12 - Segmentacja semantyczna](Rozdział12-Segmentacja/README.md)

1. [FCN](https://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Long_Fully_Convolutional_Networks_2015_CVPR_paper.pdf)

2. [PSPNet](http://openaccess.thecvf.com/content_cvpr_2017/papers/Zhao_Pyramid_Scene_Parsing_CVPR_2017_paper.pdf)

Segmentacja semantyczna

![Semantic Segmentation](Rozdział12-Segmentacja/obrazy/sample_prediction.png)

## Rozdział 13 - Uczenie nienadzorowane z wykorzystaniem informacji wzajemnej

1. [Invariant Information Clustering](http://openaccess.thecvf.com/content_ICCV_2019/papers/Ji_Invariant_Information_Clustering_for_Unsupervised_Image_Classification_and_Segmentation_ICCV_2019_paper.pdf)

2. [MINE: Mutual Information Estimation](http://proceedings.mlr.press/v80/belghazi18a/belghazi18a.pdf)

MINE
![MINE](Rozdział13-Uczenie-nienadzorowane/obrazy/mine.png)

## Cytowanie
Jeśli ta praca Ci się przydała, proszę - zacytuj:

```
@book{atienza2022advanced,
  title={Zaawansowane uczenie głębokie z TensorFlow 2 i Keras},
  author={Atienza, Rowel},
  year={2022},
  publisher={Helion}
}
```