'''
Pokazanie w jaki sposób pobrac próbki i wyświetlić cyfry MNIST
używając API Keras
https://github.com/PacktPublishing/Advanced-Deep-Learning-with-Keras
'''

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import numpy as np
from tensorflow.keras.datasets import mnist
import matplotlib.pyplot as plt

# załadowanie zbioru
(x_train, y_train), (x_test, y_test) = mnist.load_data()

# zliczenie liczby unikalnych etykiet w zbiorze uczącym
unique, counts = np.unique(y_train, return_counts=True)
print("Etykiety zbioru uczącego: ", dict(zip(unique, counts)))

# zliczenie liczby unikalnych etykiet w zbiorze testowym
unique, counts = np.unique(y_test, return_counts=True)
print("Etykiety zbioru testowego: ", dict(zip(unique, counts)))

# próbka 25 cyfr ze zbioru uczącego MNIST
indexes = np.random.randint(0, x_train.shape[0], size=25)
images = x_train[indexes]
labels = y_train[indexes]

# wyświetlenie 25 cyfr MNIST
plt.figure(figsize=(5,5))
for i in range(len(indexes)):
    plt.subplot(5, 5, i + 1)
    image = images[i]
    plt.imshow(image, cmap='gray')
    plt.axis('off')

plt.savefig("mnist-samples.png")
plt.show()
plt.close('all')