#
#  Plik:  mnist_cnn_fcn_test.py
#
#  Testuje pełną sieć splotową
#
#  RTK, 20.10.2019
#  Ostatnia aktualizacja:  20.10.2019
#
################################################################

import os
import time
import numpy as np
from keras.models import load_model
from PIL import Image

def main():
    #  Testuje poszczególne cyfry MNIST
    x_test = np.load("../data/mnist/mnist_test_images.npy")/255.0
    y_test = np.load("../data/mnist/mnist_test_labels.npy")

    #  Podzbiór losowy
    N = 1000
    idx = np.argsort(np.random.random(N))

    #  Pełny model splotowy
    model = load_model("mnist_cnn_aug_fcn_model.h5")

    #  Przeiwduje cyfry i śledzi dokładność
    nc = nw = 0.0

    for i in idx:
        p = model.predict(x_test[i][np.newaxis,:,:,np.newaxis])
        c = np.argmax(p)
        if (c == y_test[i]):
            nc += 1
        else:
            nw += 1
    print()
    print("Pojedyczne cyfry MNIST, n=%d, dokładność = %0.2f%%" % (N, 100*nc/N))
    print()

    #  Testuje większe obrazy i zapisuje wyniki
    os.system("rm -rf results_aug; mkdir results_aug")
    n = len(os.listdir("images"))

    print("Przetwarzanie większych obrazów z cyframi... ")
    st = time.time()
    for i in range(n):
        f = "images/image_%04d.png" % i
        im = np.array(Image.open(f))/255.0
        p = model.predict(im[np.newaxis,:,:,np.newaxis])
        np.save("results_aug/results_%04d.npy" % i, p[0,:,:,:])
    print("Zakończono, czas = %0.3f s" % (time.time()-st))
    print()


main()

