//   Copyright 2012,2013 Vaughn Vernon
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package com.saasovation.agilepm.domain.model.team;

import java.util.Date;

import com.saasovation.agilepm.domain.model.ValueObject;

public class MemberChangeTracker extends ValueObject {

    private Date emailAddressChangedOn;
    private Date enablingOn;
    private Date nameChangedOn;

    public boolean canChangeEmailAddress(Date asOfDate) {
        return this.emailAddressChangedOn().before(asOfDate);
    }

    public boolean canChangeName(Date asOfDate) {
        return this.nameChangedOn().before(asOfDate);
    }

    public boolean canToggleEnabling(Date asOfDate) {
        return this.enablingOn().before(asOfDate);
    }

    public MemberChangeTracker emailAddressChangedOn(Date asOfDate) {
        return new MemberChangeTracker(this.enablingOn(), this.nameChangedOn(), asOfDate);
    }

    public MemberChangeTracker enablingOn(Date asOfDate) {
        return new MemberChangeTracker(asOfDate, this.nameChangedOn(), this.emailAddressChangedOn());
    }

    public MemberChangeTracker nameChangedOn(Date asOfDate) {
        return new MemberChangeTracker(this.enablingOn(), asOfDate, this.emailAddressChangedOn());
    }

    @Override
    public boolean equals(Object anObject) {
        boolean equalObjects = false;

        if (anObject != null && this.getClass() == anObject.getClass()) {
            MemberChangeTracker typedObject = (MemberChangeTracker) anObject;
            equalObjects =
                this.enablingOn().equals(typedObject.enablingOn()) &&
                this.nameChangedOn().equals(typedObject.nameChangedOn()) &&
                this.emailAddressChangedOn().equals(typedObject.emailAddressChangedOn());
        }

        return equalObjects;
    }

    @Override
    public int hashCode() {
        int hashCodeValue =
            + (8705 * 67)
            + this.enablingOn().hashCode()
            + this.nameChangedOn().hashCode()
            + this.emailAddressChangedOn().hashCode();

        return hashCodeValue;
    }

    protected MemberChangeTracker(
            Date anEnablingOn,
            Date aNameChangedOn,
            Date anEmailAddressChangedOn) {

        this();

        this.setEmailAddressChangedOn(anEmailAddressChangedOn);
        this.setEnablingOn(anEnablingOn);
        this.setNameChangedOn(aNameChangedOn);
    }

    protected MemberChangeTracker(MemberChangeTracker aMemberChangeTracker) {
        this(aMemberChangeTracker.enablingOn(),
             aMemberChangeTracker.nameChangedOn(),
             aMemberChangeTracker.emailAddressChangedOn());
    }

    private MemberChangeTracker() {
        super();
    }

    private Date emailAddressChangedOn() {
        return this.emailAddressChangedOn;
    }

    private Date enablingOn() {
        return this.enablingOn;
    }

    private Date nameChangedOn() {
        return this.nameChangedOn;
    }
if (product == null) {
            throw new IllegalStateException(
                    "Nieznany produkt dla tego identyfikatora dzierżawcy: "
                    + aCommand.getTenantId()
                    + " i identyfikatora produktu: "
                    + aCommand.getProductId());
        }

        if (product == null) {
            throw new IllegalStateException(
                    "Nieznany produkt dla tego identyfikatora dzierżawcy: "
                    + aCommand.getTenantId()
                    + " i identyfikatora dyskusji: "
                    + processId.id());
        }


            if (product == null) {
                throw new IllegalStateException(
                        "Nieznany produkt dla tego identyfikatora dzierżawcy: "
                        + aCommand.getTenantId()
                        + " i identyfikatora produktu: "
                        + aCommand.getProductId());
            }

            TimeConstrainedProcessTracker tracker =
                    new TimeConstrainedProcessTracker(
                            product.tenantId().id(),
                            ProcessId.newProcessId(),
                            "Utworzenie dyskusji dla produktu: "
                                + product.name(),
                            new Date(),
                            5L * 60L * 1000L, // ponowienia próby co 5 minut
                            3, // ogółem 3 ponowienia próby
                            timedOutEventName);} catch (Exception e) {
                    System.out.println("Problem z publikacją powiadomień z ApplicationServiceLifeCycle.");
                }


@Override
    public String toString() {
        return "DiscussionDescriptor [id=" + id + "]";
    }

    private DiscussionDescriptor() {
        super();
    }

    private void setId(String anId) {
        this.assertArgumentNotEmpty(anId, "Należy podać identyfikator dyskusji.");
        this.assertArgumentLength(anId, 36, "Identyfikator dyskusji musi mieć 36 znaków lub mniej.");

        this.id = anId;
    }
}


  this.assertArgumentEquals(this.tenantId(), aBacklogItem.tenantId(), "The product and backlog item must have same tenant.");
        this.assertArgumentEquals(this.tenantId(), aBacklogItem.tenantId(), "The product and backlog item must have same tenant."); this.assertArgumentNotEmpty(aDescription, "Należy podać opis.");
        this.assertArgumentLength(aDescription, 500, "Opis musi zawierać 500 znaków lub mniej.");        this.assertArgumentNotNull(aDiscussion, "Dyskusja jest wymagana, nawet jeśli jest nieużywana.");  this.assertArgumentNotNull(aProductId, "Należy podać productId.");        this.assertArgumentNotNull(aProductOwnerId, "Należy podać productOwnerId.");
        this.assertArgumentEquals(this.tenantId(), aProductOwnerId.tenantId(), "Pole productOwner musi mieć tego samego dzierżawcę.");"Pozycja musi być zaplanowana do wydania, aby można ją było przypisać do sprintu".);private void setFirstName(String aFirstName) {
        if (aFirstName != null) {
            this.assertArgumentLength(aFirstName, 50, "Imię może się składać z co najwyżej 50 znaków.");
        }

        this.firstName = aFirstName;
    }

    private void setLastName(String aLastName) {
        if (aLastName != null) {
            this.assertArgumentLength(aLastName, 50, "Nazwisko może się składać z co najwyżej 50 znaków.");
        }

        this.lastName = aLastName;
    }

    private void setTenantId(TenantId aTenantId) {
        this.assertArgumentNotNull(aTenantId, "Należy podać identyfikator dzierżawcy.");

        this.tenantId = aTenantId;
    }

    private void setUsername(String aUsername) {
        this.assertArgumentNotEmpty(aUsername, "Należy podać nazwę użytkownika.");
        this.assertArgumentLength(aUserName, 250, "Nazwa użytkownika może się składać z co najwyżej 250 znaków.");

        this.username = aUsername;
    }
}

  private void setEmailAddressChangedOn(Date anEmailAddressChangedOn) {
        this.assertArgumentNotNull(anEmailAddressChangedOn, "Należy podać datę zmiany adresu e-mail.");

        this.emailAddressChangedOn = anEmailAddressChangedOn;
    }

    private void setEnablingOn(Date anEnablingOn) {
        this.assertArgumentNotNull(anEnablingOn, "Należy podać datę uaktywnienia.");

        this.enablingOn = anEnablingOn;
    }

    private void setNameChangedOn(Date aNameChangedOn) {
        this.assertArgumentNotNull(aNameChangedOn, "Należy podać datę zmiany nazwy.");

        this.nameChangedOn = aNameChangedOn;
    }
}
