//   Copyright 2012,2013 Vaughn Vernon
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package com.saasovation.identityaccess.domain.model.access;

import com.saasovation.common.AssertionConcern;
import com.saasovation.identityaccess.domain.model.identity.GroupMemberService;
import com.saasovation.identityaccess.domain.model.identity.GroupRepository;
import com.saasovation.identityaccess.domain.model.identity.TenantId;
import com.saasovation.identityaccess.domain.model.identity.User;
import com.saasovation.identityaccess.domain.model.identity.UserRepository;

public class AuthorizationService extends AssertionConcern {

    private GroupRepository groupRepository;
    private RoleRepository roleRepository;
    private UserRepository userRepository;

    public AuthorizationService(
            UserRepository aUserRepository,
            GroupRepository aGroupRepository,
            RoleRepository aRoleRepository) {

        super();

        this.groupRepository = aGroupRepository;
        this.roleRepository = aRoleRepository;
        this.userRepository = aUserRepository;
    }

    public boolean isUserInRole(TenantId aTenantId, String aUsername, String aRoleName) {
        this.assertArgumentNotNull(aTenantId, "Identyfikator TenantId nie może mieć wartości null.");
        this.assertArgumentNotEmpty(aUsername, "Należy podać nazwę użytkownika.");
        this.assertArgumentNotEmpty(aRoleName, "Nazwa roli nie może mieć wartości null.");

        User user = this.userRepository().userWithUsername(aTenantId, aUsername);

        return user == null ? false : this.isUserInRole(user, aRoleName);
    }

    public boolean isUserInRole(User aUser, String aRoleName) {
        this.assertArgumentNotNull(aUser, "Użytkownik nie może mieć wartości null.");
        this.assertArgumentNotEmpty(aRoleName, "Nazwa roli nie może mieć wartości null.");

        boolean authorized = false;

        if (aUser.isEnabled()) {
            Role role = this.roleRepository().roleNamed(aUser.tenantId(), aRoleName);

            if (role != null) {
                GroupMemberService groupMemberService =
                        new GroupMemberService(
                                this.userRepository(),
                                this.groupRepository());

                authorized = role.isInRole(aUser, groupMemberService);
            }
        }

        return authorized;
    }

    private GroupRepository groupRepository() {
        return this.groupRepository;
    }

    private RoleRepository roleRepository() {
        return this.roleRepository;
    }

    private UserRepository userRepository() {
        return this.userRepository;
    }
}
