//   Copyright 2012,2013 Vaughn Vernon
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package com.saasovation.agilepm.domain.model.team;

import java.util.Collection;

import com.saasovation.agilepm.domain.model.tenant.TenantId;

public interface ProductOwnerRepository {

    public Collection<ProductOwner> allProductOwnersOfTenant(TenantId aTenantId);

    public ProductOwner productOwnerOfIdentity(TenantId aTenantId, String aUsername);

    public void remove(ProductOwner aProductOwner);

    public void removeAll(Collection<ProductOwner> aProductOwnerCollection);

    public void save(ProductOwner aProductOwner);

    public void saveAll(Collection<ProductOwner> aProductOwnerCollection);
}
