//   Copyright 2012,2013 Vaughn Vernon
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package com.saasovation.common.port.adapter.messaging;

/**
 * Prosty RuntimeException.
 *
 * @author Vaughn Vernon
 */
public class MessageException extends RuntimeException {

    /** Moja właściwość serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** Wskaźnik powtórzeń. */
    private boolean retry;

    /**
     * Konstruuje stan domyślny.
     * @param aMessage - tekst komunikatu
     * @param aCause - przyczyna - Throwable
     * @param isRetry  - boolean - wskazuje, czy należy ponawiać wysyłanie
     */
    public MessageException(String aMessage, Throwable aCause, boolean isRetry) {
        super(aMessage, aCause);
        this.setRetry(isRetry);
    }

    /**
     * Konstruuje stan domyślny.
     * @param aMessage - tekst komunikatu
     * @param  przyczyna - Throwable
     */
    public MessageException(String aMessage, Throwable aCause) {
        super(aMessage, aCause);
    }

    /**
     *  Konstruuje stan domyślny.
     * @param aMessage - tekst komunikatu
     * @param isRetry - boolean - wskazuje, czy należy ponawiać wysyłanie
     */
    public MessageException(String aMessage, boolean isRetry) {
        super(aMessage);
        this.setRetry(isRetry);
    }

    /**
     * Konstruuje stan domyślny.
     * @param aMessage - tekst komunikatu
     */
    public MessageException(String aMessage) {
        super(aMessage);
    }

    /**
     * Odpowiada na pytanie, czy ustawiono ponawianie próby. Ponowienia prób mogą być
     * używane przez obiekt MessageListener, kiedy komunikat, dla którego
     * następiła próba obsłużenia ma być ponownie umieszczony w kolejce zamiast
     * odrzucenia. Dzięki temu próba obsłużenia może być ponowiona.
     * @return boolean
     */
    public boolean isRetry() {
        return this.retry;
    }

    /**
     * Ustawia ponowienia prób.
     * @param aRetry -wartość boolean ustawiana jako powtórzenia prób
     */
    private void setRetry(boolean aRetry) {
        this.retry = aRetry;
    }
}
