# Platforma Shiny w praktyce: wizualizowanie śmiertelnych postrzeleń przez policję

W tej sekcji przedstawiamy tworzenie aplikacji na platformę Shiny, aby zwizualizować zbiór danych na temat osób śmiertelnie postrzelonych przez policję w Stanach Zjednoczonych w pierwszej połowie 2018 r. (od stycznia do czerwca). Ten zbiór daanych został opracowany przez pracowników dziennika [Washington Post](https://www.washingtonpost.com/graphics/2018/national/police-shootings-2018/?utm_term=.d5d3a88f97da). Dane te są dostępne w serwisie [GitHub](https://github.com/washingtonpost/data-police-shootings).

Aby zwizualizować geograficzny rozkład danych, do każdej obserwacji dodaliśmy długość i szerokość geograficzną; użyliśmy do tego [skryptu](add_lat_long.R) (nie musisz uruchamiać tego skryptu, ale został on dodany, aby pokazać, jak dołączono potrzebne dane). Warto zauważyć, że aby wykonać ten skrypt, będziesz potrzebował [klucza API do Map Google](https://developers.google.com/maps/documentation/geocoding/get-api-key). 

Zgodnie z sugerowaną strukturą plików aplikacji na platformę Shiny, kod umieściliśmy w jednym pliku [`app.R`](app.R). Aby zobaczyć działanie aplikacji, otwórz ten plik w środowisku RStudio i kliknij przycisk _Run App_. Poniżej pokazano zrzut z tej interaktywnej aplikacji.

![Interaktywna mapa śmiertelnych postrzeleń przez policję](imgs/shooting-app.png)

 