# Geokodowanie adresów na podstawie następującego artykułu z bloga:
# http://www.storybench.org/geocode-csv-addresses-r/

# Użyj rozwojowej wersji pakietu ggmaps, aby można było podać klucz API Map Google.
# devtools::install_github("dkahle/ggmap")
library(ggmap)
library(dplyr)

# Wczytywanie klucza API Map Google (musisz zdobyć własny klucz).
source("api_key.R")
register_google(key = google_key)

# Wczytywanie danych z serwisu GitHub.
data_url <- "https://raw.githubusercontent.com/washingtonpost/data-police-shootings/master/fatal-police-shootings-data.csv"
shootings <- read.csv(data_url, stringsAsFactors = F) %>%
  mutate(
    address = paste0(city, ", ", state)
  ) %>% 
  filter(as.Date(date) >= as.Date("2018-01-01"))

# Pobieranie adresów.
shootings[, c("long", "lat")] <- geocode(shootings$address)

# Zastępowanie wartości.
shootings$race[shootings$race == "W"] <- "Biała (nielatynoska)"
shootings$race[shootings$race == "B"] <- "Czarna nielatynoska"
shootings$race[shootings$race == "A"] <- "Azjatycka"
shootings$race[shootings$race == "N"] <- "Rdzenno-ameryka?ska"
shootings$race[shootings$race == "H"] <- "Latynoska"
shootings$race[shootings$race == "O"] <- "Inna"
shootings$race[shootings$race == ""] <- "Nieznana"

shootings$gender[shootings$gender == "M"] <- "Mężczyzna"
shootings$gender[shootings$gender == "F"] <- "Kobieta"
shootings$gender[shootings$gender == ""] <- "Nieznana"

# Zapisywanie pliku CSV zawierającego dane.
write.csv(shootings, "police-shootings.csv", row.names = FALSE)
