# R Markdown w praktyce: tworzenie raportu na temat oczekiwanej dugoci ycia.

# Wczytywanie potrzebnych bibliotek.
library(dplyr)
library(rworldmap) # Umoliwia atwe tworzenie map.
library(RColorBrewer) # Suy do wybierania palet kolorw.

# Wczytywanie danych, pomijanie zbdnych wierszy.
life_exp <- read.csv(
  "data/API_SP.DYN.LE00.IN_DS2_en_csv_v2.csv",
  skip = 4,
  stringsAsFactors = FALSE
)

# Zauwa, e R dodaje liter "X" przed kad kolumn z rokiem
# (poniewa nazwy kolumn nie mog zaczyna si od cyfry).

# W ktrym pastwie oczekiwana dugo ycia w 2015 r. bya najwiksza?
longest_le <- life_exp %>%
  filter(X2015 == max(X2015, na.rm = T)) %>%
  select(Country.Name, X2015) %>%
  mutate(expectancy = round(X2015, 1)) # Zmiana nazwy i formatowanie kolumny.

# W ktrym pastwie oczekiwana dugo ycia w 2015 r. bya najmniejsza?
shortest_le <- life_exp %>%
  filter(X2015 == min(X2015, na.rm = T)) %>%
  select(Country.Name, X2015) %>%
  mutate(expectancy = round(X2015, 1)) # Zmiana nazwy i formatowanie kolumny.

# Obliczanie zakresu oczekiwanej dugoci ycia.
le_difference <- longest_le$expectancy - shortest_le$expectancy

# W ktrych 10 krajach odnotowano najwikszy wzrost oczekiwanej dugoci ycia?
top_10_gain <- life_exp %>%
  mutate(gain = X2015 - X1960) %>%
  top_n(10, wt = gain) %>% # Wygodna funkcja z pakietu dplyr!
  arrange(-gain) %>%
  mutate(gain_formatted = paste(format(round(gain, 1), nsmall = 1), "(w latach)")) %>%
  select(Country.Name, gain_formatted)

# Zczanie ramki danych z plikiem shapefile, ktry opisuje, jak narysowa kady kraj.
# Pakiet rworldmap udostpnia pomocn funkcj do wykonywania tej operacji.
mapped_data <- joinCountryData2Map(
  life_exp,
  joinCode = "ISO3",
  nameJoinColumn = "Country.Code",
  mapResolution = "high"
)