<a href="https://g.co/kgs/pSo6dK" target="_blank"> 
  <img src="https://raw.githubusercontent.com/datastax/graph-book/master/notebooks/images/logos/book-cover.jpg" width="300" ALIGN="RIGHT"/>
</a>
W tym pakiecie znajdują się dane, skrypty do ich wczytywania i notatniki uzupełniające książkę "Praktyczny przewodnik po danych grafowych". Napisaliśmy tę książkę i utworzyliśmy te przykłady, aby
ułatwić nawigaccję w przestrzeni między postrzeganiem danych w postaci grafu i użyciem danych o strukturze grafu.

Zachęcamy także do kopiowania i ponownego wykorzystania (z odpowiednią atrybucją) wszystkich obrazów znajdujących się w naszych [publicznych dokumentach LucidCharts](https://www.lucidchart.com/invitations/accept/ac590bc4-1407-422b-9843-bda83e0d0b6c).

&nbsp;

**Autorzy:** 
1. [Denise Gosnell](https://twitter.com/DeniseKGosnell)  
2. [Matthias Broecheler](https://twitter.com/MBroecheler)

**Redaktorzy techniczni:**
1. [Alex Ott](https://github.com/alexott)
2. [Lorina Poland](https://github.com/polandll)
3. [Daniel Kuppitz](https://github.com/dkuppitz)


## Zawartość
Ten pakiet zawiera notatniki programu Studio, dane i skrypty do ich wczytywania. Można je wykorzystać do wykonania ćwiczeń z rozdziałów od 3. do 12. książki [Praktyczny przewodnik po danych grafowych](https://g.co/kgs/pSo6dK) . Organizacja zawartości:
1. `notebooks/`: Wszystkie notatniki programu DataStax Studio dla rozdziałów od 3. do 12. Można je wczytać do programu DataStax Studio za pomocą narzędzia Studio Import Tool. (Poniżej znajdują się instrukcje)
2. `data/ch_x`: Katalog zawierający dane dla każdego rozdziału w osobnych podkatalogach. W każdym z nich znajdują się dane i skrypty służące do ich wczytania do programu DataStax Graph 6.8 za pomocą narzędzia DataStax Bulk Loader.

Poniżej znajdują się instrukcje dotyczące rozpoczęcia pracy.

## Szybkie wprowadzenie do Dockera
1. Zainstaluj programy [Docker i docker-compose](https://www.docker.com/), a także [git](https://git-scm.com/)
2. Upewnij się, że na komputerze znajduje się wystarczająca ilość zasobów systemowych niezbędnych do działania Dockera (zalecamy co najmniej 8GB pamięci RAM).
3. Wejdź do katalogu projektu i wykonaj polecenie `docker-compose up`
4. Po uruchomieniu programów Studio i DSE przejdź do [strony głównej DataStax Studio Home Page](http://localhost:9091/) w przeglądarce, aby rozpocząć korzystanie z notatników przygotowanych dla każdego rozdziału.

## Jak używać tych materiałów
1. Zainstaluj i uruchom [DataStax i DataStax Studio](#downloading-datastax-graph-and-datastax-studio), po czym otwórz [stronę główną DataStax Studio](http://localhost:9091/)
2. Wczytaj notatnik określonego rozdziału za pomocą narzędzia Notebook Upload Tool
3. Wykonaj instrukcje z notatnika.
4. (Opcjonalnie) Skonfiguruj od razu przykłady z wszystkich rozdziałów:
    1. Zaimportuj notatnik dla każdego rozdziału do programu DataStax Studio
    2. Utwórz graf i schemat grafu w notatniku każdego rozdziału
    3. Uaktualnij DEFAULT_DSBULK_PATH w pliku do wczytywania każdego rozdziału. (Wszystkie skrypty do wczytywania znajdują się w plikach `data/ch_x/ch_x_load.sh`)
    4. Uruchom skrypt `data/load_all.sh`, aby wczytać wszystkie dane do każdego rozdziału.
5. Ciesz się lekturą!

## Pobieranie DataStax Graph i DataStax Studio

Aby skorzystać z tych materiałów, musisz pobrać i skonfigurować dwa produkty DataStax: DataStax Graph 6.8 z programem DataStax Studio oraz DataStax Bulk Loader

Konfiguracja DataStax Graph 6.8 z wykorzystaniem pliku tarball:
1. Pobierz dystrybucję programów [DataStax Graph 6.8](https://downloads.datastax.com/#enterprise) i [DataStax Studio](https://downloads.datastax.com/#studio)
2. W terminalu rozpoakuj pobrane pakiety
```
$ tar -xvzf dse-6.8.0-bin.tar.gz
$ tar -xvzf datastax-studio-6.8.0.tar.gz
```
3. Uruchom DataStax Graph:
```
$ ./dse-6.8.0/bin/dse cassandra -s -g -k
```
4. Uruchom DataStax Studio:
```
$ ./datastax-studio-6.8.0/bin/server.sh
```
5. (Opcjonalnie) Zajrzyj do dokuemntacji DataStax, aby sprawdzić dodatkowe opcje konfiguracji [DataStax Graph](https://docs.datastax.com/en/dse/6.8/dse-dev/datastax_enterprise/graph/graphTOC.html) lub [DataStax Studio](https://docs.datastax.com/en/studio/6.8/index.html). Nie jest to konieczne do wykonania przykładów z tej książki.

Konfiguracja DataStax Bulk Loader z wykorzystaniem pliku tarball:
1. Pobierz linuksową dystrybucję programu [DataStax Bulk Loader](https://downloads.datastax.com/#bulk-loader)
2. Rozpakuj pobrany pakiet:
```tar -xvzf dsbulk-1.5.0.tar.gz```
3. Zanotuj ścieżkę głównego katalogu narzędzia DataStax Bulk Loader.
4. (Opcjonalnie) Zajrzyj do [dokuemntacji DataStax](https://docs.datastax.com/en/dsbulk/doc/), aby sprawdzić dodatkowe opcje konfiguracji DataStax Bulk Loader. Nie jest to konieczne do wykonania przykładów z tej książki.

## Następne kroki
1. Podziel się z nami swoją opinią [na Twitterze](https://twitter.com/Graph_Thinking)
2. Napisz [recenzję w serwisie Amazon](https://www.amazon.com/Practitioners-Guide-Graph-Data/dp/1492044075)

