package com.objectmentor.clientserver.nonthreaded;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

import common.MessageUtils;

public class Server implements Runnable {
  ServerSocket serverSocket;
  volatile boolean keepProcessing = true;

  public Server(int port, int millisecondsTimeout) throws IOException {
  serverSocket = new ServerSocket(port);
  serverSocket.setSoTimeout(millisecondsTimeout);
  }

  public void run() {
    System.out.printf("Serwer uruchamia si\n");

    while (keepProcessing) {
      try {
        System.out.printf("przyjmowanie klienta\n");
        Socket socket = serverSocket.accept();
        System.out.printf("klient przyjety\n");
        process(socket);
      } catch (Exception e) {
        handle(e);
      }
    }
  }

  private void handle(Exception e) {
    if (!(e instanceof SocketException)) {
      e.printStackTrace();
    }
  }

  public void stopProcessing() {
    keepProcessing = false;
    closeIgnoringException(serverSocket);
  }

  void process(Socket socket) {
    if (socket == null)
      return;

    try {
      System.out.printf("Serwer: pobieranie komunikatu\n");
      String message = MessageUtils.getMessage(socket);
      System.out.printf("Serwer: komunikat pobrany: %s\n", message);
      Thread.sleep(1000);
      System.out.printf("Serwer: wysyanie odpowiedzi: %s\n", message);
      MessageUtils.sendMessage(socket, "Przetworzone: " + message);
      System.out.printf("Serwer: wysane\n");
      closeIgnoringException(socket);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void closeIgnoringException(Socket socket) {
  if (socket != null)
    try {
      socket.close();
    } catch (IOException ignore) {
    }
  }

  private void closeIgnoringException(ServerSocket serverSocket) {
    if (serverSocket != null)
      try {
        serverSocket.close();
      } catch (IOException ignore) {
      }
  }
}