# coding: utf-8
import random
class Dice:
    """Klasa symulująca rzuty kostką."""
    def __init__(self, sides=6):
        self.sides = sides
    def __get__(self, instance, owner):
        return int(random.random() * self.sides) + 1
    def __set__(self, instance, value):
        if not isinstance(value, int):
            raise ValueError("Podaj liczbę całkowitą")
        print(f"Nowa wartość: {value}")
        self.sides = value

class Play:
    d6 = Dice()
    d10 = Dice(10)
    d13 = Dice(13)

play = Play()
print(play.d6)
print(play.d10)
play.d6 = 11
play.d6 = "11"