# coding: utf-8
import socket
class Protocol:
     def __init__(self, host, port):
         self.host, self.port = host, port
     def __enter__(self):
         self._client = socket.socket()
         self._client.connect((self.host, self.port))
         return self
     def __exit__(self, exception, value, traceback):
         self._client.close()
     def send(self, payload):
         # Wysyłanie danych
         self._client.sendall(payload)
     def receive(self):
         # Odbieranie danych
         return self._client.recv(1024)
with Protocol("www.helion.pl", 80) as protocol:
     protocol.send(b'get')
     result = protocol.receive()
     print(result)