# coding: utf-8
import sqlite3
con = sqlite3.connect(":memory:")
con.execute("create table person (id integer primary key, firstname varchar unique)")
# Po pomyślnym wykonaniu zapytania automatycznie wywoływana jest metoda con.commit().
with con:
     con.execute("insert into person(firstname) values (?)", ("Jan",))
# W przypadku zgłoszenia wyjątku wywoływana jest metoda con.rollback().
# Niezależnie od tego wyjątek musi zostać obsłużony.
try:
    with con:
         con.execute("insert into person(firstname) values (?)", ("Jan",))
except sqlite3.IntegrityError:
    print("Nie można dwukrotnie wpisać tych samych danych.")