﻿using PostSharp.Patterns.Caching;
using System;
using System.Threading;

namespace CH11_Caching
{
    [CacheConfiguration(AbsoluteExpiration = 10)]
    internal class StudentServices
    {
        [Cache]
        public static Student GetStudent(int id)
        {
            Console.WriteLine($">> Pobieranie konta studenta {id} z bazy danych...");
            Thread.Sleep(1000);
            return new Student { Id = id, Name = "Wiosenny kurczak" };
        }

        [InvalidateCache(nameof(GetStudent))]
        public static void UpdateStudent(int id, string name)
        {
            Console.WriteLine($">> Aktualizowanie studenta {id} w bazie danych...");
            Thread.Sleep(1000);
        }

        public static void DeleteStudent(int id, string student)
        {
            Console.WriteLine($">> Usuwanie studenta {id} z bazy danych...");
            Thread.Sleep(1000);
            CachingServices.Invalidation.Invalidate(GetStudent, id);
        }
    }
}
