﻿using PostSharp.Aspects;
using PostSharp.Serialization;
using System;

namespace CH11_AddressingCrossCuttingConcerns.Aspects
{
    [PSerializable]
    public class LoggingAspect : OnMethodBoundaryAspect
    {
        public override void OnEntry(MethodExecutionArgs args)
        {
            Console.WriteLine("Metoda {0} zakończyła działanie.", args.Method.Name);
        }

        public override void OnSuccess(MethodExecutionArgs args)
        {
            Console.WriteLine("Metoda {0} pomyślnie zakończyła działanie.", args.Method.Name);
        }

        public override void OnExit(MethodExecutionArgs args)
        {
            Console.WriteLine("Metoda {0} zakończyła działanie.", args.Method.Name);
        }

        public override void OnException(MethodExecutionArgs args)
        {
            Console.WriteLine("Metoda {0} zgłosiła wyjątek.", args.Method.Name);
        }
    }
}
