﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CH14_DesignPatterns.StructuralDesignPatterns.Facade;
using CrossCuttingConcerns.Instrumentation;
using CrossCuttingConcerns.Logging;

namespace CH14_DesignPatterns.CreationalDesignPatterns.Builder
{
    public class StringConcatenation
    {
        private static DateTime _startTime;
        private static long _durationPlus;
        private static long _durationSb;

        public static void UsingThePlusOperator()
        {
            _startTime = DateTime.Now;
            var text = string.Empty;
            for (var x = 1; x <= 10000; x++)
            {
                text += $"Wiersz: {x}, Nie mogę być leniwym programistą. Muszę ciągle się rozwijać!\n";
            }
            _durationPlus = (DateTime.Now - _startTime).Ticks;
            Console.WriteLine($"Czas trwania (takty) przy użyciu operatora plus: {_durationPlus}");
        }


        public static void UsingTheStringBuilder()
        {
            _startTime = DateTime.Now;
            var sb = new StringBuilder();
            for (var x = 1; x <= 10000; x++)
            {
                sb.AppendLine(
                $"Wiersz: {x}, Nie mogę być leniwym programistą. Muszę ciągle się rozwijać!"
                );
            }
            _durationSb = (DateTime.Now - _startTime).Ticks;
            Console.WriteLine($"Czas trwania (liczba taktów) przy użyciu klasy StringBuilder: { _durationSb} ");
        }


        public static void PrintTimeDifference()
        {
            var difference = _durationPlus - _durationSb;
            Console.WriteLine($"Różnica czasu wynosi {difference} taktów.");
            Console.WriteLine($"{difference} taktów = { TimeSpan.FromTicks(difference)} sekund.\n\n");
        }
    }
}
