﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace CH08_Processors
{
    class Program
    {
        static void Main(string[] args)
        {
            // 3 w systemie dwójkowym to 11, zatem zostaną użyte dwa pierwsze rdzenie.
            AssignCores(3);
            SetMaxThreads(2, 2);
        }

        /// <summary>
        /// Określa rdzenie używane przez proces
        /// </summary>
        /// <param name="cores">
        /// Liczba całkowita reprezentująca wartość decydującą o ty
        /// z jakich rdzeni będzie korzystał proces.
        /// </param>
        private static void AssignCores(int cores)
        {
            Process.GetCurrentProcess().ProcessorAffinity = new IntPtr(cores);
        }

        /// <summary>
        /// Ustawia liczbę wątków, które mogą być używane jednocześnie.
        /// </summary>
        /// <param name="workerThreads">
        /// Maksymalna liczba wątków roboczych w puli wątków.
        /// </param>
        /// <param name="asyncIoThreads">
        /// Maksymalna liczba asynchronicznych wątków I/O w puli wątków.
        /// </param>
        private static void SetMaxThreads(int workerThreads, int asyncIoThreads)
        {
            ThreadPool.SetMaxThreads(workerThreads, asyncIoThreads);
        }
    }
}
