﻿using System;
using System.Threading;

namespace CH08_Interlocked
{
    class Program
    {
        private static long _value = long.MaxValue;
        private static int _resourceInUse = 0;

        static void Main(string[] args)
        {
            CompareExchangeVariables();
            AddVariables();
            DecrementVariable();
            IncrementVariable();
            ReadVariable();
            PerformUnsafeCodeSafely();
        }

        private static void CompareExchangeVariables()
        {
            Interlocked.CompareExchange(ref _value, 123, long.MaxValue);
        }

        private static void AddVariables()
        {
            Interlocked.Add(ref _value, 321);
        }

        private static void DecrementVariable()
        {
            Interlocked.Decrement(ref _value);
        }

        private static void IncrementVariable()
        {
            Interlocked.Increment(ref _value);
        }

        private static long ReadVariable()
        {
            // Metoda Read jest zbędna w systemach 64-bitowych, ponieważ operacje odczytu w systemach 64-bitowych 
            // już są atomowe. W systemach 32-bitowych 64-bitowe operacje odczytu 
            // nie są atomowe jeśli nie są wykonywane za pomocą metody Read.
            return Interlocked.Read(ref _value);
        }

        private static void PerformUnsafeCodeSafely()
        {
            for (int i = 0; i < 5; i++)
            {
                UseResource();
                Thread.Sleep(1000);
            }
        }

        //Prosta metoda, która zapobiega ponownym wejściom.
        static bool UseResource()
        {
            //0 wskazuje, że metoda nie jest używana.
            if (0 == Interlocked.Exchange(ref _resourceInUse, 1))
            {
                Console.WriteLine($"Wątek {Thread.CurrentThread.Name} uzyskał blokadę");

                //Tutaj powinien się znaleźć kod sięgający do zasobu, który nie jest bezpieczny w kontekście wątków.
                NonThreadSafeResourceAccess();

                //Symulacja operacji
                Thread.Sleep(500);

                Console.WriteLine($"Wątek {Thread.CurrentThread.Name} opuścił blokadę ");

                //Zwolnienie blokady
                Interlocked.Exchange(ref _resourceInUse, 0);
                return true;
            }
            else
            {
                Console.WriteLine($"Wątek {Thread.CurrentThread.Name} nie uzyskał dostępu do blokady");
                return false;
            }
        }

        private static void NonThreadSafeResourceAccess()
        {
            Console.WriteLine("Uruchomiono kod, który nie jest bezpieczny w kontekście wątków.");
        }
    }
}
